/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AwsEcsTaskDefinitionInferenceAcceleratorsListCopier {
    static List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> copy(
            Collection<? extends AwsEcsTaskDefinitionInferenceAcceleratorsDetails> awsEcsTaskDefinitionInferenceAcceleratorsListParam) {
        List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> list;
        if (awsEcsTaskDefinitionInferenceAcceleratorsListParam == null
                || awsEcsTaskDefinitionInferenceAcceleratorsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> modifiableList = new ArrayList<>(
                    awsEcsTaskDefinitionInferenceAcceleratorsListParam.size());
            awsEcsTaskDefinitionInferenceAcceleratorsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> copyFromBuilder(
            Collection<? extends AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder> awsEcsTaskDefinitionInferenceAcceleratorsListParam) {
        List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> list;
        if (awsEcsTaskDefinitionInferenceAcceleratorsListParam == null
                || awsEcsTaskDefinitionInferenceAcceleratorsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails> modifiableList = new ArrayList<>(
                    awsEcsTaskDefinitionInferenceAcceleratorsListParam.size());
            awsEcsTaskDefinitionInferenceAcceleratorsListParam.forEach(entry -> {
                AwsEcsTaskDefinitionInferenceAcceleratorsDetails member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder> copyToBuilder(
            Collection<? extends AwsEcsTaskDefinitionInferenceAcceleratorsDetails> awsEcsTaskDefinitionInferenceAcceleratorsListParam) {
        List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder> list;
        if (awsEcsTaskDefinitionInferenceAcceleratorsListParam == null
                || awsEcsTaskDefinitionInferenceAcceleratorsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder> modifiableList = new ArrayList<>(
                    awsEcsTaskDefinitionInferenceAcceleratorsListParam.size());
            awsEcsTaskDefinitionInferenceAcceleratorsListParam.forEach(entry -> {
                AwsEcsTaskDefinitionInferenceAcceleratorsDetails.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
