/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provide details about an Amazon Managed Streaming for Apache Kafka (Amazon MSK) cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsMskClusterClusterInfoDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsMskClusterClusterInfoDetails.Builder, AwsMskClusterClusterInfoDetails> {
    private static final SdkField<AwsMskClusterClusterInfoEncryptionInfoDetails> ENCRYPTION_INFO_FIELD = SdkField
            .<AwsMskClusterClusterInfoEncryptionInfoDetails> builder(MarshallingType.SDK_POJO).memberName("EncryptionInfo")
            .getter(getter(AwsMskClusterClusterInfoDetails::encryptionInfo)).setter(setter(Builder::encryptionInfo))
            .constructor(AwsMskClusterClusterInfoEncryptionInfoDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionInfo").build()).build();

    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentVersion").getter(getter(AwsMskClusterClusterInfoDetails::currentVersion))
            .setter(setter(Builder::currentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentVersion").build()).build();

    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfBrokerNodes").getter(getter(AwsMskClusterClusterInfoDetails::numberOfBrokerNodes))
            .setter(setter(Builder::numberOfBrokerNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfBrokerNodes").build())
            .build();

    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClusterName").getter(getter(AwsMskClusterClusterInfoDetails::clusterName))
            .setter(setter(Builder::clusterName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()).build();

    private static final SdkField<AwsMskClusterClusterInfoClientAuthenticationDetails> CLIENT_AUTHENTICATION_FIELD = SdkField
            .<AwsMskClusterClusterInfoClientAuthenticationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ClientAuthentication").getter(getter(AwsMskClusterClusterInfoDetails::clientAuthentication))
            .setter(setter(Builder::clientAuthentication))
            .constructor(AwsMskClusterClusterInfoClientAuthenticationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientAuthentication").build())
            .build();

    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnhancedMonitoring").getter(getter(AwsMskClusterClusterInfoDetails::enhancedMonitoring))
            .setter(setter(Builder::enhancedMonitoring))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedMonitoring").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_INFO_FIELD,
            CURRENT_VERSION_FIELD, NUMBER_OF_BROKER_NODES_FIELD, CLUSTER_NAME_FIELD, CLIENT_AUTHENTICATION_FIELD,
            ENHANCED_MONITORING_FIELD));

    private static final long serialVersionUID = 1L;

    private final AwsMskClusterClusterInfoEncryptionInfoDetails encryptionInfo;

    private final String currentVersion;

    private final Integer numberOfBrokerNodes;

    private final String clusterName;

    private final AwsMskClusterClusterInfoClientAuthenticationDetails clientAuthentication;

    private final String enhancedMonitoring;

    private AwsMskClusterClusterInfoDetails(BuilderImpl builder) {
        this.encryptionInfo = builder.encryptionInfo;
        this.currentVersion = builder.currentVersion;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.clusterName = builder.clusterName;
        this.clientAuthentication = builder.clientAuthentication;
        this.enhancedMonitoring = builder.enhancedMonitoring;
    }

    /**
     * <p>
     * Includes encryption-related information, such as the KMS key used for encrypting data at rest and whether you
     * want Amazon MSK to encrypt your data in transit.
     * </p>
     * 
     * @return Includes encryption-related information, such as the KMS key used for encrypting data at rest and whether
     *         you want Amazon MSK to encrypt your data in transit.
     */
    public final AwsMskClusterClusterInfoEncryptionInfoDetails encryptionInfo() {
        return encryptionInfo;
    }

    /**
     * <p>
     * The current version of the cluster.
     * </p>
     * 
     * @return The current version of the cluster.
     */
    public final String currentVersion() {
        return currentVersion;
    }

    /**
     * <p>
     * The number of broker nodes in the cluster.
     * </p>
     * 
     * @return The number of broker nodes in the cluster.
     */
    public final Integer numberOfBrokerNodes() {
        return numberOfBrokerNodes;
    }

    /**
     * <p>
     * The name of the cluster.
     * </p>
     * 
     * @return The name of the cluster.
     */
    public final String clusterName() {
        return clusterName;
    }

    /**
     * <p>
     * Provides information for different modes of client authentication.
     * </p>
     * 
     * @return Provides information for different modes of client authentication.
     */
    public final AwsMskClusterClusterInfoClientAuthenticationDetails clientAuthentication() {
        return clientAuthentication;
    }

    /**
     * <p>
     * Specifies the level of monitoring for the cluster.
     * </p>
     * 
     * @return Specifies the level of monitoring for the cluster.
     */
    public final String enhancedMonitoring() {
        return enhancedMonitoring;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMonitoring());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsMskClusterClusterInfoDetails)) {
            return false;
        }
        AwsMskClusterClusterInfoDetails other = (AwsMskClusterClusterInfoDetails) obj;
        return Objects.equals(encryptionInfo(), other.encryptionInfo())
                && Objects.equals(currentVersion(), other.currentVersion())
                && Objects.equals(numberOfBrokerNodes(), other.numberOfBrokerNodes())
                && Objects.equals(clusterName(), other.clusterName())
                && Objects.equals(clientAuthentication(), other.clientAuthentication())
                && Objects.equals(enhancedMonitoring(), other.enhancedMonitoring());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsMskClusterClusterInfoDetails").add("EncryptionInfo", encryptionInfo())
                .add("CurrentVersion", currentVersion()).add("NumberOfBrokerNodes", numberOfBrokerNodes())
                .add("ClusterName", clusterName()).add("ClientAuthentication", clientAuthentication())
                .add("EnhancedMonitoring", enhancedMonitoring()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionInfo":
            return Optional.ofNullable(clazz.cast(encryptionInfo()));
        case "CurrentVersion":
            return Optional.ofNullable(clazz.cast(currentVersion()));
        case "NumberOfBrokerNodes":
            return Optional.ofNullable(clazz.cast(numberOfBrokerNodes()));
        case "ClusterName":
            return Optional.ofNullable(clazz.cast(clusterName()));
        case "ClientAuthentication":
            return Optional.ofNullable(clazz.cast(clientAuthentication()));
        case "EnhancedMonitoring":
            return Optional.ofNullable(clazz.cast(enhancedMonitoring()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsMskClusterClusterInfoDetails, T> g) {
        return obj -> g.apply((AwsMskClusterClusterInfoDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsMskClusterClusterInfoDetails> {
        /**
         * <p>
         * Includes encryption-related information, such as the KMS key used for encrypting data at rest and whether you
         * want Amazon MSK to encrypt your data in transit.
         * </p>
         * 
         * @param encryptionInfo
         *        Includes encryption-related information, such as the KMS key used for encrypting data at rest and
         *        whether you want Amazon MSK to encrypt your data in transit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionInfo(AwsMskClusterClusterInfoEncryptionInfoDetails encryptionInfo);

        /**
         * <p>
         * Includes encryption-related information, such as the KMS key used for encrypting data at rest and whether you
         * want Amazon MSK to encrypt your data in transit.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsMskClusterClusterInfoEncryptionInfoDetails.Builder} avoiding the need to create one manually via
         * {@link AwsMskClusterClusterInfoEncryptionInfoDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsMskClusterClusterInfoEncryptionInfoDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #encryptionInfo(AwsMskClusterClusterInfoEncryptionInfoDetails)}.
         * 
         * @param encryptionInfo
         *        a consumer that will call methods on {@link AwsMskClusterClusterInfoEncryptionInfoDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #encryptionInfo(AwsMskClusterClusterInfoEncryptionInfoDetails)
         */
        default Builder encryptionInfo(Consumer<AwsMskClusterClusterInfoEncryptionInfoDetails.Builder> encryptionInfo) {
            return encryptionInfo(AwsMskClusterClusterInfoEncryptionInfoDetails.builder().applyMutation(encryptionInfo).build());
        }

        /**
         * <p>
         * The current version of the cluster.
         * </p>
         * 
         * @param currentVersion
         *        The current version of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentVersion(String currentVersion);

        /**
         * <p>
         * The number of broker nodes in the cluster.
         * </p>
         * 
         * @param numberOfBrokerNodes
         *        The number of broker nodes in the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfBrokerNodes(Integer numberOfBrokerNodes);

        /**
         * <p>
         * The name of the cluster.
         * </p>
         * 
         * @param clusterName
         *        The name of the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterName(String clusterName);

        /**
         * <p>
         * Provides information for different modes of client authentication.
         * </p>
         * 
         * @param clientAuthentication
         *        Provides information for different modes of client authentication.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientAuthentication(AwsMskClusterClusterInfoClientAuthenticationDetails clientAuthentication);

        /**
         * <p>
         * Provides information for different modes of client authentication.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsMskClusterClusterInfoClientAuthenticationDetails.Builder} avoiding the need to create one manually
         * via {@link AwsMskClusterClusterInfoClientAuthenticationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link AwsMskClusterClusterInfoClientAuthenticationDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #clientAuthentication(AwsMskClusterClusterInfoClientAuthenticationDetails)}.
         * 
         * @param clientAuthentication
         *        a consumer that will call methods on
         *        {@link AwsMskClusterClusterInfoClientAuthenticationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clientAuthentication(AwsMskClusterClusterInfoClientAuthenticationDetails)
         */
        default Builder clientAuthentication(
                Consumer<AwsMskClusterClusterInfoClientAuthenticationDetails.Builder> clientAuthentication) {
            return clientAuthentication(AwsMskClusterClusterInfoClientAuthenticationDetails.builder()
                    .applyMutation(clientAuthentication).build());
        }

        /**
         * <p>
         * Specifies the level of monitoring for the cluster.
         * </p>
         * 
         * @param enhancedMonitoring
         *        Specifies the level of monitoring for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedMonitoring(String enhancedMonitoring);
    }

    static final class BuilderImpl implements Builder {
        private AwsMskClusterClusterInfoEncryptionInfoDetails encryptionInfo;

        private String currentVersion;

        private Integer numberOfBrokerNodes;

        private String clusterName;

        private AwsMskClusterClusterInfoClientAuthenticationDetails clientAuthentication;

        private String enhancedMonitoring;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsMskClusterClusterInfoDetails model) {
            encryptionInfo(model.encryptionInfo);
            currentVersion(model.currentVersion);
            numberOfBrokerNodes(model.numberOfBrokerNodes);
            clusterName(model.clusterName);
            clientAuthentication(model.clientAuthentication);
            enhancedMonitoring(model.enhancedMonitoring);
        }

        public final AwsMskClusterClusterInfoEncryptionInfoDetails.Builder getEncryptionInfo() {
            return encryptionInfo != null ? encryptionInfo.toBuilder() : null;
        }

        public final void setEncryptionInfo(AwsMskClusterClusterInfoEncryptionInfoDetails.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        @Override
        public final Builder encryptionInfo(AwsMskClusterClusterInfoEncryptionInfoDetails encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final String getCurrentVersion() {
            return currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final Integer getNumberOfBrokerNodes() {
            return numberOfBrokerNodes;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final String getClusterName() {
            return clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final AwsMskClusterClusterInfoClientAuthenticationDetails.Builder getClientAuthentication() {
            return clientAuthentication != null ? clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(
                AwsMskClusterClusterInfoClientAuthenticationDetails.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(AwsMskClusterClusterInfoClientAuthenticationDetails clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final String getEnhancedMonitoring() {
            return enhancedMonitoring;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public AwsMskClusterClusterInfoDetails build() {
            return new AwsMskClusterClusterInfoDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
