/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AwsRdsDbInstanceAssociatedRolesCopier {
    static List<AwsRdsDbInstanceAssociatedRole> copy(
            Collection<? extends AwsRdsDbInstanceAssociatedRole> awsRdsDbInstanceAssociatedRolesParam) {
        List<AwsRdsDbInstanceAssociatedRole> list;
        if (awsRdsDbInstanceAssociatedRolesParam == null || awsRdsDbInstanceAssociatedRolesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsRdsDbInstanceAssociatedRole> modifiableList = new ArrayList<>(awsRdsDbInstanceAssociatedRolesParam.size());
            awsRdsDbInstanceAssociatedRolesParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsRdsDbInstanceAssociatedRole> copyFromBuilder(
            Collection<? extends AwsRdsDbInstanceAssociatedRole.Builder> awsRdsDbInstanceAssociatedRolesParam) {
        List<AwsRdsDbInstanceAssociatedRole> list;
        if (awsRdsDbInstanceAssociatedRolesParam == null || awsRdsDbInstanceAssociatedRolesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsRdsDbInstanceAssociatedRole> modifiableList = new ArrayList<>(awsRdsDbInstanceAssociatedRolesParam.size());
            awsRdsDbInstanceAssociatedRolesParam.forEach(entry -> {
                AwsRdsDbInstanceAssociatedRole member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsRdsDbInstanceAssociatedRole.Builder> copyToBuilder(
            Collection<? extends AwsRdsDbInstanceAssociatedRole> awsRdsDbInstanceAssociatedRolesParam) {
        List<AwsRdsDbInstanceAssociatedRole.Builder> list;
        if (awsRdsDbInstanceAssociatedRolesParam == null || awsRdsDbInstanceAssociatedRolesParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsRdsDbInstanceAssociatedRole.Builder> modifiableList = new ArrayList<>(
                    awsRdsDbInstanceAssociatedRolesParam.size());
            awsRdsDbInstanceAssociatedRolesParam.forEach(entry -> {
                AwsRdsDbInstanceAssociatedRole.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
