/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the details of an Amazon RDS DB instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbInstanceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbInstanceDetails.Builder, AwsRdsDbInstanceDetails> {
    private static final SdkField<List<AwsRdsDbInstanceAssociatedRole>> ASSOCIATED_ROLES_FIELD = SdkField
            .<List<AwsRdsDbInstanceAssociatedRole>> builder(MarshallingType.LIST)
            .memberName("AssociatedRoles")
            .getter(getter(AwsRdsDbInstanceDetails::associatedRoles))
            .setter(setter(Builder::associatedRoles))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssociatedRoles").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbInstanceAssociatedRole> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbInstanceAssociatedRole::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CA_CERTIFICATE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CACertificateIdentifier").getter(getter(AwsRdsDbInstanceDetails::caCertificateIdentifier))
            .setter(setter(Builder::caCertificateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CACertificateIdentifier").build())
            .build();

    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBClusterIdentifier").getter(getter(AwsRdsDbInstanceDetails::dbClusterIdentifier))
            .setter(setter(Builder::dbClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBClusterIdentifier").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceIdentifier").getter(getter(AwsRdsDbInstanceDetails::dbInstanceIdentifier))
            .setter(setter(Builder::dbInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceIdentifier").build())
            .build();

    private static final SdkField<String> DB_INSTANCE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DBInstanceClass").getter(getter(AwsRdsDbInstanceDetails::dbInstanceClass))
            .setter(setter(Builder::dbInstanceClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBInstanceClass").build()).build();

    private static final SdkField<Integer> DB_INSTANCE_PORT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DbInstancePort").getter(getter(AwsRdsDbInstanceDetails::dbInstancePort))
            .setter(setter(Builder::dbInstancePort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstancePort").build()).build();

    private static final SdkField<String> DBI_RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbiResourceId").getter(getter(AwsRdsDbInstanceDetails::dbiResourceId))
            .setter(setter(Builder::dbiResourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbiResourceId").build()).build();

    private static final SdkField<String> DB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DBName")
            .getter(getter(AwsRdsDbInstanceDetails::dbName)).setter(setter(Builder::dbName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()).build();

    private static final SdkField<Boolean> DELETION_PROTECTION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("DeletionProtection").getter(getter(AwsRdsDbInstanceDetails::deletionProtection))
            .setter(setter(Builder::deletionProtection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeletionProtection").build())
            .build();

    private static final SdkField<AwsRdsDbInstanceEndpoint> ENDPOINT_FIELD = SdkField
            .<AwsRdsDbInstanceEndpoint> builder(MarshallingType.SDK_POJO).memberName("Endpoint")
            .getter(getter(AwsRdsDbInstanceDetails::endpoint)).setter(setter(Builder::endpoint))
            .constructor(AwsRdsDbInstanceEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Engine")
            .getter(getter(AwsRdsDbInstanceDetails::engine)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(AwsRdsDbInstanceDetails::engineVersion))
            .setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<Boolean> IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IAMDatabaseAuthenticationEnabled")
            .getter(getter(AwsRdsDbInstanceDetails::iamDatabaseAuthenticationEnabled))
            .setter(setter(Builder::iamDatabaseAuthenticationEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IAMDatabaseAuthenticationEnabled")
                    .build()).build();

    private static final SdkField<String> INSTANCE_CREATE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceCreateTime").getter(getter(AwsRdsDbInstanceDetails::instanceCreateTime))
            .setter(setter(Builder::instanceCreateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCreateTime").build())
            .build();

    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyId").getter(getter(AwsRdsDbInstanceDetails::kmsKeyId)).setter(setter(Builder::kmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()).build();

    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PubliclyAccessible").getter(getter(AwsRdsDbInstanceDetails::publiclyAccessible))
            .setter(setter(Builder::publiclyAccessible))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build())
            .build();

    private static final SdkField<Boolean> STORAGE_ENCRYPTED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("StorageEncrypted").getter(getter(AwsRdsDbInstanceDetails::storageEncrypted))
            .setter(setter(Builder::storageEncrypted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageEncrypted").build()).build();

    private static final SdkField<String> TDE_CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TdeCredentialArn").getter(getter(AwsRdsDbInstanceDetails::tdeCredentialArn))
            .setter(setter(Builder::tdeCredentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TdeCredentialArn").build()).build();

    private static final SdkField<List<AwsRdsDbInstanceVpcSecurityGroup>> VPC_SECURITY_GROUPS_FIELD = SdkField
            .<List<AwsRdsDbInstanceVpcSecurityGroup>> builder(MarshallingType.LIST)
            .memberName("VpcSecurityGroups")
            .getter(getter(AwsRdsDbInstanceDetails::vpcSecurityGroups))
            .setter(setter(Builder::vpcSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbInstanceVpcSecurityGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbInstanceVpcSecurityGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> MULTI_AZ_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("MultiAz").getter(getter(AwsRdsDbInstanceDetails::multiAz)).setter(setter(Builder::multiAz))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiAz").build()).build();

    private static final SdkField<String> ENHANCED_MONITORING_RESOURCE_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("EnhancedMonitoringResourceArn")
            .getter(getter(AwsRdsDbInstanceDetails::enhancedMonitoringResourceArn))
            .setter(setter(Builder::enhancedMonitoringResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedMonitoringResourceArn")
                    .build()).build();

    private static final SdkField<String> DB_INSTANCE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DbInstanceStatus").getter(getter(AwsRdsDbInstanceDetails::dbInstanceStatus))
            .setter(setter(Builder::dbInstanceStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbInstanceStatus").build()).build();

    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MasterUsername").getter(getter(AwsRdsDbInstanceDetails::masterUsername))
            .setter(setter(Builder::masterUsername))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()).build();

    private static final SdkField<Integer> ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AllocatedStorage").getter(getter(AwsRdsDbInstanceDetails::allocatedStorage))
            .setter(setter(Builder::allocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllocatedStorage").build()).build();

    private static final SdkField<String> PREFERRED_BACKUP_WINDOW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredBackupWindow").getter(getter(AwsRdsDbInstanceDetails::preferredBackupWindow))
            .setter(setter(Builder::preferredBackupWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredBackupWindow").build())
            .build();

    private static final SdkField<Integer> BACKUP_RETENTION_PERIOD_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("BackupRetentionPeriod").getter(getter(AwsRdsDbInstanceDetails::backupRetentionPeriod))
            .setter(setter(Builder::backupRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRetentionPeriod").build())
            .build();

    private static final SdkField<List<String>> DB_SECURITY_GROUPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DbSecurityGroups")
            .getter(getter(AwsRdsDbInstanceDetails::dbSecurityGroups))
            .setter(setter(Builder::dbSecurityGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSecurityGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsRdsDbParameterGroup>> DB_PARAMETER_GROUPS_FIELD = SdkField
            .<List<AwsRdsDbParameterGroup>> builder(MarshallingType.LIST)
            .memberName("DbParameterGroups")
            .getter(getter(AwsRdsDbInstanceDetails::dbParameterGroups))
            .setter(setter(Builder::dbParameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbParameterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbParameterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(AwsRdsDbInstanceDetails::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<AwsRdsDbSubnetGroup> DB_SUBNET_GROUP_FIELD = SdkField
            .<AwsRdsDbSubnetGroup> builder(MarshallingType.SDK_POJO).memberName("DbSubnetGroup")
            .getter(getter(AwsRdsDbInstanceDetails::dbSubnetGroup)).setter(setter(Builder::dbSubnetGroup))
            .constructor(AwsRdsDbSubnetGroup::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DbSubnetGroup").build()).build();

    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PreferredMaintenanceWindow")
            .getter(getter(AwsRdsDbInstanceDetails::preferredMaintenanceWindow))
            .setter(setter(Builder::preferredMaintenanceWindow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build())
            .build();

    private static final SdkField<AwsRdsDbPendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField
            .<AwsRdsDbPendingModifiedValues> builder(MarshallingType.SDK_POJO).memberName("PendingModifiedValues")
            .getter(getter(AwsRdsDbInstanceDetails::pendingModifiedValues)).setter(setter(Builder::pendingModifiedValues))
            .constructor(AwsRdsDbPendingModifiedValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build())
            .build();

    private static final SdkField<String> LATEST_RESTORABLE_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LatestRestorableTime").getter(getter(AwsRdsDbInstanceDetails::latestRestorableTime))
            .setter(setter(Builder::latestRestorableTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRestorableTime").build())
            .build();

    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("AutoMinorVersionUpgrade").getter(getter(AwsRdsDbInstanceDetails::autoMinorVersionUpgrade))
            .setter(setter(Builder::autoMinorVersionUpgrade))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build())
            .build();

    private static final SdkField<String> READ_REPLICA_SOURCE_DB_INSTANCE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ReadReplicaSourceDBInstanceIdentifier")
            .getter(getter(AwsRdsDbInstanceDetails::readReplicaSourceDBInstanceIdentifier))
            .setter(setter(Builder::readReplicaSourceDBInstanceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ReadReplicaSourceDBInstanceIdentifier").build()).build();

    private static final SdkField<List<String>> READ_REPLICA_DB_INSTANCE_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadReplicaDBInstanceIdentifiers")
            .getter(getter(AwsRdsDbInstanceDetails::readReplicaDBInstanceIdentifiers))
            .setter(setter(Builder::readReplicaDBInstanceIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaDBInstanceIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> READ_REPLICA_DB_CLUSTER_IDENTIFIERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReadReplicaDBClusterIdentifiers")
            .getter(getter(AwsRdsDbInstanceDetails::readReplicaDBClusterIdentifiers))
            .setter(setter(Builder::readReplicaDBClusterIdentifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadReplicaDBClusterIdentifiers")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LicenseModel").getter(getter(AwsRdsDbInstanceDetails::licenseModel))
            .setter(setter(Builder::licenseModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LicenseModel").build()).build();

    private static final SdkField<Integer> IOPS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Iops")
            .getter(getter(AwsRdsDbInstanceDetails::iops)).setter(setter(Builder::iops))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Iops").build()).build();

    private static final SdkField<List<AwsRdsDbOptionGroupMembership>> OPTION_GROUP_MEMBERSHIPS_FIELD = SdkField
            .<List<AwsRdsDbOptionGroupMembership>> builder(MarshallingType.LIST)
            .memberName("OptionGroupMemberships")
            .getter(getter(AwsRdsDbInstanceDetails::optionGroupMemberships))
            .setter(setter(Builder::optionGroupMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OptionGroupMemberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbOptionGroupMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbOptionGroupMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CHARACTER_SET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CharacterSetName").getter(getter(AwsRdsDbInstanceDetails::characterSetName))
            .setter(setter(Builder::characterSetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CharacterSetName").build()).build();

    private static final SdkField<String> SECONDARY_AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecondaryAvailabilityZone").getter(getter(AwsRdsDbInstanceDetails::secondaryAvailabilityZone))
            .setter(setter(Builder::secondaryAvailabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecondaryAvailabilityZone").build())
            .build();

    private static final SdkField<List<AwsRdsDbStatusInfo>> STATUS_INFOS_FIELD = SdkField
            .<List<AwsRdsDbStatusInfo>> builder(MarshallingType.LIST)
            .memberName("StatusInfos")
            .getter(getter(AwsRdsDbInstanceDetails::statusInfos))
            .setter(setter(Builder::statusInfos))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusInfos").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbStatusInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbStatusInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(AwsRdsDbInstanceDetails::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<List<AwsRdsDbDomainMembership>> DOMAIN_MEMBERSHIPS_FIELD = SdkField
            .<List<AwsRdsDbDomainMembership>> builder(MarshallingType.LIST)
            .memberName("DomainMemberships")
            .getter(getter(AwsRdsDbInstanceDetails::domainMemberships))
            .setter(setter(Builder::domainMemberships))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainMemberships").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbDomainMembership> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbDomainMembership::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> COPY_TAGS_TO_SNAPSHOT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("CopyTagsToSnapshot").getter(getter(AwsRdsDbInstanceDetails::copyTagsToSnapshot))
            .setter(setter(Builder::copyTagsToSnapshot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTagsToSnapshot").build())
            .build();

    private static final SdkField<Integer> MONITORING_INTERVAL_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MonitoringInterval").getter(getter(AwsRdsDbInstanceDetails::monitoringInterval))
            .setter(setter(Builder::monitoringInterval))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringInterval").build())
            .build();

    private static final SdkField<String> MONITORING_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MonitoringRoleArn").getter(getter(AwsRdsDbInstanceDetails::monitoringRoleArn))
            .setter(setter(Builder::monitoringRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringRoleArn").build()).build();

    private static final SdkField<Integer> PROMOTION_TIER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("PromotionTier").getter(getter(AwsRdsDbInstanceDetails::promotionTier))
            .setter(setter(Builder::promotionTier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PromotionTier").build()).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Timezone").getter(getter(AwsRdsDbInstanceDetails::timezone)).setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timezone").build()).build();

    private static final SdkField<Boolean> PERFORMANCE_INSIGHTS_ENABLED_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PerformanceInsightsEnabled")
            .getter(getter(AwsRdsDbInstanceDetails::performanceInsightsEnabled))
            .setter(setter(Builder::performanceInsightsEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsEnabled").build())
            .build();

    private static final SdkField<String> PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PerformanceInsightsKmsKeyId")
            .getter(getter(AwsRdsDbInstanceDetails::performanceInsightsKmsKeyId))
            .setter(setter(Builder::performanceInsightsKmsKeyId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsKmsKeyId")
                    .build()).build();

    private static final SdkField<Integer> PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("PerformanceInsightsRetentionPeriod")
            .getter(getter(AwsRdsDbInstanceDetails::performanceInsightsRetentionPeriod))
            .setter(setter(Builder::performanceInsightsRetentionPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PerformanceInsightsRetentionPeriod")
                    .build()).build();

    private static final SdkField<List<String>> ENABLED_CLOUD_WATCH_LOGS_EXPORTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnabledCloudWatchLogsExports")
            .getter(getter(AwsRdsDbInstanceDetails::enabledCloudWatchLogsExports))
            .setter(setter(Builder::enabledCloudWatchLogsExports))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnabledCloudWatchLogsExports")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsRdsDbProcessorFeature>> PROCESSOR_FEATURES_FIELD = SdkField
            .<List<AwsRdsDbProcessorFeature>> builder(MarshallingType.LIST)
            .memberName("ProcessorFeatures")
            .getter(getter(AwsRdsDbInstanceDetails::processorFeatures))
            .setter(setter(Builder::processorFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessorFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRdsDbProcessorFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRdsDbProcessorFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AwsRdsDbInstanceEndpoint> LISTENER_ENDPOINT_FIELD = SdkField
            .<AwsRdsDbInstanceEndpoint> builder(MarshallingType.SDK_POJO).memberName("ListenerEndpoint")
            .getter(getter(AwsRdsDbInstanceDetails::listenerEndpoint)).setter(setter(Builder::listenerEndpoint))
            .constructor(AwsRdsDbInstanceEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ListenerEndpoint").build()).build();

    private static final SdkField<Integer> MAX_ALLOCATED_STORAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxAllocatedStorage").getter(getter(AwsRdsDbInstanceDetails::maxAllocatedStorage))
            .setter(setter(Builder::maxAllocatedStorage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxAllocatedStorage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_ROLES_FIELD,
            CA_CERTIFICATE_IDENTIFIER_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DB_INSTANCE_IDENTIFIER_FIELD, DB_INSTANCE_CLASS_FIELD,
            DB_INSTANCE_PORT_FIELD, DBI_RESOURCE_ID_FIELD, DB_NAME_FIELD, DELETION_PROTECTION_FIELD, ENDPOINT_FIELD,
            ENGINE_FIELD, ENGINE_VERSION_FIELD, IAM_DATABASE_AUTHENTICATION_ENABLED_FIELD, INSTANCE_CREATE_TIME_FIELD,
            KMS_KEY_ID_FIELD, PUBLICLY_ACCESSIBLE_FIELD, STORAGE_ENCRYPTED_FIELD, TDE_CREDENTIAL_ARN_FIELD,
            VPC_SECURITY_GROUPS_FIELD, MULTI_AZ_FIELD, ENHANCED_MONITORING_RESOURCE_ARN_FIELD, DB_INSTANCE_STATUS_FIELD,
            MASTER_USERNAME_FIELD, ALLOCATED_STORAGE_FIELD, PREFERRED_BACKUP_WINDOW_FIELD, BACKUP_RETENTION_PERIOD_FIELD,
            DB_SECURITY_GROUPS_FIELD, DB_PARAMETER_GROUPS_FIELD, AVAILABILITY_ZONE_FIELD, DB_SUBNET_GROUP_FIELD,
            PREFERRED_MAINTENANCE_WINDOW_FIELD, PENDING_MODIFIED_VALUES_FIELD, LATEST_RESTORABLE_TIME_FIELD,
            AUTO_MINOR_VERSION_UPGRADE_FIELD, READ_REPLICA_SOURCE_DB_INSTANCE_IDENTIFIER_FIELD,
            READ_REPLICA_DB_INSTANCE_IDENTIFIERS_FIELD, READ_REPLICA_DB_CLUSTER_IDENTIFIERS_FIELD, LICENSE_MODEL_FIELD,
            IOPS_FIELD, OPTION_GROUP_MEMBERSHIPS_FIELD, CHARACTER_SET_NAME_FIELD, SECONDARY_AVAILABILITY_ZONE_FIELD,
            STATUS_INFOS_FIELD, STORAGE_TYPE_FIELD, DOMAIN_MEMBERSHIPS_FIELD, COPY_TAGS_TO_SNAPSHOT_FIELD,
            MONITORING_INTERVAL_FIELD, MONITORING_ROLE_ARN_FIELD, PROMOTION_TIER_FIELD, TIMEZONE_FIELD,
            PERFORMANCE_INSIGHTS_ENABLED_FIELD, PERFORMANCE_INSIGHTS_KMS_KEY_ID_FIELD,
            PERFORMANCE_INSIGHTS_RETENTION_PERIOD_FIELD, ENABLED_CLOUD_WATCH_LOGS_EXPORTS_FIELD, PROCESSOR_FEATURES_FIELD,
            LISTENER_ENDPOINT_FIELD, MAX_ALLOCATED_STORAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsRdsDbInstanceAssociatedRole> associatedRoles;

    private final String caCertificateIdentifier;

    private final String dbClusterIdentifier;

    private final String dbInstanceIdentifier;

    private final String dbInstanceClass;

    private final Integer dbInstancePort;

    private final String dbiResourceId;

    private final String dbName;

    private final Boolean deletionProtection;

    private final AwsRdsDbInstanceEndpoint endpoint;

    private final String engine;

    private final String engineVersion;

    private final Boolean iamDatabaseAuthenticationEnabled;

    private final String instanceCreateTime;

    private final String kmsKeyId;

    private final Boolean publiclyAccessible;

    private final Boolean storageEncrypted;

    private final String tdeCredentialArn;

    private final List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups;

    private final Boolean multiAz;

    private final String enhancedMonitoringResourceArn;

    private final String dbInstanceStatus;

    private final String masterUsername;

    private final Integer allocatedStorage;

    private final String preferredBackupWindow;

    private final Integer backupRetentionPeriod;

    private final List<String> dbSecurityGroups;

    private final List<AwsRdsDbParameterGroup> dbParameterGroups;

    private final String availabilityZone;

    private final AwsRdsDbSubnetGroup dbSubnetGroup;

    private final String preferredMaintenanceWindow;

    private final AwsRdsDbPendingModifiedValues pendingModifiedValues;

    private final String latestRestorableTime;

    private final Boolean autoMinorVersionUpgrade;

    private final String readReplicaSourceDBInstanceIdentifier;

    private final List<String> readReplicaDBInstanceIdentifiers;

    private final List<String> readReplicaDBClusterIdentifiers;

    private final String licenseModel;

    private final Integer iops;

    private final List<AwsRdsDbOptionGroupMembership> optionGroupMemberships;

    private final String characterSetName;

    private final String secondaryAvailabilityZone;

    private final List<AwsRdsDbStatusInfo> statusInfos;

    private final String storageType;

    private final List<AwsRdsDbDomainMembership> domainMemberships;

    private final Boolean copyTagsToSnapshot;

    private final Integer monitoringInterval;

    private final String monitoringRoleArn;

    private final Integer promotionTier;

    private final String timezone;

    private final Boolean performanceInsightsEnabled;

    private final String performanceInsightsKmsKeyId;

    private final Integer performanceInsightsRetentionPeriod;

    private final List<String> enabledCloudWatchLogsExports;

    private final List<AwsRdsDbProcessorFeature> processorFeatures;

    private final AwsRdsDbInstanceEndpoint listenerEndpoint;

    private final Integer maxAllocatedStorage;

    private AwsRdsDbInstanceDetails(BuilderImpl builder) {
        this.associatedRoles = builder.associatedRoles;
        this.caCertificateIdentifier = builder.caCertificateIdentifier;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.dbInstanceIdentifier = builder.dbInstanceIdentifier;
        this.dbInstanceClass = builder.dbInstanceClass;
        this.dbInstancePort = builder.dbInstancePort;
        this.dbiResourceId = builder.dbiResourceId;
        this.dbName = builder.dbName;
        this.deletionProtection = builder.deletionProtection;
        this.endpoint = builder.endpoint;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.iamDatabaseAuthenticationEnabled = builder.iamDatabaseAuthenticationEnabled;
        this.instanceCreateTime = builder.instanceCreateTime;
        this.kmsKeyId = builder.kmsKeyId;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.storageEncrypted = builder.storageEncrypted;
        this.tdeCredentialArn = builder.tdeCredentialArn;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.multiAz = builder.multiAz;
        this.enhancedMonitoringResourceArn = builder.enhancedMonitoringResourceArn;
        this.dbInstanceStatus = builder.dbInstanceStatus;
        this.masterUsername = builder.masterUsername;
        this.allocatedStorage = builder.allocatedStorage;
        this.preferredBackupWindow = builder.preferredBackupWindow;
        this.backupRetentionPeriod = builder.backupRetentionPeriod;
        this.dbSecurityGroups = builder.dbSecurityGroups;
        this.dbParameterGroups = builder.dbParameterGroups;
        this.availabilityZone = builder.availabilityZone;
        this.dbSubnetGroup = builder.dbSubnetGroup;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.latestRestorableTime = builder.latestRestorableTime;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.readReplicaSourceDBInstanceIdentifier = builder.readReplicaSourceDBInstanceIdentifier;
        this.readReplicaDBInstanceIdentifiers = builder.readReplicaDBInstanceIdentifiers;
        this.readReplicaDBClusterIdentifiers = builder.readReplicaDBClusterIdentifiers;
        this.licenseModel = builder.licenseModel;
        this.iops = builder.iops;
        this.optionGroupMemberships = builder.optionGroupMemberships;
        this.characterSetName = builder.characterSetName;
        this.secondaryAvailabilityZone = builder.secondaryAvailabilityZone;
        this.statusInfos = builder.statusInfos;
        this.storageType = builder.storageType;
        this.domainMemberships = builder.domainMemberships;
        this.copyTagsToSnapshot = builder.copyTagsToSnapshot;
        this.monitoringInterval = builder.monitoringInterval;
        this.monitoringRoleArn = builder.monitoringRoleArn;
        this.promotionTier = builder.promotionTier;
        this.timezone = builder.timezone;
        this.performanceInsightsEnabled = builder.performanceInsightsEnabled;
        this.performanceInsightsKmsKeyId = builder.performanceInsightsKmsKeyId;
        this.performanceInsightsRetentionPeriod = builder.performanceInsightsRetentionPeriod;
        this.enabledCloudWatchLogsExports = builder.enabledCloudWatchLogsExports;
        this.processorFeatures = builder.processorFeatures;
        this.listenerEndpoint = builder.listenerEndpoint;
        this.maxAllocatedStorage = builder.maxAllocatedStorage;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedRoles property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedRoles() {
        return associatedRoles != null && !(associatedRoles instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The IAM roles associated with the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedRoles} method.
     * </p>
     * 
     * @return The IAM roles associated with the DB instance.
     */
    public final List<AwsRdsDbInstanceAssociatedRole> associatedRoles() {
        return associatedRoles;
    }

    /**
     * <p>
     * The identifier of the CA certificate for this DB instance.
     * </p>
     * 
     * @return The identifier of the CA certificate for this DB instance.
     */
    public final String caCertificateIdentifier() {
        return caCertificateIdentifier;
    }

    /**
     * <p>
     * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a
     * member of.
     * </p>
     * 
     * @return If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance
     *         is a member of.
     */
    public final String dbClusterIdentifier() {
        return dbClusterIdentifier;
    }

    /**
     * <p>
     * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB instance.
     * </p>
     * 
     * @return Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB
     *         instance.
     */
    public final String dbInstanceIdentifier() {
        return dbInstanceIdentifier;
    }

    /**
     * <p>
     * Contains the name of the compute and memory capacity class of the DB instance.
     * </p>
     * 
     * @return Contains the name of the compute and memory capacity class of the DB instance.
     */
    public final String dbInstanceClass() {
        return dbInstanceClass;
    }

    /**
     * <p>
     * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a
     * different port than the DB cluster port.
     * </p>
     * 
     * @return Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can
     *         be a different port than the DB cluster port.
     */
    public final Integer dbInstancePort() {
        return dbInstancePort;
    }

    /**
     * <p>
     * The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in
     * CloudTrail log entries whenever the KMS key for the DB instance is accessed.
     * </p>
     * 
     * @return The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found
     *         in CloudTrail log entries whenever the KMS key for the DB instance is accessed.
     */
    public final String dbiResourceId() {
        return dbiResourceId;
    }

    /**
     * <p>
     * The meaning of this parameter differs according to the database engine you use.
     * </p>
     * <p>
     * <b>MySQL, MariaDB, SQL Server, PostgreSQL</b>
     * </p>
     * <p>
     * Contains the name of the initial database of this instance that was provided at create time, if one was specified
     * when the DB instance was created. This same name is returned for the life of the DB instance.
     * </p>
     * <p>
     * <b>Oracle</b>
     * </p>
     * <p>
     * Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters don't
     * apply to an Oracle DB instance.
     * </p>
     * 
     * @return The meaning of this parameter differs according to the database engine you use.</p>
     *         <p>
     *         <b>MySQL, MariaDB, SQL Server, PostgreSQL</b>
     *         </p>
     *         <p>
     *         Contains the name of the initial database of this instance that was provided at create time, if one was
     *         specified when the DB instance was created. This same name is returned for the life of the DB instance.
     *         </p>
     *         <p>
     *         <b>Oracle</b>
     *         </p>
     *         <p>
     *         Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters
     *         don't apply to an Oracle DB instance.
     */
    public final String dbName() {
        return dbName;
    }

    /**
     * <p>
     * Indicates whether the DB instance has deletion protection enabled.
     * </p>
     * <p>
     * When deletion protection is enabled, the database cannot be deleted.
     * </p>
     * 
     * @return Indicates whether the DB instance has deletion protection enabled.</p>
     *         <p>
     *         When deletion protection is enabled, the database cannot be deleted.
     */
    public final Boolean deletionProtection() {
        return deletionProtection;
    }

    /**
     * <p>
     * Specifies the connection endpoint.
     * </p>
     * 
     * @return Specifies the connection endpoint.
     */
    public final AwsRdsDbInstanceEndpoint endpoint() {
        return endpoint;
    }

    /**
     * <p>
     * Provides the name of the database engine to use for this DB instance.
     * </p>
     * 
     * @return Provides the name of the database engine to use for this DB instance.
     */
    public final String engine() {
        return engine;
    }

    /**
     * <p>
     * Indicates the database engine version.
     * </p>
     * 
     * @return Indicates the database engine version.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * True if mapping of IAM accounts to database accounts is enabled, and otherwise false.
     * </p>
     * <p>
     * IAM database authentication can be enabled for the following database engines.
     * </p>
     * <ul>
     * <li>
     * <p>
     * For MySQL 5.6, minor version 5.6.34 or higher
     * </p>
     * </li>
     * <li>
     * <p>
     * For MySQL 5.7, minor version 5.7.16 or higher
     * </p>
     * </li>
     * <li>
     * <p>
     * Aurora 5.6 or higher
     * </p>
     * </li>
     * </ul>
     * 
     * @return True if mapping of IAM accounts to database accounts is enabled, and otherwise false.</p>
     *         <p>
     *         IAM database authentication can be enabled for the following database engines.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         For MySQL 5.6, minor version 5.6.34 or higher
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         For MySQL 5.7, minor version 5.7.16 or higher
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Aurora 5.6 or higher
     *         </p>
     *         </li>
     */
    public final Boolean iamDatabaseAuthenticationEnabled() {
        return iamDatabaseAuthenticationEnabled;
    }

    /**
     * <p>
     * Indicates when the DB instance was created.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates when the DB instance was created.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String instanceCreateTime() {
        return instanceCreateTime;
    }

    /**
     * <p>
     * If <code>StorageEncrypted</code> is true, the KMS key identifier for the encrypted DB instance.
     * </p>
     * 
     * @return If <code>StorageEncrypted</code> is true, the KMS key identifier for the encrypted DB instance.
     */
    public final String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * Specifies the accessibility options for the DB instance.
     * </p>
     * <p>
     * A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to a
     * public IP address.
     * </p>
     * <p>
     * A value of false specifies an internal instance with a DNS name that resolves to a private IP address.
     * </p>
     * 
     * @return Specifies the accessibility options for the DB instance.</p>
     *         <p>
     *         A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves
     *         to a public IP address.
     *         </p>
     *         <p>
     *         A value of false specifies an internal instance with a DNS name that resolves to a private IP address.
     */
    public final Boolean publiclyAccessible() {
        return publiclyAccessible;
    }

    /**
     * <p>
     * Specifies whether the DB instance is encrypted.
     * </p>
     * 
     * @return Specifies whether the DB instance is encrypted.
     */
    public final Boolean storageEncrypted() {
        return storageEncrypted;
    }

    /**
     * <p>
     * The ARN from the key store with which the instance is associated for TDE encryption.
     * </p>
     * 
     * @return The ARN from the key store with which the instance is associated for TDE encryption.
     */
    public final String tdeCredentialArn() {
        return tdeCredentialArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcSecurityGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcSecurityGroups() {
        return vpcSecurityGroups != null && !(vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of VPC security groups that the DB instance belongs to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcSecurityGroups} method.
     * </p>
     * 
     * @return A list of VPC security groups that the DB instance belongs to.
     */
    public final List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups() {
        return vpcSecurityGroups;
    }

    /**
     * <p>
     * Whether the DB instance is a multiple Availability Zone deployment.
     * </p>
     * 
     * @return Whether the DB instance is a multiple Availability Zone deployment.
     */
    public final Boolean multiAz() {
        return multiAz;
    }

    /**
     * <p>
     * The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring metrics data for the DB instance.
     * </p>
     * 
     * @return The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring metrics data for the DB
     *         instance.
     */
    public final String enhancedMonitoringResourceArn() {
        return enhancedMonitoringResourceArn;
    }

    /**
     * <p>
     * The current status of the DB instance.
     * </p>
     * 
     * @return The current status of the DB instance.
     */
    public final String dbInstanceStatus() {
        return dbInstanceStatus;
    }

    /**
     * <p>
     * The master user name of the DB instance.
     * </p>
     * 
     * @return The master user name of the DB instance.
     */
    public final String masterUsername() {
        return masterUsername;
    }

    /**
     * <p>
     * The amount of storage (in gigabytes) to initially allocate for the DB instance.
     * </p>
     * 
     * @return The amount of storage (in gigabytes) to initially allocate for the DB instance.
     */
    public final Integer allocatedStorage() {
        return allocatedStorage;
    }

    /**
     * <p>
     * The range of time each day when automated backups are created, if automated backups are enabled.
     * </p>
     * <p>
     * Uses the format <code>HH:MM-HH:MM</code>. For example, <code>04:52-05:22</code>.
     * </p>
     * 
     * @return The range of time each day when automated backups are created, if automated backups are enabled.</p>
     *         <p>
     *         Uses the format <code>HH:MM-HH:MM</code>. For example, <code>04:52-05:22</code>.
     */
    public final String preferredBackupWindow() {
        return preferredBackupWindow;
    }

    /**
     * <p>
     * The number of days for which to retain automated backups.
     * </p>
     * 
     * @return The number of days for which to retain automated backups.
     */
    public final Integer backupRetentionPeriod() {
        return backupRetentionPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the DbSecurityGroups property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDbSecurityGroups() {
        return dbSecurityGroups != null && !(dbSecurityGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the DB security groups to assign to the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbSecurityGroups} method.
     * </p>
     * 
     * @return A list of the DB security groups to assign to the DB instance.
     */
    public final List<String> dbSecurityGroups() {
        return dbSecurityGroups;
    }

    /**
     * For responses, this returns true if the service returned a value for the DbParameterGroups property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDbParameterGroups() {
        return dbParameterGroups != null && !(dbParameterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of the DB parameter groups to assign to the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDbParameterGroups} method.
     * </p>
     * 
     * @return A list of the DB parameter groups to assign to the DB instance.
     */
    public final List<AwsRdsDbParameterGroup> dbParameterGroups() {
        return dbParameterGroups;
    }

    /**
     * <p>
     * The Availability Zone where the DB instance will be created.
     * </p>
     * 
     * @return The Availability Zone where the DB instance will be created.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Information about the subnet group that is associated with the DB instance.
     * </p>
     * 
     * @return Information about the subnet group that is associated with the DB instance.
     */
    public final AwsRdsDbSubnetGroup dbSubnetGroup() {
        return dbSubnetGroup;
    }

    /**
     * <p>
     * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
     * </p>
     * <p>
     * Uses the format <code>&lt;day&gt;:HH:MM-&lt;day&gt;:HH:MM</code>.
     * </p>
     * <p>
     * For the day values, use <code>mon</code>|<code>tue</code>|<code>wed</code>|<code>thu</code>|<code>fri</code>|
     * <code>sat</code>|<code>sun</code>.
     * </p>
     * <p>
     * For example, <code>sun:09:32-sun:10:02</code>.
     * </p>
     * 
     * @return The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).</p>
     *         <p>
     *         Uses the format <code>&lt;day&gt;:HH:MM-&lt;day&gt;:HH:MM</code>.
     *         </p>
     *         <p>
     *         For the day values, use <code>mon</code>|<code>tue</code>|<code>wed</code>|<code>thu</code>|
     *         <code>fri</code>|<code>sat</code>|<code>sun</code>.
     *         </p>
     *         <p>
     *         For example, <code>sun:09:32-sun:10:02</code>.
     */
    public final String preferredMaintenanceWindow() {
        return preferredMaintenanceWindow;
    }

    /**
     * <p>
     * Changes to the DB instance that are currently pending.
     * </p>
     * 
     * @return Changes to the DB instance that are currently pending.
     */
    public final AwsRdsDbPendingModifiedValues pendingModifiedValues() {
        return pendingModifiedValues;
    }

    /**
     * <p>
     * Specifies the latest time to which a database can be restored with point-in-time restore.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the latest time to which a database can be restored with point-in-time restore.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String latestRestorableTime() {
        return latestRestorableTime;
    }

    /**
     * <p>
     * Indicates whether minor version patches are applied automatically.
     * </p>
     * 
     * @return Indicates whether minor version patches are applied automatically.
     */
    public final Boolean autoMinorVersionUpgrade() {
        return autoMinorVersionUpgrade;
    }

    /**
     * <p>
     * If this DB instance is a read replica, contains the identifier of the source DB instance.
     * </p>
     * 
     * @return If this DB instance is a read replica, contains the identifier of the source DB instance.
     */
    public final String readReplicaSourceDBInstanceIdentifier() {
        return readReplicaSourceDBInstanceIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadReplicaDBInstanceIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReadReplicaDBInstanceIdentifiers() {
        return readReplicaDBInstanceIdentifiers != null && !(readReplicaDBInstanceIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of identifiers of the read replicas associated with this DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadReplicaDBInstanceIdentifiers}
     * method.
     * </p>
     * 
     * @return List of identifiers of the read replicas associated with this DB instance.
     */
    public final List<String> readReplicaDBInstanceIdentifiers() {
        return readReplicaDBInstanceIdentifiers;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReadReplicaDBClusterIdentifiers
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasReadReplicaDBClusterIdentifiers() {
        return readReplicaDBClusterIdentifiers != null && !(readReplicaDBClusterIdentifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReadReplicaDBClusterIdentifiers}
     * method.
     * </p>
     * 
     * @return List of identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica.
     */
    public final List<String> readReplicaDBClusterIdentifiers() {
        return readReplicaDBClusterIdentifiers;
    }

    /**
     * <p>
     * License model information for this DB instance.
     * </p>
     * 
     * @return License model information for this DB instance.
     */
    public final String licenseModel() {
        return licenseModel;
    }

    /**
     * <p>
     * Specifies the provisioned IOPS (I/O operations per second) for this DB instance.
     * </p>
     * 
     * @return Specifies the provisioned IOPS (I/O operations per second) for this DB instance.
     */
    public final Integer iops() {
        return iops;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptionGroupMemberships property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOptionGroupMemberships() {
        return optionGroupMemberships != null && !(optionGroupMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of option group memberships for this DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptionGroupMemberships} method.
     * </p>
     * 
     * @return The list of option group memberships for this DB instance.
     */
    public final List<AwsRdsDbOptionGroupMembership> optionGroupMemberships() {
        return optionGroupMemberships;
    }

    /**
     * <p>
     * The name of the character set that this DB instance is associated with.
     * </p>
     * 
     * @return The name of the character set that this DB instance is associated with.
     */
    public final String characterSetName() {
        return characterSetName;
    }

    /**
     * <p>
     * For a DB instance with multi-Availability Zone support, the name of the secondary Availability Zone.
     * </p>
     * 
     * @return For a DB instance with multi-Availability Zone support, the name of the secondary Availability Zone.
     */
    public final String secondaryAvailabilityZone() {
        return secondaryAvailabilityZone;
    }

    /**
     * For responses, this returns true if the service returned a value for the StatusInfos property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasStatusInfos() {
        return statusInfos != null && !(statusInfos instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The status of a read replica. If the instance isn't a read replica, this is empty.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatusInfos} method.
     * </p>
     * 
     * @return The status of a read replica. If the instance isn't a read replica, this is empty.
     */
    public final List<AwsRdsDbStatusInfo> statusInfos() {
        return statusInfos;
    }

    /**
     * <p>
     * The storage type for the DB instance.
     * </p>
     * 
     * @return The storage type for the DB instance.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainMemberships property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDomainMemberships() {
        return domainMemberships != null && !(domainMemberships instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Active Directory domain membership records associated with the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainMemberships} method.
     * </p>
     * 
     * @return The Active Directory domain membership records associated with the DB instance.
     */
    public final List<AwsRdsDbDomainMembership> domainMemberships() {
        return domainMemberships;
    }

    /**
     * <p>
     * Whether to copy resource tags to snapshots of the DB instance.
     * </p>
     * 
     * @return Whether to copy resource tags to snapshots of the DB instance.
     */
    public final Boolean copyTagsToSnapshot() {
        return copyTagsToSnapshot;
    }

    /**
     * <p>
     * The interval, in seconds, between points when enhanced monitoring metrics are collected for the DB instance.
     * </p>
     * 
     * @return The interval, in seconds, between points when enhanced monitoring metrics are collected for the DB
     *         instance.
     */
    public final Integer monitoringInterval() {
        return monitoringInterval;
    }

    /**
     * <p>
     * The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring metrics to CloudWatch Logs.
     * </p>
     * 
     * @return The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring metrics to CloudWatch Logs.
     */
    public final String monitoringRoleArn() {
        return monitoringRoleArn;
    }

    /**
     * <p>
     * The order in which to promote an Aurora replica to the primary instance after a failure of the existing primary
     * instance.
     * </p>
     * 
     * @return The order in which to promote an Aurora replica to the primary instance after a failure of the existing
     *         primary instance.
     */
    public final Integer promotionTier() {
        return promotionTier;
    }

    /**
     * <p>
     * The time zone of the DB instance.
     * </p>
     * 
     * @return The time zone of the DB instance.
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * Indicates whether Performance Insights is enabled for the DB instance.
     * </p>
     * 
     * @return Indicates whether Performance Insights is enabled for the DB instance.
     */
    public final Boolean performanceInsightsEnabled() {
        return performanceInsightsEnabled;
    }

    /**
     * <p>
     * The identifier of the KMS key used to encrypt the Performance Insights data.
     * </p>
     * 
     * @return The identifier of the KMS key used to encrypt the Performance Insights data.
     */
    public final String performanceInsightsKmsKeyId() {
        return performanceInsightsKmsKeyId;
    }

    /**
     * <p>
     * The number of days to retain Performance Insights data.
     * </p>
     * 
     * @return The number of days to retain Performance Insights data.
     */
    public final Integer performanceInsightsRetentionPeriod() {
        return performanceInsightsRetentionPeriod;
    }

    /**
     * For responses, this returns true if the service returned a value for the EnabledCloudWatchLogsExports property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEnabledCloudWatchLogsExports() {
        return enabledCloudWatchLogsExports != null && !(enabledCloudWatchLogsExports instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of log types that this DB instance is configured to export to CloudWatch Logs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEnabledCloudWatchLogsExports} method.
     * </p>
     * 
     * @return A list of log types that this DB instance is configured to export to CloudWatch Logs.
     */
    public final List<String> enabledCloudWatchLogsExports() {
        return enabledCloudWatchLogsExports;
    }

    /**
     * For responses, this returns true if the service returned a value for the ProcessorFeatures property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasProcessorFeatures() {
        return processorFeatures != null && !(processorFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasProcessorFeatures} method.
     * </p>
     * 
     * @return The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
     */
    public final List<AwsRdsDbProcessorFeature> processorFeatures() {
        return processorFeatures;
    }

    /**
     * Returns the value of the ListenerEndpoint property for this object.
     * 
     * @return The value of the ListenerEndpoint property for this object.
     */
    public final AwsRdsDbInstanceEndpoint listenerEndpoint() {
        return listenerEndpoint;
    }

    /**
     * <p>
     * The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.
     * </p>
     * 
     * @return The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.
     */
    public final Integer maxAllocatedStorage() {
        return maxAllocatedStorage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedRoles() ? associatedRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(caCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceClass());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstancePort());
        hashCode = 31 * hashCode + Objects.hashCode(dbiResourceId());
        hashCode = 31 * hashCode + Objects.hashCode(dbName());
        hashCode = 31 * hashCode + Objects.hashCode(deletionProtection());
        hashCode = 31 * hashCode + Objects.hashCode(endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(engine());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(iamDatabaseAuthenticationEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(instanceCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(storageEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(tdeCredentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcSecurityGroups() ? vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(multiAz());
        hashCode = 31 * hashCode + Objects.hashCode(enhancedMonitoringResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(dbInstanceStatus());
        hashCode = 31 * hashCode + Objects.hashCode(masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(allocatedStorage());
        hashCode = 31 * hashCode + Objects.hashCode(preferredBackupWindow());
        hashCode = 31 * hashCode + Objects.hashCode(backupRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasDbSecurityGroups() ? dbSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDbParameterGroups() ? dbParameterGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(dbSubnetGroup());
        hashCode = 31 * hashCode + Objects.hashCode(preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(latestRestorableTime());
        hashCode = 31 * hashCode + Objects.hashCode(autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(readReplicaSourceDBInstanceIdentifier());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReadReplicaDBInstanceIdentifiers() ? readReplicaDBInstanceIdentifiers() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasReadReplicaDBClusterIdentifiers() ? readReplicaDBClusterIdentifiers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(licenseModel());
        hashCode = 31 * hashCode + Objects.hashCode(iops());
        hashCode = 31 * hashCode + Objects.hashCode(hasOptionGroupMemberships() ? optionGroupMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(characterSetName());
        hashCode = 31 * hashCode + Objects.hashCode(secondaryAvailabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatusInfos() ? statusInfos() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainMemberships() ? domainMemberships() : null);
        hashCode = 31 * hashCode + Objects.hashCode(copyTagsToSnapshot());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringInterval());
        hashCode = 31 * hashCode + Objects.hashCode(monitoringRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(promotionTier());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(performanceInsightsRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(hasEnabledCloudWatchLogsExports() ? enabledCloudWatchLogsExports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasProcessorFeatures() ? processorFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(listenerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(maxAllocatedStorage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbInstanceDetails)) {
            return false;
        }
        AwsRdsDbInstanceDetails other = (AwsRdsDbInstanceDetails) obj;
        return hasAssociatedRoles() == other.hasAssociatedRoles() && Objects.equals(associatedRoles(), other.associatedRoles())
                && Objects.equals(caCertificateIdentifier(), other.caCertificateIdentifier())
                && Objects.equals(dbClusterIdentifier(), other.dbClusterIdentifier())
                && Objects.equals(dbInstanceIdentifier(), other.dbInstanceIdentifier())
                && Objects.equals(dbInstanceClass(), other.dbInstanceClass())
                && Objects.equals(dbInstancePort(), other.dbInstancePort())
                && Objects.equals(dbiResourceId(), other.dbiResourceId()) && Objects.equals(dbName(), other.dbName())
                && Objects.equals(deletionProtection(), other.deletionProtection())
                && Objects.equals(endpoint(), other.endpoint()) && Objects.equals(engine(), other.engine())
                && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(iamDatabaseAuthenticationEnabled(), other.iamDatabaseAuthenticationEnabled())
                && Objects.equals(instanceCreateTime(), other.instanceCreateTime())
                && Objects.equals(kmsKeyId(), other.kmsKeyId())
                && Objects.equals(publiclyAccessible(), other.publiclyAccessible())
                && Objects.equals(storageEncrypted(), other.storageEncrypted())
                && Objects.equals(tdeCredentialArn(), other.tdeCredentialArn())
                && hasVpcSecurityGroups() == other.hasVpcSecurityGroups()
                && Objects.equals(vpcSecurityGroups(), other.vpcSecurityGroups()) && Objects.equals(multiAz(), other.multiAz())
                && Objects.equals(enhancedMonitoringResourceArn(), other.enhancedMonitoringResourceArn())
                && Objects.equals(dbInstanceStatus(), other.dbInstanceStatus())
                && Objects.equals(masterUsername(), other.masterUsername())
                && Objects.equals(allocatedStorage(), other.allocatedStorage())
                && Objects.equals(preferredBackupWindow(), other.preferredBackupWindow())
                && Objects.equals(backupRetentionPeriod(), other.backupRetentionPeriod())
                && hasDbSecurityGroups() == other.hasDbSecurityGroups()
                && Objects.equals(dbSecurityGroups(), other.dbSecurityGroups())
                && hasDbParameterGroups() == other.hasDbParameterGroups()
                && Objects.equals(dbParameterGroups(), other.dbParameterGroups())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(dbSubnetGroup(), other.dbSubnetGroup())
                && Objects.equals(preferredMaintenanceWindow(), other.preferredMaintenanceWindow())
                && Objects.equals(pendingModifiedValues(), other.pendingModifiedValues())
                && Objects.equals(latestRestorableTime(), other.latestRestorableTime())
                && Objects.equals(autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade())
                && Objects.equals(readReplicaSourceDBInstanceIdentifier(), other.readReplicaSourceDBInstanceIdentifier())
                && hasReadReplicaDBInstanceIdentifiers() == other.hasReadReplicaDBInstanceIdentifiers()
                && Objects.equals(readReplicaDBInstanceIdentifiers(), other.readReplicaDBInstanceIdentifiers())
                && hasReadReplicaDBClusterIdentifiers() == other.hasReadReplicaDBClusterIdentifiers()
                && Objects.equals(readReplicaDBClusterIdentifiers(), other.readReplicaDBClusterIdentifiers())
                && Objects.equals(licenseModel(), other.licenseModel()) && Objects.equals(iops(), other.iops())
                && hasOptionGroupMemberships() == other.hasOptionGroupMemberships()
                && Objects.equals(optionGroupMemberships(), other.optionGroupMemberships())
                && Objects.equals(characterSetName(), other.characterSetName())
                && Objects.equals(secondaryAvailabilityZone(), other.secondaryAvailabilityZone())
                && hasStatusInfos() == other.hasStatusInfos() && Objects.equals(statusInfos(), other.statusInfos())
                && Objects.equals(storageType(), other.storageType()) && hasDomainMemberships() == other.hasDomainMemberships()
                && Objects.equals(domainMemberships(), other.domainMemberships())
                && Objects.equals(copyTagsToSnapshot(), other.copyTagsToSnapshot())
                && Objects.equals(monitoringInterval(), other.monitoringInterval())
                && Objects.equals(monitoringRoleArn(), other.monitoringRoleArn())
                && Objects.equals(promotionTier(), other.promotionTier()) && Objects.equals(timezone(), other.timezone())
                && Objects.equals(performanceInsightsEnabled(), other.performanceInsightsEnabled())
                && Objects.equals(performanceInsightsKmsKeyId(), other.performanceInsightsKmsKeyId())
                && Objects.equals(performanceInsightsRetentionPeriod(), other.performanceInsightsRetentionPeriod())
                && hasEnabledCloudWatchLogsExports() == other.hasEnabledCloudWatchLogsExports()
                && Objects.equals(enabledCloudWatchLogsExports(), other.enabledCloudWatchLogsExports())
                && hasProcessorFeatures() == other.hasProcessorFeatures()
                && Objects.equals(processorFeatures(), other.processorFeatures())
                && Objects.equals(listenerEndpoint(), other.listenerEndpoint())
                && Objects.equals(maxAllocatedStorage(), other.maxAllocatedStorage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("AwsRdsDbInstanceDetails")
                .add("AssociatedRoles", hasAssociatedRoles() ? associatedRoles() : null)
                .add("CACertificateIdentifier", caCertificateIdentifier())
                .add("DBClusterIdentifier", dbClusterIdentifier())
                .add("DBInstanceIdentifier", dbInstanceIdentifier())
                .add("DBInstanceClass", dbInstanceClass())
                .add("DbInstancePort", dbInstancePort())
                .add("DbiResourceId", dbiResourceId())
                .add("DBName", dbName())
                .add("DeletionProtection", deletionProtection())
                .add("Endpoint", endpoint())
                .add("Engine", engine())
                .add("EngineVersion", engineVersion())
                .add("IAMDatabaseAuthenticationEnabled", iamDatabaseAuthenticationEnabled())
                .add("InstanceCreateTime", instanceCreateTime())
                .add("KmsKeyId", kmsKeyId())
                .add("PubliclyAccessible", publiclyAccessible())
                .add("StorageEncrypted", storageEncrypted())
                .add("TdeCredentialArn", tdeCredentialArn())
                .add("VpcSecurityGroups", hasVpcSecurityGroups() ? vpcSecurityGroups() : null)
                .add("MultiAz", multiAz())
                .add("EnhancedMonitoringResourceArn", enhancedMonitoringResourceArn())
                .add("DbInstanceStatus", dbInstanceStatus())
                .add("MasterUsername", masterUsername())
                .add("AllocatedStorage", allocatedStorage())
                .add("PreferredBackupWindow", preferredBackupWindow())
                .add("BackupRetentionPeriod", backupRetentionPeriod())
                .add("DbSecurityGroups", hasDbSecurityGroups() ? dbSecurityGroups() : null)
                .add("DbParameterGroups", hasDbParameterGroups() ? dbParameterGroups() : null)
                .add("AvailabilityZone", availabilityZone())
                .add("DbSubnetGroup", dbSubnetGroup())
                .add("PreferredMaintenanceWindow", preferredMaintenanceWindow())
                .add("PendingModifiedValues", pendingModifiedValues())
                .add("LatestRestorableTime", latestRestorableTime())
                .add("AutoMinorVersionUpgrade", autoMinorVersionUpgrade())
                .add("ReadReplicaSourceDBInstanceIdentifier", readReplicaSourceDBInstanceIdentifier())
                .add("ReadReplicaDBInstanceIdentifiers",
                        hasReadReplicaDBInstanceIdentifiers() ? readReplicaDBInstanceIdentifiers() : null)
                .add("ReadReplicaDBClusterIdentifiers",
                        hasReadReplicaDBClusterIdentifiers() ? readReplicaDBClusterIdentifiers() : null)
                .add("LicenseModel", licenseModel()).add("Iops", iops())
                .add("OptionGroupMemberships", hasOptionGroupMemberships() ? optionGroupMemberships() : null)
                .add("CharacterSetName", characterSetName()).add("SecondaryAvailabilityZone", secondaryAvailabilityZone())
                .add("StatusInfos", hasStatusInfos() ? statusInfos() : null).add("StorageType", storageType())
                .add("DomainMemberships", hasDomainMemberships() ? domainMemberships() : null)
                .add("CopyTagsToSnapshot", copyTagsToSnapshot()).add("MonitoringInterval", monitoringInterval())
                .add("MonitoringRoleArn", monitoringRoleArn()).add("PromotionTier", promotionTier()).add("Timezone", timezone())
                .add("PerformanceInsightsEnabled", performanceInsightsEnabled())
                .add("PerformanceInsightsKmsKeyId", performanceInsightsKmsKeyId())
                .add("PerformanceInsightsRetentionPeriod", performanceInsightsRetentionPeriod())
                .add("EnabledCloudWatchLogsExports", hasEnabledCloudWatchLogsExports() ? enabledCloudWatchLogsExports() : null)
                .add("ProcessorFeatures", hasProcessorFeatures() ? processorFeatures() : null)
                .add("ListenerEndpoint", listenerEndpoint()).add("MaxAllocatedStorage", maxAllocatedStorage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AssociatedRoles":
            return Optional.ofNullable(clazz.cast(associatedRoles()));
        case "CACertificateIdentifier":
            return Optional.ofNullable(clazz.cast(caCertificateIdentifier()));
        case "DBClusterIdentifier":
            return Optional.ofNullable(clazz.cast(dbClusterIdentifier()));
        case "DBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(dbInstanceIdentifier()));
        case "DBInstanceClass":
            return Optional.ofNullable(clazz.cast(dbInstanceClass()));
        case "DbInstancePort":
            return Optional.ofNullable(clazz.cast(dbInstancePort()));
        case "DbiResourceId":
            return Optional.ofNullable(clazz.cast(dbiResourceId()));
        case "DBName":
            return Optional.ofNullable(clazz.cast(dbName()));
        case "DeletionProtection":
            return Optional.ofNullable(clazz.cast(deletionProtection()));
        case "Endpoint":
            return Optional.ofNullable(clazz.cast(endpoint()));
        case "Engine":
            return Optional.ofNullable(clazz.cast(engine()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "IAMDatabaseAuthenticationEnabled":
            return Optional.ofNullable(clazz.cast(iamDatabaseAuthenticationEnabled()));
        case "InstanceCreateTime":
            return Optional.ofNullable(clazz.cast(instanceCreateTime()));
        case "KmsKeyId":
            return Optional.ofNullable(clazz.cast(kmsKeyId()));
        case "PubliclyAccessible":
            return Optional.ofNullable(clazz.cast(publiclyAccessible()));
        case "StorageEncrypted":
            return Optional.ofNullable(clazz.cast(storageEncrypted()));
        case "TdeCredentialArn":
            return Optional.ofNullable(clazz.cast(tdeCredentialArn()));
        case "VpcSecurityGroups":
            return Optional.ofNullable(clazz.cast(vpcSecurityGroups()));
        case "MultiAz":
            return Optional.ofNullable(clazz.cast(multiAz()));
        case "EnhancedMonitoringResourceArn":
            return Optional.ofNullable(clazz.cast(enhancedMonitoringResourceArn()));
        case "DbInstanceStatus":
            return Optional.ofNullable(clazz.cast(dbInstanceStatus()));
        case "MasterUsername":
            return Optional.ofNullable(clazz.cast(masterUsername()));
        case "AllocatedStorage":
            return Optional.ofNullable(clazz.cast(allocatedStorage()));
        case "PreferredBackupWindow":
            return Optional.ofNullable(clazz.cast(preferredBackupWindow()));
        case "BackupRetentionPeriod":
            return Optional.ofNullable(clazz.cast(backupRetentionPeriod()));
        case "DbSecurityGroups":
            return Optional.ofNullable(clazz.cast(dbSecurityGroups()));
        case "DbParameterGroups":
            return Optional.ofNullable(clazz.cast(dbParameterGroups()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "DbSubnetGroup":
            return Optional.ofNullable(clazz.cast(dbSubnetGroup()));
        case "PreferredMaintenanceWindow":
            return Optional.ofNullable(clazz.cast(preferredMaintenanceWindow()));
        case "PendingModifiedValues":
            return Optional.ofNullable(clazz.cast(pendingModifiedValues()));
        case "LatestRestorableTime":
            return Optional.ofNullable(clazz.cast(latestRestorableTime()));
        case "AutoMinorVersionUpgrade":
            return Optional.ofNullable(clazz.cast(autoMinorVersionUpgrade()));
        case "ReadReplicaSourceDBInstanceIdentifier":
            return Optional.ofNullable(clazz.cast(readReplicaSourceDBInstanceIdentifier()));
        case "ReadReplicaDBInstanceIdentifiers":
            return Optional.ofNullable(clazz.cast(readReplicaDBInstanceIdentifiers()));
        case "ReadReplicaDBClusterIdentifiers":
            return Optional.ofNullable(clazz.cast(readReplicaDBClusterIdentifiers()));
        case "LicenseModel":
            return Optional.ofNullable(clazz.cast(licenseModel()));
        case "Iops":
            return Optional.ofNullable(clazz.cast(iops()));
        case "OptionGroupMemberships":
            return Optional.ofNullable(clazz.cast(optionGroupMemberships()));
        case "CharacterSetName":
            return Optional.ofNullable(clazz.cast(characterSetName()));
        case "SecondaryAvailabilityZone":
            return Optional.ofNullable(clazz.cast(secondaryAvailabilityZone()));
        case "StatusInfos":
            return Optional.ofNullable(clazz.cast(statusInfos()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "DomainMemberships":
            return Optional.ofNullable(clazz.cast(domainMemberships()));
        case "CopyTagsToSnapshot":
            return Optional.ofNullable(clazz.cast(copyTagsToSnapshot()));
        case "MonitoringInterval":
            return Optional.ofNullable(clazz.cast(monitoringInterval()));
        case "MonitoringRoleArn":
            return Optional.ofNullable(clazz.cast(monitoringRoleArn()));
        case "PromotionTier":
            return Optional.ofNullable(clazz.cast(promotionTier()));
        case "Timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "PerformanceInsightsEnabled":
            return Optional.ofNullable(clazz.cast(performanceInsightsEnabled()));
        case "PerformanceInsightsKmsKeyId":
            return Optional.ofNullable(clazz.cast(performanceInsightsKmsKeyId()));
        case "PerformanceInsightsRetentionPeriod":
            return Optional.ofNullable(clazz.cast(performanceInsightsRetentionPeriod()));
        case "EnabledCloudWatchLogsExports":
            return Optional.ofNullable(clazz.cast(enabledCloudWatchLogsExports()));
        case "ProcessorFeatures":
            return Optional.ofNullable(clazz.cast(processorFeatures()));
        case "ListenerEndpoint":
            return Optional.ofNullable(clazz.cast(listenerEndpoint()));
        case "MaxAllocatedStorage":
            return Optional.ofNullable(clazz.cast(maxAllocatedStorage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbInstanceDetails, T> g) {
        return obj -> g.apply((AwsRdsDbInstanceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbInstanceDetails> {
        /**
         * <p>
         * The IAM roles associated with the DB instance.
         * </p>
         * 
         * @param associatedRoles
         *        The IAM roles associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(Collection<AwsRdsDbInstanceAssociatedRole> associatedRoles);

        /**
         * <p>
         * The IAM roles associated with the DB instance.
         * </p>
         * 
         * @param associatedRoles
         *        The IAM roles associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedRoles(AwsRdsDbInstanceAssociatedRole... associatedRoles);

        /**
         * <p>
         * The IAM roles associated with the DB instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole.Builder#build()} is
         * called immediately and its result is passed to {@link #associatedRoles(List<AwsRdsDbInstanceAssociatedRole>)}.
         * 
         * @param associatedRoles
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceAssociatedRole.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #associatedRoles(java.util.Collection<AwsRdsDbInstanceAssociatedRole>)
         */
        Builder associatedRoles(Consumer<AwsRdsDbInstanceAssociatedRole.Builder>... associatedRoles);

        /**
         * <p>
         * The identifier of the CA certificate for this DB instance.
         * </p>
         * 
         * @param caCertificateIdentifier
         *        The identifier of the CA certificate for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caCertificateIdentifier(String caCertificateIdentifier);

        /**
         * <p>
         * If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB instance is a
         * member of.
         * </p>
         * 
         * @param dbClusterIdentifier
         *        If the DB instance is a member of a DB cluster, contains the name of the DB cluster that the DB
         *        instance is a member of.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbClusterIdentifier(String dbClusterIdentifier);

        /**
         * <p>
         * Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB
         * instance.
         * </p>
         * 
         * @param dbInstanceIdentifier
         *        Contains a user-supplied database identifier. This identifier is the unique key that identifies a DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceIdentifier(String dbInstanceIdentifier);

        /**
         * <p>
         * Contains the name of the compute and memory capacity class of the DB instance.
         * </p>
         * 
         * @param dbInstanceClass
         *        Contains the name of the compute and memory capacity class of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceClass(String dbInstanceClass);

        /**
         * <p>
         * Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this can be a
         * different port than the DB cluster port.
         * </p>
         * 
         * @param dbInstancePort
         *        Specifies the port that the DB instance listens on. If the DB instance is part of a DB cluster, this
         *        can be a different port than the DB cluster port.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstancePort(Integer dbInstancePort);

        /**
         * <p>
         * The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is found in
         * CloudTrail log entries whenever the KMS key for the DB instance is accessed.
         * </p>
         * 
         * @param dbiResourceId
         *        The Amazon Web Services Region-unique, immutable identifier for the DB instance. This identifier is
         *        found in CloudTrail log entries whenever the KMS key for the DB instance is accessed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbiResourceId(String dbiResourceId);

        /**
         * <p>
         * The meaning of this parameter differs according to the database engine you use.
         * </p>
         * <p>
         * <b>MySQL, MariaDB, SQL Server, PostgreSQL</b>
         * </p>
         * <p>
         * Contains the name of the initial database of this instance that was provided at create time, if one was
         * specified when the DB instance was created. This same name is returned for the life of the DB instance.
         * </p>
         * <p>
         * <b>Oracle</b>
         * </p>
         * <p>
         * Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters don't
         * apply to an Oracle DB instance.
         * </p>
         * 
         * @param dbName
         *        The meaning of this parameter differs according to the database engine you use.</p>
         *        <p>
         *        <b>MySQL, MariaDB, SQL Server, PostgreSQL</b>
         *        </p>
         *        <p>
         *        Contains the name of the initial database of this instance that was provided at create time, if one
         *        was specified when the DB instance was created. This same name is returned for the life of the DB
         *        instance.
         *        </p>
         *        <p>
         *        <b>Oracle</b>
         *        </p>
         *        <p>
         *        Contains the Oracle System ID (SID) of the created DB instance. Not shown when the returned parameters
         *        don't apply to an Oracle DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbName(String dbName);

        /**
         * <p>
         * Indicates whether the DB instance has deletion protection enabled.
         * </p>
         * <p>
         * When deletion protection is enabled, the database cannot be deleted.
         * </p>
         * 
         * @param deletionProtection
         *        Indicates whether the DB instance has deletion protection enabled.</p>
         *        <p>
         *        When deletion protection is enabled, the database cannot be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletionProtection(Boolean deletionProtection);

        /**
         * <p>
         * Specifies the connection endpoint.
         * </p>
         * 
         * @param endpoint
         *        Specifies the connection endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endpoint(AwsRdsDbInstanceEndpoint endpoint);

        /**
         * <p>
         * Specifies the connection endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRdsDbInstanceEndpoint.Builder}
         * avoiding the need to create one manually via {@link AwsRdsDbInstanceEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsDbInstanceEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #endpoint(AwsRdsDbInstanceEndpoint)}.
         * 
         * @param endpoint
         *        a consumer that will call methods on {@link AwsRdsDbInstanceEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #endpoint(AwsRdsDbInstanceEndpoint)
         */
        default Builder endpoint(Consumer<AwsRdsDbInstanceEndpoint.Builder> endpoint) {
            return endpoint(AwsRdsDbInstanceEndpoint.builder().applyMutation(endpoint).build());
        }

        /**
         * <p>
         * Provides the name of the database engine to use for this DB instance.
         * </p>
         * 
         * @param engine
         *        Provides the name of the database engine to use for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engine(String engine);

        /**
         * <p>
         * Indicates the database engine version.
         * </p>
         * 
         * @param engineVersion
         *        Indicates the database engine version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * True if mapping of IAM accounts to database accounts is enabled, and otherwise false.
         * </p>
         * <p>
         * IAM database authentication can be enabled for the following database engines.
         * </p>
         * <ul>
         * <li>
         * <p>
         * For MySQL 5.6, minor version 5.6.34 or higher
         * </p>
         * </li>
         * <li>
         * <p>
         * For MySQL 5.7, minor version 5.7.16 or higher
         * </p>
         * </li>
         * <li>
         * <p>
         * Aurora 5.6 or higher
         * </p>
         * </li>
         * </ul>
         * 
         * @param iamDatabaseAuthenticationEnabled
         *        True if mapping of IAM accounts to database accounts is enabled, and otherwise false.</p>
         *        <p>
         *        IAM database authentication can be enabled for the following database engines.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        For MySQL 5.6, minor version 5.6.34 or higher
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        For MySQL 5.7, minor version 5.7.16 or higher
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Aurora 5.6 or higher
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled);

        /**
         * <p>
         * Indicates when the DB instance was created.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceCreateTime
         *        Indicates when the DB instance was created.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCreateTime(String instanceCreateTime);

        /**
         * <p>
         * If <code>StorageEncrypted</code> is true, the KMS key identifier for the encrypted DB instance.
         * </p>
         * 
         * @param kmsKeyId
         *        If <code>StorageEncrypted</code> is true, the KMS key identifier for the encrypted DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * Specifies the accessibility options for the DB instance.
         * </p>
         * <p>
         * A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which resolves to
         * a public IP address.
         * </p>
         * <p>
         * A value of false specifies an internal instance with a DNS name that resolves to a private IP address.
         * </p>
         * 
         * @param publiclyAccessible
         *        Specifies the accessibility options for the DB instance.</p>
         *        <p>
         *        A value of true specifies an Internet-facing instance with a publicly resolvable DNS name, which
         *        resolves to a public IP address.
         *        </p>
         *        <p>
         *        A value of false specifies an internal instance with a DNS name that resolves to a private IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publiclyAccessible(Boolean publiclyAccessible);

        /**
         * <p>
         * Specifies whether the DB instance is encrypted.
         * </p>
         * 
         * @param storageEncrypted
         *        Specifies whether the DB instance is encrypted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageEncrypted(Boolean storageEncrypted);

        /**
         * <p>
         * The ARN from the key store with which the instance is associated for TDE encryption.
         * </p>
         * 
         * @param tdeCredentialArn
         *        The ARN from the key store with which the instance is associated for TDE encryption.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tdeCredentialArn(String tdeCredentialArn);

        /**
         * <p>
         * A list of VPC security groups that the DB instance belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        A list of VPC security groups that the DB instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups);

        /**
         * <p>
         * A list of VPC security groups that the DB instance belongs to.
         * </p>
         * 
         * @param vpcSecurityGroups
         *        A list of VPC security groups that the DB instance belongs to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcSecurityGroups(AwsRdsDbInstanceVpcSecurityGroup... vpcSecurityGroups);

        /**
         * <p>
         * A list of VPC security groups that the DB instance belongs to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #vpcSecurityGroups(List<AwsRdsDbInstanceVpcSecurityGroup>)}.
         * 
         * @param vpcSecurityGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbInstanceVpcSecurityGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcSecurityGroups(java.util.Collection<AwsRdsDbInstanceVpcSecurityGroup>)
         */
        Builder vpcSecurityGroups(Consumer<AwsRdsDbInstanceVpcSecurityGroup.Builder>... vpcSecurityGroups);

        /**
         * <p>
         * Whether the DB instance is a multiple Availability Zone deployment.
         * </p>
         * 
         * @param multiAz
         *        Whether the DB instance is a multiple Availability Zone deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiAz(Boolean multiAz);

        /**
         * <p>
         * The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring metrics data for the DB
         * instance.
         * </p>
         * 
         * @param enhancedMonitoringResourceArn
         *        The ARN of the CloudWatch Logs log stream that receives the enhanced monitoring metrics data for the
         *        DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enhancedMonitoringResourceArn(String enhancedMonitoringResourceArn);

        /**
         * <p>
         * The current status of the DB instance.
         * </p>
         * 
         * @param dbInstanceStatus
         *        The current status of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbInstanceStatus(String dbInstanceStatus);

        /**
         * <p>
         * The master user name of the DB instance.
         * </p>
         * 
         * @param masterUsername
         *        The master user name of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder masterUsername(String masterUsername);

        /**
         * <p>
         * The amount of storage (in gigabytes) to initially allocate for the DB instance.
         * </p>
         * 
         * @param allocatedStorage
         *        The amount of storage (in gigabytes) to initially allocate for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allocatedStorage(Integer allocatedStorage);

        /**
         * <p>
         * The range of time each day when automated backups are created, if automated backups are enabled.
         * </p>
         * <p>
         * Uses the format <code>HH:MM-HH:MM</code>. For example, <code>04:52-05:22</code>.
         * </p>
         * 
         * @param preferredBackupWindow
         *        The range of time each day when automated backups are created, if automated backups are enabled.</p>
         *        <p>
         *        Uses the format <code>HH:MM-HH:MM</code>. For example, <code>04:52-05:22</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredBackupWindow(String preferredBackupWindow);

        /**
         * <p>
         * The number of days for which to retain automated backups.
         * </p>
         * 
         * @param backupRetentionPeriod
         *        The number of days for which to retain automated backups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRetentionPeriod(Integer backupRetentionPeriod);

        /**
         * <p>
         * A list of the DB security groups to assign to the DB instance.
         * </p>
         * 
         * @param dbSecurityGroups
         *        A list of the DB security groups to assign to the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(Collection<String> dbSecurityGroups);

        /**
         * <p>
         * A list of the DB security groups to assign to the DB instance.
         * </p>
         * 
         * @param dbSecurityGroups
         *        A list of the DB security groups to assign to the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSecurityGroups(String... dbSecurityGroups);

        /**
         * <p>
         * A list of the DB parameter groups to assign to the DB instance.
         * </p>
         * 
         * @param dbParameterGroups
         *        A list of the DB parameter groups to assign to the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroups(Collection<AwsRdsDbParameterGroup> dbParameterGroups);

        /**
         * <p>
         * A list of the DB parameter groups to assign to the DB instance.
         * </p>
         * 
         * @param dbParameterGroups
         *        A list of the DB parameter groups to assign to the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroups(AwsRdsDbParameterGroup... dbParameterGroups);

        /**
         * <p>
         * A list of the DB parameter groups to assign to the DB instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbParameterGroup.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbParameterGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbParameterGroup.Builder#build()} is called
         * immediately and its result is passed to {@link #dbParameterGroups(List<AwsRdsDbParameterGroup>)}.
         * 
         * @param dbParameterGroups
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbParameterGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbParameterGroups(java.util.Collection<AwsRdsDbParameterGroup>)
         */
        Builder dbParameterGroups(Consumer<AwsRdsDbParameterGroup.Builder>... dbParameterGroups);

        /**
         * <p>
         * The Availability Zone where the DB instance will be created.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone where the DB instance will be created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Information about the subnet group that is associated with the DB instance.
         * </p>
         * 
         * @param dbSubnetGroup
         *        Information about the subnet group that is associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbSubnetGroup(AwsRdsDbSubnetGroup dbSubnetGroup);

        /**
         * <p>
         * Information about the subnet group that is associated with the DB instance.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRdsDbSubnetGroup.Builder} avoiding the
         * need to create one manually via {@link AwsRdsDbSubnetGroup#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsDbSubnetGroup.Builder#build()} is called immediately and
         * its result is passed to {@link #dbSubnetGroup(AwsRdsDbSubnetGroup)}.
         * 
         * @param dbSubnetGroup
         *        a consumer that will call methods on {@link AwsRdsDbSubnetGroup.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbSubnetGroup(AwsRdsDbSubnetGroup)
         */
        default Builder dbSubnetGroup(Consumer<AwsRdsDbSubnetGroup.Builder> dbSubnetGroup) {
            return dbSubnetGroup(AwsRdsDbSubnetGroup.builder().applyMutation(dbSubnetGroup).build());
        }

        /**
         * <p>
         * The weekly time range during which system maintenance can occur, in Universal Coordinated Time (UTC).
         * </p>
         * <p>
         * Uses the format <code>&lt;day&gt;:HH:MM-&lt;day&gt;:HH:MM</code>.
         * </p>
         * <p>
         * For the day values, use <code>mon</code>|<code>tue</code>|<code>wed</code>|<code>thu</code>|<code>fri</code>|
         * <code>sat</code>|<code>sun</code>.
         * </p>
         * <p>
         * For example, <code>sun:09:32-sun:10:02</code>.
         * </p>
         * 
         * @param preferredMaintenanceWindow
         *        The weekly time range during which system maintenance can occur, in Universal Coordinated Time
         *        (UTC).</p>
         *        <p>
         *        Uses the format <code>&lt;day&gt;:HH:MM-&lt;day&gt;:HH:MM</code>.
         *        </p>
         *        <p>
         *        For the day values, use <code>mon</code>|<code>tue</code>|<code>wed</code>|<code>thu</code>|
         *        <code>fri</code>|<code>sat</code>|<code>sun</code>.
         *        </p>
         *        <p>
         *        For example, <code>sun:09:32-sun:10:02</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder preferredMaintenanceWindow(String preferredMaintenanceWindow);

        /**
         * <p>
         * Changes to the DB instance that are currently pending.
         * </p>
         * 
         * @param pendingModifiedValues
         *        Changes to the DB instance that are currently pending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingModifiedValues(AwsRdsDbPendingModifiedValues pendingModifiedValues);

        /**
         * <p>
         * Changes to the DB instance that are currently pending.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsRdsDbPendingModifiedValues.Builder}
         * avoiding the need to create one manually via {@link AwsRdsDbPendingModifiedValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsDbPendingModifiedValues.Builder#build()} is called
         * immediately and its result is passed to {@link #pendingModifiedValues(AwsRdsDbPendingModifiedValues)}.
         * 
         * @param pendingModifiedValues
         *        a consumer that will call methods on {@link AwsRdsDbPendingModifiedValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pendingModifiedValues(AwsRdsDbPendingModifiedValues)
         */
        default Builder pendingModifiedValues(Consumer<AwsRdsDbPendingModifiedValues.Builder> pendingModifiedValues) {
            return pendingModifiedValues(AwsRdsDbPendingModifiedValues.builder().applyMutation(pendingModifiedValues).build());
        }

        /**
         * <p>
         * Specifies the latest time to which a database can be restored with point-in-time restore.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param latestRestorableTime
         *        Specifies the latest time to which a database can be restored with point-in-time restore.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRestorableTime(String latestRestorableTime);

        /**
         * <p>
         * Indicates whether minor version patches are applied automatically.
         * </p>
         * 
         * @param autoMinorVersionUpgrade
         *        Indicates whether minor version patches are applied automatically.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade);

        /**
         * <p>
         * If this DB instance is a read replica, contains the identifier of the source DB instance.
         * </p>
         * 
         * @param readReplicaSourceDBInstanceIdentifier
         *        If this DB instance is a read replica, contains the identifier of the source DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier);

        /**
         * <p>
         * List of identifiers of the read replicas associated with this DB instance.
         * </p>
         * 
         * @param readReplicaDBInstanceIdentifiers
         *        List of identifiers of the read replicas associated with this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers);

        /**
         * <p>
         * List of identifiers of the read replicas associated with this DB instance.
         * </p>
         * 
         * @param readReplicaDBInstanceIdentifiers
         *        List of identifiers of the read replicas associated with this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaDBInstanceIdentifiers(String... readReplicaDBInstanceIdentifiers);

        /**
         * <p>
         * List of identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica.
         * </p>
         * 
         * @param readReplicaDBClusterIdentifiers
         *        List of identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read
         *        replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers);

        /**
         * <p>
         * List of identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read replica.
         * </p>
         * 
         * @param readReplicaDBClusterIdentifiers
         *        List of identifiers of Aurora DB clusters to which the RDS DB instance is replicated as a read
         *        replica.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readReplicaDBClusterIdentifiers(String... readReplicaDBClusterIdentifiers);

        /**
         * <p>
         * License model information for this DB instance.
         * </p>
         * 
         * @param licenseModel
         *        License model information for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseModel(String licenseModel);

        /**
         * <p>
         * Specifies the provisioned IOPS (I/O operations per second) for this DB instance.
         * </p>
         * 
         * @param iops
         *        Specifies the provisioned IOPS (I/O operations per second) for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);

        /**
         * <p>
         * The list of option group memberships for this DB instance.
         * </p>
         * 
         * @param optionGroupMemberships
         *        The list of option group memberships for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupMemberships(Collection<AwsRdsDbOptionGroupMembership> optionGroupMemberships);

        /**
         * <p>
         * The list of option group memberships for this DB instance.
         * </p>
         * 
         * @param optionGroupMemberships
         *        The list of option group memberships for this DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optionGroupMemberships(AwsRdsDbOptionGroupMembership... optionGroupMemberships);

        /**
         * <p>
         * The list of option group memberships for this DB instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbOptionGroupMembership.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbOptionGroupMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbOptionGroupMembership.Builder#build()} is
         * called immediately and its result is passed to {@link
         * #optionGroupMemberships(List<AwsRdsDbOptionGroupMembership>)}.
         * 
         * @param optionGroupMemberships
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbOptionGroupMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optionGroupMemberships(java.util.Collection<AwsRdsDbOptionGroupMembership>)
         */
        Builder optionGroupMemberships(Consumer<AwsRdsDbOptionGroupMembership.Builder>... optionGroupMemberships);

        /**
         * <p>
         * The name of the character set that this DB instance is associated with.
         * </p>
         * 
         * @param characterSetName
         *        The name of the character set that this DB instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder characterSetName(String characterSetName);

        /**
         * <p>
         * For a DB instance with multi-Availability Zone support, the name of the secondary Availability Zone.
         * </p>
         * 
         * @param secondaryAvailabilityZone
         *        For a DB instance with multi-Availability Zone support, the name of the secondary Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder secondaryAvailabilityZone(String secondaryAvailabilityZone);

        /**
         * <p>
         * The status of a read replica. If the instance isn't a read replica, this is empty.
         * </p>
         * 
         * @param statusInfos
         *        The status of a read replica. If the instance isn't a read replica, this is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusInfos(Collection<AwsRdsDbStatusInfo> statusInfos);

        /**
         * <p>
         * The status of a read replica. If the instance isn't a read replica, this is empty.
         * </p>
         * 
         * @param statusInfos
         *        The status of a read replica. If the instance isn't a read replica, this is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusInfos(AwsRdsDbStatusInfo... statusInfos);

        /**
         * <p>
         * The status of a read replica. If the instance isn't a read replica, this is empty.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo.Builder#build()} is called
         * immediately and its result is passed to {@link #statusInfos(List<AwsRdsDbStatusInfo>)}.
         * 
         * @param statusInfos
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbStatusInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #statusInfos(java.util.Collection<AwsRdsDbStatusInfo>)
         */
        Builder statusInfos(Consumer<AwsRdsDbStatusInfo.Builder>... statusInfos);

        /**
         * <p>
         * The storage type for the DB instance.
         * </p>
         * 
         * @param storageType
         *        The storage type for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The Active Directory domain membership records associated with the DB instance.
         * </p>
         * 
         * @param domainMemberships
         *        The Active Directory domain membership records associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainMemberships(Collection<AwsRdsDbDomainMembership> domainMemberships);

        /**
         * <p>
         * The Active Directory domain membership records associated with the DB instance.
         * </p>
         * 
         * @param domainMemberships
         *        The Active Directory domain membership records associated with the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainMemberships(AwsRdsDbDomainMembership... domainMemberships);

        /**
         * <p>
         * The Active Directory domain membership records associated with the DB instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership.Builder#build()} is called
         * immediately and its result is passed to {@link #domainMemberships(List<AwsRdsDbDomainMembership>)}.
         * 
         * @param domainMemberships
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbDomainMembership.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainMemberships(java.util.Collection<AwsRdsDbDomainMembership>)
         */
        Builder domainMemberships(Consumer<AwsRdsDbDomainMembership.Builder>... domainMemberships);

        /**
         * <p>
         * Whether to copy resource tags to snapshots of the DB instance.
         * </p>
         * 
         * @param copyTagsToSnapshot
         *        Whether to copy resource tags to snapshots of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot);

        /**
         * <p>
         * The interval, in seconds, between points when enhanced monitoring metrics are collected for the DB instance.
         * </p>
         * 
         * @param monitoringInterval
         *        The interval, in seconds, between points when enhanced monitoring metrics are collected for the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringInterval(Integer monitoringInterval);

        /**
         * <p>
         * The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring metrics to CloudWatch Logs.
         * </p>
         * 
         * @param monitoringRoleArn
         *        The ARN for the IAM role that permits Amazon RDS to send enhanced monitoring metrics to CloudWatch
         *        Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoringRoleArn(String monitoringRoleArn);

        /**
         * <p>
         * The order in which to promote an Aurora replica to the primary instance after a failure of the existing
         * primary instance.
         * </p>
         * 
         * @param promotionTier
         *        The order in which to promote an Aurora replica to the primary instance after a failure of the
         *        existing primary instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder promotionTier(Integer promotionTier);

        /**
         * <p>
         * The time zone of the DB instance.
         * </p>
         * 
         * @param timezone
         *        The time zone of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * Indicates whether Performance Insights is enabled for the DB instance.
         * </p>
         * 
         * @param performanceInsightsEnabled
         *        Indicates whether Performance Insights is enabled for the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsEnabled(Boolean performanceInsightsEnabled);

        /**
         * <p>
         * The identifier of the KMS key used to encrypt the Performance Insights data.
         * </p>
         * 
         * @param performanceInsightsKmsKeyId
         *        The identifier of the KMS key used to encrypt the Performance Insights data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsKmsKeyId(String performanceInsightsKmsKeyId);

        /**
         * <p>
         * The number of days to retain Performance Insights data.
         * </p>
         * 
         * @param performanceInsightsRetentionPeriod
         *        The number of days to retain Performance Insights data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod);

        /**
         * <p>
         * A list of log types that this DB instance is configured to export to CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudWatchLogsExports
         *        A list of log types that this DB instance is configured to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudWatchLogsExports(Collection<String> enabledCloudWatchLogsExports);

        /**
         * <p>
         * A list of log types that this DB instance is configured to export to CloudWatch Logs.
         * </p>
         * 
         * @param enabledCloudWatchLogsExports
         *        A list of log types that this DB instance is configured to export to CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabledCloudWatchLogsExports(String... enabledCloudWatchLogsExports);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(Collection<AwsRdsDbProcessorFeature> processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * 
         * @param processorFeatures
         *        The number of CPU cores and the number of threads per core for the DB instance class of the DB
         *        instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder processorFeatures(AwsRdsDbProcessorFeature... processorFeatures);

        /**
         * <p>
         * The number of CPU cores and the number of threads per core for the DB instance class of the DB instance.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature.Builder#build()} is called
         * immediately and its result is passed to {@link #processorFeatures(List<AwsRdsDbProcessorFeature>)}.
         * 
         * @param processorFeatures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRdsDbProcessorFeature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #processorFeatures(java.util.Collection<AwsRdsDbProcessorFeature>)
         */
        Builder processorFeatures(Consumer<AwsRdsDbProcessorFeature.Builder>... processorFeatures);

        /**
         * Sets the value of the ListenerEndpoint property for this object.
         *
         * @param listenerEndpoint
         *        The new value for the ListenerEndpoint property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerEndpoint(AwsRdsDbInstanceEndpoint listenerEndpoint);

        /**
         * Sets the value of the ListenerEndpoint property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AwsRdsDbInstanceEndpoint.Builder}
         * avoiding the need to create one manually via {@link AwsRdsDbInstanceEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRdsDbInstanceEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #listenerEndpoint(AwsRdsDbInstanceEndpoint)}.
         * 
         * @param listenerEndpoint
         *        a consumer that will call methods on {@link AwsRdsDbInstanceEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listenerEndpoint(AwsRdsDbInstanceEndpoint)
         */
        default Builder listenerEndpoint(Consumer<AwsRdsDbInstanceEndpoint.Builder> listenerEndpoint) {
            return listenerEndpoint(AwsRdsDbInstanceEndpoint.builder().applyMutation(listenerEndpoint).build());
        }

        /**
         * <p>
         * The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.
         * </p>
         * 
         * @param maxAllocatedStorage
         *        The upper limit to which Amazon RDS can automatically scale the storage of the DB instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxAllocatedStorage(Integer maxAllocatedStorage);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsRdsDbInstanceAssociatedRole> associatedRoles = DefaultSdkAutoConstructList.getInstance();

        private String caCertificateIdentifier;

        private String dbClusterIdentifier;

        private String dbInstanceIdentifier;

        private String dbInstanceClass;

        private Integer dbInstancePort;

        private String dbiResourceId;

        private String dbName;

        private Boolean deletionProtection;

        private AwsRdsDbInstanceEndpoint endpoint;

        private String engine;

        private String engineVersion;

        private Boolean iamDatabaseAuthenticationEnabled;

        private String instanceCreateTime;

        private String kmsKeyId;

        private Boolean publiclyAccessible;

        private Boolean storageEncrypted;

        private String tdeCredentialArn;

        private List<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private Boolean multiAz;

        private String enhancedMonitoringResourceArn;

        private String dbInstanceStatus;

        private String masterUsername;

        private Integer allocatedStorage;

        private String preferredBackupWindow;

        private Integer backupRetentionPeriod;

        private List<String> dbSecurityGroups = DefaultSdkAutoConstructList.getInstance();

        private List<AwsRdsDbParameterGroup> dbParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private String availabilityZone;

        private AwsRdsDbSubnetGroup dbSubnetGroup;

        private String preferredMaintenanceWindow;

        private AwsRdsDbPendingModifiedValues pendingModifiedValues;

        private String latestRestorableTime;

        private Boolean autoMinorVersionUpgrade;

        private String readReplicaSourceDBInstanceIdentifier;

        private List<String> readReplicaDBInstanceIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private List<String> readReplicaDBClusterIdentifiers = DefaultSdkAutoConstructList.getInstance();

        private String licenseModel;

        private Integer iops;

        private List<AwsRdsDbOptionGroupMembership> optionGroupMemberships = DefaultSdkAutoConstructList.getInstance();

        private String characterSetName;

        private String secondaryAvailabilityZone;

        private List<AwsRdsDbStatusInfo> statusInfos = DefaultSdkAutoConstructList.getInstance();

        private String storageType;

        private List<AwsRdsDbDomainMembership> domainMemberships = DefaultSdkAutoConstructList.getInstance();

        private Boolean copyTagsToSnapshot;

        private Integer monitoringInterval;

        private String monitoringRoleArn;

        private Integer promotionTier;

        private String timezone;

        private Boolean performanceInsightsEnabled;

        private String performanceInsightsKmsKeyId;

        private Integer performanceInsightsRetentionPeriod;

        private List<String> enabledCloudWatchLogsExports = DefaultSdkAutoConstructList.getInstance();

        private List<AwsRdsDbProcessorFeature> processorFeatures = DefaultSdkAutoConstructList.getInstance();

        private AwsRdsDbInstanceEndpoint listenerEndpoint;

        private Integer maxAllocatedStorage;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbInstanceDetails model) {
            associatedRoles(model.associatedRoles);
            caCertificateIdentifier(model.caCertificateIdentifier);
            dbClusterIdentifier(model.dbClusterIdentifier);
            dbInstanceIdentifier(model.dbInstanceIdentifier);
            dbInstanceClass(model.dbInstanceClass);
            dbInstancePort(model.dbInstancePort);
            dbiResourceId(model.dbiResourceId);
            dbName(model.dbName);
            deletionProtection(model.deletionProtection);
            endpoint(model.endpoint);
            engine(model.engine);
            engineVersion(model.engineVersion);
            iamDatabaseAuthenticationEnabled(model.iamDatabaseAuthenticationEnabled);
            instanceCreateTime(model.instanceCreateTime);
            kmsKeyId(model.kmsKeyId);
            publiclyAccessible(model.publiclyAccessible);
            storageEncrypted(model.storageEncrypted);
            tdeCredentialArn(model.tdeCredentialArn);
            vpcSecurityGroups(model.vpcSecurityGroups);
            multiAz(model.multiAz);
            enhancedMonitoringResourceArn(model.enhancedMonitoringResourceArn);
            dbInstanceStatus(model.dbInstanceStatus);
            masterUsername(model.masterUsername);
            allocatedStorage(model.allocatedStorage);
            preferredBackupWindow(model.preferredBackupWindow);
            backupRetentionPeriod(model.backupRetentionPeriod);
            dbSecurityGroups(model.dbSecurityGroups);
            dbParameterGroups(model.dbParameterGroups);
            availabilityZone(model.availabilityZone);
            dbSubnetGroup(model.dbSubnetGroup);
            preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            pendingModifiedValues(model.pendingModifiedValues);
            latestRestorableTime(model.latestRestorableTime);
            autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            readReplicaSourceDBInstanceIdentifier(model.readReplicaSourceDBInstanceIdentifier);
            readReplicaDBInstanceIdentifiers(model.readReplicaDBInstanceIdentifiers);
            readReplicaDBClusterIdentifiers(model.readReplicaDBClusterIdentifiers);
            licenseModel(model.licenseModel);
            iops(model.iops);
            optionGroupMemberships(model.optionGroupMemberships);
            characterSetName(model.characterSetName);
            secondaryAvailabilityZone(model.secondaryAvailabilityZone);
            statusInfos(model.statusInfos);
            storageType(model.storageType);
            domainMemberships(model.domainMemberships);
            copyTagsToSnapshot(model.copyTagsToSnapshot);
            monitoringInterval(model.monitoringInterval);
            monitoringRoleArn(model.monitoringRoleArn);
            promotionTier(model.promotionTier);
            timezone(model.timezone);
            performanceInsightsEnabled(model.performanceInsightsEnabled);
            performanceInsightsKmsKeyId(model.performanceInsightsKmsKeyId);
            performanceInsightsRetentionPeriod(model.performanceInsightsRetentionPeriod);
            enabledCloudWatchLogsExports(model.enabledCloudWatchLogsExports);
            processorFeatures(model.processorFeatures);
            listenerEndpoint(model.listenerEndpoint);
            maxAllocatedStorage(model.maxAllocatedStorage);
        }

        public final List<AwsRdsDbInstanceAssociatedRole.Builder> getAssociatedRoles() {
            List<AwsRdsDbInstanceAssociatedRole.Builder> result = AwsRdsDbInstanceAssociatedRolesCopier
                    .copyToBuilder(this.associatedRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociatedRoles(Collection<AwsRdsDbInstanceAssociatedRole.BuilderImpl> associatedRoles) {
            this.associatedRoles = AwsRdsDbInstanceAssociatedRolesCopier.copyFromBuilder(associatedRoles);
        }

        @Override
        public final Builder associatedRoles(Collection<AwsRdsDbInstanceAssociatedRole> associatedRoles) {
            this.associatedRoles = AwsRdsDbInstanceAssociatedRolesCopier.copy(associatedRoles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(AwsRdsDbInstanceAssociatedRole... associatedRoles) {
            associatedRoles(Arrays.asList(associatedRoles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associatedRoles(Consumer<AwsRdsDbInstanceAssociatedRole.Builder>... associatedRoles) {
            associatedRoles(Stream.of(associatedRoles)
                    .map(c -> AwsRdsDbInstanceAssociatedRole.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCaCertificateIdentifier() {
            return caCertificateIdentifier;
        }

        public final void setCaCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
        }

        @Override
        public final Builder caCertificateIdentifier(String caCertificateIdentifier) {
            this.caCertificateIdentifier = caCertificateIdentifier;
            return this;
        }

        public final String getDbClusterIdentifier() {
            return dbClusterIdentifier;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final String getDbInstanceIdentifier() {
            return dbInstanceIdentifier;
        }

        public final void setDbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
        }

        @Override
        public final Builder dbInstanceIdentifier(String dbInstanceIdentifier) {
            this.dbInstanceIdentifier = dbInstanceIdentifier;
            return this;
        }

        public final String getDbInstanceClass() {
            return dbInstanceClass;
        }

        public final void setDbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
        }

        @Override
        public final Builder dbInstanceClass(String dbInstanceClass) {
            this.dbInstanceClass = dbInstanceClass;
            return this;
        }

        public final Integer getDbInstancePort() {
            return dbInstancePort;
        }

        public final void setDbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
        }

        @Override
        public final Builder dbInstancePort(Integer dbInstancePort) {
            this.dbInstancePort = dbInstancePort;
            return this;
        }

        public final String getDbiResourceId() {
            return dbiResourceId;
        }

        public final void setDbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
        }

        @Override
        public final Builder dbiResourceId(String dbiResourceId) {
            this.dbiResourceId = dbiResourceId;
            return this;
        }

        public final String getDbName() {
            return dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final Boolean getDeletionProtection() {
            return deletionProtection;
        }

        public final void setDeletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
        }

        @Override
        public final Builder deletionProtection(Boolean deletionProtection) {
            this.deletionProtection = deletionProtection;
            return this;
        }

        public final AwsRdsDbInstanceEndpoint.Builder getEndpoint() {
            return endpoint != null ? endpoint.toBuilder() : null;
        }

        public final void setEndpoint(AwsRdsDbInstanceEndpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        public final Builder endpoint(AwsRdsDbInstanceEndpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final Boolean getIamDatabaseAuthenticationEnabled() {
            return iamDatabaseAuthenticationEnabled;
        }

        public final void setIamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
        }

        @Override
        public final Builder iamDatabaseAuthenticationEnabled(Boolean iamDatabaseAuthenticationEnabled) {
            this.iamDatabaseAuthenticationEnabled = iamDatabaseAuthenticationEnabled;
            return this;
        }

        public final String getInstanceCreateTime() {
            return instanceCreateTime;
        }

        public final void setInstanceCreateTime(String instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
        }

        @Override
        public final Builder instanceCreateTime(String instanceCreateTime) {
            this.instanceCreateTime = instanceCreateTime;
            return this;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Boolean getStorageEncrypted() {
            return storageEncrypted;
        }

        public final void setStorageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
        }

        @Override
        public final Builder storageEncrypted(Boolean storageEncrypted) {
            this.storageEncrypted = storageEncrypted;
            return this;
        }

        public final String getTdeCredentialArn() {
            return tdeCredentialArn;
        }

        public final void setTdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
        }

        @Override
        public final Builder tdeCredentialArn(String tdeCredentialArn) {
            this.tdeCredentialArn = tdeCredentialArn;
            return this;
        }

        public final List<AwsRdsDbInstanceVpcSecurityGroup.Builder> getVpcSecurityGroups() {
            List<AwsRdsDbInstanceVpcSecurityGroup.Builder> result = AwsRdsDbInstanceVpcSecurityGroupsCopier
                    .copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRdsDbInstanceVpcSecurityGroupsCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        public final Builder vpcSecurityGroups(Collection<AwsRdsDbInstanceVpcSecurityGroup> vpcSecurityGroups) {
            this.vpcSecurityGroups = AwsRdsDbInstanceVpcSecurityGroupsCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(AwsRdsDbInstanceVpcSecurityGroup... vpcSecurityGroups) {
            vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<AwsRdsDbInstanceVpcSecurityGroup.Builder>... vpcSecurityGroups) {
            vpcSecurityGroups(Stream.of(vpcSecurityGroups)
                    .map(c -> AwsRdsDbInstanceVpcSecurityGroup.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getMultiAz() {
            return multiAz;
        }

        public final void setMultiAz(Boolean multiAz) {
            this.multiAz = multiAz;
        }

        @Override
        public final Builder multiAz(Boolean multiAz) {
            this.multiAz = multiAz;
            return this;
        }

        public final String getEnhancedMonitoringResourceArn() {
            return enhancedMonitoringResourceArn;
        }

        public final void setEnhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
            this.enhancedMonitoringResourceArn = enhancedMonitoringResourceArn;
        }

        @Override
        public final Builder enhancedMonitoringResourceArn(String enhancedMonitoringResourceArn) {
            this.enhancedMonitoringResourceArn = enhancedMonitoringResourceArn;
            return this;
        }

        public final String getDbInstanceStatus() {
            return dbInstanceStatus;
        }

        public final void setDbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
        }

        @Override
        public final Builder dbInstanceStatus(String dbInstanceStatus) {
            this.dbInstanceStatus = dbInstanceStatus;
            return this;
        }

        public final String getMasterUsername() {
            return masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final Integer getAllocatedStorage() {
            return allocatedStorage;
        }

        public final void setAllocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
        }

        @Override
        public final Builder allocatedStorage(Integer allocatedStorage) {
            this.allocatedStorage = allocatedStorage;
            return this;
        }

        public final String getPreferredBackupWindow() {
            return preferredBackupWindow;
        }

        public final void setPreferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
        }

        @Override
        public final Builder preferredBackupWindow(String preferredBackupWindow) {
            this.preferredBackupWindow = preferredBackupWindow;
            return this;
        }

        public final Integer getBackupRetentionPeriod() {
            return backupRetentionPeriod;
        }

        public final void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
        }

        @Override
        public final Builder backupRetentionPeriod(Integer backupRetentionPeriod) {
            this.backupRetentionPeriod = backupRetentionPeriod;
            return this;
        }

        public final Collection<String> getDbSecurityGroups() {
            if (dbSecurityGroups instanceof SdkAutoConstructList) {
                return null;
            }
            return dbSecurityGroups;
        }

        public final void setDbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = StringListCopier.copy(dbSecurityGroups);
        }

        @Override
        public final Builder dbSecurityGroups(Collection<String> dbSecurityGroups) {
            this.dbSecurityGroups = StringListCopier.copy(dbSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbSecurityGroups(String... dbSecurityGroups) {
            dbSecurityGroups(Arrays.asList(dbSecurityGroups));
            return this;
        }

        public final List<AwsRdsDbParameterGroup.Builder> getDbParameterGroups() {
            List<AwsRdsDbParameterGroup.Builder> result = AwsRdsDbParameterGroupsCopier.copyToBuilder(this.dbParameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDbParameterGroups(Collection<AwsRdsDbParameterGroup.BuilderImpl> dbParameterGroups) {
            this.dbParameterGroups = AwsRdsDbParameterGroupsCopier.copyFromBuilder(dbParameterGroups);
        }

        @Override
        public final Builder dbParameterGroups(Collection<AwsRdsDbParameterGroup> dbParameterGroups) {
            this.dbParameterGroups = AwsRdsDbParameterGroupsCopier.copy(dbParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(AwsRdsDbParameterGroup... dbParameterGroups) {
            dbParameterGroups(Arrays.asList(dbParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(Consumer<AwsRdsDbParameterGroup.Builder>... dbParameterGroups) {
            dbParameterGroups(Stream.of(dbParameterGroups).map(c -> AwsRdsDbParameterGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final AwsRdsDbSubnetGroup.Builder getDbSubnetGroup() {
            return dbSubnetGroup != null ? dbSubnetGroup.toBuilder() : null;
        }

        public final void setDbSubnetGroup(AwsRdsDbSubnetGroup.BuilderImpl dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup != null ? dbSubnetGroup.build() : null;
        }

        @Override
        public final Builder dbSubnetGroup(AwsRdsDbSubnetGroup dbSubnetGroup) {
            this.dbSubnetGroup = dbSubnetGroup;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final AwsRdsDbPendingModifiedValues.Builder getPendingModifiedValues() {
            return pendingModifiedValues != null ? pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(AwsRdsDbPendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        public final Builder pendingModifiedValues(AwsRdsDbPendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final String getLatestRestorableTime() {
            return latestRestorableTime;
        }

        public final void setLatestRestorableTime(String latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
        }

        @Override
        public final Builder latestRestorableTime(String latestRestorableTime) {
            this.latestRestorableTime = latestRestorableTime;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getReadReplicaSourceDBInstanceIdentifier() {
            return readReplicaSourceDBInstanceIdentifier;
        }

        public final void setReadReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
            this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
        }

        @Override
        public final Builder readReplicaSourceDBInstanceIdentifier(String readReplicaSourceDBInstanceIdentifier) {
            this.readReplicaSourceDBInstanceIdentifier = readReplicaSourceDBInstanceIdentifier;
            return this;
        }

        public final Collection<String> getReadReplicaDBInstanceIdentifiers() {
            if (readReplicaDBInstanceIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return readReplicaDBInstanceIdentifiers;
        }

        public final void setReadReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
            this.readReplicaDBInstanceIdentifiers = StringListCopier.copy(readReplicaDBInstanceIdentifiers);
        }

        @Override
        public final Builder readReplicaDBInstanceIdentifiers(Collection<String> readReplicaDBInstanceIdentifiers) {
            this.readReplicaDBInstanceIdentifiers = StringListCopier.copy(readReplicaDBInstanceIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaDBInstanceIdentifiers(String... readReplicaDBInstanceIdentifiers) {
            readReplicaDBInstanceIdentifiers(Arrays.asList(readReplicaDBInstanceIdentifiers));
            return this;
        }

        public final Collection<String> getReadReplicaDBClusterIdentifiers() {
            if (readReplicaDBClusterIdentifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return readReplicaDBClusterIdentifiers;
        }

        public final void setReadReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
            this.readReplicaDBClusterIdentifiers = StringListCopier.copy(readReplicaDBClusterIdentifiers);
        }

        @Override
        public final Builder readReplicaDBClusterIdentifiers(Collection<String> readReplicaDBClusterIdentifiers) {
            this.readReplicaDBClusterIdentifiers = StringListCopier.copy(readReplicaDBClusterIdentifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readReplicaDBClusterIdentifiers(String... readReplicaDBClusterIdentifiers) {
            readReplicaDBClusterIdentifiers(Arrays.asList(readReplicaDBClusterIdentifiers));
            return this;
        }

        public final String getLicenseModel() {
            return licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        public final Integer getIops() {
            return iops;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final List<AwsRdsDbOptionGroupMembership.Builder> getOptionGroupMemberships() {
            List<AwsRdsDbOptionGroupMembership.Builder> result = AwsRdsDbOptionGroupMembershipsCopier
                    .copyToBuilder(this.optionGroupMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptionGroupMemberships(Collection<AwsRdsDbOptionGroupMembership.BuilderImpl> optionGroupMemberships) {
            this.optionGroupMemberships = AwsRdsDbOptionGroupMembershipsCopier.copyFromBuilder(optionGroupMemberships);
        }

        @Override
        public final Builder optionGroupMemberships(Collection<AwsRdsDbOptionGroupMembership> optionGroupMemberships) {
            this.optionGroupMemberships = AwsRdsDbOptionGroupMembershipsCopier.copy(optionGroupMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupMemberships(AwsRdsDbOptionGroupMembership... optionGroupMemberships) {
            optionGroupMemberships(Arrays.asList(optionGroupMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optionGroupMemberships(Consumer<AwsRdsDbOptionGroupMembership.Builder>... optionGroupMemberships) {
            optionGroupMemberships(Stream.of(optionGroupMemberships)
                    .map(c -> AwsRdsDbOptionGroupMembership.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCharacterSetName() {
            return characterSetName;
        }

        public final void setCharacterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
        }

        @Override
        public final Builder characterSetName(String characterSetName) {
            this.characterSetName = characterSetName;
            return this;
        }

        public final String getSecondaryAvailabilityZone() {
            return secondaryAvailabilityZone;
        }

        public final void setSecondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
        }

        @Override
        public final Builder secondaryAvailabilityZone(String secondaryAvailabilityZone) {
            this.secondaryAvailabilityZone = secondaryAvailabilityZone;
            return this;
        }

        public final List<AwsRdsDbStatusInfo.Builder> getStatusInfos() {
            List<AwsRdsDbStatusInfo.Builder> result = AwsRdsDbStatusInfosCopier.copyToBuilder(this.statusInfos);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStatusInfos(Collection<AwsRdsDbStatusInfo.BuilderImpl> statusInfos) {
            this.statusInfos = AwsRdsDbStatusInfosCopier.copyFromBuilder(statusInfos);
        }

        @Override
        public final Builder statusInfos(Collection<AwsRdsDbStatusInfo> statusInfos) {
            this.statusInfos = AwsRdsDbStatusInfosCopier.copy(statusInfos);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusInfos(AwsRdsDbStatusInfo... statusInfos) {
            statusInfos(Arrays.asList(statusInfos));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusInfos(Consumer<AwsRdsDbStatusInfo.Builder>... statusInfos) {
            statusInfos(Stream.of(statusInfos).map(c -> AwsRdsDbStatusInfo.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final List<AwsRdsDbDomainMembership.Builder> getDomainMemberships() {
            List<AwsRdsDbDomainMembership.Builder> result = AwsRdsDbDomainMembershipsCopier.copyToBuilder(this.domainMemberships);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainMemberships(Collection<AwsRdsDbDomainMembership.BuilderImpl> domainMemberships) {
            this.domainMemberships = AwsRdsDbDomainMembershipsCopier.copyFromBuilder(domainMemberships);
        }

        @Override
        public final Builder domainMemberships(Collection<AwsRdsDbDomainMembership> domainMemberships) {
            this.domainMemberships = AwsRdsDbDomainMembershipsCopier.copy(domainMemberships);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(AwsRdsDbDomainMembership... domainMemberships) {
            domainMemberships(Arrays.asList(domainMemberships));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainMemberships(Consumer<AwsRdsDbDomainMembership.Builder>... domainMemberships) {
            domainMemberships(Stream.of(domainMemberships).map(c -> AwsRdsDbDomainMembership.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getCopyTagsToSnapshot() {
            return copyTagsToSnapshot;
        }

        public final void setCopyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
        }

        @Override
        public final Builder copyTagsToSnapshot(Boolean copyTagsToSnapshot) {
            this.copyTagsToSnapshot = copyTagsToSnapshot;
            return this;
        }

        public final Integer getMonitoringInterval() {
            return monitoringInterval;
        }

        public final void setMonitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
        }

        @Override
        public final Builder monitoringInterval(Integer monitoringInterval) {
            this.monitoringInterval = monitoringInterval;
            return this;
        }

        public final String getMonitoringRoleArn() {
            return monitoringRoleArn;
        }

        public final void setMonitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
        }

        @Override
        public final Builder monitoringRoleArn(String monitoringRoleArn) {
            this.monitoringRoleArn = monitoringRoleArn;
            return this;
        }

        public final Integer getPromotionTier() {
            return promotionTier;
        }

        public final void setPromotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
        }

        @Override
        public final Builder promotionTier(Integer promotionTier) {
            this.promotionTier = promotionTier;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final Boolean getPerformanceInsightsEnabled() {
            return performanceInsightsEnabled;
        }

        public final void setPerformanceInsightsEnabled(Boolean performanceInsightsEnabled) {
            this.performanceInsightsEnabled = performanceInsightsEnabled;
        }

        @Override
        public final Builder performanceInsightsEnabled(Boolean performanceInsightsEnabled) {
            this.performanceInsightsEnabled = performanceInsightsEnabled;
            return this;
        }

        public final String getPerformanceInsightsKmsKeyId() {
            return performanceInsightsKmsKeyId;
        }

        public final void setPerformanceInsightsKmsKeyId(String performanceInsightsKmsKeyId) {
            this.performanceInsightsKmsKeyId = performanceInsightsKmsKeyId;
        }

        @Override
        public final Builder performanceInsightsKmsKeyId(String performanceInsightsKmsKeyId) {
            this.performanceInsightsKmsKeyId = performanceInsightsKmsKeyId;
            return this;
        }

        public final Integer getPerformanceInsightsRetentionPeriod() {
            return performanceInsightsRetentionPeriod;
        }

        public final void setPerformanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
        }

        @Override
        public final Builder performanceInsightsRetentionPeriod(Integer performanceInsightsRetentionPeriod) {
            this.performanceInsightsRetentionPeriod = performanceInsightsRetentionPeriod;
            return this;
        }

        public final Collection<String> getEnabledCloudWatchLogsExports() {
            if (enabledCloudWatchLogsExports instanceof SdkAutoConstructList) {
                return null;
            }
            return enabledCloudWatchLogsExports;
        }

        public final void setEnabledCloudWatchLogsExports(Collection<String> enabledCloudWatchLogsExports) {
            this.enabledCloudWatchLogsExports = StringListCopier.copy(enabledCloudWatchLogsExports);
        }

        @Override
        public final Builder enabledCloudWatchLogsExports(Collection<String> enabledCloudWatchLogsExports) {
            this.enabledCloudWatchLogsExports = StringListCopier.copy(enabledCloudWatchLogsExports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledCloudWatchLogsExports(String... enabledCloudWatchLogsExports) {
            enabledCloudWatchLogsExports(Arrays.asList(enabledCloudWatchLogsExports));
            return this;
        }

        public final List<AwsRdsDbProcessorFeature.Builder> getProcessorFeatures() {
            List<AwsRdsDbProcessorFeature.Builder> result = AwsRdsDbProcessorFeaturesCopier.copyToBuilder(this.processorFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProcessorFeatures(Collection<AwsRdsDbProcessorFeature.BuilderImpl> processorFeatures) {
            this.processorFeatures = AwsRdsDbProcessorFeaturesCopier.copyFromBuilder(processorFeatures);
        }

        @Override
        public final Builder processorFeatures(Collection<AwsRdsDbProcessorFeature> processorFeatures) {
            this.processorFeatures = AwsRdsDbProcessorFeaturesCopier.copy(processorFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(AwsRdsDbProcessorFeature... processorFeatures) {
            processorFeatures(Arrays.asList(processorFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder processorFeatures(Consumer<AwsRdsDbProcessorFeature.Builder>... processorFeatures) {
            processorFeatures(Stream.of(processorFeatures).map(c -> AwsRdsDbProcessorFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final AwsRdsDbInstanceEndpoint.Builder getListenerEndpoint() {
            return listenerEndpoint != null ? listenerEndpoint.toBuilder() : null;
        }

        public final void setListenerEndpoint(AwsRdsDbInstanceEndpoint.BuilderImpl listenerEndpoint) {
            this.listenerEndpoint = listenerEndpoint != null ? listenerEndpoint.build() : null;
        }

        @Override
        public final Builder listenerEndpoint(AwsRdsDbInstanceEndpoint listenerEndpoint) {
            this.listenerEndpoint = listenerEndpoint;
            return this;
        }

        public final Integer getMaxAllocatedStorage() {
            return maxAllocatedStorage;
        }

        public final void setMaxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
        }

        @Override
        public final Builder maxAllocatedStorage(Integer maxAllocatedStorage) {
            this.maxAllocatedStorage = maxAllocatedStorage;
            return this;
        }

        @Override
        public AwsRdsDbInstanceDetails build() {
            return new AwsRdsDbInstanceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
