/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about the threat intelligence related to a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThreatIntelIndicator implements SdkPojo, Serializable,
        ToCopyableBuilder<ThreatIntelIndicator.Builder, ThreatIntelIndicator> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ThreatIntelIndicator::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ThreatIntelIndicator::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Category").getter(getter(ThreatIntelIndicator::categoryAsString)).setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build()).build();

    private static final SdkField<String> LAST_OBSERVED_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastObservedAt").getter(getter(ThreatIntelIndicator::lastObservedAt))
            .setter(setter(Builder::lastObservedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastObservedAt").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(ThreatIntelIndicator::source)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<String> SOURCE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceUrl").getter(getter(ThreatIntelIndicator::sourceUrl)).setter(setter(Builder::sourceUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, VALUE_FIELD,
            CATEGORY_FIELD, LAST_OBSERVED_AT_FIELD, SOURCE_FIELD, SOURCE_URL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String value;

    private final String category;

    private final String lastObservedAt;

    private final String source;

    private final String sourceUrl;

    private ThreatIntelIndicator(BuilderImpl builder) {
        this.type = builder.type;
        this.value = builder.value;
        this.category = builder.category;
        this.lastObservedAt = builder.lastObservedAt;
        this.source = builder.source;
        this.sourceUrl = builder.sourceUrl;
    }

    /**
     * <p>
     * The type of threat intelligence indicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThreatIntelIndicatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of threat intelligence indicator.
     * @see ThreatIntelIndicatorType
     */
    public final ThreatIntelIndicatorType type() {
        return ThreatIntelIndicatorType.fromValue(type);
    }

    /**
     * <p>
     * The type of threat intelligence indicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ThreatIntelIndicatorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of threat intelligence indicator.
     * @see ThreatIntelIndicatorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The value of a threat intelligence indicator.
     * </p>
     * <p>
     * Length Constraints: Minimum of 1 length. Maximum of 512 length.
     * </p>
     * 
     * @return The value of a threat intelligence indicator.</p>
     *         <p>
     *         Length Constraints: Minimum of 1 length. Maximum of 512 length.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The category of a threat intelligence indicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ThreatIntelIndicatorCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of a threat intelligence indicator.
     * @see ThreatIntelIndicatorCategory
     */
    public final ThreatIntelIndicatorCategory category() {
        return ThreatIntelIndicatorCategory.fromValue(category);
    }

    /**
     * <p>
     * The category of a threat intelligence indicator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #category} will
     * return {@link ThreatIntelIndicatorCategory#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #categoryAsString}.
     * </p>
     * 
     * @return The category of a threat intelligence indicator.
     * @see ThreatIntelIndicatorCategory
     */
    public final String categoryAsString() {
        return category;
    }

    /**
     * <p>
     * Indicates when the most recent instance of a threat intelligence indicator was observed.
     * </p>
     * <p>
     * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum of 9
     * digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example, <code>2024-01-04T15:25:10.123456789+17:59</code>)
     * </p>
     * </li>
     * </ul>
     * 
     * @return Indicates when the most recent instance of a threat intelligence indicator was observed.</p>
     *         <p>
     *         This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
     *         <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
     *         maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
     *         <code>2024-01-04T15:25:10.123456789+17:59</code>)
     *         </p>
     *         </li>
     */
    public final String lastObservedAt() {
        return lastObservedAt;
    }

    /**
     * <p>
     * The source of the threat intelligence indicator.
     * </p>
     * <p>
     * Length Constraints: Minimum of 1 length. Maximum of 64 length.
     * </p>
     * 
     * @return The source of the threat intelligence indicator.</p>
     *         <p>
     *         Length Constraints: Minimum of 1 length. Maximum of 64 length.
     */
    public final String source() {
        return source;
    }

    /**
     * <p>
     * The URL to the page or site where you can get more information about the threat intelligence indicator.
     * </p>
     * 
     * @return The URL to the page or site where you can get more information about the threat intelligence indicator.
     */
    public final String sourceUrl() {
        return sourceUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lastObservedAt());
        hashCode = 31 * hashCode + Objects.hashCode(source());
        hashCode = 31 * hashCode + Objects.hashCode(sourceUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThreatIntelIndicator)) {
            return false;
        }
        ThreatIntelIndicator other = (ThreatIntelIndicator) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(value(), other.value())
                && Objects.equals(categoryAsString(), other.categoryAsString())
                && Objects.equals(lastObservedAt(), other.lastObservedAt()) && Objects.equals(source(), other.source())
                && Objects.equals(sourceUrl(), other.sourceUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThreatIntelIndicator").add("Type", typeAsString()).add("Value", value())
                .add("Category", categoryAsString()).add("LastObservedAt", lastObservedAt()).add("Source", source())
                .add("SourceUrl", sourceUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "Category":
            return Optional.ofNullable(clazz.cast(categoryAsString()));
        case "LastObservedAt":
            return Optional.ofNullable(clazz.cast(lastObservedAt()));
        case "Source":
            return Optional.ofNullable(clazz.cast(source()));
        case "SourceUrl":
            return Optional.ofNullable(clazz.cast(sourceUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThreatIntelIndicator, T> g) {
        return obj -> g.apply((ThreatIntelIndicator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThreatIntelIndicator> {
        /**
         * <p>
         * The type of threat intelligence indicator.
         * </p>
         * 
         * @param type
         *        The type of threat intelligence indicator.
         * @see ThreatIntelIndicatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatIntelIndicatorType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of threat intelligence indicator.
         * </p>
         * 
         * @param type
         *        The type of threat intelligence indicator.
         * @see ThreatIntelIndicatorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatIntelIndicatorType
         */
        Builder type(ThreatIntelIndicatorType type);

        /**
         * <p>
         * The value of a threat intelligence indicator.
         * </p>
         * <p>
         * Length Constraints: Minimum of 1 length. Maximum of 512 length.
         * </p>
         * 
         * @param value
         *        The value of a threat intelligence indicator.</p>
         *        <p>
         *        Length Constraints: Minimum of 1 length. Maximum of 512 length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The category of a threat intelligence indicator.
         * </p>
         * 
         * @param category
         *        The category of a threat intelligence indicator.
         * @see ThreatIntelIndicatorCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatIntelIndicatorCategory
         */
        Builder category(String category);

        /**
         * <p>
         * The category of a threat intelligence indicator.
         * </p>
         * 
         * @param category
         *        The category of a threat intelligence indicator.
         * @see ThreatIntelIndicatorCategory
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThreatIntelIndicatorCategory
         */
        Builder category(ThreatIntelIndicatorCategory category);

        /**
         * <p>
         * Indicates when the most recent instance of a threat intelligence indicator was observed.
         * </p>
         * <p>
         * This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         * <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a maximum
         * of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         * <code>2024-01-04T15:25:10.123456789+17:59</code>)
         * </p>
         * </li>
         * </ul>
         * 
         * @param lastObservedAt
         *        Indicates when the most recent instance of a threat intelligence indicator was observed.</p>
         *        <p>
         *        This field accepts only the specified formats. Timestamps can end with <code>Z</code> or
         *        <code>("+" / "-") time-hour [":" time-minute]</code>. The time-secfrac after seconds is limited to a
         *        maximum of 9 digits. The offset is bounded by +/-18:00. Here are valid timestamp formats with
         *        examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SSZ</code> (for example, <code>2019-01-31T23:00:00Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmmZ</code> (for example, <code>2019-01-31T23:00:00.123456789Z</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS+HH:MM</code> (for example, <code>2024-01-04T15:25:10+17:59</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS-HHMM</code> (for example, <code>2024-01-04T15:25:10-1759</code>)
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>YYYY-MM-DDTHH:MM:SS.mmmmmmmmm+HH:MM</code> (for example,
         *        <code>2024-01-04T15:25:10.123456789+17:59</code>)
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastObservedAt(String lastObservedAt);

        /**
         * <p>
         * The source of the threat intelligence indicator.
         * </p>
         * <p>
         * Length Constraints: Minimum of 1 length. Maximum of 64 length.
         * </p>
         * 
         * @param source
         *        The source of the threat intelligence indicator.</p>
         *        <p>
         *        Length Constraints: Minimum of 1 length. Maximum of 64 length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source(String source);

        /**
         * <p>
         * The URL to the page or site where you can get more information about the threat intelligence indicator.
         * </p>
         * 
         * @param sourceUrl
         *        The URL to the page or site where you can get more information about the threat intelligence
         *        indicator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceUrl(String sourceUrl);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String value;

        private String category;

        private String lastObservedAt;

        private String source;

        private String sourceUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ThreatIntelIndicator model) {
            type(model.type);
            value(model.value);
            category(model.category);
            lastObservedAt(model.lastObservedAt);
            source(model.source);
            sourceUrl(model.sourceUrl);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ThreatIntelIndicatorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getCategory() {
            return category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ThreatIntelIndicatorCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getLastObservedAt() {
            return lastObservedAt;
        }

        public final void setLastObservedAt(String lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
        }

        @Override
        public final Builder lastObservedAt(String lastObservedAt) {
            this.lastObservedAt = lastObservedAt;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        public final String getSourceUrl() {
            return sourceUrl;
        }

        public final void setSourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
        }

        @Override
        public final Builder sourceUrl(String sourceUrl) {
            this.sourceUrl = sourceUrl;
            return this;
        }

        @Override
        public ThreatIntelIndicator build() {
            return new ThreatIntelIndicator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
