/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class AwsEc2SecurityGroupIpv6RangeListCopier {
    static List<AwsEc2SecurityGroupIpv6Range> copy(
            Collection<? extends AwsEc2SecurityGroupIpv6Range> awsEc2SecurityGroupIpv6RangeListParam) {
        List<AwsEc2SecurityGroupIpv6Range> list;
        if (awsEc2SecurityGroupIpv6RangeListParam == null
                || awsEc2SecurityGroupIpv6RangeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEc2SecurityGroupIpv6Range> modifiableList = new ArrayList<>(awsEc2SecurityGroupIpv6RangeListParam.size());
            awsEc2SecurityGroupIpv6RangeListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsEc2SecurityGroupIpv6Range> copyFromBuilder(
            Collection<? extends AwsEc2SecurityGroupIpv6Range.Builder> awsEc2SecurityGroupIpv6RangeListParam) {
        List<AwsEc2SecurityGroupIpv6Range> list;
        if (awsEc2SecurityGroupIpv6RangeListParam == null
                || awsEc2SecurityGroupIpv6RangeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEc2SecurityGroupIpv6Range> modifiableList = new ArrayList<>(awsEc2SecurityGroupIpv6RangeListParam.size());
            awsEc2SecurityGroupIpv6RangeListParam.forEach(entry -> {
                AwsEc2SecurityGroupIpv6Range member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<AwsEc2SecurityGroupIpv6Range.Builder> copyToBuilder(
            Collection<? extends AwsEc2SecurityGroupIpv6Range> awsEc2SecurityGroupIpv6RangeListParam) {
        List<AwsEc2SecurityGroupIpv6Range.Builder> list;
        if (awsEc2SecurityGroupIpv6RangeListParam == null
                || awsEc2SecurityGroupIpv6RangeListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<AwsEc2SecurityGroupIpv6Range.Builder> modifiableList = new ArrayList<>(
                    awsEc2SecurityGroupIpv6RangeListParam.size());
            awsEc2SecurityGroupIpv6RangeListParam.forEach(entry -> {
                AwsEc2SecurityGroupIpv6Range.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
