/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details about a service within an ECS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsEcsServiceDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsEcsServiceDetails.Builder, AwsEcsServiceDetails> {
    private static final SdkField<List<AwsEcsServiceCapacityProviderStrategyDetails>> CAPACITY_PROVIDER_STRATEGY_FIELD = SdkField
            .<List<AwsEcsServiceCapacityProviderStrategyDetails>> builder(MarshallingType.LIST)
            .memberName("CapacityProviderStrategy")
            .getter(getter(AwsEcsServiceDetails::capacityProviderStrategy))
            .setter(setter(Builder::capacityProviderStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityProviderStrategy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsServiceCapacityProviderStrategyDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsServiceCapacityProviderStrategyDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CLUSTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Cluster")
            .getter(getter(AwsEcsServiceDetails::cluster)).setter(setter(Builder::cluster))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cluster").build()).build();

    private static final SdkField<AwsEcsServiceDeploymentConfigurationDetails> DEPLOYMENT_CONFIGURATION_FIELD = SdkField
            .<AwsEcsServiceDeploymentConfigurationDetails> builder(MarshallingType.SDK_POJO)
            .memberName("DeploymentConfiguration").getter(getter(AwsEcsServiceDetails::deploymentConfiguration))
            .setter(setter(Builder::deploymentConfiguration)).constructor(AwsEcsServiceDeploymentConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentConfiguration").build())
            .build();

    private static final SdkField<AwsEcsServiceDeploymentControllerDetails> DEPLOYMENT_CONTROLLER_FIELD = SdkField
            .<AwsEcsServiceDeploymentControllerDetails> builder(MarshallingType.SDK_POJO).memberName("DeploymentController")
            .getter(getter(AwsEcsServiceDetails::deploymentController)).setter(setter(Builder::deploymentController))
            .constructor(AwsEcsServiceDeploymentControllerDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeploymentController").build())
            .build();

    private static final SdkField<Integer> DESIRED_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredCount").getter(getter(AwsEcsServiceDetails::desiredCount)).setter(setter(Builder::desiredCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredCount").build()).build();

    private static final SdkField<Boolean> ENABLE_ECS_MANAGED_TAGS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableEcsManagedTags").getter(getter(AwsEcsServiceDetails::enableEcsManagedTags))
            .setter(setter(Builder::enableEcsManagedTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableEcsManagedTags").build())
            .build();

    private static final SdkField<Boolean> ENABLE_EXECUTE_COMMAND_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableExecuteCommand").getter(getter(AwsEcsServiceDetails::enableExecuteCommand))
            .setter(setter(Builder::enableExecuteCommand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableExecuteCommand").build())
            .build();

    private static final SdkField<Integer> HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("HealthCheckGracePeriodSeconds")
            .getter(getter(AwsEcsServiceDetails::healthCheckGracePeriodSeconds))
            .setter(setter(Builder::healthCheckGracePeriodSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HealthCheckGracePeriodSeconds")
                    .build()).build();

    private static final SdkField<String> LAUNCH_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LaunchType").getter(getter(AwsEcsServiceDetails::launchType)).setter(setter(Builder::launchType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchType").build()).build();

    private static final SdkField<List<AwsEcsServiceLoadBalancersDetails>> LOAD_BALANCERS_FIELD = SdkField
            .<List<AwsEcsServiceLoadBalancersDetails>> builder(MarshallingType.LIST)
            .memberName("LoadBalancers")
            .getter(getter(AwsEcsServiceDetails::loadBalancers))
            .setter(setter(Builder::loadBalancers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LoadBalancers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsServiceLoadBalancersDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsServiceLoadBalancersDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsEcsServiceDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AwsEcsServiceNetworkConfigurationDetails> NETWORK_CONFIGURATION_FIELD = SdkField
            .<AwsEcsServiceNetworkConfigurationDetails> builder(MarshallingType.SDK_POJO).memberName("NetworkConfiguration")
            .getter(getter(AwsEcsServiceDetails::networkConfiguration)).setter(setter(Builder::networkConfiguration))
            .constructor(AwsEcsServiceNetworkConfigurationDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkConfiguration").build())
            .build();

    private static final SdkField<List<AwsEcsServicePlacementConstraintsDetails>> PLACEMENT_CONSTRAINTS_FIELD = SdkField
            .<List<AwsEcsServicePlacementConstraintsDetails>> builder(MarshallingType.LIST)
            .memberName("PlacementConstraints")
            .getter(getter(AwsEcsServiceDetails::placementConstraints))
            .setter(setter(Builder::placementConstraints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementConstraints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsServicePlacementConstraintsDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsServicePlacementConstraintsDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<AwsEcsServicePlacementStrategiesDetails>> PLACEMENT_STRATEGIES_FIELD = SdkField
            .<List<AwsEcsServicePlacementStrategiesDetails>> builder(MarshallingType.LIST)
            .memberName("PlacementStrategies")
            .getter(getter(AwsEcsServiceDetails::placementStrategies))
            .setter(setter(Builder::placementStrategies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlacementStrategies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsServicePlacementStrategiesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsServicePlacementStrategiesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PLATFORM_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PlatformVersion").getter(getter(AwsEcsServiceDetails::platformVersion))
            .setter(setter(Builder::platformVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlatformVersion").build()).build();

    private static final SdkField<String> PROPAGATE_TAGS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PropagateTags").getter(getter(AwsEcsServiceDetails::propagateTags))
            .setter(setter(Builder::propagateTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PropagateTags").build()).build();

    private static final SdkField<String> ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Role")
            .getter(getter(AwsEcsServiceDetails::role)).setter(setter(Builder::role))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Role").build()).build();

    private static final SdkField<String> SCHEDULING_STRATEGY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchedulingStrategy").getter(getter(AwsEcsServiceDetails::schedulingStrategy))
            .setter(setter(Builder::schedulingStrategy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulingStrategy").build())
            .build();

    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceArn").getter(getter(AwsEcsServiceDetails::serviceArn)).setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceArn").build()).build();

    private static final SdkField<String> SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ServiceName").getter(getter(AwsEcsServiceDetails::serviceName)).setter(setter(Builder::serviceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceName").build()).build();

    private static final SdkField<List<AwsEcsServiceServiceRegistriesDetails>> SERVICE_REGISTRIES_FIELD = SdkField
            .<List<AwsEcsServiceServiceRegistriesDetails>> builder(MarshallingType.LIST)
            .memberName("ServiceRegistries")
            .getter(getter(AwsEcsServiceDetails::serviceRegistries))
            .setter(setter(Builder::serviceRegistries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceRegistries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsEcsServiceServiceRegistriesDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsEcsServiceServiceRegistriesDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TASK_DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TaskDefinition").getter(getter(AwsEcsServiceDetails::taskDefinition))
            .setter(setter(Builder::taskDefinition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskDefinition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CAPACITY_PROVIDER_STRATEGY_FIELD, CLUSTER_FIELD, DEPLOYMENT_CONFIGURATION_FIELD, DEPLOYMENT_CONTROLLER_FIELD,
            DESIRED_COUNT_FIELD, ENABLE_ECS_MANAGED_TAGS_FIELD, ENABLE_EXECUTE_COMMAND_FIELD,
            HEALTH_CHECK_GRACE_PERIOD_SECONDS_FIELD, LAUNCH_TYPE_FIELD, LOAD_BALANCERS_FIELD, NAME_FIELD,
            NETWORK_CONFIGURATION_FIELD, PLACEMENT_CONSTRAINTS_FIELD, PLACEMENT_STRATEGIES_FIELD, PLATFORM_VERSION_FIELD,
            PROPAGATE_TAGS_FIELD, ROLE_FIELD, SCHEDULING_STRATEGY_FIELD, SERVICE_ARN_FIELD, SERVICE_NAME_FIELD,
            SERVICE_REGISTRIES_FIELD, TASK_DEFINITION_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsEcsServiceCapacityProviderStrategyDetails> capacityProviderStrategy;

    private final String cluster;

    private final AwsEcsServiceDeploymentConfigurationDetails deploymentConfiguration;

    private final AwsEcsServiceDeploymentControllerDetails deploymentController;

    private final Integer desiredCount;

    private final Boolean enableEcsManagedTags;

    private final Boolean enableExecuteCommand;

    private final Integer healthCheckGracePeriodSeconds;

    private final String launchType;

    private final List<AwsEcsServiceLoadBalancersDetails> loadBalancers;

    private final String name;

    private final AwsEcsServiceNetworkConfigurationDetails networkConfiguration;

    private final List<AwsEcsServicePlacementConstraintsDetails> placementConstraints;

    private final List<AwsEcsServicePlacementStrategiesDetails> placementStrategies;

    private final String platformVersion;

    private final String propagateTags;

    private final String role;

    private final String schedulingStrategy;

    private final String serviceArn;

    private final String serviceName;

    private final List<AwsEcsServiceServiceRegistriesDetails> serviceRegistries;

    private final String taskDefinition;

    private AwsEcsServiceDetails(BuilderImpl builder) {
        this.capacityProviderStrategy = builder.capacityProviderStrategy;
        this.cluster = builder.cluster;
        this.deploymentConfiguration = builder.deploymentConfiguration;
        this.deploymentController = builder.deploymentController;
        this.desiredCount = builder.desiredCount;
        this.enableEcsManagedTags = builder.enableEcsManagedTags;
        this.enableExecuteCommand = builder.enableExecuteCommand;
        this.healthCheckGracePeriodSeconds = builder.healthCheckGracePeriodSeconds;
        this.launchType = builder.launchType;
        this.loadBalancers = builder.loadBalancers;
        this.name = builder.name;
        this.networkConfiguration = builder.networkConfiguration;
        this.placementConstraints = builder.placementConstraints;
        this.placementStrategies = builder.placementStrategies;
        this.platformVersion = builder.platformVersion;
        this.propagateTags = builder.propagateTags;
        this.role = builder.role;
        this.schedulingStrategy = builder.schedulingStrategy;
        this.serviceArn = builder.serviceArn;
        this.serviceName = builder.serviceName;
        this.serviceRegistries = builder.serviceRegistries;
        this.taskDefinition = builder.taskDefinition;
    }

    /**
     * For responses, this returns true if the service returned a value for the CapacityProviderStrategy property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCapacityProviderStrategy() {
        return capacityProviderStrategy != null && !(capacityProviderStrategy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capacity provider strategy that the service uses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapacityProviderStrategy} method.
     * </p>
     * 
     * @return The capacity provider strategy that the service uses.
     */
    public final List<AwsEcsServiceCapacityProviderStrategyDetails> capacityProviderStrategy() {
        return capacityProviderStrategy;
    }

    /**
     * <p>
     * The ARN of the cluster that hosts the service.
     * </p>
     * 
     * @return The ARN of the cluster that hosts the service.
     */
    public final String cluster() {
        return cluster;
    }

    /**
     * <p>
     * Deployment parameters for the service. Includes the number of tasks that run and the order in which to start and
     * stop tasks.
     * </p>
     * 
     * @return Deployment parameters for the service. Includes the number of tasks that run and the order in which to
     *         start and stop tasks.
     */
    public final AwsEcsServiceDeploymentConfigurationDetails deploymentConfiguration() {
        return deploymentConfiguration;
    }

    /**
     * <p>
     * Contains the deployment controller type that the service uses.
     * </p>
     * 
     * @return Contains the deployment controller type that the service uses.
     */
    public final AwsEcsServiceDeploymentControllerDetails deploymentController() {
        return deploymentController;
    }

    /**
     * <p>
     * The number of instantiations of the task definition to run on the service.
     * </p>
     * 
     * @return The number of instantiations of the task definition to run on the service.
     */
    public final Integer desiredCount() {
        return desiredCount;
    }

    /**
     * <p>
     * Whether to enable Amazon ECS managed tags for the tasks in the service.
     * </p>
     * 
     * @return Whether to enable Amazon ECS managed tags for the tasks in the service.
     */
    public final Boolean enableEcsManagedTags() {
        return enableEcsManagedTags;
    }

    /**
     * <p>
     * Whether the execute command functionality is enabled for the service.
     * </p>
     * 
     * @return Whether the execute command functionality is enabled for the service.
     */
    public final Boolean enableExecuteCommand() {
        return enableExecuteCommand;
    }

    /**
     * <p>
     * After a task starts, the amount of time in seconds that the Amazon ECS service scheduler ignores unhealthy
     * Elastic Load Balancing target health checks.
     * </p>
     * 
     * @return After a task starts, the amount of time in seconds that the Amazon ECS service scheduler ignores
     *         unhealthy Elastic Load Balancing target health checks.
     */
    public final Integer healthCheckGracePeriodSeconds() {
        return healthCheckGracePeriodSeconds;
    }

    /**
     * <p>
     * The launch type that the service uses.
     * </p>
     * <p>
     * Valid values: <code>EC2</code> | <code>FARGATE</code> | <code>EXTERNAL</code>
     * </p>
     * 
     * @return The launch type that the service uses.</p>
     *         <p>
     *         Valid values: <code>EC2</code> | <code>FARGATE</code> | <code>EXTERNAL</code>
     */
    public final String launchType() {
        return launchType;
    }

    /**
     * For responses, this returns true if the service returned a value for the LoadBalancers property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLoadBalancers() {
        return loadBalancers != null && !(loadBalancers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the load balancers that the service uses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLoadBalancers} method.
     * </p>
     * 
     * @return Information about the load balancers that the service uses.
     */
    public final List<AwsEcsServiceLoadBalancersDetails> loadBalancers() {
        return loadBalancers;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * 
     * @return The name of the service.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.
     * </p>
     * 
     * @return For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group
     *         configuration.
     */
    public final AwsEcsServiceNetworkConfigurationDetails networkConfiguration() {
        return networkConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementConstraints property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementConstraints() {
        return placementConstraints != null && !(placementConstraints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The placement constraints for the tasks in the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementConstraints} method.
     * </p>
     * 
     * @return The placement constraints for the tasks in the service.
     */
    public final List<AwsEcsServicePlacementConstraintsDetails> placementConstraints() {
        return placementConstraints;
    }

    /**
     * For responses, this returns true if the service returned a value for the PlacementStrategies property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPlacementStrategies() {
        return placementStrategies != null && !(placementStrategies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about how tasks for the service are placed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPlacementStrategies} method.
     * </p>
     * 
     * @return Information about how tasks for the service are placed.
     */
    public final List<AwsEcsServicePlacementStrategiesDetails> placementStrategies() {
        return placementStrategies;
    }

    /**
     * <p>
     * The platform version on which to run the service. Only specified for tasks that are hosted on Fargate. If a
     * platform version is not specified, the <code>LATEST</code> platform version is used by default.
     * </p>
     * 
     * @return The platform version on which to run the service. Only specified for tasks that are hosted on Fargate. If
     *         a platform version is not specified, the <code>LATEST</code> platform version is used by default.
     */
    public final String platformVersion() {
        return platformVersion;
    }

    /**
     * <p>
     * Indicates whether to propagate the tags from the task definition to the task or from the service to the task. If
     * no value is provided, then tags are not propagated.
     * </p>
     * <p>
     * Valid values: <code>TASK_DEFINITION</code> | <code>SERVICE</code>
     * </p>
     * 
     * @return Indicates whether to propagate the tags from the task definition to the task or from the service to the
     *         task. If no value is provided, then tags are not propagated.</p>
     *         <p>
     *         Valid values: <code>TASK_DEFINITION</code> | <code>SERVICE</code>
     */
    public final String propagateTags() {
        return propagateTags;
    }

    /**
     * <p>
     * The ARN of the IAM role that is associated with the service. The role allows the Amazon ECS container agent to
     * register container instances with an Elastic Load Balancing load balancer.
     * </p>
     * 
     * @return The ARN of the IAM role that is associated with the service. The role allows the Amazon ECS container
     *         agent to register container instances with an Elastic Load Balancing load balancer.
     */
    public final String role() {
        return role;
    }

    /**
     * <p>
     * The scheduling strategy to use for the service.
     * </p>
     * <p>
     * The <code>REPLICA</code> scheduling strategy places and maintains the desired number of tasks across the cluster.
     * By default, the service scheduler spreads tasks across Availability Zones. Task placement strategies and
     * constraints are used to customize task placement decisions.
     * </p>
     * <p>
     * The <code>DAEMON</code> scheduling strategy deploys exactly one task on each active container instance that meets
     * all of the task placement constraints that are specified in the cluster. The service scheduler also evaluates the
     * task placement constraints for running tasks and stops tasks that don't meet the placement constraints.
     * </p>
     * <p>
     * Valid values: <code>REPLICA</code> | <code>DAEMON</code>
     * </p>
     * 
     * @return The scheduling strategy to use for the service.</p>
     *         <p>
     *         The <code>REPLICA</code> scheduling strategy places and maintains the desired number of tasks across the
     *         cluster. By default, the service scheduler spreads tasks across Availability Zones. Task placement
     *         strategies and constraints are used to customize task placement decisions.
     *         </p>
     *         <p>
     *         The <code>DAEMON</code> scheduling strategy deploys exactly one task on each active container instance
     *         that meets all of the task placement constraints that are specified in the cluster. The service scheduler
     *         also evaluates the task placement constraints for running tasks and stops tasks that don't meet the
     *         placement constraints.
     *         </p>
     *         <p>
     *         Valid values: <code>REPLICA</code> | <code>DAEMON</code>
     */
    public final String schedulingStrategy() {
        return schedulingStrategy;
    }

    /**
     * <p>
     * The ARN of the service.
     * </p>
     * 
     * @return The ARN of the service.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    /**
     * <p>
     * The name of the service.
     * </p>
     * <p>
     * The name can contain up to 255 characters. It can use letters, numbers, underscores, and hyphens.
     * </p>
     * 
     * @return The name of the service.</p>
     *         <p>
     *         The name can contain up to 255 characters. It can use letters, numbers, underscores, and hyphens.
     */
    public final String serviceName() {
        return serviceName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ServiceRegistries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasServiceRegistries() {
        return serviceRegistries != null && !(serviceRegistries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the service discovery registries to assign to the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServiceRegistries} method.
     * </p>
     * 
     * @return Information about the service discovery registries to assign to the service.
     */
    public final List<AwsEcsServiceServiceRegistriesDetails> serviceRegistries() {
        return serviceRegistries;
    }

    /**
     * <p>
     * The task definition to use for tasks in the service.
     * </p>
     * 
     * @return The task definition to use for tasks in the service.
     */
    public final String taskDefinition() {
        return taskDefinition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCapacityProviderStrategy() ? capacityProviderStrategy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cluster());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentController());
        hashCode = 31 * hashCode + Objects.hashCode(desiredCount());
        hashCode = 31 * hashCode + Objects.hashCode(enableEcsManagedTags());
        hashCode = 31 * hashCode + Objects.hashCode(enableExecuteCommand());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckGracePeriodSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(launchType());
        hashCode = 31 * hashCode + Objects.hashCode(hasLoadBalancers() ? loadBalancers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementConstraints() ? placementConstraints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasPlacementStrategies() ? placementStrategies() : null);
        hashCode = 31 * hashCode + Objects.hashCode(platformVersion());
        hashCode = 31 * hashCode + Objects.hashCode(propagateTags());
        hashCode = 31 * hashCode + Objects.hashCode(role());
        hashCode = 31 * hashCode + Objects.hashCode(schedulingStrategy());
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceName());
        hashCode = 31 * hashCode + Objects.hashCode(hasServiceRegistries() ? serviceRegistries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(taskDefinition());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEcsServiceDetails)) {
            return false;
        }
        AwsEcsServiceDetails other = (AwsEcsServiceDetails) obj;
        return hasCapacityProviderStrategy() == other.hasCapacityProviderStrategy()
                && Objects.equals(capacityProviderStrategy(), other.capacityProviderStrategy())
                && Objects.equals(cluster(), other.cluster())
                && Objects.equals(deploymentConfiguration(), other.deploymentConfiguration())
                && Objects.equals(deploymentController(), other.deploymentController())
                && Objects.equals(desiredCount(), other.desiredCount())
                && Objects.equals(enableEcsManagedTags(), other.enableEcsManagedTags())
                && Objects.equals(enableExecuteCommand(), other.enableExecuteCommand())
                && Objects.equals(healthCheckGracePeriodSeconds(), other.healthCheckGracePeriodSeconds())
                && Objects.equals(launchType(), other.launchType()) && hasLoadBalancers() == other.hasLoadBalancers()
                && Objects.equals(loadBalancers(), other.loadBalancers()) && Objects.equals(name(), other.name())
                && Objects.equals(networkConfiguration(), other.networkConfiguration())
                && hasPlacementConstraints() == other.hasPlacementConstraints()
                && Objects.equals(placementConstraints(), other.placementConstraints())
                && hasPlacementStrategies() == other.hasPlacementStrategies()
                && Objects.equals(placementStrategies(), other.placementStrategies())
                && Objects.equals(platformVersion(), other.platformVersion())
                && Objects.equals(propagateTags(), other.propagateTags()) && Objects.equals(role(), other.role())
                && Objects.equals(schedulingStrategy(), other.schedulingStrategy())
                && Objects.equals(serviceArn(), other.serviceArn()) && Objects.equals(serviceName(), other.serviceName())
                && hasServiceRegistries() == other.hasServiceRegistries()
                && Objects.equals(serviceRegistries(), other.serviceRegistries())
                && Objects.equals(taskDefinition(), other.taskDefinition());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsEcsServiceDetails")
                .add("CapacityProviderStrategy", hasCapacityProviderStrategy() ? capacityProviderStrategy() : null)
                .add("Cluster", cluster()).add("DeploymentConfiguration", deploymentConfiguration())
                .add("DeploymentController", deploymentController()).add("DesiredCount", desiredCount())
                .add("EnableEcsManagedTags", enableEcsManagedTags()).add("EnableExecuteCommand", enableExecuteCommand())
                .add("HealthCheckGracePeriodSeconds", healthCheckGracePeriodSeconds()).add("LaunchType", launchType())
                .add("LoadBalancers", hasLoadBalancers() ? loadBalancers() : null).add("Name", name())
                .add("NetworkConfiguration", networkConfiguration())
                .add("PlacementConstraints", hasPlacementConstraints() ? placementConstraints() : null)
                .add("PlacementStrategies", hasPlacementStrategies() ? placementStrategies() : null)
                .add("PlatformVersion", platformVersion()).add("PropagateTags", propagateTags()).add("Role", role())
                .add("SchedulingStrategy", schedulingStrategy()).add("ServiceArn", serviceArn())
                .add("ServiceName", serviceName()).add("ServiceRegistries", hasServiceRegistries() ? serviceRegistries() : null)
                .add("TaskDefinition", taskDefinition()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CapacityProviderStrategy":
            return Optional.ofNullable(clazz.cast(capacityProviderStrategy()));
        case "Cluster":
            return Optional.ofNullable(clazz.cast(cluster()));
        case "DeploymentConfiguration":
            return Optional.ofNullable(clazz.cast(deploymentConfiguration()));
        case "DeploymentController":
            return Optional.ofNullable(clazz.cast(deploymentController()));
        case "DesiredCount":
            return Optional.ofNullable(clazz.cast(desiredCount()));
        case "EnableEcsManagedTags":
            return Optional.ofNullable(clazz.cast(enableEcsManagedTags()));
        case "EnableExecuteCommand":
            return Optional.ofNullable(clazz.cast(enableExecuteCommand()));
        case "HealthCheckGracePeriodSeconds":
            return Optional.ofNullable(clazz.cast(healthCheckGracePeriodSeconds()));
        case "LaunchType":
            return Optional.ofNullable(clazz.cast(launchType()));
        case "LoadBalancers":
            return Optional.ofNullable(clazz.cast(loadBalancers()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NetworkConfiguration":
            return Optional.ofNullable(clazz.cast(networkConfiguration()));
        case "PlacementConstraints":
            return Optional.ofNullable(clazz.cast(placementConstraints()));
        case "PlacementStrategies":
            return Optional.ofNullable(clazz.cast(placementStrategies()));
        case "PlatformVersion":
            return Optional.ofNullable(clazz.cast(platformVersion()));
        case "PropagateTags":
            return Optional.ofNullable(clazz.cast(propagateTags()));
        case "Role":
            return Optional.ofNullable(clazz.cast(role()));
        case "SchedulingStrategy":
            return Optional.ofNullable(clazz.cast(schedulingStrategy()));
        case "ServiceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        case "ServiceName":
            return Optional.ofNullable(clazz.cast(serviceName()));
        case "ServiceRegistries":
            return Optional.ofNullable(clazz.cast(serviceRegistries()));
        case "TaskDefinition":
            return Optional.ofNullable(clazz.cast(taskDefinition()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsEcsServiceDetails, T> g) {
        return obj -> g.apply((AwsEcsServiceDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsEcsServiceDetails> {
        /**
         * <p>
         * The capacity provider strategy that the service uses.
         * </p>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy that the service uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(Collection<AwsEcsServiceCapacityProviderStrategyDetails> capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy that the service uses.
         * </p>
         * 
         * @param capacityProviderStrategy
         *        The capacity provider strategy that the service uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityProviderStrategy(AwsEcsServiceCapacityProviderStrategyDetails... capacityProviderStrategy);

        /**
         * <p>
         * The capacity provider strategy that the service uses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #capacityProviderStrategy(List<AwsEcsServiceCapacityProviderStrategyDetails>)}.
         * 
         * @param capacityProviderStrategy
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceCapacityProviderStrategyDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityProviderStrategy(java.util.Collection<AwsEcsServiceCapacityProviderStrategyDetails>)
         */
        Builder capacityProviderStrategy(
                Consumer<AwsEcsServiceCapacityProviderStrategyDetails.Builder>... capacityProviderStrategy);

        /**
         * <p>
         * The ARN of the cluster that hosts the service.
         * </p>
         * 
         * @param cluster
         *        The ARN of the cluster that hosts the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cluster(String cluster);

        /**
         * <p>
         * Deployment parameters for the service. Includes the number of tasks that run and the order in which to start
         * and stop tasks.
         * </p>
         * 
         * @param deploymentConfiguration
         *        Deployment parameters for the service. Includes the number of tasks that run and the order in which to
         *        start and stop tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentConfiguration(AwsEcsServiceDeploymentConfigurationDetails deploymentConfiguration);

        /**
         * <p>
         * Deployment parameters for the service. Includes the number of tasks that run and the order in which to start
         * and stop tasks.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEcsServiceDeploymentConfigurationDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEcsServiceDeploymentConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsServiceDeploymentConfigurationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deploymentConfiguration(AwsEcsServiceDeploymentConfigurationDetails)}.
         * 
         * @param deploymentConfiguration
         *        a consumer that will call methods on {@link AwsEcsServiceDeploymentConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentConfiguration(AwsEcsServiceDeploymentConfigurationDetails)
         */
        default Builder deploymentConfiguration(
                Consumer<AwsEcsServiceDeploymentConfigurationDetails.Builder> deploymentConfiguration) {
            return deploymentConfiguration(AwsEcsServiceDeploymentConfigurationDetails.builder()
                    .applyMutation(deploymentConfiguration).build());
        }

        /**
         * <p>
         * Contains the deployment controller type that the service uses.
         * </p>
         * 
         * @param deploymentController
         *        Contains the deployment controller type that the service uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentController(AwsEcsServiceDeploymentControllerDetails deploymentController);

        /**
         * <p>
         * Contains the deployment controller type that the service uses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEcsServiceDeploymentControllerDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEcsServiceDeploymentControllerDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsServiceDeploymentControllerDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #deploymentController(AwsEcsServiceDeploymentControllerDetails)}.
         * 
         * @param deploymentController
         *        a consumer that will call methods on {@link AwsEcsServiceDeploymentControllerDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deploymentController(AwsEcsServiceDeploymentControllerDetails)
         */
        default Builder deploymentController(Consumer<AwsEcsServiceDeploymentControllerDetails.Builder> deploymentController) {
            return deploymentController(AwsEcsServiceDeploymentControllerDetails.builder().applyMutation(deploymentController)
                    .build());
        }

        /**
         * <p>
         * The number of instantiations of the task definition to run on the service.
         * </p>
         * 
         * @param desiredCount
         *        The number of instantiations of the task definition to run on the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredCount(Integer desiredCount);

        /**
         * <p>
         * Whether to enable Amazon ECS managed tags for the tasks in the service.
         * </p>
         * 
         * @param enableEcsManagedTags
         *        Whether to enable Amazon ECS managed tags for the tasks in the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableEcsManagedTags(Boolean enableEcsManagedTags);

        /**
         * <p>
         * Whether the execute command functionality is enabled for the service.
         * </p>
         * 
         * @param enableExecuteCommand
         *        Whether the execute command functionality is enabled for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableExecuteCommand(Boolean enableExecuteCommand);

        /**
         * <p>
         * After a task starts, the amount of time in seconds that the Amazon ECS service scheduler ignores unhealthy
         * Elastic Load Balancing target health checks.
         * </p>
         * 
         * @param healthCheckGracePeriodSeconds
         *        After a task starts, the amount of time in seconds that the Amazon ECS service scheduler ignores
         *        unhealthy Elastic Load Balancing target health checks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds);

        /**
         * <p>
         * The launch type that the service uses.
         * </p>
         * <p>
         * Valid values: <code>EC2</code> | <code>FARGATE</code> | <code>EXTERNAL</code>
         * </p>
         * 
         * @param launchType
         *        The launch type that the service uses.</p>
         *        <p>
         *        Valid values: <code>EC2</code> | <code>FARGATE</code> | <code>EXTERNAL</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchType(String launchType);

        /**
         * <p>
         * Information about the load balancers that the service uses.
         * </p>
         * 
         * @param loadBalancers
         *        Information about the load balancers that the service uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(Collection<AwsEcsServiceLoadBalancersDetails> loadBalancers);

        /**
         * <p>
         * Information about the load balancers that the service uses.
         * </p>
         * 
         * @param loadBalancers
         *        Information about the load balancers that the service uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder loadBalancers(AwsEcsServiceLoadBalancersDetails... loadBalancers);

        /**
         * <p>
         * Information about the load balancers that the service uses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #loadBalancers(List<AwsEcsServiceLoadBalancersDetails>)}.
         * 
         * @param loadBalancers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceLoadBalancersDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #loadBalancers(java.util.Collection<AwsEcsServiceLoadBalancersDetails>)
         */
        Builder loadBalancers(Consumer<AwsEcsServiceLoadBalancersDetails.Builder>... loadBalancers);

        /**
         * <p>
         * The name of the service.
         * </p>
         * 
         * @param name
         *        The name of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.
         * </p>
         * 
         * @param networkConfiguration
         *        For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group
         *        configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkConfiguration(AwsEcsServiceNetworkConfigurationDetails networkConfiguration);

        /**
         * <p>
         * For tasks that use the <code>awsvpc</code> networking mode, the VPC subnet and security group configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsEcsServiceNetworkConfigurationDetails.Builder} avoiding the need to create one manually via
         * {@link AwsEcsServiceNetworkConfigurationDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsEcsServiceNetworkConfigurationDetails.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #networkConfiguration(AwsEcsServiceNetworkConfigurationDetails)}.
         * 
         * @param networkConfiguration
         *        a consumer that will call methods on {@link AwsEcsServiceNetworkConfigurationDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkConfiguration(AwsEcsServiceNetworkConfigurationDetails)
         */
        default Builder networkConfiguration(Consumer<AwsEcsServiceNetworkConfigurationDetails.Builder> networkConfiguration) {
            return networkConfiguration(AwsEcsServiceNetworkConfigurationDetails.builder().applyMutation(networkConfiguration)
                    .build());
        }

        /**
         * <p>
         * The placement constraints for the tasks in the service.
         * </p>
         * 
         * @param placementConstraints
         *        The placement constraints for the tasks in the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(Collection<AwsEcsServicePlacementConstraintsDetails> placementConstraints);

        /**
         * <p>
         * The placement constraints for the tasks in the service.
         * </p>
         * 
         * @param placementConstraints
         *        The placement constraints for the tasks in the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementConstraints(AwsEcsServicePlacementConstraintsDetails... placementConstraints);

        /**
         * <p>
         * The placement constraints for the tasks in the service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementConstraintsDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementConstraintsDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementConstraintsDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #placementConstraints(List<AwsEcsServicePlacementConstraintsDetails>)}.
         * 
         * @param placementConstraints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementConstraintsDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementConstraints(java.util.Collection<AwsEcsServicePlacementConstraintsDetails>)
         */
        Builder placementConstraints(Consumer<AwsEcsServicePlacementConstraintsDetails.Builder>... placementConstraints);

        /**
         * <p>
         * Information about how tasks for the service are placed.
         * </p>
         * 
         * @param placementStrategies
         *        Information about how tasks for the service are placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategies(Collection<AwsEcsServicePlacementStrategiesDetails> placementStrategies);

        /**
         * <p>
         * Information about how tasks for the service are placed.
         * </p>
         * 
         * @param placementStrategies
         *        Information about how tasks for the service are placed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placementStrategies(AwsEcsServicePlacementStrategiesDetails... placementStrategies);

        /**
         * <p>
         * Information about how tasks for the service are placed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #placementStrategies(List<AwsEcsServicePlacementStrategiesDetails>)}.
         * 
         * @param placementStrategies
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServicePlacementStrategiesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placementStrategies(java.util.Collection<AwsEcsServicePlacementStrategiesDetails>)
         */
        Builder placementStrategies(Consumer<AwsEcsServicePlacementStrategiesDetails.Builder>... placementStrategies);

        /**
         * <p>
         * The platform version on which to run the service. Only specified for tasks that are hosted on Fargate. If a
         * platform version is not specified, the <code>LATEST</code> platform version is used by default.
         * </p>
         * 
         * @param platformVersion
         *        The platform version on which to run the service. Only specified for tasks that are hosted on Fargate.
         *        If a platform version is not specified, the <code>LATEST</code> platform version is used by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platformVersion(String platformVersion);

        /**
         * <p>
         * Indicates whether to propagate the tags from the task definition to the task or from the service to the task.
         * If no value is provided, then tags are not propagated.
         * </p>
         * <p>
         * Valid values: <code>TASK_DEFINITION</code> | <code>SERVICE</code>
         * </p>
         * 
         * @param propagateTags
         *        Indicates whether to propagate the tags from the task definition to the task or from the service to
         *        the task. If no value is provided, then tags are not propagated.</p>
         *        <p>
         *        Valid values: <code>TASK_DEFINITION</code> | <code>SERVICE</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagateTags(String propagateTags);

        /**
         * <p>
         * The ARN of the IAM role that is associated with the service. The role allows the Amazon ECS container agent
         * to register container instances with an Elastic Load Balancing load balancer.
         * </p>
         * 
         * @param role
         *        The ARN of the IAM role that is associated with the service. The role allows the Amazon ECS container
         *        agent to register container instances with an Elastic Load Balancing load balancer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder role(String role);

        /**
         * <p>
         * The scheduling strategy to use for the service.
         * </p>
         * <p>
         * The <code>REPLICA</code> scheduling strategy places and maintains the desired number of tasks across the
         * cluster. By default, the service scheduler spreads tasks across Availability Zones. Task placement strategies
         * and constraints are used to customize task placement decisions.
         * </p>
         * <p>
         * The <code>DAEMON</code> scheduling strategy deploys exactly one task on each active container instance that
         * meets all of the task placement constraints that are specified in the cluster. The service scheduler also
         * evaluates the task placement constraints for running tasks and stops tasks that don't meet the placement
         * constraints.
         * </p>
         * <p>
         * Valid values: <code>REPLICA</code> | <code>DAEMON</code>
         * </p>
         * 
         * @param schedulingStrategy
         *        The scheduling strategy to use for the service.</p>
         *        <p>
         *        The <code>REPLICA</code> scheduling strategy places and maintains the desired number of tasks across
         *        the cluster. By default, the service scheduler spreads tasks across Availability Zones. Task placement
         *        strategies and constraints are used to customize task placement decisions.
         *        </p>
         *        <p>
         *        The <code>DAEMON</code> scheduling strategy deploys exactly one task on each active container instance
         *        that meets all of the task placement constraints that are specified in the cluster. The service
         *        scheduler also evaluates the task placement constraints for running tasks and stops tasks that don't
         *        meet the placement constraints.
         *        </p>
         *        <p>
         *        Valid values: <code>REPLICA</code> | <code>DAEMON</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schedulingStrategy(String schedulingStrategy);

        /**
         * <p>
         * The ARN of the service.
         * </p>
         * 
         * @param serviceArn
         *        The ARN of the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);

        /**
         * <p>
         * The name of the service.
         * </p>
         * <p>
         * The name can contain up to 255 characters. It can use letters, numbers, underscores, and hyphens.
         * </p>
         * 
         * @param serviceName
         *        The name of the service.</p>
         *        <p>
         *        The name can contain up to 255 characters. It can use letters, numbers, underscores, and hyphens.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceName(String serviceName);

        /**
         * <p>
         * Information about the service discovery registries to assign to the service.
         * </p>
         * 
         * @param serviceRegistries
         *        Information about the service discovery registries to assign to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(Collection<AwsEcsServiceServiceRegistriesDetails> serviceRegistries);

        /**
         * <p>
         * Information about the service discovery registries to assign to the service.
         * </p>
         * 
         * @param serviceRegistries
         *        Information about the service discovery registries to assign to the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceRegistries(AwsEcsServiceServiceRegistriesDetails... serviceRegistries);

        /**
         * <p>
         * Information about the service discovery registries to assign to the service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #serviceRegistries(List<AwsEcsServiceServiceRegistriesDetails>)}.
         * 
         * @param serviceRegistries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsEcsServiceServiceRegistriesDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceRegistries(java.util.Collection<AwsEcsServiceServiceRegistriesDetails>)
         */
        Builder serviceRegistries(Consumer<AwsEcsServiceServiceRegistriesDetails.Builder>... serviceRegistries);

        /**
         * <p>
         * The task definition to use for tasks in the service.
         * </p>
         * 
         * @param taskDefinition
         *        The task definition to use for tasks in the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskDefinition(String taskDefinition);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsEcsServiceCapacityProviderStrategyDetails> capacityProviderStrategy = DefaultSdkAutoConstructList
                .getInstance();

        private String cluster;

        private AwsEcsServiceDeploymentConfigurationDetails deploymentConfiguration;

        private AwsEcsServiceDeploymentControllerDetails deploymentController;

        private Integer desiredCount;

        private Boolean enableEcsManagedTags;

        private Boolean enableExecuteCommand;

        private Integer healthCheckGracePeriodSeconds;

        private String launchType;

        private List<AwsEcsServiceLoadBalancersDetails> loadBalancers = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private AwsEcsServiceNetworkConfigurationDetails networkConfiguration;

        private List<AwsEcsServicePlacementConstraintsDetails> placementConstraints = DefaultSdkAutoConstructList.getInstance();

        private List<AwsEcsServicePlacementStrategiesDetails> placementStrategies = DefaultSdkAutoConstructList.getInstance();

        private String platformVersion;

        private String propagateTags;

        private String role;

        private String schedulingStrategy;

        private String serviceArn;

        private String serviceName;

        private List<AwsEcsServiceServiceRegistriesDetails> serviceRegistries = DefaultSdkAutoConstructList.getInstance();

        private String taskDefinition;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEcsServiceDetails model) {
            capacityProviderStrategy(model.capacityProviderStrategy);
            cluster(model.cluster);
            deploymentConfiguration(model.deploymentConfiguration);
            deploymentController(model.deploymentController);
            desiredCount(model.desiredCount);
            enableEcsManagedTags(model.enableEcsManagedTags);
            enableExecuteCommand(model.enableExecuteCommand);
            healthCheckGracePeriodSeconds(model.healthCheckGracePeriodSeconds);
            launchType(model.launchType);
            loadBalancers(model.loadBalancers);
            name(model.name);
            networkConfiguration(model.networkConfiguration);
            placementConstraints(model.placementConstraints);
            placementStrategies(model.placementStrategies);
            platformVersion(model.platformVersion);
            propagateTags(model.propagateTags);
            role(model.role);
            schedulingStrategy(model.schedulingStrategy);
            serviceArn(model.serviceArn);
            serviceName(model.serviceName);
            serviceRegistries(model.serviceRegistries);
            taskDefinition(model.taskDefinition);
        }

        public final List<AwsEcsServiceCapacityProviderStrategyDetails.Builder> getCapacityProviderStrategy() {
            List<AwsEcsServiceCapacityProviderStrategyDetails.Builder> result = AwsEcsServiceCapacityProviderStrategyListCopier
                    .copyToBuilder(this.capacityProviderStrategy);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityProviderStrategy(
                Collection<AwsEcsServiceCapacityProviderStrategyDetails.BuilderImpl> capacityProviderStrategy) {
            this.capacityProviderStrategy = AwsEcsServiceCapacityProviderStrategyListCopier
                    .copyFromBuilder(capacityProviderStrategy);
        }

        @Override
        public final Builder capacityProviderStrategy(
                Collection<AwsEcsServiceCapacityProviderStrategyDetails> capacityProviderStrategy) {
            this.capacityProviderStrategy = AwsEcsServiceCapacityProviderStrategyListCopier.copy(capacityProviderStrategy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(AwsEcsServiceCapacityProviderStrategyDetails... capacityProviderStrategy) {
            capacityProviderStrategy(Arrays.asList(capacityProviderStrategy));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityProviderStrategy(
                Consumer<AwsEcsServiceCapacityProviderStrategyDetails.Builder>... capacityProviderStrategy) {
            capacityProviderStrategy(Stream.of(capacityProviderStrategy)
                    .map(c -> AwsEcsServiceCapacityProviderStrategyDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getCluster() {
            return cluster;
        }

        public final void setCluster(String cluster) {
            this.cluster = cluster;
        }

        @Override
        public final Builder cluster(String cluster) {
            this.cluster = cluster;
            return this;
        }

        public final AwsEcsServiceDeploymentConfigurationDetails.Builder getDeploymentConfiguration() {
            return deploymentConfiguration != null ? deploymentConfiguration.toBuilder() : null;
        }

        public final void setDeploymentConfiguration(
                AwsEcsServiceDeploymentConfigurationDetails.BuilderImpl deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration != null ? deploymentConfiguration.build() : null;
        }

        @Override
        public final Builder deploymentConfiguration(AwsEcsServiceDeploymentConfigurationDetails deploymentConfiguration) {
            this.deploymentConfiguration = deploymentConfiguration;
            return this;
        }

        public final AwsEcsServiceDeploymentControllerDetails.Builder getDeploymentController() {
            return deploymentController != null ? deploymentController.toBuilder() : null;
        }

        public final void setDeploymentController(AwsEcsServiceDeploymentControllerDetails.BuilderImpl deploymentController) {
            this.deploymentController = deploymentController != null ? deploymentController.build() : null;
        }

        @Override
        public final Builder deploymentController(AwsEcsServiceDeploymentControllerDetails deploymentController) {
            this.deploymentController = deploymentController;
            return this;
        }

        public final Integer getDesiredCount() {
            return desiredCount;
        }

        public final void setDesiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
        }

        @Override
        public final Builder desiredCount(Integer desiredCount) {
            this.desiredCount = desiredCount;
            return this;
        }

        public final Boolean getEnableEcsManagedTags() {
            return enableEcsManagedTags;
        }

        public final void setEnableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
        }

        @Override
        public final Builder enableEcsManagedTags(Boolean enableEcsManagedTags) {
            this.enableEcsManagedTags = enableEcsManagedTags;
            return this;
        }

        public final Boolean getEnableExecuteCommand() {
            return enableExecuteCommand;
        }

        public final void setEnableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
        }

        @Override
        public final Builder enableExecuteCommand(Boolean enableExecuteCommand) {
            this.enableExecuteCommand = enableExecuteCommand;
            return this;
        }

        public final Integer getHealthCheckGracePeriodSeconds() {
            return healthCheckGracePeriodSeconds;
        }

        public final void setHealthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
        }

        @Override
        public final Builder healthCheckGracePeriodSeconds(Integer healthCheckGracePeriodSeconds) {
            this.healthCheckGracePeriodSeconds = healthCheckGracePeriodSeconds;
            return this;
        }

        public final String getLaunchType() {
            return launchType;
        }

        public final void setLaunchType(String launchType) {
            this.launchType = launchType;
        }

        @Override
        public final Builder launchType(String launchType) {
            this.launchType = launchType;
            return this;
        }

        public final List<AwsEcsServiceLoadBalancersDetails.Builder> getLoadBalancers() {
            List<AwsEcsServiceLoadBalancersDetails.Builder> result = AwsEcsServiceLoadBalancersListCopier
                    .copyToBuilder(this.loadBalancers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLoadBalancers(Collection<AwsEcsServiceLoadBalancersDetails.BuilderImpl> loadBalancers) {
            this.loadBalancers = AwsEcsServiceLoadBalancersListCopier.copyFromBuilder(loadBalancers);
        }

        @Override
        public final Builder loadBalancers(Collection<AwsEcsServiceLoadBalancersDetails> loadBalancers) {
            this.loadBalancers = AwsEcsServiceLoadBalancersListCopier.copy(loadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(AwsEcsServiceLoadBalancersDetails... loadBalancers) {
            loadBalancers(Arrays.asList(loadBalancers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder loadBalancers(Consumer<AwsEcsServiceLoadBalancersDetails.Builder>... loadBalancers) {
            loadBalancers(Stream.of(loadBalancers).map(c -> AwsEcsServiceLoadBalancersDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsEcsServiceNetworkConfigurationDetails.Builder getNetworkConfiguration() {
            return networkConfiguration != null ? networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(AwsEcsServiceNetworkConfigurationDetails.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(AwsEcsServiceNetworkConfigurationDetails networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final List<AwsEcsServicePlacementConstraintsDetails.Builder> getPlacementConstraints() {
            List<AwsEcsServicePlacementConstraintsDetails.Builder> result = AwsEcsServicePlacementConstraintsListCopier
                    .copyToBuilder(this.placementConstraints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementConstraints(
                Collection<AwsEcsServicePlacementConstraintsDetails.BuilderImpl> placementConstraints) {
            this.placementConstraints = AwsEcsServicePlacementConstraintsListCopier.copyFromBuilder(placementConstraints);
        }

        @Override
        public final Builder placementConstraints(Collection<AwsEcsServicePlacementConstraintsDetails> placementConstraints) {
            this.placementConstraints = AwsEcsServicePlacementConstraintsListCopier.copy(placementConstraints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(AwsEcsServicePlacementConstraintsDetails... placementConstraints) {
            placementConstraints(Arrays.asList(placementConstraints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementConstraints(
                Consumer<AwsEcsServicePlacementConstraintsDetails.Builder>... placementConstraints) {
            placementConstraints(Stream.of(placementConstraints)
                    .map(c -> AwsEcsServicePlacementConstraintsDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<AwsEcsServicePlacementStrategiesDetails.Builder> getPlacementStrategies() {
            List<AwsEcsServicePlacementStrategiesDetails.Builder> result = AwsEcsServicePlacementStrategiesListCopier
                    .copyToBuilder(this.placementStrategies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPlacementStrategies(
                Collection<AwsEcsServicePlacementStrategiesDetails.BuilderImpl> placementStrategies) {
            this.placementStrategies = AwsEcsServicePlacementStrategiesListCopier.copyFromBuilder(placementStrategies);
        }

        @Override
        public final Builder placementStrategies(Collection<AwsEcsServicePlacementStrategiesDetails> placementStrategies) {
            this.placementStrategies = AwsEcsServicePlacementStrategiesListCopier.copy(placementStrategies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategies(AwsEcsServicePlacementStrategiesDetails... placementStrategies) {
            placementStrategies(Arrays.asList(placementStrategies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder placementStrategies(Consumer<AwsEcsServicePlacementStrategiesDetails.Builder>... placementStrategies) {
            placementStrategies(Stream.of(placementStrategies)
                    .map(c -> AwsEcsServicePlacementStrategiesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPlatformVersion() {
            return platformVersion;
        }

        public final void setPlatformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
        }

        @Override
        public final Builder platformVersion(String platformVersion) {
            this.platformVersion = platformVersion;
            return this;
        }

        public final String getPropagateTags() {
            return propagateTags;
        }

        public final void setPropagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
        }

        @Override
        public final Builder propagateTags(String propagateTags) {
            this.propagateTags = propagateTags;
            return this;
        }

        public final String getRole() {
            return role;
        }

        public final void setRole(String role) {
            this.role = role;
        }

        @Override
        public final Builder role(String role) {
            this.role = role;
            return this;
        }

        public final String getSchedulingStrategy() {
            return schedulingStrategy;
        }

        public final void setSchedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
        }

        @Override
        public final Builder schedulingStrategy(String schedulingStrategy) {
            this.schedulingStrategy = schedulingStrategy;
            return this;
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        public final String getServiceName() {
            return serviceName;
        }

        public final void setServiceName(String serviceName) {
            this.serviceName = serviceName;
        }

        @Override
        public final Builder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public final List<AwsEcsServiceServiceRegistriesDetails.Builder> getServiceRegistries() {
            List<AwsEcsServiceServiceRegistriesDetails.Builder> result = AwsEcsServiceServiceRegistriesListCopier
                    .copyToBuilder(this.serviceRegistries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServiceRegistries(Collection<AwsEcsServiceServiceRegistriesDetails.BuilderImpl> serviceRegistries) {
            this.serviceRegistries = AwsEcsServiceServiceRegistriesListCopier.copyFromBuilder(serviceRegistries);
        }

        @Override
        public final Builder serviceRegistries(Collection<AwsEcsServiceServiceRegistriesDetails> serviceRegistries) {
            this.serviceRegistries = AwsEcsServiceServiceRegistriesListCopier.copy(serviceRegistries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(AwsEcsServiceServiceRegistriesDetails... serviceRegistries) {
            serviceRegistries(Arrays.asList(serviceRegistries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceRegistries(Consumer<AwsEcsServiceServiceRegistriesDetails.Builder>... serviceRegistries) {
            serviceRegistries(Stream.of(serviceRegistries)
                    .map(c -> AwsEcsServiceServiceRegistriesDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTaskDefinition() {
            return taskDefinition;
        }

        public final void setTaskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
        }

        @Override
        public final Builder taskDefinition(String taskDefinition) {
            this.taskDefinition = taskDefinition;
            return this;
        }

        @Override
        public AwsEcsServiceDetails build() {
            return new AwsEcsServiceDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
