/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides details for client authentication using TLS.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsMskClusterClusterInfoClientAuthenticationTlsDetails
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<AwsMskClusterClusterInfoClientAuthenticationTlsDetails.Builder, AwsMskClusterClusterInfoClientAuthenticationTlsDetails> {
    private static final SdkField<List<String>> CERTIFICATE_AUTHORITY_ARN_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CertificateAuthorityArnList")
            .getter(getter(AwsMskClusterClusterInfoClientAuthenticationTlsDetails::certificateAuthorityArnList))
            .setter(setter(Builder::certificateAuthorityArnList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateAuthorityArnList")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(AwsMskClusterClusterInfoClientAuthenticationTlsDetails::enabled))
            .setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CERTIFICATE_AUTHORITY_ARN_LIST_FIELD, ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> certificateAuthorityArnList;

    private final Boolean enabled;

    private AwsMskClusterClusterInfoClientAuthenticationTlsDetails(BuilderImpl builder) {
        this.certificateAuthorityArnList = builder.certificateAuthorityArnList;
        this.enabled = builder.enabled;
    }

    /**
     * For responses, this returns true if the service returned a value for the CertificateAuthorityArnList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCertificateAuthorityArnList() {
        return certificateAuthorityArnList != null && !(certificateAuthorityArnList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of Amazon Web Services Private CA Amazon Resource Names (ARNs). Amazon Web Services Private CA enables
     * creation of private certificate authority (CA) hierarchies, including root and subordinate CAs, without the
     * investment and maintenance costs of operating an on-premises CA.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCertificateAuthorityArnList} method.
     * </p>
     * 
     * @return List of Amazon Web Services Private CA Amazon Resource Names (ARNs). Amazon Web Services Private CA
     *         enables creation of private certificate authority (CA) hierarchies, including root and subordinate CAs,
     *         without the investment and maintenance costs of operating an on-premises CA.
     */
    public final List<String> certificateAuthorityArnList() {
        return certificateAuthorityArnList;
    }

    /**
     * <p>
     * Indicates whether TLS authentication is enabled or not.
     * </p>
     * 
     * @return Indicates whether TLS authentication is enabled or not.
     */
    public final Boolean enabled() {
        return enabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasCertificateAuthorityArnList() ? certificateAuthorityArnList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsMskClusterClusterInfoClientAuthenticationTlsDetails)) {
            return false;
        }
        AwsMskClusterClusterInfoClientAuthenticationTlsDetails other = (AwsMskClusterClusterInfoClientAuthenticationTlsDetails) obj;
        return hasCertificateAuthorityArnList() == other.hasCertificateAuthorityArnList()
                && Objects.equals(certificateAuthorityArnList(), other.certificateAuthorityArnList())
                && Objects.equals(enabled(), other.enabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsMskClusterClusterInfoClientAuthenticationTlsDetails")
                .add("CertificateAuthorityArnList", hasCertificateAuthorityArnList() ? certificateAuthorityArnList() : null)
                .add("Enabled", enabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateAuthorityArnList":
            return Optional.ofNullable(clazz.cast(certificateAuthorityArnList()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsMskClusterClusterInfoClientAuthenticationTlsDetails, T> g) {
        return obj -> g.apply((AwsMskClusterClusterInfoClientAuthenticationTlsDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsMskClusterClusterInfoClientAuthenticationTlsDetails> {
        /**
         * <p>
         * List of Amazon Web Services Private CA Amazon Resource Names (ARNs). Amazon Web Services Private CA enables
         * creation of private certificate authority (CA) hierarchies, including root and subordinate CAs, without the
         * investment and maintenance costs of operating an on-premises CA.
         * </p>
         * 
         * @param certificateAuthorityArnList
         *        List of Amazon Web Services Private CA Amazon Resource Names (ARNs). Amazon Web Services Private CA
         *        enables creation of private certificate authority (CA) hierarchies, including root and subordinate
         *        CAs, without the investment and maintenance costs of operating an on-premises CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArnList(Collection<String> certificateAuthorityArnList);

        /**
         * <p>
         * List of Amazon Web Services Private CA Amazon Resource Names (ARNs). Amazon Web Services Private CA enables
         * creation of private certificate authority (CA) hierarchies, including root and subordinate CAs, without the
         * investment and maintenance costs of operating an on-premises CA.
         * </p>
         * 
         * @param certificateAuthorityArnList
         *        List of Amazon Web Services Private CA Amazon Resource Names (ARNs). Amazon Web Services Private CA
         *        enables creation of private certificate authority (CA) hierarchies, including root and subordinate
         *        CAs, without the investment and maintenance costs of operating an on-premises CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateAuthorityArnList(String... certificateAuthorityArnList);

        /**
         * <p>
         * Indicates whether TLS authentication is enabled or not.
         * </p>
         * 
         * @param enabled
         *        Indicates whether TLS authentication is enabled or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);
    }

    static final class BuilderImpl implements Builder {
        private List<String> certificateAuthorityArnList = DefaultSdkAutoConstructList.getInstance();

        private Boolean enabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsMskClusterClusterInfoClientAuthenticationTlsDetails model) {
            certificateAuthorityArnList(model.certificateAuthorityArnList);
            enabled(model.enabled);
        }

        public final Collection<String> getCertificateAuthorityArnList() {
            if (certificateAuthorityArnList instanceof SdkAutoConstructList) {
                return null;
            }
            return certificateAuthorityArnList;
        }

        public final void setCertificateAuthorityArnList(Collection<String> certificateAuthorityArnList) {
            this.certificateAuthorityArnList = StringListCopier.copy(certificateAuthorityArnList);
        }

        @Override
        public final Builder certificateAuthorityArnList(Collection<String> certificateAuthorityArnList) {
            this.certificateAuthorityArnList = StringListCopier.copy(certificateAuthorityArnList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder certificateAuthorityArnList(String... certificateAuthorityArnList) {
            certificateAuthorityArnList(Arrays.asList(certificateAuthorityArnList));
            return this;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public AwsMskClusterClusterInfoClientAuthenticationTlsDetails build() {
            return new AwsMskClusterClusterInfoClientAuthenticationTlsDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
