/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * EC2 security group information for an RDS DB security group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRdsDbSecurityGroupEc2SecurityGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRdsDbSecurityGroupEc2SecurityGroup.Builder, AwsRdsDbSecurityGroupEc2SecurityGroup> {
    private static final SdkField<String> EC2_SECURITY_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2SecurityGroupId").getter(getter(AwsRdsDbSecurityGroupEc2SecurityGroup::ec2SecurityGroupId))
            .setter(setter(Builder::ec2SecurityGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2SecurityGroupId").build())
            .build();

    private static final SdkField<String> EC2_SECURITY_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2SecurityGroupName").getter(getter(AwsRdsDbSecurityGroupEc2SecurityGroup::ec2SecurityGroupName))
            .setter(setter(Builder::ec2SecurityGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2SecurityGroupName").build())
            .build();

    private static final SdkField<String> EC2_SECURITY_GROUP_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Ec2SecurityGroupOwnerId").getter(getter(AwsRdsDbSecurityGroupEc2SecurityGroup::ec2SecurityGroupOwnerId))
            .setter(setter(Builder::ec2SecurityGroupOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ec2SecurityGroupOwnerId").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(AwsRdsDbSecurityGroupEc2SecurityGroup::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_SECURITY_GROUP_ID_FIELD,
            EC2_SECURITY_GROUP_NAME_FIELD, EC2_SECURITY_GROUP_OWNER_ID_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ec2SecurityGroupId;

    private final String ec2SecurityGroupName;

    private final String ec2SecurityGroupOwnerId;

    private final String status;

    private AwsRdsDbSecurityGroupEc2SecurityGroup(BuilderImpl builder) {
        this.ec2SecurityGroupId = builder.ec2SecurityGroupId;
        this.ec2SecurityGroupName = builder.ec2SecurityGroupName;
        this.ec2SecurityGroupOwnerId = builder.ec2SecurityGroupOwnerId;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies the ID for the EC2 security group.
     * </p>
     * 
     * @return Specifies the ID for the EC2 security group.
     */
    public final String ec2SecurityGroupId() {
        return ec2SecurityGroupId;
    }

    /**
     * <p>
     * Specifies the name of the EC2 security group.
     * </p>
     * 
     * @return Specifies the name of the EC2 security group.
     */
    public final String ec2SecurityGroupName() {
        return ec2SecurityGroupName;
    }

    /**
     * <p>
     * Provides the Amazon Web Services ID of the owner of the EC2 security group.
     * </p>
     * 
     * @return Provides the Amazon Web Services ID of the owner of the EC2 security group.
     */
    public final String ec2SecurityGroupOwnerId() {
        return ec2SecurityGroupOwnerId;
    }

    /**
     * <p>
     * Provides the status of the EC2 security group.
     * </p>
     * 
     * @return Provides the status of the EC2 security group.
     */
    public final String status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(ec2SecurityGroupOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRdsDbSecurityGroupEc2SecurityGroup)) {
            return false;
        }
        AwsRdsDbSecurityGroupEc2SecurityGroup other = (AwsRdsDbSecurityGroupEc2SecurityGroup) obj;
        return Objects.equals(ec2SecurityGroupId(), other.ec2SecurityGroupId())
                && Objects.equals(ec2SecurityGroupName(), other.ec2SecurityGroupName())
                && Objects.equals(ec2SecurityGroupOwnerId(), other.ec2SecurityGroupOwnerId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRdsDbSecurityGroupEc2SecurityGroup").add("Ec2SecurityGroupId", ec2SecurityGroupId())
                .add("Ec2SecurityGroupName", ec2SecurityGroupName()).add("Ec2SecurityGroupOwnerId", ec2SecurityGroupOwnerId())
                .add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Ec2SecurityGroupId":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupId()));
        case "Ec2SecurityGroupName":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupName()));
        case "Ec2SecurityGroupOwnerId":
            return Optional.ofNullable(clazz.cast(ec2SecurityGroupOwnerId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRdsDbSecurityGroupEc2SecurityGroup, T> g) {
        return obj -> g.apply((AwsRdsDbSecurityGroupEc2SecurityGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRdsDbSecurityGroupEc2SecurityGroup> {
        /**
         * <p>
         * Specifies the ID for the EC2 security group.
         * </p>
         * 
         * @param ec2SecurityGroupId
         *        Specifies the ID for the EC2 security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupId(String ec2SecurityGroupId);

        /**
         * <p>
         * Specifies the name of the EC2 security group.
         * </p>
         * 
         * @param ec2SecurityGroupName
         *        Specifies the name of the EC2 security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupName(String ec2SecurityGroupName);

        /**
         * <p>
         * Provides the Amazon Web Services ID of the owner of the EC2 security group.
         * </p>
         * 
         * @param ec2SecurityGroupOwnerId
         *        Provides the Amazon Web Services ID of the owner of the EC2 security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId);

        /**
         * <p>
         * Provides the status of the EC2 security group.
         * </p>
         * 
         * @param status
         *        Provides the status of the EC2 security group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);
    }

    static final class BuilderImpl implements Builder {
        private String ec2SecurityGroupId;

        private String ec2SecurityGroupName;

        private String ec2SecurityGroupOwnerId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRdsDbSecurityGroupEc2SecurityGroup model) {
            ec2SecurityGroupId(model.ec2SecurityGroupId);
            ec2SecurityGroupName(model.ec2SecurityGroupName);
            ec2SecurityGroupOwnerId(model.ec2SecurityGroupOwnerId);
            status(model.status);
        }

        public final String getEc2SecurityGroupId() {
            return ec2SecurityGroupId;
        }

        public final void setEc2SecurityGroupId(String ec2SecurityGroupId) {
            this.ec2SecurityGroupId = ec2SecurityGroupId;
        }

        @Override
        public final Builder ec2SecurityGroupId(String ec2SecurityGroupId) {
            this.ec2SecurityGroupId = ec2SecurityGroupId;
            return this;
        }

        public final String getEc2SecurityGroupName() {
            return ec2SecurityGroupName;
        }

        public final void setEc2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
        }

        @Override
        public final Builder ec2SecurityGroupName(String ec2SecurityGroupName) {
            this.ec2SecurityGroupName = ec2SecurityGroupName;
            return this;
        }

        public final String getEc2SecurityGroupOwnerId() {
            return ec2SecurityGroupOwnerId;
        }

        public final void setEc2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
        }

        @Override
        public final Builder ec2SecurityGroupOwnerId(String ec2SecurityGroupOwnerId) {
            this.ec2SecurityGroupOwnerId = ec2SecurityGroupOwnerId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public AwsRdsDbSecurityGroupEc2SecurityGroup build() {
            return new AwsRdsDbSecurityGroupEc2SecurityGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
