/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A cluster parameter group that is associated with an Amazon Redshift cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRedshiftClusterClusterParameterGroup implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRedshiftClusterClusterParameterGroup.Builder, AwsRedshiftClusterClusterParameterGroup> {
    private static final SdkField<List<AwsRedshiftClusterClusterParameterStatus>> CLUSTER_PARAMETER_STATUS_LIST_FIELD = SdkField
            .<List<AwsRedshiftClusterClusterParameterStatus>> builder(MarshallingType.LIST)
            .memberName("ClusterParameterStatusList")
            .getter(getter(AwsRedshiftClusterClusterParameterGroup::clusterParameterStatusList))
            .setter(setter(Builder::clusterParameterStatusList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterStatusList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AwsRedshiftClusterClusterParameterStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(AwsRedshiftClusterClusterParameterStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterApplyStatus").getter(getter(AwsRedshiftClusterClusterParameterGroup::parameterApplyStatus))
            .setter(setter(Builder::parameterApplyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build())
            .build();

    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(AwsRedshiftClusterClusterParameterGroup::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CLUSTER_PARAMETER_STATUS_LIST_FIELD, PARAMETER_APPLY_STATUS_FIELD, PARAMETER_GROUP_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<AwsRedshiftClusterClusterParameterStatus> clusterParameterStatusList;

    private final String parameterApplyStatus;

    private final String parameterGroupName;

    private AwsRedshiftClusterClusterParameterGroup(BuilderImpl builder) {
        this.clusterParameterStatusList = builder.clusterParameterStatusList;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.parameterGroupName = builder.parameterGroupName;
    }

    /**
     * For responses, this returns true if the service returned a value for the ClusterParameterStatusList property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasClusterParameterStatusList() {
        return clusterParameterStatusList != null && !(clusterParameterStatusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of parameter statuses.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasClusterParameterStatusList} method.
     * </p>
     * 
     * @return The list of parameter statuses.
     */
    public final List<AwsRedshiftClusterClusterParameterStatus> clusterParameterStatusList() {
        return clusterParameterStatusList;
    }

    /**
     * <p>
     * The status of updates to the parameters.
     * </p>
     * 
     * @return The status of updates to the parameters.
     */
    public final String parameterApplyStatus() {
        return parameterApplyStatus;
    }

    /**
     * <p>
     * The name of the parameter group.
     * </p>
     * 
     * @return The name of the parameter group.
     */
    public final String parameterGroupName() {
        return parameterGroupName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasClusterParameterStatusList() ? clusterParameterStatusList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRedshiftClusterClusterParameterGroup)) {
            return false;
        }
        AwsRedshiftClusterClusterParameterGroup other = (AwsRedshiftClusterClusterParameterGroup) obj;
        return hasClusterParameterStatusList() == other.hasClusterParameterStatusList()
                && Objects.equals(clusterParameterStatusList(), other.clusterParameterStatusList())
                && Objects.equals(parameterApplyStatus(), other.parameterApplyStatus())
                && Objects.equals(parameterGroupName(), other.parameterGroupName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRedshiftClusterClusterParameterGroup")
                .add("ClusterParameterStatusList", hasClusterParameterStatusList() ? clusterParameterStatusList() : null)
                .add("ParameterApplyStatus", parameterApplyStatus()).add("ParameterGroupName", parameterGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterParameterStatusList":
            return Optional.ofNullable(clazz.cast(clusterParameterStatusList()));
        case "ParameterApplyStatus":
            return Optional.ofNullable(clazz.cast(parameterApplyStatus()));
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRedshiftClusterClusterParameterGroup, T> g) {
        return obj -> g.apply((AwsRedshiftClusterClusterParameterGroup) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRedshiftClusterClusterParameterGroup> {
        /**
         * <p>
         * The list of parameter statuses.
         * </p>
         * 
         * @param clusterParameterStatusList
         *        The list of parameter statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterStatusList(Collection<AwsRedshiftClusterClusterParameterStatus> clusterParameterStatusList);

        /**
         * <p>
         * The list of parameter statuses.
         * </p>
         * 
         * @param clusterParameterStatusList
         *        The list of parameter statuses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterStatusList(AwsRedshiftClusterClusterParameterStatus... clusterParameterStatusList);

        /**
         * <p>
         * The list of parameter statuses.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterStatus.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterStatus.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #clusterParameterStatusList(List<AwsRedshiftClusterClusterParameterStatus>)}.
         * 
         * @param clusterParameterStatusList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityhub.model.AwsRedshiftClusterClusterParameterStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterParameterStatusList(java.util.Collection<AwsRedshiftClusterClusterParameterStatus>)
         */
        Builder clusterParameterStatusList(
                Consumer<AwsRedshiftClusterClusterParameterStatus.Builder>... clusterParameterStatusList);

        /**
         * <p>
         * The status of updates to the parameters.
         * </p>
         * 
         * @param parameterApplyStatus
         *        The status of updates to the parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterApplyStatus(String parameterApplyStatus);

        /**
         * <p>
         * The name of the parameter group.
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);
    }

    static final class BuilderImpl implements Builder {
        private List<AwsRedshiftClusterClusterParameterStatus> clusterParameterStatusList = DefaultSdkAutoConstructList
                .getInstance();

        private String parameterApplyStatus;

        private String parameterGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRedshiftClusterClusterParameterGroup model) {
            clusterParameterStatusList(model.clusterParameterStatusList);
            parameterApplyStatus(model.parameterApplyStatus);
            parameterGroupName(model.parameterGroupName);
        }

        public final List<AwsRedshiftClusterClusterParameterStatus.Builder> getClusterParameterStatusList() {
            List<AwsRedshiftClusterClusterParameterStatus.Builder> result = AwsRedshiftClusterClusterParameterStatusListCopier
                    .copyToBuilder(this.clusterParameterStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterParameterStatusList(
                Collection<AwsRedshiftClusterClusterParameterStatus.BuilderImpl> clusterParameterStatusList) {
            this.clusterParameterStatusList = AwsRedshiftClusterClusterParameterStatusListCopier
                    .copyFromBuilder(clusterParameterStatusList);
        }

        @Override
        public final Builder clusterParameterStatusList(
                Collection<AwsRedshiftClusterClusterParameterStatus> clusterParameterStatusList) {
            this.clusterParameterStatusList = AwsRedshiftClusterClusterParameterStatusListCopier.copy(clusterParameterStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterStatusList(AwsRedshiftClusterClusterParameterStatus... clusterParameterStatusList) {
            clusterParameterStatusList(Arrays.asList(clusterParameterStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterStatusList(
                Consumer<AwsRedshiftClusterClusterParameterStatus.Builder>... clusterParameterStatusList) {
            clusterParameterStatusList(Stream.of(clusterParameterStatusList)
                    .map(c -> AwsRedshiftClusterClusterParameterStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getParameterApplyStatus() {
            return parameterApplyStatus;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        @Override
        public AwsRedshiftClusterClusterParameterGroup build() {
            return new AwsRedshiftClusterClusterParameterGroup(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
