/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains information about an Amazon Route 53 hosted zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsRoute53HostedZoneObjectDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsRoute53HostedZoneObjectDetails.Builder, AwsRoute53HostedZoneObjectDetails> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(AwsRoute53HostedZoneObjectDetails::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AwsRoute53HostedZoneObjectDetails::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AwsRoute53HostedZoneConfigDetails> CONFIG_FIELD = SdkField
            .<AwsRoute53HostedZoneConfigDetails> builder(MarshallingType.SDK_POJO).memberName("Config")
            .getter(getter(AwsRoute53HostedZoneObjectDetails::config)).setter(setter(Builder::config))
            .constructor(AwsRoute53HostedZoneConfigDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Config").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final AwsRoute53HostedZoneConfigDetails config;

    private AwsRoute53HostedZoneObjectDetails(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.config = builder.config;
    }

    /**
     * <p>
     * The ID that Route 53 assigns to the hosted zone when you create it.
     * </p>
     * 
     * @return The ID that Route 53 assigns to the hosted zone when you create it.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
     * registrar.
     * </p>
     * 
     * @return The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
     *         registrar.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An object that includes the <code>Comment</code> element.
     * </p>
     * 
     * @return An object that includes the <code>Comment</code> element.
     */
    public final AwsRoute53HostedZoneConfigDetails config() {
        return config;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(config());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsRoute53HostedZoneObjectDetails)) {
            return false;
        }
        AwsRoute53HostedZoneObjectDetails other = (AwsRoute53HostedZoneObjectDetails) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(config(), other.config());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsRoute53HostedZoneObjectDetails").add("Id", id()).add("Name", name()).add("Config", config())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Config":
            return Optional.ofNullable(clazz.cast(config()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsRoute53HostedZoneObjectDetails, T> g) {
        return obj -> g.apply((AwsRoute53HostedZoneObjectDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsRoute53HostedZoneObjectDetails> {
        /**
         * <p>
         * The ID that Route 53 assigns to the hosted zone when you create it.
         * </p>
         * 
         * @param id
         *        The ID that Route 53 assigns to the hosted zone when you create it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the domain. For public hosted zones, this is the name that you have registered with your DNS
         * registrar.
         * </p>
         * 
         * @param name
         *        The name of the domain. For public hosted zones, this is the name that you have registered with your
         *        DNS registrar.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An object that includes the <code>Comment</code> element.
         * </p>
         * 
         * @param config
         *        An object that includes the <code>Comment</code> element.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder config(AwsRoute53HostedZoneConfigDetails config);

        /**
         * <p>
         * An object that includes the <code>Comment</code> element.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link AwsRoute53HostedZoneConfigDetails.Builder} avoiding the need to create one manually via
         * {@link AwsRoute53HostedZoneConfigDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsRoute53HostedZoneConfigDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #config(AwsRoute53HostedZoneConfigDetails)}.
         * 
         * @param config
         *        a consumer that will call methods on {@link AwsRoute53HostedZoneConfigDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #config(AwsRoute53HostedZoneConfigDetails)
         */
        default Builder config(Consumer<AwsRoute53HostedZoneConfigDetails.Builder> config) {
            return config(AwsRoute53HostedZoneConfigDetails.builder().applyMutation(config).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private AwsRoute53HostedZoneConfigDetails config;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsRoute53HostedZoneObjectDetails model) {
            id(model.id);
            name(model.name);
            config(model.config);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsRoute53HostedZoneConfigDetails.Builder getConfig() {
            return config != null ? config.toBuilder() : null;
        }

        public final void setConfig(AwsRoute53HostedZoneConfigDetails.BuilderImpl config) {
            this.config = config != null ? config.build() : null;
        }

        @Override
        public final Builder config(AwsRoute53HostedZoneConfigDetails config) {
            this.config = config;
            return this;
        }

        @Override
        public AwsRoute53HostedZoneObjectDetails build() {
            return new AwsRoute53HostedZoneObjectDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
