/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A match predicate. A predicate might look for characteristics such as specific IP addresses, geographic locations, or
 * sizes.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsWafRateBasedRuleMatchPredicate implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsWafRateBasedRuleMatchPredicate.Builder, AwsWafRateBasedRuleMatchPredicate> {
    private static final SdkField<String> DATA_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("DataId")
            .getter(getter(AwsWafRateBasedRuleMatchPredicate::dataId)).setter(setter(Builder::dataId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataId").build()).build();

    private static final SdkField<Boolean> NEGATED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Negated").getter(getter(AwsWafRateBasedRuleMatchPredicate::negated)).setter(setter(Builder::negated))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Negated").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(AwsWafRateBasedRuleMatchPredicate::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_ID_FIELD, NEGATED_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dataId;

    private final Boolean negated;

    private final String type;

    private AwsWafRateBasedRuleMatchPredicate(BuilderImpl builder) {
        this.dataId = builder.dataId;
        this.negated = builder.negated;
        this.type = builder.type;
    }

    /**
     * <p>
     * The unique identifier for the predicate.
     * </p>
     * 
     * @return The unique identifier for the predicate.
     */
    public final String dataId() {
        return dataId;
    }

    /**
     * <p>
     * If set to <code>true</code>, then the rule actions are performed on requests that match the predicate settings.
     * </p>
     * <p>
     * If set to <code>false</code>, then the rule actions are performed on all requests except those that match the
     * predicate settings.
     * </p>
     * 
     * @return If set to <code>true</code>, then the rule actions are performed on requests that match the predicate
     *         settings.</p>
     *         <p>
     *         If set to <code>false</code>, then the rule actions are performed on all requests except those that match
     *         the predicate settings.
     */
    public final Boolean negated() {
        return negated;
    }

    /**
     * <p>
     * The type of predicate. Valid values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ByteMatch</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>GeoMatch</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>IPMatch</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RegexMatch</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SizeConstraint</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SqlInjectionMatch</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>XssMatch</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The type of predicate. Valid values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ByteMatch</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>GeoMatch</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>IPMatch</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RegexMatch</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SizeConstraint</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SqlInjectionMatch</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>XssMatch</code>
     *         </p>
     *         </li>
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataId());
        hashCode = 31 * hashCode + Objects.hashCode(negated());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsWafRateBasedRuleMatchPredicate)) {
            return false;
        }
        AwsWafRateBasedRuleMatchPredicate other = (AwsWafRateBasedRuleMatchPredicate) obj;
        return Objects.equals(dataId(), other.dataId()) && Objects.equals(negated(), other.negated())
                && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsWafRateBasedRuleMatchPredicate").add("DataId", dataId()).add("Negated", negated())
                .add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataId":
            return Optional.ofNullable(clazz.cast(dataId()));
        case "Negated":
            return Optional.ofNullable(clazz.cast(negated()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AwsWafRateBasedRuleMatchPredicate, T> g) {
        return obj -> g.apply((AwsWafRateBasedRuleMatchPredicate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsWafRateBasedRuleMatchPredicate> {
        /**
         * <p>
         * The unique identifier for the predicate.
         * </p>
         * 
         * @param dataId
         *        The unique identifier for the predicate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataId(String dataId);

        /**
         * <p>
         * If set to <code>true</code>, then the rule actions are performed on requests that match the predicate
         * settings.
         * </p>
         * <p>
         * If set to <code>false</code>, then the rule actions are performed on all requests except those that match the
         * predicate settings.
         * </p>
         * 
         * @param negated
         *        If set to <code>true</code>, then the rule actions are performed on requests that match the predicate
         *        settings.</p>
         *        <p>
         *        If set to <code>false</code>, then the rule actions are performed on all requests except those that
         *        match the predicate settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder negated(Boolean negated);

        /**
         * <p>
         * The type of predicate. Valid values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ByteMatch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>GeoMatch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>IPMatch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RegexMatch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SizeConstraint</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SqlInjectionMatch</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>XssMatch</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param type
         *        The type of predicate. Valid values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ByteMatch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>GeoMatch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>IPMatch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RegexMatch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SizeConstraint</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SqlInjectionMatch</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>XssMatch</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String dataId;

        private Boolean negated;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsWafRateBasedRuleMatchPredicate model) {
            dataId(model.dataId);
            negated(model.negated);
            type(model.type);
        }

        public final String getDataId() {
            return dataId;
        }

        public final void setDataId(String dataId) {
            this.dataId = dataId;
        }

        @Override
        public final Builder dataId(String dataId) {
            this.dataId = dataId;
            return this;
        }

        public final Boolean getNegated() {
            return negated;
        }

        public final void setNegated(Boolean negated) {
            this.negated = negated;
        }

        @Override
        public final Builder negated(Boolean negated) {
            this.negated = negated;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public AwsWafRateBasedRuleMatchPredicate build() {
            return new AwsWafRateBasedRuleMatchPredicate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
