/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that defines how Security Hub is configured. It includes whether Security Hub is enabled or disabled, a
 * list of enabled security standards, a list of enabled or disabled security controls, and a list of custom parameter
 * values for specified controls. If you provide a list of security controls that are enabled in the configuration
 * policy, Security Hub disables all other controls (including newly released controls). If you provide a list of
 * security controls that are disabled in the configuration policy, Security Hub enables all other controls (including
 * newly released controls).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Policy implements SdkPojo, Serializable, ToCopyableBuilder<Policy.Builder, Policy> {
    private static final SdkField<SecurityHubPolicy> SECURITY_HUB_FIELD = SdkField
            .<SecurityHubPolicy> builder(MarshallingType.SDK_POJO).memberName("SecurityHub").getter(getter(Policy::securityHub))
            .setter(setter(Builder::securityHub)).constructor(SecurityHubPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityHub").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_HUB_FIELD));

    private static final long serialVersionUID = 1L;

    private final SecurityHubPolicy securityHub;

    private final Type type;

    private Policy(BuilderImpl builder) {
        this.securityHub = builder.securityHub;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Web Services service that the configuration policy applies to.
     * </p>
     * 
     * @return The Amazon Web Services service that the configuration policy applies to.
     */
    public final SecurityHubPolicy securityHub() {
        return securityHub;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(securityHub());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Policy)) {
            return false;
        }
        Policy other = (Policy) obj;
        return Objects.equals(securityHub(), other.securityHub());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Policy").add("SecurityHub", securityHub()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityHub":
            return Optional.ofNullable(clazz.cast(securityHub()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #securityHub()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services service that the configuration policy applies to.
     * </p>
     * 
     * @param securityHub
     *        The Amazon Web Services service that the configuration policy applies to.
     */
    public static Policy fromSecurityHub(SecurityHubPolicy securityHub) {
        return builder().securityHub(securityHub).build();
    }

    /**
     * Create an instance of this class with {@link #securityHub()} initialized to the given value.
     *
     * <p>
     * The Amazon Web Services service that the configuration policy applies to.
     * </p>
     * 
     * @param securityHub
     *        The Amazon Web Services service that the configuration policy applies to.
     */
    public static Policy fromSecurityHub(Consumer<SecurityHubPolicy.Builder> securityHub) {
        SecurityHubPolicy.Builder builder = SecurityHubPolicy.builder();
        securityHub.accept(builder);
        return fromSecurityHub(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Policy, T> g) {
        return obj -> g.apply((Policy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Policy> {
        /**
         * <p>
         * The Amazon Web Services service that the configuration policy applies to.
         * </p>
         * 
         * @param securityHub
         *        The Amazon Web Services service that the configuration policy applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityHub(SecurityHubPolicy securityHub);

        /**
         * <p>
         * The Amazon Web Services service that the configuration policy applies to.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityHubPolicy.Builder} avoiding the
         * need to create one manually via {@link SecurityHubPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityHubPolicy.Builder#build()} is called immediately and its
         * result is passed to {@link #securityHub(SecurityHubPolicy)}.
         * 
         * @param securityHub
         *        a consumer that will call methods on {@link SecurityHubPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityHub(SecurityHubPolicy)
         */
        default Builder securityHub(Consumer<SecurityHubPolicy.Builder> securityHub) {
            return securityHub(SecurityHubPolicy.builder().applyMutation(securityHub).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SecurityHubPolicy securityHub;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Policy model) {
            securityHub(model.securityHub);
        }

        public final SecurityHubPolicy.Builder getSecurityHub() {
            return securityHub != null ? securityHub.toBuilder() : null;
        }

        public final void setSecurityHub(SecurityHubPolicy.BuilderImpl securityHub) {
            Object oldValue = this.securityHub;
            this.securityHub = securityHub != null ? securityHub.build() : null;
            handleUnionValueChange(Type.SECURITY_HUB, oldValue, this.securityHub);
        }

        @Override
        public final Builder securityHub(SecurityHubPolicy securityHub) {
            Object oldValue = this.securityHub;
            this.securityHub = securityHub;
            handleUnionValueChange(Type.SECURITY_HUB, oldValue, this.securityHub);
            return this;
        }

        @Override
        public Policy build() {
            return new Policy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Policy#type()
     */
    public enum Type {
        SECURITY_HUB,

        UNKNOWN_TO_SDK_VERSION
    }
}
