/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityControlRequest extends SecurityHubRequest implements
        ToCopyableBuilder<UpdateSecurityControlRequest.Builder, UpdateSecurityControlRequest> {
    private static final SdkField<String> SECURITY_CONTROL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SecurityControlId").getter(getter(UpdateSecurityControlRequest::securityControlId))
            .setter(setter(Builder::securityControlId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityControlId").build()).build();

    private static final SdkField<Map<String, ParameterConfiguration>> PARAMETERS_FIELD = SdkField
            .<Map<String, ParameterConfiguration>> builder(MarshallingType.MAP)
            .memberName("Parameters")
            .getter(getter(UpdateSecurityControlRequest::parameters))
            .setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<ParameterConfiguration> builder(MarshallingType.SDK_POJO)
                                            .constructor(ParameterConfiguration::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> LAST_UPDATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastUpdateReason").getter(getter(UpdateSecurityControlRequest::lastUpdateReason))
            .setter(setter(Builder::lastUpdateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONTROL_ID_FIELD,
            PARAMETERS_FIELD, LAST_UPDATE_REASON_FIELD));

    private final String securityControlId;

    private final Map<String, ParameterConfiguration> parameters;

    private final String lastUpdateReason;

    private UpdateSecurityControlRequest(BuilderImpl builder) {
        super(builder);
        this.securityControlId = builder.securityControlId;
        this.parameters = builder.parameters;
        this.lastUpdateReason = builder.lastUpdateReason;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) or ID of the control to update.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) or ID of the control to update.
     */
    public final String securityControlId() {
        return securityControlId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Parameters property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasParameters() {
        return parameters != null && !(parameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that specifies which security control parameters to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameters} method.
     * </p>
     * 
     * @return An object that specifies which security control parameters to update.
     */
    public final Map<String, ParameterConfiguration> parameters() {
        return parameters;
    }

    /**
     * <p>
     * The most recent reason for updating the properties of the security control. This field accepts alphanumeric
     * characters in addition to white spaces, dashes, and underscores.
     * </p>
     * 
     * @return The most recent reason for updating the properties of the security control. This field accepts
     *         alphanumeric characters in addition to white spaces, dashes, and underscores.
     */
    public final String lastUpdateReason() {
        return lastUpdateReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityControlId());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameters() ? parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityControlRequest)) {
            return false;
        }
        UpdateSecurityControlRequest other = (UpdateSecurityControlRequest) obj;
        return Objects.equals(securityControlId(), other.securityControlId()) && hasParameters() == other.hasParameters()
                && Objects.equals(parameters(), other.parameters())
                && Objects.equals(lastUpdateReason(), other.lastUpdateReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecurityControlRequest").add("SecurityControlId", securityControlId())
                .add("Parameters", hasParameters() ? parameters() : null).add("LastUpdateReason", lastUpdateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SecurityControlId":
            return Optional.ofNullable(clazz.cast(securityControlId()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "LastUpdateReason":
            return Optional.ofNullable(clazz.cast(lastUpdateReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityControlRequest, T> g) {
        return obj -> g.apply((UpdateSecurityControlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityHubRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSecurityControlRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) or ID of the control to update.
         * </p>
         * 
         * @param securityControlId
         *        The Amazon Resource Name (ARN) or ID of the control to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityControlId(String securityControlId);

        /**
         * <p>
         * An object that specifies which security control parameters to update.
         * </p>
         * 
         * @param parameters
         *        An object that specifies which security control parameters to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Map<String, ParameterConfiguration> parameters);

        /**
         * <p>
         * The most recent reason for updating the properties of the security control. This field accepts alphanumeric
         * characters in addition to white spaces, dashes, and underscores.
         * </p>
         * 
         * @param lastUpdateReason
         *        The most recent reason for updating the properties of the security control. This field accepts
         *        alphanumeric characters in addition to white spaces, dashes, and underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateReason(String lastUpdateReason);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityHubRequest.BuilderImpl implements Builder {
        private String securityControlId;

        private Map<String, ParameterConfiguration> parameters = DefaultSdkAutoConstructMap.getInstance();

        private String lastUpdateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityControlRequest model) {
            super(model);
            securityControlId(model.securityControlId);
            parameters(model.parameters);
            lastUpdateReason(model.lastUpdateReason);
        }

        public final String getSecurityControlId() {
            return securityControlId;
        }

        public final void setSecurityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
        }

        @Override
        public final Builder securityControlId(String securityControlId) {
            this.securityControlId = securityControlId;
            return this;
        }

        public final Map<String, ParameterConfiguration.Builder> getParameters() {
            Map<String, ParameterConfiguration.Builder> result = ParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, ParameterConfiguration.BuilderImpl> parameters) {
            this.parameters = ParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ParameterConfiguration> parameters) {
            this.parameters = ParametersCopier.copy(parameters);
            return this;
        }

        public final String getLastUpdateReason() {
            return lastUpdateReason;
        }

        public final void setLastUpdateReason(String lastUpdateReason) {
            this.lastUpdateReason = lastUpdateReason;
        }

        @Override
        public final Builder lastUpdateReason(String lastUpdateReason) {
            this.lastUpdateReason = lastUpdateReason;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSecurityControlRequest build() {
            return new UpdateSecurityControlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
