/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointEventBusesListCopier;
import software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointReplicationConfigDetails;
import software.amazon.awssdk.services.securityhub.model.AwsEventsEndpointRoutingConfigDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsEventsEndpointDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsEventsEndpointDetails> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::arn)).setter(AwsEventsEndpointDetails.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::description)).setter(AwsEventsEndpointDetails.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENDPOINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointId").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::endpointId)).setter(AwsEventsEndpointDetails.setter(Builder::endpointId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointId").build()}).build();
    private static final SdkField<String> ENDPOINT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointUrl").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::endpointUrl)).setter(AwsEventsEndpointDetails.setter(Builder::endpointUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointUrl").build()}).build();
    private static final SdkField<List<AwsEventsEndpointEventBusesDetails>> EVENT_BUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EventBuses").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::eventBuses)).setter(AwsEventsEndpointDetails.setter(Builder::eventBuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AwsEventsEndpointEventBusesDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::name)).setter(AwsEventsEndpointDetails.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<AwsEventsEndpointReplicationConfigDetails> REPLICATION_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicationConfig").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::replicationConfig)).setter(AwsEventsEndpointDetails.setter(Builder::replicationConfig)).constructor(AwsEventsEndpointReplicationConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicationConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::roleArn)).setter(AwsEventsEndpointDetails.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<AwsEventsEndpointRoutingConfigDetails> ROUTING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RoutingConfig").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::routingConfig)).setter(AwsEventsEndpointDetails.setter(Builder::routingConfig)).constructor(AwsEventsEndpointRoutingConfigDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoutingConfig").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::state)).setter(AwsEventsEndpointDetails.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StateReason").getter(AwsEventsEndpointDetails.getter(AwsEventsEndpointDetails::stateReason)).setter(AwsEventsEndpointDetails.setter(Builder::stateReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DESCRIPTION_FIELD, ENDPOINT_ID_FIELD, ENDPOINT_URL_FIELD, EVENT_BUSES_FIELD, NAME_FIELD, REPLICATION_CONFIG_FIELD, ROLE_ARN_FIELD, ROUTING_CONFIG_FIELD, STATE_FIELD, STATE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("EndpointId", ENDPOINT_ID_FIELD);
            this.put("EndpointUrl", ENDPOINT_URL_FIELD);
            this.put("EventBuses", EVENT_BUSES_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("ReplicationConfig", REPLICATION_CONFIG_FIELD);
            this.put("RoleArn", ROLE_ARN_FIELD);
            this.put("RoutingConfig", ROUTING_CONFIG_FIELD);
            this.put("State", STATE_FIELD);
            this.put("StateReason", STATE_REASON_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String description;
    private final String endpointId;
    private final String endpointUrl;
    private final List<AwsEventsEndpointEventBusesDetails> eventBuses;
    private final String name;
    private final AwsEventsEndpointReplicationConfigDetails replicationConfig;
    private final String roleArn;
    private final AwsEventsEndpointRoutingConfigDetails routingConfig;
    private final String state;
    private final String stateReason;

    private AwsEventsEndpointDetails(BuilderImpl builder) {
        this.arn = builder.arn;
        this.description = builder.description;
        this.endpointId = builder.endpointId;
        this.endpointUrl = builder.endpointUrl;
        this.eventBuses = builder.eventBuses;
        this.name = builder.name;
        this.replicationConfig = builder.replicationConfig;
        this.roleArn = builder.roleArn;
        this.routingConfig = builder.routingConfig;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
    }

    public final String arn() {
        return this.arn;
    }

    public final String description() {
        return this.description;
    }

    public final String endpointId() {
        return this.endpointId;
    }

    public final String endpointUrl() {
        return this.endpointUrl;
    }

    public final boolean hasEventBuses() {
        return this.eventBuses != null && !(this.eventBuses instanceof SdkAutoConstructList);
    }

    public final List<AwsEventsEndpointEventBusesDetails> eventBuses() {
        return this.eventBuses;
    }

    public final String name() {
        return this.name;
    }

    public final AwsEventsEndpointReplicationConfigDetails replicationConfig() {
        return this.replicationConfig;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final AwsEventsEndpointRoutingConfigDetails routingConfig() {
        return this.routingConfig;
    }

    public final String state() {
        return this.state;
    }

    public final String stateReason() {
        return this.stateReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointId());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventBuses() ? this.eventBuses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.routingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.state());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsEventsEndpointDetails)) {
            return false;
        }
        AwsEventsEndpointDetails other = (AwsEventsEndpointDetails)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.endpointId(), other.endpointId()) && Objects.equals(this.endpointUrl(), other.endpointUrl()) && this.hasEventBuses() == other.hasEventBuses() && Objects.equals(this.eventBuses(), other.eventBuses()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.replicationConfig(), other.replicationConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.routingConfig(), other.routingConfig()) && Objects.equals(this.state(), other.state()) && Objects.equals(this.stateReason(), other.stateReason());
    }

    public final String toString() {
        return ToString.builder((String)"AwsEventsEndpointDetails").add("Arn", (Object)this.arn()).add("Description", (Object)this.description()).add("EndpointId", (Object)this.endpointId()).add("EndpointUrl", (Object)this.endpointUrl()).add("EventBuses", this.hasEventBuses() ? this.eventBuses() : null).add("Name", (Object)this.name()).add("ReplicationConfig", (Object)this.replicationConfig()).add("RoleArn", (Object)this.roleArn()).add("RoutingConfig", (Object)this.routingConfig()).add("State", (Object)this.state()).add("StateReason", (Object)this.stateReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EndpointId": {
                return Optional.ofNullable(clazz.cast(this.endpointId()));
            }
            case "EndpointUrl": {
                return Optional.ofNullable(clazz.cast(this.endpointUrl()));
            }
            case "EventBuses": {
                return Optional.ofNullable(clazz.cast(this.eventBuses()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ReplicationConfig": {
                return Optional.ofNullable(clazz.cast(this.replicationConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "RoutingConfig": {
                return Optional.ofNullable(clazz.cast(this.routingConfig()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.state()));
            }
            case "StateReason": {
                return Optional.ofNullable(clazz.cast(this.stateReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AwsEventsEndpointDetails, T> g) {
        return obj -> g.apply((AwsEventsEndpointDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String description;
        private String endpointId;
        private String endpointUrl;
        private List<AwsEventsEndpointEventBusesDetails> eventBuses = DefaultSdkAutoConstructList.getInstance();
        private String name;
        private AwsEventsEndpointReplicationConfigDetails replicationConfig;
        private String roleArn;
        private AwsEventsEndpointRoutingConfigDetails routingConfig;
        private String state;
        private String stateReason;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsEventsEndpointDetails model) {
            this.arn(model.arn);
            this.description(model.description);
            this.endpointId(model.endpointId);
            this.endpointUrl(model.endpointUrl);
            this.eventBuses(model.eventBuses);
            this.name(model.name);
            this.replicationConfig(model.replicationConfig);
            this.roleArn(model.roleArn);
            this.routingConfig(model.routingConfig);
            this.state(model.state);
            this.stateReason(model.stateReason);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEndpointId() {
            return this.endpointId;
        }

        public final void setEndpointId(String endpointId) {
            this.endpointId = endpointId;
        }

        @Override
        public final Builder endpointId(String endpointId) {
            this.endpointId = endpointId;
            return this;
        }

        public final String getEndpointUrl() {
            return this.endpointUrl;
        }

        public final void setEndpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
        }

        @Override
        public final Builder endpointUrl(String endpointUrl) {
            this.endpointUrl = endpointUrl;
            return this;
        }

        public final List<AwsEventsEndpointEventBusesDetails.Builder> getEventBuses() {
            List<AwsEventsEndpointEventBusesDetails.Builder> result = AwsEventsEndpointEventBusesListCopier.copyToBuilder(this.eventBuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventBuses(Collection<AwsEventsEndpointEventBusesDetails.BuilderImpl> eventBuses) {
            this.eventBuses = AwsEventsEndpointEventBusesListCopier.copyFromBuilder(eventBuses);
        }

        @Override
        public final Builder eventBuses(Collection<AwsEventsEndpointEventBusesDetails> eventBuses) {
            this.eventBuses = AwsEventsEndpointEventBusesListCopier.copy(eventBuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(AwsEventsEndpointEventBusesDetails ... eventBuses) {
            this.eventBuses(Arrays.asList(eventBuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eventBuses(Consumer<AwsEventsEndpointEventBusesDetails.Builder> ... eventBuses) {
            this.eventBuses(Stream.of(eventBuses).map(c -> (AwsEventsEndpointEventBusesDetails)((AwsEventsEndpointEventBusesDetails.Builder)AwsEventsEndpointEventBusesDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AwsEventsEndpointReplicationConfigDetails.Builder getReplicationConfig() {
            return this.replicationConfig != null ? this.replicationConfig.toBuilder() : null;
        }

        public final void setReplicationConfig(AwsEventsEndpointReplicationConfigDetails.BuilderImpl replicationConfig) {
            this.replicationConfig = replicationConfig != null ? replicationConfig.build() : null;
        }

        @Override
        public final Builder replicationConfig(AwsEventsEndpointReplicationConfigDetails replicationConfig) {
            this.replicationConfig = replicationConfig;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final AwsEventsEndpointRoutingConfigDetails.Builder getRoutingConfig() {
            return this.routingConfig != null ? this.routingConfig.toBuilder() : null;
        }

        public final void setRoutingConfig(AwsEventsEndpointRoutingConfigDetails.BuilderImpl routingConfig) {
            this.routingConfig = routingConfig != null ? routingConfig.build() : null;
        }

        @Override
        public final Builder routingConfig(AwsEventsEndpointRoutingConfigDetails routingConfig) {
            this.routingConfig = routingConfig;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        public final String getStateReason() {
            return this.stateReason;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public AwsEventsEndpointDetails build() {
            return new AwsEventsEndpointDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsEventsEndpointDetails> {
        public Builder arn(String var1);

        public Builder description(String var1);

        public Builder endpointId(String var1);

        public Builder endpointUrl(String var1);

        public Builder eventBuses(Collection<AwsEventsEndpointEventBusesDetails> var1);

        public Builder eventBuses(AwsEventsEndpointEventBusesDetails ... var1);

        public Builder eventBuses(Consumer<AwsEventsEndpointEventBusesDetails.Builder> ... var1);

        public Builder name(String var1);

        public Builder replicationConfig(AwsEventsEndpointReplicationConfigDetails var1);

        default public Builder replicationConfig(Consumer<AwsEventsEndpointReplicationConfigDetails.Builder> replicationConfig) {
            return this.replicationConfig((AwsEventsEndpointReplicationConfigDetails)((AwsEventsEndpointReplicationConfigDetails.Builder)AwsEventsEndpointReplicationConfigDetails.builder().applyMutation(replicationConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder routingConfig(AwsEventsEndpointRoutingConfigDetails var1);

        default public Builder routingConfig(Consumer<AwsEventsEndpointRoutingConfigDetails.Builder> routingConfig) {
            return this.routingConfig((AwsEventsEndpointRoutingConfigDetails)((AwsEventsEndpointRoutingConfigDetails.Builder)AwsEventsEndpointRoutingConfigDetails.builder().applyMutation(routingConfig)).build());
        }

        public Builder state(String var1);

        public Builder stateReason(String var1);
    }
}

