/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.Policy;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConfigurationPolicyResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, UpdateConfigurationPolicyResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(UpdateConfigurationPolicyResponse.getter(UpdateConfigurationPolicyResponse::arn)).setter(UpdateConfigurationPolicyResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(UpdateConfigurationPolicyResponse.getter(UpdateConfigurationPolicyResponse::id)).setter(UpdateConfigurationPolicyResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(UpdateConfigurationPolicyResponse.getter(UpdateConfigurationPolicyResponse::name)).setter(UpdateConfigurationPolicyResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateConfigurationPolicyResponse.getter(UpdateConfigurationPolicyResponse::description)).setter(UpdateConfigurationPolicyResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(UpdateConfigurationPolicyResponse.getter(UpdateConfigurationPolicyResponse::updatedAt)).setter(UpdateConfigurationPolicyResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(UpdateConfigurationPolicyResponse.getter(UpdateConfigurationPolicyResponse::createdAt)).setter(UpdateConfigurationPolicyResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Policy> CONFIGURATION_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConfigurationPolicy").getter(UpdateConfigurationPolicyResponse.getter(UpdateConfigurationPolicyResponse::configurationPolicy)).setter(UpdateConfigurationPolicyResponse.setter(Builder::configurationPolicy)).constructor(Policy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigurationPolicy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, UPDATED_AT_FIELD, CREATED_AT_FIELD, CONFIGURATION_POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Arn", ARN_FIELD);
            this.put("Id", ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("UpdatedAt", UPDATED_AT_FIELD);
            this.put("CreatedAt", CREATED_AT_FIELD);
            this.put("ConfigurationPolicy", CONFIGURATION_POLICY_FIELD);
        }
    });
    private final String arn;
    private final String id;
    private final String name;
    private final String description;
    private final Instant updatedAt;
    private final Instant createdAt;
    private final Policy configurationPolicy;

    private UpdateConfigurationPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.updatedAt = builder.updatedAt;
        this.createdAt = builder.createdAt;
        this.configurationPolicy = builder.configurationPolicy;
    }

    public final String arn() {
        return this.arn;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Policy configurationPolicy() {
        return this.configurationPolicy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.configurationPolicy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConfigurationPolicyResponse)) {
            return false;
        }
        UpdateConfigurationPolicyResponse other = (UpdateConfigurationPolicyResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.configurationPolicy(), other.configurationPolicy());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConfigurationPolicyResponse").add("Arn", (Object)this.arn()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("UpdatedAt", (Object)this.updatedAt()).add("CreatedAt", (Object)this.createdAt()).add("ConfigurationPolicy", (Object)this.configurationPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "ConfigurationPolicy": {
                return Optional.ofNullable(clazz.cast(this.configurationPolicy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UpdateConfigurationPolicyResponse, T> g) {
        return obj -> g.apply((UpdateConfigurationPolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String id;
        private String name;
        private String description;
        private Instant updatedAt;
        private Instant createdAt;
        private Policy configurationPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConfigurationPolicyResponse model) {
            super(model);
            this.arn(model.arn);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.updatedAt(model.updatedAt);
            this.createdAt(model.createdAt);
            this.configurationPolicy(model.configurationPolicy);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Policy.Builder getConfigurationPolicy() {
            return this.configurationPolicy != null ? this.configurationPolicy.toBuilder() : null;
        }

        public final void setConfigurationPolicy(Policy.BuilderImpl configurationPolicy) {
            this.configurationPolicy = configurationPolicy != null ? configurationPolicy.build() : null;
        }

        @Override
        public final Builder configurationPolicy(Policy configurationPolicy) {
            this.configurationPolicy = configurationPolicy;
            return this;
        }

        @Override
        public UpdateConfigurationPolicyResponse build() {
            return new UpdateConfigurationPolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConfigurationPolicyResponse> {
        public Builder arn(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder updatedAt(Instant var1);

        public Builder createdAt(Instant var1);

        public Builder configurationPolicy(Policy var1);

        default public Builder configurationPolicy(Consumer<Policy.Builder> configurationPolicy) {
            return this.configurationPolicy((Policy)((Policy.Builder)Policy.builder().applyMutation(configurationPolicy)).build());
        }
    }
}

