/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.ResourcesFilters;
import software.amazon.awssdk.services.securityhub.model.SecurityHubRequest;
import software.amazon.awssdk.services.securityhub.model.SortCriteriaCopier;
import software.amazon.awssdk.services.securityhub.model.SortCriterion;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetResourcesV2Request
extends SecurityHubRequest
implements ToCopyableBuilder<Builder, GetResourcesV2Request> {
    private static final SdkField<ResourcesFilters> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Filters").getter(GetResourcesV2Request.getter(GetResourcesV2Request::filters)).setter(GetResourcesV2Request.setter(Builder::filters)).constructor(ResourcesFilters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build()}).build();
    private static final SdkField<List<SortCriterion>> SORT_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SortCriteria").getter(GetResourcesV2Request.getter(GetResourcesV2Request::sortCriteria)).setter(GetResourcesV2Request.setter(Builder::sortCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortCriteria").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SortCriterion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(GetResourcesV2Request.getter(GetResourcesV2Request::nextToken)).setter(GetResourcesV2Request.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(GetResourcesV2Request.getter(GetResourcesV2Request::maxResults)).setter(GetResourcesV2Request.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTERS_FIELD, SORT_CRITERIA_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetResourcesV2Request.memberNameToFieldInitializer();
    private final ResourcesFilters filters;
    private final List<SortCriterion> sortCriteria;
    private final String nextToken;
    private final Integer maxResults;

    private GetResourcesV2Request(BuilderImpl builder) {
        super(builder);
        this.filters = builder.filters;
        this.sortCriteria = builder.sortCriteria;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final ResourcesFilters filters() {
        return this.filters;
    }

    public final boolean hasSortCriteria() {
        return this.sortCriteria != null && !(this.sortCriteria instanceof SdkAutoConstructList);
    }

    public final List<SortCriterion> sortCriteria() {
        return this.sortCriteria;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSortCriteria() ? this.sortCriteria() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourcesV2Request)) {
            return false;
        }
        GetResourcesV2Request other = (GetResourcesV2Request)((Object)obj);
        return Objects.equals(this.filters(), other.filters()) && this.hasSortCriteria() == other.hasSortCriteria() && Objects.equals(this.sortCriteria(), other.sortCriteria()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetResourcesV2Request").add("Filters", (Object)this.filters()).add("SortCriteria", this.hasSortCriteria() ? this.sortCriteria() : null).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "SortCriteria": {
                return Optional.ofNullable(clazz.cast(this.sortCriteria()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Filters", FILTERS_FIELD);
        map.put("SortCriteria", SORT_CRITERIA_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourcesV2Request, T> g) {
        return obj -> g.apply((GetResourcesV2Request)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubRequest.BuilderImpl
    implements Builder {
        private ResourcesFilters filters;
        private List<SortCriterion> sortCriteria = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourcesV2Request model) {
            super(model);
            this.filters(model.filters);
            this.sortCriteria(model.sortCriteria);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final ResourcesFilters.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(ResourcesFilters.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(ResourcesFilters filters) {
            this.filters = filters;
            return this;
        }

        public final List<SortCriterion.Builder> getSortCriteria() {
            List<SortCriterion.Builder> result = SortCriteriaCopier.copyToBuilder(this.sortCriteria);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortCriteria(Collection<SortCriterion.BuilderImpl> sortCriteria) {
            this.sortCriteria = SortCriteriaCopier.copyFromBuilder(sortCriteria);
        }

        @Override
        public final Builder sortCriteria(Collection<SortCriterion> sortCriteria) {
            this.sortCriteria = SortCriteriaCopier.copy(sortCriteria);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(SortCriterion ... sortCriteria) {
            this.sortCriteria(Arrays.asList(sortCriteria));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortCriteria(Consumer<SortCriterion.Builder> ... sortCriteria) {
            this.sortCriteria(Stream.of(sortCriteria).map(c -> (SortCriterion)((SortCriterion.Builder)SortCriterion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourcesV2Request build() {
            return new GetResourcesV2Request(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetResourcesV2Request> {
        public Builder filters(ResourcesFilters var1);

        default public Builder filters(Consumer<ResourcesFilters.Builder> filters) {
            return this.filters((ResourcesFilters)((ResourcesFilters.Builder)ResourcesFilters.builder().applyMutation(filters)).build());
        }

        public Builder sortCriteria(Collection<SortCriterion> var1);

        public Builder sortCriteria(SortCriterion ... var1);

        public Builder sortCriteria(Consumer<SortCriterion.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

