/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AllowedOperators;
import software.amazon.awssdk.services.securityhub.model.ResourcesDateFilter;
import software.amazon.awssdk.services.securityhub.model.ResourcesDateFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.ResourcesMapFilter;
import software.amazon.awssdk.services.securityhub.model.ResourcesMapFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.ResourcesNumberFilter;
import software.amazon.awssdk.services.securityhub.model.ResourcesNumberFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.ResourcesStringFilter;
import software.amazon.awssdk.services.securityhub.model.ResourcesStringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourcesCompositeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourcesCompositeFilter> {
    private static final SdkField<List<ResourcesStringFilter>> STRING_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringFilters").getter(ResourcesCompositeFilter.getter(ResourcesCompositeFilter::stringFilters)).setter(ResourcesCompositeFilter.setter(Builder::stringFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcesStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourcesDateFilter>> DATE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DateFilters").getter(ResourcesCompositeFilter.getter(ResourcesCompositeFilter::dateFilters)).setter(ResourcesCompositeFilter.setter(Builder::dateFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcesDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourcesNumberFilter>> NUMBER_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NumberFilters").getter(ResourcesCompositeFilter.getter(ResourcesCompositeFilter::numberFilters)).setter(ResourcesCompositeFilter.setter(Builder::numberFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcesNumberFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourcesMapFilter>> MAP_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MapFilters").getter(ResourcesCompositeFilter.getter(ResourcesCompositeFilter::mapFilters)).setter(ResourcesCompositeFilter.setter(Builder::mapFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourcesMapFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(ResourcesCompositeFilter.getter(ResourcesCompositeFilter::operatorAsString)).setter(ResourcesCompositeFilter.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_FILTERS_FIELD, DATE_FILTERS_FIELD, NUMBER_FILTERS_FIELD, MAP_FILTERS_FIELD, OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourcesCompositeFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<ResourcesStringFilter> stringFilters;
    private final List<ResourcesDateFilter> dateFilters;
    private final List<ResourcesNumberFilter> numberFilters;
    private final List<ResourcesMapFilter> mapFilters;
    private final String operator;

    private ResourcesCompositeFilter(BuilderImpl builder) {
        this.stringFilters = builder.stringFilters;
        this.dateFilters = builder.dateFilters;
        this.numberFilters = builder.numberFilters;
        this.mapFilters = builder.mapFilters;
        this.operator = builder.operator;
    }

    public final boolean hasStringFilters() {
        return this.stringFilters != null && !(this.stringFilters instanceof SdkAutoConstructList);
    }

    public final List<ResourcesStringFilter> stringFilters() {
        return this.stringFilters;
    }

    public final boolean hasDateFilters() {
        return this.dateFilters != null && !(this.dateFilters instanceof SdkAutoConstructList);
    }

    public final List<ResourcesDateFilter> dateFilters() {
        return this.dateFilters;
    }

    public final boolean hasNumberFilters() {
        return this.numberFilters != null && !(this.numberFilters instanceof SdkAutoConstructList);
    }

    public final List<ResourcesNumberFilter> numberFilters() {
        return this.numberFilters;
    }

    public final boolean hasMapFilters() {
        return this.mapFilters != null && !(this.mapFilters instanceof SdkAutoConstructList);
    }

    public final List<ResourcesMapFilter> mapFilters() {
        return this.mapFilters;
    }

    public final AllowedOperators operator() {
        return AllowedOperators.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringFilters() ? this.stringFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDateFilters() ? this.dateFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNumberFilters() ? this.numberFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapFilters() ? this.mapFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourcesCompositeFilter)) {
            return false;
        }
        ResourcesCompositeFilter other = (ResourcesCompositeFilter)obj;
        return this.hasStringFilters() == other.hasStringFilters() && Objects.equals(this.stringFilters(), other.stringFilters()) && this.hasDateFilters() == other.hasDateFilters() && Objects.equals(this.dateFilters(), other.dateFilters()) && this.hasNumberFilters() == other.hasNumberFilters() && Objects.equals(this.numberFilters(), other.numberFilters()) && this.hasMapFilters() == other.hasMapFilters() && Objects.equals(this.mapFilters(), other.mapFilters()) && Objects.equals(this.operatorAsString(), other.operatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ResourcesCompositeFilter").add("StringFilters", this.hasStringFilters() ? this.stringFilters() : null).add("DateFilters", this.hasDateFilters() ? this.dateFilters() : null).add("NumberFilters", this.hasNumberFilters() ? this.numberFilters() : null).add("MapFilters", this.hasMapFilters() ? this.mapFilters() : null).add("Operator", (Object)this.operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringFilters": {
                return Optional.ofNullable(clazz.cast(this.stringFilters()));
            }
            case "DateFilters": {
                return Optional.ofNullable(clazz.cast(this.dateFilters()));
            }
            case "NumberFilters": {
                return Optional.ofNullable(clazz.cast(this.numberFilters()));
            }
            case "MapFilters": {
                return Optional.ofNullable(clazz.cast(this.mapFilters()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StringFilters", STRING_FILTERS_FIELD);
        map.put("DateFilters", DATE_FILTERS_FIELD);
        map.put("NumberFilters", NUMBER_FILTERS_FIELD);
        map.put("MapFilters", MAP_FILTERS_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourcesCompositeFilter, T> g) {
        return obj -> g.apply((ResourcesCompositeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<ResourcesStringFilter> stringFilters = DefaultSdkAutoConstructList.getInstance();
        private List<ResourcesDateFilter> dateFilters = DefaultSdkAutoConstructList.getInstance();
        private List<ResourcesNumberFilter> numberFilters = DefaultSdkAutoConstructList.getInstance();
        private List<ResourcesMapFilter> mapFilters = DefaultSdkAutoConstructList.getInstance();
        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourcesCompositeFilter model) {
            this.stringFilters(model.stringFilters);
            this.dateFilters(model.dateFilters);
            this.numberFilters(model.numberFilters);
            this.mapFilters(model.mapFilters);
            this.operator(model.operator);
        }

        public final List<ResourcesStringFilter.Builder> getStringFilters() {
            List<ResourcesStringFilter.Builder> result = ResourcesStringFilterListCopier.copyToBuilder(this.stringFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringFilters(Collection<ResourcesStringFilter.BuilderImpl> stringFilters) {
            this.stringFilters = ResourcesStringFilterListCopier.copyFromBuilder(stringFilters);
        }

        @Override
        public final Builder stringFilters(Collection<ResourcesStringFilter> stringFilters) {
            this.stringFilters = ResourcesStringFilterListCopier.copy(stringFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(ResourcesStringFilter ... stringFilters) {
            this.stringFilters(Arrays.asList(stringFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(Consumer<ResourcesStringFilter.Builder> ... stringFilters) {
            this.stringFilters(Stream.of(stringFilters).map(c -> (ResourcesStringFilter)((ResourcesStringFilter.Builder)ResourcesStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcesDateFilter.Builder> getDateFilters() {
            List<ResourcesDateFilter.Builder> result = ResourcesDateFilterListCopier.copyToBuilder(this.dateFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDateFilters(Collection<ResourcesDateFilter.BuilderImpl> dateFilters) {
            this.dateFilters = ResourcesDateFilterListCopier.copyFromBuilder(dateFilters);
        }

        @Override
        public final Builder dateFilters(Collection<ResourcesDateFilter> dateFilters) {
            this.dateFilters = ResourcesDateFilterListCopier.copy(dateFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateFilters(ResourcesDateFilter ... dateFilters) {
            this.dateFilters(Arrays.asList(dateFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateFilters(Consumer<ResourcesDateFilter.Builder> ... dateFilters) {
            this.dateFilters(Stream.of(dateFilters).map(c -> (ResourcesDateFilter)((ResourcesDateFilter.Builder)ResourcesDateFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcesNumberFilter.Builder> getNumberFilters() {
            List<ResourcesNumberFilter.Builder> result = ResourcesNumberFilterListCopier.copyToBuilder(this.numberFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNumberFilters(Collection<ResourcesNumberFilter.BuilderImpl> numberFilters) {
            this.numberFilters = ResourcesNumberFilterListCopier.copyFromBuilder(numberFilters);
        }

        @Override
        public final Builder numberFilters(Collection<ResourcesNumberFilter> numberFilters) {
            this.numberFilters = ResourcesNumberFilterListCopier.copy(numberFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberFilters(ResourcesNumberFilter ... numberFilters) {
            this.numberFilters(Arrays.asList(numberFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberFilters(Consumer<ResourcesNumberFilter.Builder> ... numberFilters) {
            this.numberFilters(Stream.of(numberFilters).map(c -> (ResourcesNumberFilter)((ResourcesNumberFilter.Builder)ResourcesNumberFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcesMapFilter.Builder> getMapFilters() {
            List<ResourcesMapFilter.Builder> result = ResourcesMapFilterListCopier.copyToBuilder(this.mapFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapFilters(Collection<ResourcesMapFilter.BuilderImpl> mapFilters) {
            this.mapFilters = ResourcesMapFilterListCopier.copyFromBuilder(mapFilters);
        }

        @Override
        public final Builder mapFilters(Collection<ResourcesMapFilter> mapFilters) {
            this.mapFilters = ResourcesMapFilterListCopier.copy(mapFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapFilters(ResourcesMapFilter ... mapFilters) {
            this.mapFilters(Arrays.asList(mapFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapFilters(Consumer<ResourcesMapFilter.Builder> ... mapFilters) {
            this.mapFilters(Stream.of(mapFilters).map(c -> (ResourcesMapFilter)((ResourcesMapFilter.Builder)ResourcesMapFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(AllowedOperators operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public ResourcesCompositeFilter build() {
            return new ResourcesCompositeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourcesCompositeFilter> {
        public Builder stringFilters(Collection<ResourcesStringFilter> var1);

        public Builder stringFilters(ResourcesStringFilter ... var1);

        public Builder stringFilters(Consumer<ResourcesStringFilter.Builder> ... var1);

        public Builder dateFilters(Collection<ResourcesDateFilter> var1);

        public Builder dateFilters(ResourcesDateFilter ... var1);

        public Builder dateFilters(Consumer<ResourcesDateFilter.Builder> ... var1);

        public Builder numberFilters(Collection<ResourcesNumberFilter> var1);

        public Builder numberFilters(ResourcesNumberFilter ... var1);

        public Builder numberFilters(Consumer<ResourcesNumberFilter.Builder> ... var1);

        public Builder mapFilters(Collection<ResourcesMapFilter> var1);

        public Builder mapFilters(ResourcesMapFilter ... var1);

        public Builder mapFilters(Consumer<ResourcesMapFilter.Builder> ... var1);

        public Builder operator(String var1);

        public Builder operator(AllowedOperators var1);
    }
}

