/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTicketV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, CreateTicketV2Response> {
    private static final SdkField<String> TICKET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TicketId").getter(CreateTicketV2Response.getter(CreateTicketV2Response::ticketId)).setter(CreateTicketV2Response.setter(Builder::ticketId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketId").build()}).build();
    private static final SdkField<String> TICKET_SRC_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TicketSrcUrl").getter(CreateTicketV2Response.getter(CreateTicketV2Response::ticketSrcUrl)).setter(CreateTicketV2Response.setter(Builder::ticketSrcUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TicketSrcUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TICKET_ID_FIELD, TICKET_SRC_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTicketV2Response.memberNameToFieldInitializer();
    private final String ticketId;
    private final String ticketSrcUrl;

    private CreateTicketV2Response(BuilderImpl builder) {
        super(builder);
        this.ticketId = builder.ticketId;
        this.ticketSrcUrl = builder.ticketSrcUrl;
    }

    public final String ticketId() {
        return this.ticketId;
    }

    public final String ticketSrcUrl() {
        return this.ticketSrcUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ticketId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ticketSrcUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTicketV2Response)) {
            return false;
        }
        CreateTicketV2Response other = (CreateTicketV2Response)((Object)obj);
        return Objects.equals(this.ticketId(), other.ticketId()) && Objects.equals(this.ticketSrcUrl(), other.ticketSrcUrl());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTicketV2Response").add("TicketId", (Object)this.ticketId()).add("TicketSrcUrl", (Object)this.ticketSrcUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TicketId": {
                return Optional.ofNullable(clazz.cast(this.ticketId()));
            }
            case "TicketSrcUrl": {
                return Optional.ofNullable(clazz.cast(this.ticketSrcUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TicketId", TICKET_ID_FIELD);
        map.put("TicketSrcUrl", TICKET_SRC_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTicketV2Response, T> g) {
        return obj -> g.apply((CreateTicketV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String ticketId;
        private String ticketSrcUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTicketV2Response model) {
            super(model);
            this.ticketId(model.ticketId);
            this.ticketSrcUrl(model.ticketSrcUrl);
        }

        public final String getTicketId() {
            return this.ticketId;
        }

        public final void setTicketId(String ticketId) {
            this.ticketId = ticketId;
        }

        @Override
        public final Builder ticketId(String ticketId) {
            this.ticketId = ticketId;
            return this;
        }

        public final String getTicketSrcUrl() {
            return this.ticketSrcUrl;
        }

        public final void setTicketSrcUrl(String ticketSrcUrl) {
            this.ticketSrcUrl = ticketSrcUrl;
        }

        @Override
        public final Builder ticketSrcUrl(String ticketSrcUrl) {
            this.ticketSrcUrl = ticketSrcUrl;
            return this;
        }

        @Override
        public CreateTicketV2Response build() {
            return new CreateTicketV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTicketV2Response> {
        public Builder ticketId(String var1);

        public Builder ticketSrcUrl(String var1);
    }
}

