/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourcesMapField {
    TAGS("tags"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourcesMapField> VALUE_MAP;
    private final String value;

    private ResourcesMapField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourcesMapField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourcesMapField> knownValues() {
        EnumSet<ResourcesMapField> knownValues = EnumSet.allOf(ResourcesMapField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourcesMapField.class, ResourcesMapField::toString);
    }
}

