/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourcesStringField {
    RESOURCE_ARN("resource_arn"),
    RESOURCE_ID("resource_id"),
    ACCOUNT_ID("account_id"),
    REGION("region"),
    RESOURCE_CATEGORY("resource_category"),
    RESOURCE_TYPE("resource_type"),
    RESOURCE_NAME("resource_name"),
    FINDINGS_SUMMARY_FINDING_TYPE("findings_summary.finding_type"),
    FINDINGS_SUMMARY_PRODUCT_NAME("findings_summary.product_name"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourcesStringField> VALUE_MAP;
    private final String value;

    private ResourcesStringField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourcesStringField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourcesStringField> knownValues() {
        EnumSet<ResourcesStringField> knownValues = EnumSet.allOf(ResourcesStringField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourcesStringField.class, ResourcesStringField::toString);
    }
}

