/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.GroupByResult;
import software.amazon.awssdk.services.securityhub.model.GroupByResultsCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingStatisticsV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetFindingStatisticsV2Response> {
    private static final SdkField<List<GroupByResult>> GROUP_BY_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("GroupByResults").getter(GetFindingStatisticsV2Response.getter(GetFindingStatisticsV2Response::groupByResults)).setter(GetFindingStatisticsV2Response.setter(Builder::groupByResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupByResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GroupByResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GROUP_BY_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetFindingStatisticsV2Response.memberNameToFieldInitializer();
    private final List<GroupByResult> groupByResults;

    private GetFindingStatisticsV2Response(BuilderImpl builder) {
        super(builder);
        this.groupByResults = builder.groupByResults;
    }

    public final boolean hasGroupByResults() {
        return this.groupByResults != null && !(this.groupByResults instanceof SdkAutoConstructList);
    }

    public final List<GroupByResult> groupByResults() {
        return this.groupByResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGroupByResults() ? this.groupByResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingStatisticsV2Response)) {
            return false;
        }
        GetFindingStatisticsV2Response other = (GetFindingStatisticsV2Response)((Object)obj);
        return this.hasGroupByResults() == other.hasGroupByResults() && Objects.equals(this.groupByResults(), other.groupByResults());
    }

    public final String toString() {
        return ToString.builder((String)"GetFindingStatisticsV2Response").add("GroupByResults", this.hasGroupByResults() ? this.groupByResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GroupByResults": {
                return Optional.ofNullable(clazz.cast(this.groupByResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<GroupByResult>>> map = new HashMap<String, SdkField<List<GroupByResult>>>();
        map.put("GroupByResults", GROUP_BY_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetFindingStatisticsV2Response, T> g) {
        return obj -> g.apply((GetFindingStatisticsV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<GroupByResult> groupByResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingStatisticsV2Response model) {
            super(model);
            this.groupByResults(model.groupByResults);
        }

        public final List<GroupByResult.Builder> getGroupByResults() {
            List<GroupByResult.Builder> result = GroupByResultsCopier.copyToBuilder(this.groupByResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGroupByResults(Collection<GroupByResult.BuilderImpl> groupByResults) {
            this.groupByResults = GroupByResultsCopier.copyFromBuilder(groupByResults);
        }

        @Override
        public final Builder groupByResults(Collection<GroupByResult> groupByResults) {
            this.groupByResults = GroupByResultsCopier.copy(groupByResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByResults(GroupByResult ... groupByResults) {
            this.groupByResults(Arrays.asList(groupByResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByResults(Consumer<GroupByResult.Builder> ... groupByResults) {
            this.groupByResults(Stream.of(groupByResults).map(c -> (GroupByResult)((GroupByResult.Builder)GroupByResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetFindingStatisticsV2Response build() {
            return new GetFindingStatisticsV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingStatisticsV2Response> {
        public Builder groupByResults(Collection<GroupByResult> var1);

        public Builder groupByResults(GroupByResult ... var1);

        public Builder groupByResults(Consumer<GroupByResult.Builder> ... var1);
    }
}

