/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum OcsfNumberField {
    ACTIVITY_ID("activity_id"),
    COMPLIANCE_STATUS_ID("compliance.status_id"),
    CONFIDENCE_SCORE("confidence_score"),
    SEVERITY_ID("severity_id"),
    STATUS_ID("status_id"),
    FINDING_INFO_RELATED_EVENTS_COUNT("finding_info.related_events_count"),
    EVIDENCES_API_RESPONSE_CODE("evidences.api.response.code"),
    EVIDENCES_DST_ENDPOINT_AUTONOMOUS_SYSTEM_NUMBER("evidences.dst_endpoint.autonomous_system.number"),
    EVIDENCES_DST_ENDPOINT_PORT("evidences.dst_endpoint.port"),
    EVIDENCES_SRC_ENDPOINT_AUTONOMOUS_SYSTEM_NUMBER("evidences.src_endpoint.autonomous_system.number"),
    EVIDENCES_SRC_ENDPOINT_PORT("evidences.src_endpoint.port"),
    RESOURCES_IMAGE_IN_USE_COUNT("resources.image.in_use_count"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, OcsfNumberField> VALUE_MAP;
    private final String value;

    private OcsfNumberField(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static OcsfNumberField fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<OcsfNumberField> knownValues() {
        EnumSet<OcsfNumberField> knownValues = EnumSet.allOf(OcsfNumberField.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(OcsfNumberField.class, OcsfNumberField::toString);
    }
}

