/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AllowedOperators {
    AND("AND"),
    OR("OR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AllowedOperators> VALUE_MAP;
    private final String value;

    private AllowedOperators(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AllowedOperators fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AllowedOperators> knownValues() {
        EnumSet<AllowedOperators> knownValues = EnumSet.allOf(AllowedOperators.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AllowedOperators.class, AllowedOperators::toString);
    }
}

