/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AllowedOperators;
import software.amazon.awssdk.services.securityhub.model.CompositeFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.OcsfBooleanFilter;
import software.amazon.awssdk.services.securityhub.model.OcsfBooleanFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.OcsfDateFilter;
import software.amazon.awssdk.services.securityhub.model.OcsfDateFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.OcsfIpFilter;
import software.amazon.awssdk.services.securityhub.model.OcsfIpFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.OcsfMapFilter;
import software.amazon.awssdk.services.securityhub.model.OcsfMapFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.OcsfNumberFilter;
import software.amazon.awssdk.services.securityhub.model.OcsfNumberFilterListCopier;
import software.amazon.awssdk.services.securityhub.model.OcsfStringFilter;
import software.amazon.awssdk.services.securityhub.model.OcsfStringFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CompositeFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CompositeFilter> {
    private static final SdkField<List<OcsfStringFilter>> STRING_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("StringFilters").getter(CompositeFilter.getter(CompositeFilter::stringFilters)).setter(CompositeFilter.setter(Builder::stringFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StringFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OcsfStringFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OcsfDateFilter>> DATE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DateFilters").getter(CompositeFilter.getter(CompositeFilter::dateFilters)).setter(CompositeFilter.setter(Builder::dateFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OcsfDateFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OcsfBooleanFilter>> BOOLEAN_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("BooleanFilters").getter(CompositeFilter.getter(CompositeFilter::booleanFilters)).setter(CompositeFilter.setter(Builder::booleanFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BooleanFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OcsfBooleanFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OcsfNumberFilter>> NUMBER_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NumberFilters").getter(CompositeFilter.getter(CompositeFilter::numberFilters)).setter(CompositeFilter.setter(Builder::numberFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OcsfNumberFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OcsfMapFilter>> MAP_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MapFilters").getter(CompositeFilter.getter(CompositeFilter::mapFilters)).setter(CompositeFilter.setter(Builder::mapFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MapFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OcsfMapFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OcsfIpFilter>> IP_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IpFilters").getter(CompositeFilter.getter(CompositeFilter::ipFilters)).setter(CompositeFilter.setter(Builder::ipFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OcsfIpFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CompositeFilter>> NESTED_COMPOSITE_FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NestedCompositeFilters").getter(CompositeFilter.getter(CompositeFilter::nestedCompositeFilters)).setter(CompositeFilter.setter(Builder::nestedCompositeFilters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NestedCompositeFilters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CompositeFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Operator").getter(CompositeFilter.getter(CompositeFilter::operatorAsString)).setter(CompositeFilter.setter(Builder::operator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRING_FILTERS_FIELD, DATE_FILTERS_FIELD, BOOLEAN_FILTERS_FIELD, NUMBER_FILTERS_FIELD, MAP_FILTERS_FIELD, IP_FILTERS_FIELD, NESTED_COMPOSITE_FILTERS_FIELD, OPERATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CompositeFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<OcsfStringFilter> stringFilters;
    private final List<OcsfDateFilter> dateFilters;
    private final List<OcsfBooleanFilter> booleanFilters;
    private final List<OcsfNumberFilter> numberFilters;
    private final List<OcsfMapFilter> mapFilters;
    private final List<OcsfIpFilter> ipFilters;
    private final List<CompositeFilter> nestedCompositeFilters;
    private final String operator;

    private CompositeFilter(BuilderImpl builder) {
        this.stringFilters = builder.stringFilters;
        this.dateFilters = builder.dateFilters;
        this.booleanFilters = builder.booleanFilters;
        this.numberFilters = builder.numberFilters;
        this.mapFilters = builder.mapFilters;
        this.ipFilters = builder.ipFilters;
        this.nestedCompositeFilters = builder.nestedCompositeFilters;
        this.operator = builder.operator;
    }

    public final boolean hasStringFilters() {
        return this.stringFilters != null && !(this.stringFilters instanceof SdkAutoConstructList);
    }

    public final List<OcsfStringFilter> stringFilters() {
        return this.stringFilters;
    }

    public final boolean hasDateFilters() {
        return this.dateFilters != null && !(this.dateFilters instanceof SdkAutoConstructList);
    }

    public final List<OcsfDateFilter> dateFilters() {
        return this.dateFilters;
    }

    public final boolean hasBooleanFilters() {
        return this.booleanFilters != null && !(this.booleanFilters instanceof SdkAutoConstructList);
    }

    public final List<OcsfBooleanFilter> booleanFilters() {
        return this.booleanFilters;
    }

    public final boolean hasNumberFilters() {
        return this.numberFilters != null && !(this.numberFilters instanceof SdkAutoConstructList);
    }

    public final List<OcsfNumberFilter> numberFilters() {
        return this.numberFilters;
    }

    public final boolean hasMapFilters() {
        return this.mapFilters != null && !(this.mapFilters instanceof SdkAutoConstructList);
    }

    public final List<OcsfMapFilter> mapFilters() {
        return this.mapFilters;
    }

    public final boolean hasIpFilters() {
        return this.ipFilters != null && !(this.ipFilters instanceof SdkAutoConstructList);
    }

    public final List<OcsfIpFilter> ipFilters() {
        return this.ipFilters;
    }

    public final boolean hasNestedCompositeFilters() {
        return this.nestedCompositeFilters != null && !(this.nestedCompositeFilters instanceof SdkAutoConstructList);
    }

    public final List<CompositeFilter> nestedCompositeFilters() {
        return this.nestedCompositeFilters;
    }

    public final AllowedOperators operator() {
        return AllowedOperators.fromValue(this.operator);
    }

    public final String operatorAsString() {
        return this.operator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStringFilters() ? this.stringFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDateFilters() ? this.dateFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBooleanFilters() ? this.booleanFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNumberFilters() ? this.numberFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMapFilters() ? this.mapFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIpFilters() ? this.ipFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNestedCompositeFilters() ? this.nestedCompositeFilters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.operatorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompositeFilter)) {
            return false;
        }
        CompositeFilter other = (CompositeFilter)obj;
        return this.hasStringFilters() == other.hasStringFilters() && Objects.equals(this.stringFilters(), other.stringFilters()) && this.hasDateFilters() == other.hasDateFilters() && Objects.equals(this.dateFilters(), other.dateFilters()) && this.hasBooleanFilters() == other.hasBooleanFilters() && Objects.equals(this.booleanFilters(), other.booleanFilters()) && this.hasNumberFilters() == other.hasNumberFilters() && Objects.equals(this.numberFilters(), other.numberFilters()) && this.hasMapFilters() == other.hasMapFilters() && Objects.equals(this.mapFilters(), other.mapFilters()) && this.hasIpFilters() == other.hasIpFilters() && Objects.equals(this.ipFilters(), other.ipFilters()) && this.hasNestedCompositeFilters() == other.hasNestedCompositeFilters() && Objects.equals(this.nestedCompositeFilters(), other.nestedCompositeFilters()) && Objects.equals(this.operatorAsString(), other.operatorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CompositeFilter").add("StringFilters", this.hasStringFilters() ? this.stringFilters() : null).add("DateFilters", this.hasDateFilters() ? this.dateFilters() : null).add("BooleanFilters", this.hasBooleanFilters() ? this.booleanFilters() : null).add("NumberFilters", this.hasNumberFilters() ? this.numberFilters() : null).add("MapFilters", this.hasMapFilters() ? this.mapFilters() : null).add("IpFilters", this.hasIpFilters() ? this.ipFilters() : null).add("NestedCompositeFilters", this.hasNestedCompositeFilters() ? this.nestedCompositeFilters() : null).add("Operator", (Object)this.operatorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "StringFilters": {
                return Optional.ofNullable(clazz.cast(this.stringFilters()));
            }
            case "DateFilters": {
                return Optional.ofNullable(clazz.cast(this.dateFilters()));
            }
            case "BooleanFilters": {
                return Optional.ofNullable(clazz.cast(this.booleanFilters()));
            }
            case "NumberFilters": {
                return Optional.ofNullable(clazz.cast(this.numberFilters()));
            }
            case "MapFilters": {
                return Optional.ofNullable(clazz.cast(this.mapFilters()));
            }
            case "IpFilters": {
                return Optional.ofNullable(clazz.cast(this.ipFilters()));
            }
            case "NestedCompositeFilters": {
                return Optional.ofNullable(clazz.cast(this.nestedCompositeFilters()));
            }
            case "Operator": {
                return Optional.ofNullable(clazz.cast(this.operatorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("StringFilters", STRING_FILTERS_FIELD);
        map.put("DateFilters", DATE_FILTERS_FIELD);
        map.put("BooleanFilters", BOOLEAN_FILTERS_FIELD);
        map.put("NumberFilters", NUMBER_FILTERS_FIELD);
        map.put("MapFilters", MAP_FILTERS_FIELD);
        map.put("IpFilters", IP_FILTERS_FIELD);
        map.put("NestedCompositeFilters", NESTED_COMPOSITE_FILTERS_FIELD);
        map.put("Operator", OPERATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompositeFilter, T> g) {
        return obj -> g.apply((CompositeFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<OcsfStringFilter> stringFilters = DefaultSdkAutoConstructList.getInstance();
        private List<OcsfDateFilter> dateFilters = DefaultSdkAutoConstructList.getInstance();
        private List<OcsfBooleanFilter> booleanFilters = DefaultSdkAutoConstructList.getInstance();
        private List<OcsfNumberFilter> numberFilters = DefaultSdkAutoConstructList.getInstance();
        private List<OcsfMapFilter> mapFilters = DefaultSdkAutoConstructList.getInstance();
        private List<OcsfIpFilter> ipFilters = DefaultSdkAutoConstructList.getInstance();
        private List<CompositeFilter> nestedCompositeFilters = DefaultSdkAutoConstructList.getInstance();
        private String operator;

        private BuilderImpl() {
        }

        private BuilderImpl(CompositeFilter model) {
            this.stringFilters(model.stringFilters);
            this.dateFilters(model.dateFilters);
            this.booleanFilters(model.booleanFilters);
            this.numberFilters(model.numberFilters);
            this.mapFilters(model.mapFilters);
            this.ipFilters(model.ipFilters);
            this.nestedCompositeFilters(model.nestedCompositeFilters);
            this.operator(model.operator);
        }

        public final List<OcsfStringFilter.Builder> getStringFilters() {
            List<OcsfStringFilter.Builder> result = OcsfStringFilterListCopier.copyToBuilder(this.stringFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStringFilters(Collection<OcsfStringFilter.BuilderImpl> stringFilters) {
            this.stringFilters = OcsfStringFilterListCopier.copyFromBuilder(stringFilters);
        }

        @Override
        public final Builder stringFilters(Collection<OcsfStringFilter> stringFilters) {
            this.stringFilters = OcsfStringFilterListCopier.copy(stringFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(OcsfStringFilter ... stringFilters) {
            this.stringFilters(Arrays.asList(stringFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stringFilters(Consumer<OcsfStringFilter.Builder> ... stringFilters) {
            this.stringFilters(Stream.of(stringFilters).map(c -> (OcsfStringFilter)((OcsfStringFilter.Builder)OcsfStringFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OcsfDateFilter.Builder> getDateFilters() {
            List<OcsfDateFilter.Builder> result = OcsfDateFilterListCopier.copyToBuilder(this.dateFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDateFilters(Collection<OcsfDateFilter.BuilderImpl> dateFilters) {
            this.dateFilters = OcsfDateFilterListCopier.copyFromBuilder(dateFilters);
        }

        @Override
        public final Builder dateFilters(Collection<OcsfDateFilter> dateFilters) {
            this.dateFilters = OcsfDateFilterListCopier.copy(dateFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateFilters(OcsfDateFilter ... dateFilters) {
            this.dateFilters(Arrays.asList(dateFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dateFilters(Consumer<OcsfDateFilter.Builder> ... dateFilters) {
            this.dateFilters(Stream.of(dateFilters).map(c -> (OcsfDateFilter)((OcsfDateFilter.Builder)OcsfDateFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OcsfBooleanFilter.Builder> getBooleanFilters() {
            List<OcsfBooleanFilter.Builder> result = OcsfBooleanFilterListCopier.copyToBuilder(this.booleanFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBooleanFilters(Collection<OcsfBooleanFilter.BuilderImpl> booleanFilters) {
            this.booleanFilters = OcsfBooleanFilterListCopier.copyFromBuilder(booleanFilters);
        }

        @Override
        public final Builder booleanFilters(Collection<OcsfBooleanFilter> booleanFilters) {
            this.booleanFilters = OcsfBooleanFilterListCopier.copy(booleanFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder booleanFilters(OcsfBooleanFilter ... booleanFilters) {
            this.booleanFilters(Arrays.asList(booleanFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder booleanFilters(Consumer<OcsfBooleanFilter.Builder> ... booleanFilters) {
            this.booleanFilters(Stream.of(booleanFilters).map(c -> (OcsfBooleanFilter)((OcsfBooleanFilter.Builder)OcsfBooleanFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OcsfNumberFilter.Builder> getNumberFilters() {
            List<OcsfNumberFilter.Builder> result = OcsfNumberFilterListCopier.copyToBuilder(this.numberFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNumberFilters(Collection<OcsfNumberFilter.BuilderImpl> numberFilters) {
            this.numberFilters = OcsfNumberFilterListCopier.copyFromBuilder(numberFilters);
        }

        @Override
        public final Builder numberFilters(Collection<OcsfNumberFilter> numberFilters) {
            this.numberFilters = OcsfNumberFilterListCopier.copy(numberFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberFilters(OcsfNumberFilter ... numberFilters) {
            this.numberFilters(Arrays.asList(numberFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder numberFilters(Consumer<OcsfNumberFilter.Builder> ... numberFilters) {
            this.numberFilters(Stream.of(numberFilters).map(c -> (OcsfNumberFilter)((OcsfNumberFilter.Builder)OcsfNumberFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OcsfMapFilter.Builder> getMapFilters() {
            List<OcsfMapFilter.Builder> result = OcsfMapFilterListCopier.copyToBuilder(this.mapFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMapFilters(Collection<OcsfMapFilter.BuilderImpl> mapFilters) {
            this.mapFilters = OcsfMapFilterListCopier.copyFromBuilder(mapFilters);
        }

        @Override
        public final Builder mapFilters(Collection<OcsfMapFilter> mapFilters) {
            this.mapFilters = OcsfMapFilterListCopier.copy(mapFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapFilters(OcsfMapFilter ... mapFilters) {
            this.mapFilters(Arrays.asList(mapFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mapFilters(Consumer<OcsfMapFilter.Builder> ... mapFilters) {
            this.mapFilters(Stream.of(mapFilters).map(c -> (OcsfMapFilter)((OcsfMapFilter.Builder)OcsfMapFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OcsfIpFilter.Builder> getIpFilters() {
            List<OcsfIpFilter.Builder> result = OcsfIpFilterListCopier.copyToBuilder(this.ipFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIpFilters(Collection<OcsfIpFilter.BuilderImpl> ipFilters) {
            this.ipFilters = OcsfIpFilterListCopier.copyFromBuilder(ipFilters);
        }

        @Override
        public final Builder ipFilters(Collection<OcsfIpFilter> ipFilters) {
            this.ipFilters = OcsfIpFilterListCopier.copy(ipFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipFilters(OcsfIpFilter ... ipFilters) {
            this.ipFilters(Arrays.asList(ipFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ipFilters(Consumer<OcsfIpFilter.Builder> ... ipFilters) {
            this.ipFilters(Stream.of(ipFilters).map(c -> (OcsfIpFilter)((OcsfIpFilter.Builder)OcsfIpFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Builder> getNestedCompositeFilters() {
            List<Builder> result = CompositeFilterListCopier.copyToBuilder(this.nestedCompositeFilters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNestedCompositeFilters(Collection<BuilderImpl> nestedCompositeFilters) {
            this.nestedCompositeFilters = CompositeFilterListCopier.copyFromBuilder(nestedCompositeFilters);
        }

        @Override
        public final Builder nestedCompositeFilters(Collection<CompositeFilter> nestedCompositeFilters) {
            this.nestedCompositeFilters = CompositeFilterListCopier.copy(nestedCompositeFilters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(CompositeFilter ... nestedCompositeFilters) {
            this.nestedCompositeFilters(Arrays.asList(nestedCompositeFilters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nestedCompositeFilters(Consumer<Builder> ... nestedCompositeFilters) {
            this.nestedCompositeFilters(Stream.of(nestedCompositeFilters).map(c -> (CompositeFilter)((Builder)CompositeFilter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getOperator() {
            return this.operator;
        }

        public final void setOperator(String operator) {
            this.operator = operator;
        }

        @Override
        public final Builder operator(String operator) {
            this.operator = operator;
            return this;
        }

        @Override
        public final Builder operator(AllowedOperators operator) {
            this.operator(operator == null ? null : operator.toString());
            return this;
        }

        public CompositeFilter build() {
            return new CompositeFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CompositeFilter> {
        public Builder stringFilters(Collection<OcsfStringFilter> var1);

        public Builder stringFilters(OcsfStringFilter ... var1);

        public Builder stringFilters(Consumer<OcsfStringFilter.Builder> ... var1);

        public Builder dateFilters(Collection<OcsfDateFilter> var1);

        public Builder dateFilters(OcsfDateFilter ... var1);

        public Builder dateFilters(Consumer<OcsfDateFilter.Builder> ... var1);

        public Builder booleanFilters(Collection<OcsfBooleanFilter> var1);

        public Builder booleanFilters(OcsfBooleanFilter ... var1);

        public Builder booleanFilters(Consumer<OcsfBooleanFilter.Builder> ... var1);

        public Builder numberFilters(Collection<OcsfNumberFilter> var1);

        public Builder numberFilters(OcsfNumberFilter ... var1);

        public Builder numberFilters(Consumer<OcsfNumberFilter.Builder> ... var1);

        public Builder mapFilters(Collection<OcsfMapFilter> var1);

        public Builder mapFilters(OcsfMapFilter ... var1);

        public Builder mapFilters(Consumer<OcsfMapFilter.Builder> ... var1);

        public Builder ipFilters(Collection<OcsfIpFilter> var1);

        public Builder ipFilters(OcsfIpFilter ... var1);

        public Builder ipFilters(Consumer<OcsfIpFilter.Builder> ... var1);

        public Builder nestedCompositeFilters(Collection<CompositeFilter> var1);

        public Builder nestedCompositeFilters(CompositeFilter ... var1);

        public Builder nestedCompositeFilters(Consumer<Builder> ... var1);

        public Builder operator(String var1);

        public Builder operator(AllowedOperators var1);
    }
}

