/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.Result;
import software.amazon.awssdk.services.securityhub.model.ResultListCopier;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMembersResponse
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, CreateMembersResponse> {
    private static final SdkField<List<Result>> UNPROCESSED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("UnprocessedAccounts").getter(CreateMembersResponse.getter(CreateMembersResponse::unprocessedAccounts)).setter(CreateMembersResponse.setter(Builder::unprocessedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UnprocessedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Result::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UNPROCESSED_ACCOUNTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMembersResponse.memberNameToFieldInitializer();
    private final List<Result> unprocessedAccounts;

    private CreateMembersResponse(BuilderImpl builder) {
        super(builder);
        this.unprocessedAccounts = builder.unprocessedAccounts;
    }

    public final boolean hasUnprocessedAccounts() {
        return this.unprocessedAccounts != null && !(this.unprocessedAccounts instanceof SdkAutoConstructList);
    }

    public final List<Result> unprocessedAccounts() {
        return this.unprocessedAccounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembersResponse)) {
            return false;
        }
        CreateMembersResponse other = (CreateMembersResponse)((Object)obj);
        return this.hasUnprocessedAccounts() == other.hasUnprocessedAccounts() && Objects.equals(this.unprocessedAccounts(), other.unprocessedAccounts());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMembersResponse").add("UnprocessedAccounts", this.hasUnprocessedAccounts() ? this.unprocessedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UnprocessedAccounts": {
                return Optional.ofNullable(clazz.cast(this.unprocessedAccounts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<Result>>> map = new HashMap<String, SdkField<List<Result>>>();
        map.put("UnprocessedAccounts", UNPROCESSED_ACCOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMembersResponse, T> g) {
        return obj -> g.apply((CreateMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private List<Result> unprocessedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembersResponse model) {
            super(model);
            this.unprocessedAccounts(model.unprocessedAccounts);
        }

        public final List<Result.Builder> getUnprocessedAccounts() {
            List<Result.Builder> result = ResultListCopier.copyToBuilder(this.unprocessedAccounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUnprocessedAccounts(Collection<Result.BuilderImpl> unprocessedAccounts) {
            this.unprocessedAccounts = ResultListCopier.copyFromBuilder(unprocessedAccounts);
        }

        @Override
        public final Builder unprocessedAccounts(Collection<Result> unprocessedAccounts) {
            this.unprocessedAccounts = ResultListCopier.copy(unprocessedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Result ... unprocessedAccounts) {
            this.unprocessedAccounts(Arrays.asList(unprocessedAccounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unprocessedAccounts(Consumer<Result.Builder> ... unprocessedAccounts) {
            this.unprocessedAccounts(Stream.of(unprocessedAccounts).map(c -> (Result)((Result.Builder)Result.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CreateMembersResponse build() {
            return new CreateMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMembersResponse> {
        public Builder unprocessedAccounts(Collection<Result> var1);

        public Builder unprocessedAccounts(Result ... var1);

        public Builder unprocessedAccounts(Consumer<Result.Builder> ... var1);
    }
}

