/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesActionListV2Copier;
import software.amazon.awssdk.services.securityhub.model.AutomationRulesActionV2;
import software.amazon.awssdk.services.securityhub.model.Criteria;
import software.amazon.awssdk.services.securityhub.model.RuleStatusV2;
import software.amazon.awssdk.services.securityhub.model.SecurityHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAutomationRuleV2Response
extends SecurityHubResponse
implements ToCopyableBuilder<Builder, GetAutomationRuleV2Response> {
    private static final SdkField<String> RULE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleArn").getter(GetAutomationRuleV2Response.getter(GetAutomationRuleV2Response::ruleArn)).setter(GetAutomationRuleV2Response.setter(Builder::ruleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleArn").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(GetAutomationRuleV2Response.getter(GetAutomationRuleV2Response::ruleId)).setter(GetAutomationRuleV2Response.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<Float> RULE_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("RuleOrder").getter(GetAutomationRuleV2Response.getter(GetAutomationRuleV2Response::ruleOrder)).setter(GetAutomationRuleV2Response.setter(Builder::ruleOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleOrder").build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleName").getter(GetAutomationRuleV2Response.getter(GetAutomationRuleV2Response::ruleName)).setter(GetAutomationRuleV2Response.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleName").build()}).build();
    private static final SdkField<String> RULE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleStatus").getter(GetAutomationRuleV2Response.getter(GetAutomationRuleV2Response::ruleStatusAsString)).setter(GetAutomationRuleV2Response.setter(Builder::ruleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleStatus").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetAutomationRuleV2Response.getter(GetAutomationRuleV2Response::description)).setter(GetAutomationRuleV2Response.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Criteria> CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Criteria").getter(GetAutomationRuleV2Response.getter(GetAutomationRuleV2Response::criteria)).setter(GetAutomationRuleV2Response.setter(Builder::criteria)).constructor(Criteria::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Criteria").build()}).build();
    private static final SdkField<List<AutomationRulesActionV2>> ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Actions").getter(GetAutomationRuleV2Response.getter(GetAutomationRuleV2Response::actions)).setter(GetAutomationRuleV2Response.setter(Builder::actions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Actions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AutomationRulesActionV2::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetAutomationRuleV2Response.getter(GetAutomationRuleV2Response::createdAt)).setter(GetAutomationRuleV2Response.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("UpdatedAt").getter(GetAutomationRuleV2Response.getter(GetAutomationRuleV2Response::updatedAt)).setter(GetAutomationRuleV2Response.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULE_ARN_FIELD, RULE_ID_FIELD, RULE_ORDER_FIELD, RULE_NAME_FIELD, RULE_STATUS_FIELD, DESCRIPTION_FIELD, CRITERIA_FIELD, ACTIONS_FIELD, CREATED_AT_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAutomationRuleV2Response.memberNameToFieldInitializer();
    private final String ruleArn;
    private final String ruleId;
    private final Float ruleOrder;
    private final String ruleName;
    private final String ruleStatus;
    private final String description;
    private final Criteria criteria;
    private final List<AutomationRulesActionV2> actions;
    private final Instant createdAt;
    private final Instant updatedAt;

    private GetAutomationRuleV2Response(BuilderImpl builder) {
        super(builder);
        this.ruleArn = builder.ruleArn;
        this.ruleId = builder.ruleId;
        this.ruleOrder = builder.ruleOrder;
        this.ruleName = builder.ruleName;
        this.ruleStatus = builder.ruleStatus;
        this.description = builder.description;
        this.criteria = builder.criteria;
        this.actions = builder.actions;
        this.createdAt = builder.createdAt;
        this.updatedAt = builder.updatedAt;
    }

    public final String ruleArn() {
        return this.ruleArn;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final Float ruleOrder() {
        return this.ruleOrder;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public final RuleStatusV2 ruleStatus() {
        return RuleStatusV2.fromValue(this.ruleStatus);
    }

    public final String ruleStatusAsString() {
        return this.ruleStatus;
    }

    public final String description() {
        return this.description;
    }

    public final Criteria criteria() {
        return this.criteria;
    }

    public final boolean hasActions() {
        return this.actions != null && !(this.actions instanceof SdkAutoConstructList);
    }

    public final List<AutomationRulesActionV2> actions() {
        return this.actions;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleOrder());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.criteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActions() ? this.actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAutomationRuleV2Response)) {
            return false;
        }
        GetAutomationRuleV2Response other = (GetAutomationRuleV2Response)((Object)obj);
        return Objects.equals(this.ruleArn(), other.ruleArn()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.ruleOrder(), other.ruleOrder()) && Objects.equals(this.ruleName(), other.ruleName()) && Objects.equals(this.ruleStatusAsString(), other.ruleStatusAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.criteria(), other.criteria()) && this.hasActions() == other.hasActions() && Objects.equals(this.actions(), other.actions()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"GetAutomationRuleV2Response").add("RuleArn", (Object)this.ruleArn()).add("RuleId", (Object)this.ruleId()).add("RuleOrder", (Object)this.ruleOrder()).add("RuleName", (Object)this.ruleName()).add("RuleStatus", (Object)this.ruleStatusAsString()).add("Description", (Object)this.description()).add("Criteria", (Object)this.criteria()).add("Actions", this.hasActions() ? this.actions() : null).add("CreatedAt", (Object)this.createdAt()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RuleArn": {
                return Optional.ofNullable(clazz.cast(this.ruleArn()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "RuleOrder": {
                return Optional.ofNullable(clazz.cast(this.ruleOrder()));
            }
            case "RuleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
            case "RuleStatus": {
                return Optional.ofNullable(clazz.cast(this.ruleStatusAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Criteria": {
                return Optional.ofNullable(clazz.cast(this.criteria()));
            }
            case "Actions": {
                return Optional.ofNullable(clazz.cast(this.actions()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "UpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RuleArn", RULE_ARN_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("RuleOrder", RULE_ORDER_FIELD);
        map.put("RuleName", RULE_NAME_FIELD);
        map.put("RuleStatus", RULE_STATUS_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Criteria", CRITERIA_FIELD);
        map.put("Actions", ACTIONS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("UpdatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAutomationRuleV2Response, T> g) {
        return obj -> g.apply((GetAutomationRuleV2Response)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityHubResponse.BuilderImpl
    implements Builder {
        private String ruleArn;
        private String ruleId;
        private Float ruleOrder;
        private String ruleName;
        private String ruleStatus;
        private String description;
        private Criteria criteria;
        private List<AutomationRulesActionV2> actions = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAutomationRuleV2Response model) {
            super(model);
            this.ruleArn(model.ruleArn);
            this.ruleId(model.ruleId);
            this.ruleOrder(model.ruleOrder);
            this.ruleName(model.ruleName);
            this.ruleStatus(model.ruleStatus);
            this.description(model.description);
            this.criteria(model.criteria);
            this.actions(model.actions);
            this.createdAt(model.createdAt);
            this.updatedAt(model.updatedAt);
        }

        public final String getRuleArn() {
            return this.ruleArn;
        }

        public final void setRuleArn(String ruleArn) {
            this.ruleArn = ruleArn;
        }

        @Override
        public final Builder ruleArn(String ruleArn) {
            this.ruleArn = ruleArn;
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final Float getRuleOrder() {
            return this.ruleOrder;
        }

        public final void setRuleOrder(Float ruleOrder) {
            this.ruleOrder = ruleOrder;
        }

        @Override
        public final Builder ruleOrder(Float ruleOrder) {
            this.ruleOrder = ruleOrder;
            return this;
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final String getRuleStatus() {
            return this.ruleStatus;
        }

        public final void setRuleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
        }

        @Override
        public final Builder ruleStatus(String ruleStatus) {
            this.ruleStatus = ruleStatus;
            return this;
        }

        @Override
        public final Builder ruleStatus(RuleStatusV2 ruleStatus) {
            this.ruleStatus(ruleStatus == null ? null : ruleStatus.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Criteria.Builder getCriteria() {
            return this.criteria != null ? this.criteria.toBuilder() : null;
        }

        public final void setCriteria(Criteria.BuilderImpl criteria) {
            this.criteria = criteria != null ? criteria.build() : null;
        }

        @Override
        public final Builder criteria(Criteria criteria) {
            this.criteria = criteria;
            return this;
        }

        public final List<AutomationRulesActionV2.Builder> getActions() {
            List<AutomationRulesActionV2.Builder> result = AutomationRulesActionListV2Copier.copyToBuilder(this.actions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActions(Collection<AutomationRulesActionV2.BuilderImpl> actions) {
            this.actions = AutomationRulesActionListV2Copier.copyFromBuilder(actions);
        }

        @Override
        public final Builder actions(Collection<AutomationRulesActionV2> actions) {
            this.actions = AutomationRulesActionListV2Copier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(AutomationRulesActionV2 ... actions) {
            this.actions(Arrays.asList(actions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(Consumer<AutomationRulesActionV2.Builder> ... actions) {
            this.actions(Stream.of(actions).map(c -> (AutomationRulesActionV2)((AutomationRulesActionV2.Builder)AutomationRulesActionV2.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public GetAutomationRuleV2Response build() {
            return new GetAutomationRuleV2Response(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityHubResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAutomationRuleV2Response> {
        public Builder ruleArn(String var1);

        public Builder ruleId(String var1);

        public Builder ruleOrder(Float var1);

        public Builder ruleName(String var1);

        public Builder ruleStatus(String var1);

        public Builder ruleStatus(RuleStatusV2 var1);

        public Builder description(String var1);

        public Builder criteria(Criteria var1);

        default public Builder criteria(Consumer<Criteria.Builder> criteria) {
            return this.criteria((Criteria)((Criteria.Builder)Criteria.builder().applyMutation(criteria)).build());
        }

        public Builder actions(Collection<AutomationRulesActionV2> var1);

        public Builder actions(AutomationRulesActionV2 ... var1);

        public Builder actions(Consumer<AutomationRulesActionV2.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder updatedAt(Instant var1);
    }
}

