/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.GetMembershipAccountDetailError;
import software.amazon.awssdk.services.securityir.model.GetMembershipAccountDetailErrorsCopier;
import software.amazon.awssdk.services.securityir.model.GetMembershipAccountDetailItem;
import software.amazon.awssdk.services.securityir.model.GetMembershipAccountDetailItemsCopier;
import software.amazon.awssdk.services.securityir.model.SecurityIrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetMemberAccountDetailsResponse
extends SecurityIrResponse
implements ToCopyableBuilder<Builder, BatchGetMemberAccountDetailsResponse> {
    private static final SdkField<List<GetMembershipAccountDetailItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(BatchGetMemberAccountDetailsResponse.getter(BatchGetMemberAccountDetailsResponse::items)).setter(BatchGetMemberAccountDetailsResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetMembershipAccountDetailItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GetMembershipAccountDetailError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetMemberAccountDetailsResponse.getter(BatchGetMemberAccountDetailsResponse::errors)).setter(BatchGetMemberAccountDetailsResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GetMembershipAccountDetailError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ITEMS_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("items", ITEMS_FIELD);
            this.put("errors", ERRORS_FIELD);
        }
    });
    private final List<GetMembershipAccountDetailItem> items;
    private final List<GetMembershipAccountDetailError> errors;

    private BatchGetMemberAccountDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.items = builder.items;
        this.errors = builder.errors;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<GetMembershipAccountDetailItem> items() {
        return this.items;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<GetMembershipAccountDetailError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetMemberAccountDetailsResponse)) {
            return false;
        }
        BatchGetMemberAccountDetailsResponse other = (BatchGetMemberAccountDetailsResponse)((Object)obj);
        return this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetMemberAccountDetailsResponse").add("Items", this.hasItems() ? this.items() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetMemberAccountDetailsResponse, T> g) {
        return obj -> g.apply((BatchGetMemberAccountDetailsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrResponse.BuilderImpl
    implements Builder {
        private List<GetMembershipAccountDetailItem> items = DefaultSdkAutoConstructList.getInstance();
        private List<GetMembershipAccountDetailError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetMemberAccountDetailsResponse model) {
            super(model);
            this.items(model.items);
            this.errors(model.errors);
        }

        public final List<GetMembershipAccountDetailItem.Builder> getItems() {
            List<GetMembershipAccountDetailItem.Builder> result = GetMembershipAccountDetailItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<GetMembershipAccountDetailItem.BuilderImpl> items) {
            this.items = GetMembershipAccountDetailItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<GetMembershipAccountDetailItem> items) {
            this.items = GetMembershipAccountDetailItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(GetMembershipAccountDetailItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<GetMembershipAccountDetailItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (GetMembershipAccountDetailItem)((GetMembershipAccountDetailItem.Builder)GetMembershipAccountDetailItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GetMembershipAccountDetailError.Builder> getErrors() {
            List<GetMembershipAccountDetailError.Builder> result = GetMembershipAccountDetailErrorsCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<GetMembershipAccountDetailError.BuilderImpl> errors) {
            this.errors = GetMembershipAccountDetailErrorsCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<GetMembershipAccountDetailError> errors) {
            this.errors = GetMembershipAccountDetailErrorsCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(GetMembershipAccountDetailError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<GetMembershipAccountDetailError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (GetMembershipAccountDetailError)((GetMembershipAccountDetailError.Builder)GetMembershipAccountDetailError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetMemberAccountDetailsResponse build() {
            return new BatchGetMemberAccountDetailsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityIrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetMemberAccountDetailsResponse> {
        public Builder items(Collection<GetMembershipAccountDetailItem> var1);

        public Builder items(GetMembershipAccountDetailItem ... var1);

        public Builder items(Consumer<GetMembershipAccountDetailItem.Builder> ... var1);

        public Builder errors(Collection<GetMembershipAccountDetailError> var1);

        public Builder errors(GetMembershipAccountDetailError ... var1);

        public Builder errors(Consumer<GetMembershipAccountDetailError.Builder> ... var1);
    }
}

