/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.securityir.model.EngagementType;
import software.amazon.awssdk.services.securityir.model.ImpactedAccountsCopier;
import software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion;
import software.amazon.awssdk.services.securityir.model.ImpactedAwsRegionListCopier;
import software.amazon.awssdk.services.securityir.model.ImpactedServicesListCopier;
import software.amazon.awssdk.services.securityir.model.ResolverType;
import software.amazon.awssdk.services.securityir.model.SecurityIrRequest;
import software.amazon.awssdk.services.securityir.model.TagMapCopier;
import software.amazon.awssdk.services.securityir.model.ThreatActorIp;
import software.amazon.awssdk.services.securityir.model.ThreatActorIpListCopier;
import software.amazon.awssdk.services.securityir.model.Watcher;
import software.amazon.awssdk.services.securityir.model.WatchersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCaseRequest
extends SecurityIrRequest
implements ToCopyableBuilder<Builder, CreateCaseRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateCaseRequest.getter(CreateCaseRequest::clientToken)).setter(CreateCaseRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> RESOLVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolverType").getter(CreateCaseRequest.getter(CreateCaseRequest::resolverTypeAsString)).setter(CreateCaseRequest.setter(Builder::resolverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverType").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(CreateCaseRequest.getter(CreateCaseRequest::title)).setter(CreateCaseRequest.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateCaseRequest.getter(CreateCaseRequest::description)).setter(CreateCaseRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> ENGAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engagementType").getter(CreateCaseRequest.getter(CreateCaseRequest::engagementTypeAsString)).setter(CreateCaseRequest.setter(Builder::engagementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagementType").build()}).build();
    private static final SdkField<Instant> REPORTED_INCIDENT_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("reportedIncidentStartDate").getter(CreateCaseRequest.getter(CreateCaseRequest::reportedIncidentStartDate)).setter(CreateCaseRequest.setter(Builder::reportedIncidentStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportedIncidentStartDate").build()}).build();
    private static final SdkField<List<String>> IMPACTED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedAccounts").getter(CreateCaseRequest.getter(CreateCaseRequest::impactedAccounts)).setter(CreateCaseRequest.setter(Builder::impactedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Watcher>> WATCHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("watchers").getter(CreateCaseRequest.getter(CreateCaseRequest::watchers)).setter(CreateCaseRequest.setter(Builder::watchers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("watchers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Watcher::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ThreatActorIp>> THREAT_ACTOR_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("threatActorIpAddresses").getter(CreateCaseRequest.getter(CreateCaseRequest::threatActorIpAddresses)).setter(CreateCaseRequest.setter(Builder::threatActorIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatActorIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThreatActorIp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMPACTED_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedServices").getter(CreateCaseRequest.getter(CreateCaseRequest::impactedServices)).setter(CreateCaseRequest.setter(Builder::impactedServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ImpactedAwsRegion>> IMPACTED_AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedAwsRegions").getter(CreateCaseRequest.getter(CreateCaseRequest::impactedAwsRegions)).setter(CreateCaseRequest.setter(Builder::impactedAwsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImpactedAwsRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateCaseRequest.getter(CreateCaseRequest::tags)).setter(CreateCaseRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, RESOLVER_TYPE_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, ENGAGEMENT_TYPE_FIELD, REPORTED_INCIDENT_START_DATE_FIELD, IMPACTED_ACCOUNTS_FIELD, WATCHERS_FIELD, THREAT_ACTOR_IP_ADDRESSES_FIELD, IMPACTED_SERVICES_FIELD, IMPACTED_AWS_REGIONS_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("resolverType", RESOLVER_TYPE_FIELD);
            this.put("title", TITLE_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("engagementType", ENGAGEMENT_TYPE_FIELD);
            this.put("reportedIncidentStartDate", REPORTED_INCIDENT_START_DATE_FIELD);
            this.put("impactedAccounts", IMPACTED_ACCOUNTS_FIELD);
            this.put("watchers", WATCHERS_FIELD);
            this.put("threatActorIpAddresses", THREAT_ACTOR_IP_ADDRESSES_FIELD);
            this.put("impactedServices", IMPACTED_SERVICES_FIELD);
            this.put("impactedAwsRegions", IMPACTED_AWS_REGIONS_FIELD);
            this.put("tags", TAGS_FIELD);
        }
    });
    private final String clientToken;
    private final String resolverType;
    private final String title;
    private final String description;
    private final String engagementType;
    private final Instant reportedIncidentStartDate;
    private final List<String> impactedAccounts;
    private final List<Watcher> watchers;
    private final List<ThreatActorIp> threatActorIpAddresses;
    private final List<String> impactedServices;
    private final List<ImpactedAwsRegion> impactedAwsRegions;
    private final Map<String, String> tags;

    private CreateCaseRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.resolverType = builder.resolverType;
        this.title = builder.title;
        this.description = builder.description;
        this.engagementType = builder.engagementType;
        this.reportedIncidentStartDate = builder.reportedIncidentStartDate;
        this.impactedAccounts = builder.impactedAccounts;
        this.watchers = builder.watchers;
        this.threatActorIpAddresses = builder.threatActorIpAddresses;
        this.impactedServices = builder.impactedServices;
        this.impactedAwsRegions = builder.impactedAwsRegions;
        this.tags = builder.tags;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final ResolverType resolverType() {
        return ResolverType.fromValue(this.resolverType);
    }

    public final String resolverTypeAsString() {
        return this.resolverType;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final EngagementType engagementType() {
        return EngagementType.fromValue(this.engagementType);
    }

    public final String engagementTypeAsString() {
        return this.engagementType;
    }

    public final Instant reportedIncidentStartDate() {
        return this.reportedIncidentStartDate;
    }

    public final boolean hasImpactedAccounts() {
        return this.impactedAccounts != null && !(this.impactedAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> impactedAccounts() {
        return this.impactedAccounts;
    }

    public final boolean hasWatchers() {
        return this.watchers != null && !(this.watchers instanceof SdkAutoConstructList);
    }

    public final List<Watcher> watchers() {
        return this.watchers;
    }

    public final boolean hasThreatActorIpAddresses() {
        return this.threatActorIpAddresses != null && !(this.threatActorIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<ThreatActorIp> threatActorIpAddresses() {
        return this.threatActorIpAddresses;
    }

    public final boolean hasImpactedServices() {
        return this.impactedServices != null && !(this.impactedServices instanceof SdkAutoConstructList);
    }

    public final List<String> impactedServices() {
        return this.impactedServices;
    }

    public final boolean hasImpactedAwsRegions() {
        return this.impactedAwsRegions != null && !(this.impactedAwsRegions instanceof SdkAutoConstructList);
    }

    public final List<ImpactedAwsRegion> impactedAwsRegions() {
        return this.impactedAwsRegions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportedIncidentStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedAccounts() ? this.impactedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWatchers() ? this.watchers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreatActorIpAddresses() ? this.threatActorIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedServices() ? this.impactedServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedAwsRegions() ? this.impactedAwsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCaseRequest)) {
            return false;
        }
        CreateCaseRequest other = (CreateCaseRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.resolverTypeAsString(), other.resolverTypeAsString()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engagementTypeAsString(), other.engagementTypeAsString()) && Objects.equals(this.reportedIncidentStartDate(), other.reportedIncidentStartDate()) && this.hasImpactedAccounts() == other.hasImpactedAccounts() && Objects.equals(this.impactedAccounts(), other.impactedAccounts()) && this.hasWatchers() == other.hasWatchers() && Objects.equals(this.watchers(), other.watchers()) && this.hasThreatActorIpAddresses() == other.hasThreatActorIpAddresses() && Objects.equals(this.threatActorIpAddresses(), other.threatActorIpAddresses()) && this.hasImpactedServices() == other.hasImpactedServices() && Objects.equals(this.impactedServices(), other.impactedServices()) && this.hasImpactedAwsRegions() == other.hasImpactedAwsRegions() && Objects.equals(this.impactedAwsRegions(), other.impactedAwsRegions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCaseRequest").add("ClientToken", (Object)this.clientToken()).add("ResolverType", (Object)this.resolverTypeAsString()).add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EngagementType", (Object)this.engagementTypeAsString()).add("ReportedIncidentStartDate", (Object)this.reportedIncidentStartDate()).add("ImpactedAccounts", this.hasImpactedAccounts() ? this.impactedAccounts() : null).add("Watchers", this.hasWatchers() ? this.watchers() : null).add("ThreatActorIpAddresses", this.hasThreatActorIpAddresses() ? this.threatActorIpAddresses() : null).add("ImpactedServices", this.hasImpactedServices() ? this.impactedServices() : null).add("ImpactedAwsRegions", this.hasImpactedAwsRegions() ? this.impactedAwsRegions() : null).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "resolverType": {
                return Optional.ofNullable(clazz.cast(this.resolverTypeAsString()));
            }
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "engagementType": {
                return Optional.ofNullable(clazz.cast(this.engagementTypeAsString()));
            }
            case "reportedIncidentStartDate": {
                return Optional.ofNullable(clazz.cast(this.reportedIncidentStartDate()));
            }
            case "impactedAccounts": {
                return Optional.ofNullable(clazz.cast(this.impactedAccounts()));
            }
            case "watchers": {
                return Optional.ofNullable(clazz.cast(this.watchers()));
            }
            case "threatActorIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.threatActorIpAddresses()));
            }
            case "impactedServices": {
                return Optional.ofNullable(clazz.cast(this.impactedServices()));
            }
            case "impactedAwsRegions": {
                return Optional.ofNullable(clazz.cast(this.impactedAwsRegions()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateCaseRequest, T> g) {
        return obj -> g.apply((CreateCaseRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String resolverType;
        private String title;
        private String description;
        private String engagementType;
        private Instant reportedIncidentStartDate;
        private List<String> impactedAccounts = DefaultSdkAutoConstructList.getInstance();
        private List<Watcher> watchers = DefaultSdkAutoConstructList.getInstance();
        private List<ThreatActorIp> threatActorIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private List<String> impactedServices = DefaultSdkAutoConstructList.getInstance();
        private List<ImpactedAwsRegion> impactedAwsRegions = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCaseRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.resolverType(model.resolverType);
            this.title(model.title);
            this.description(model.description);
            this.engagementType(model.engagementType);
            this.reportedIncidentStartDate(model.reportedIncidentStartDate);
            this.impactedAccounts(model.impactedAccounts);
            this.watchers(model.watchers);
            this.threatActorIpAddresses(model.threatActorIpAddresses);
            this.impactedServices(model.impactedServices);
            this.impactedAwsRegions(model.impactedAwsRegions);
            this.tags(model.tags);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getResolverType() {
            return this.resolverType;
        }

        public final void setResolverType(String resolverType) {
            this.resolverType = resolverType;
        }

        @Override
        public final Builder resolverType(String resolverType) {
            this.resolverType = resolverType;
            return this;
        }

        @Override
        public final Builder resolverType(ResolverType resolverType) {
            this.resolverType(resolverType == null ? null : resolverType.toString());
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngagementType() {
            return this.engagementType;
        }

        public final void setEngagementType(String engagementType) {
            this.engagementType = engagementType;
        }

        @Override
        public final Builder engagementType(String engagementType) {
            this.engagementType = engagementType;
            return this;
        }

        @Override
        public final Builder engagementType(EngagementType engagementType) {
            this.engagementType(engagementType == null ? null : engagementType.toString());
            return this;
        }

        public final Instant getReportedIncidentStartDate() {
            return this.reportedIncidentStartDate;
        }

        public final void setReportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
        }

        @Override
        public final Builder reportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
            return this;
        }

        public final Collection<String> getImpactedAccounts() {
            if (this.impactedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.impactedAccounts;
        }

        public final void setImpactedAccounts(Collection<String> impactedAccounts) {
            this.impactedAccounts = ImpactedAccountsCopier.copy(impactedAccounts);
        }

        @Override
        public final Builder impactedAccounts(Collection<String> impactedAccounts) {
            this.impactedAccounts = ImpactedAccountsCopier.copy(impactedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAccounts(String ... impactedAccounts) {
            this.impactedAccounts(Arrays.asList(impactedAccounts));
            return this;
        }

        public final List<Watcher.Builder> getWatchers() {
            List<Watcher.Builder> result = WatchersCopier.copyToBuilder(this.watchers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatchers(Collection<Watcher.BuilderImpl> watchers) {
            this.watchers = WatchersCopier.copyFromBuilder(watchers);
        }

        @Override
        public final Builder watchers(Collection<Watcher> watchers) {
            this.watchers = WatchersCopier.copy(watchers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchers(Watcher ... watchers) {
            this.watchers(Arrays.asList(watchers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchers(Consumer<Watcher.Builder> ... watchers) {
            this.watchers(Stream.of(watchers).map(c -> (Watcher)((Watcher.Builder)Watcher.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ThreatActorIp.Builder> getThreatActorIpAddresses() {
            List<ThreatActorIp.Builder> result = ThreatActorIpListCopier.copyToBuilder(this.threatActorIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatActorIpAddresses(Collection<ThreatActorIp.BuilderImpl> threatActorIpAddresses) {
            this.threatActorIpAddresses = ThreatActorIpListCopier.copyFromBuilder(threatActorIpAddresses);
        }

        @Override
        public final Builder threatActorIpAddresses(Collection<ThreatActorIp> threatActorIpAddresses) {
            this.threatActorIpAddresses = ThreatActorIpListCopier.copy(threatActorIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddresses(ThreatActorIp ... threatActorIpAddresses) {
            this.threatActorIpAddresses(Arrays.asList(threatActorIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddresses(Consumer<ThreatActorIp.Builder> ... threatActorIpAddresses) {
            this.threatActorIpAddresses(Stream.of(threatActorIpAddresses).map(c -> (ThreatActorIp)((ThreatActorIp.Builder)ThreatActorIp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getImpactedServices() {
            if (this.impactedServices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.impactedServices;
        }

        public final void setImpactedServices(Collection<String> impactedServices) {
            this.impactedServices = ImpactedServicesListCopier.copy(impactedServices);
        }

        @Override
        public final Builder impactedServices(Collection<String> impactedServices) {
            this.impactedServices = ImpactedServicesListCopier.copy(impactedServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedServices(String ... impactedServices) {
            this.impactedServices(Arrays.asList(impactedServices));
            return this;
        }

        public final List<ImpactedAwsRegion.Builder> getImpactedAwsRegions() {
            List<ImpactedAwsRegion.Builder> result = ImpactedAwsRegionListCopier.copyToBuilder(this.impactedAwsRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpactedAwsRegions(Collection<ImpactedAwsRegion.BuilderImpl> impactedAwsRegions) {
            this.impactedAwsRegions = ImpactedAwsRegionListCopier.copyFromBuilder(impactedAwsRegions);
        }

        @Override
        public final Builder impactedAwsRegions(Collection<ImpactedAwsRegion> impactedAwsRegions) {
            this.impactedAwsRegions = ImpactedAwsRegionListCopier.copy(impactedAwsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegions(ImpactedAwsRegion ... impactedAwsRegions) {
            this.impactedAwsRegions(Arrays.asList(impactedAwsRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegions(Consumer<ImpactedAwsRegion.Builder> ... impactedAwsRegions) {
            this.impactedAwsRegions(Stream.of(impactedAwsRegions).map(c -> (ImpactedAwsRegion)((ImpactedAwsRegion.Builder)ImpactedAwsRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCaseRequest build() {
            return new CreateCaseRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityIrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCaseRequest> {
        public Builder clientToken(String var1);

        public Builder resolverType(String var1);

        public Builder resolverType(ResolverType var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder engagementType(String var1);

        public Builder engagementType(EngagementType var1);

        public Builder reportedIncidentStartDate(Instant var1);

        public Builder impactedAccounts(Collection<String> var1);

        public Builder impactedAccounts(String ... var1);

        public Builder watchers(Collection<Watcher> var1);

        public Builder watchers(Watcher ... var1);

        public Builder watchers(Consumer<Watcher.Builder> ... var1);

        public Builder threatActorIpAddresses(Collection<ThreatActorIp> var1);

        public Builder threatActorIpAddresses(ThreatActorIp ... var1);

        public Builder threatActorIpAddresses(Consumer<ThreatActorIp.Builder> ... var1);

        public Builder impactedServices(Collection<String> var1);

        public Builder impactedServices(String ... var1);

        public Builder impactedAwsRegions(Collection<ImpactedAwsRegion> var1);

        public Builder impactedAwsRegions(ImpactedAwsRegion ... var1);

        public Builder impactedAwsRegions(Consumer<ImpactedAwsRegion.Builder> ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

