/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.CaseEditItem;
import software.amazon.awssdk.services.securityir.model.CaseEditItemsCopier;
import software.amazon.awssdk.services.securityir.model.SecurityIrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListCaseEditsResponse
extends SecurityIrResponse
implements ToCopyableBuilder<Builder, ListCaseEditsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListCaseEditsResponse.getter(ListCaseEditsResponse::nextToken)).setter(ListCaseEditsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<CaseEditItem>> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("items").getter(ListCaseEditsResponse.getter(ListCaseEditsResponse::items)).setter(ListCaseEditsResponse.setter(Builder::items)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaseEditItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> TOTAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("total").getter(ListCaseEditsResponse.getter(ListCaseEditsResponse::total)).setter(ListCaseEditsResponse.setter(Builder::total)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ITEMS_FIELD, TOTAL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("items", ITEMS_FIELD);
            this.put("total", TOTAL_FIELD);
        }
    });
    private final String nextToken;
    private final List<CaseEditItem> items;
    private final Integer total;

    private ListCaseEditsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.items = builder.items;
        this.total = builder.total;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasItems() {
        return this.items != null && !(this.items instanceof SdkAutoConstructList);
    }

    public final List<CaseEditItem> items() {
        return this.items;
    }

    public final Integer total() {
        return this.total;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasItems() ? this.items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.total());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCaseEditsResponse)) {
            return false;
        }
        ListCaseEditsResponse other = (ListCaseEditsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasItems() == other.hasItems() && Objects.equals(this.items(), other.items()) && Objects.equals(this.total(), other.total());
    }

    public final String toString() {
        return ToString.builder((String)"ListCaseEditsResponse").add("NextToken", (Object)this.nextToken()).add("Items", this.hasItems() ? this.items() : null).add("Total", (Object)this.total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "total": {
                return Optional.ofNullable(clazz.cast(this.total()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListCaseEditsResponse, T> g) {
        return obj -> g.apply((ListCaseEditsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CaseEditItem> items = DefaultSdkAutoConstructList.getInstance();
        private Integer total;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCaseEditsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.items(model.items);
            this.total(model.total);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<CaseEditItem.Builder> getItems() {
            List<CaseEditItem.Builder> result = CaseEditItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<CaseEditItem.BuilderImpl> items) {
            this.items = CaseEditItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<CaseEditItem> items) {
            this.items = CaseEditItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(CaseEditItem ... items) {
            this.items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<CaseEditItem.Builder> ... items) {
            this.items(Stream.of(items).map(c -> (CaseEditItem)((CaseEditItem.Builder)CaseEditItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getTotal() {
            return this.total;
        }

        public final void setTotal(Integer total) {
            this.total = total;
        }

        @Override
        public final Builder total(Integer total) {
            this.total = total;
            return this;
        }

        @Override
        public ListCaseEditsResponse build() {
            return new ListCaseEditsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityIrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListCaseEditsResponse> {
        public Builder nextToken(String var1);

        public Builder items(Collection<CaseEditItem> var1);

        public Builder items(CaseEditItem ... var1);

        public Builder items(Consumer<CaseEditItem.Builder> ... var1);

        public Builder total(Integer var1);
    }
}

