/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.securityir.model.CaseAttachmentStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CaseAttachmentAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CaseAttachmentAttributes> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentId").getter(CaseAttachmentAttributes.getter(CaseAttachmentAttributes::attachmentId)).setter(CaseAttachmentAttributes.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentId").build()}).build();
    private static final SdkField<String> FILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fileName").getter(CaseAttachmentAttributes.getter(CaseAttachmentAttributes::fileName)).setter(CaseAttachmentAttributes.setter(Builder::fileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()}).build();
    private static final SdkField<String> ATTACHMENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("attachmentStatus").getter(CaseAttachmentAttributes.getter(CaseAttachmentAttributes::attachmentStatusAsString)).setter(CaseAttachmentAttributes.setter(Builder::attachmentStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentStatus").build()}).build();
    private static final SdkField<String> CREATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("creator").getter(CaseAttachmentAttributes.getter(CaseAttachmentAttributes::creator)).setter(CaseAttachmentAttributes.setter(Builder::creator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creator").build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(CaseAttachmentAttributes.getter(CaseAttachmentAttributes::createdDate)).setter(CaseAttachmentAttributes.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD, FILE_NAME_FIELD, ATTACHMENT_STATUS_FIELD, CREATOR_FIELD, CREATED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CaseAttachmentAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String attachmentId;
    private final String fileName;
    private final String attachmentStatus;
    private final String creator;
    private final Instant createdDate;

    private CaseAttachmentAttributes(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.fileName = builder.fileName;
        this.attachmentStatus = builder.attachmentStatus;
        this.creator = builder.creator;
        this.createdDate = builder.createdDate;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final String fileName() {
        return this.fileName;
    }

    public final CaseAttachmentStatus attachmentStatus() {
        return CaseAttachmentStatus.fromValue(this.attachmentStatus);
    }

    public final String attachmentStatusAsString() {
        return this.attachmentStatus;
    }

    public final String creator() {
        return this.creator;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creator());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseAttachmentAttributes)) {
            return false;
        }
        CaseAttachmentAttributes other = (CaseAttachmentAttributes)obj;
        return Objects.equals(this.attachmentId(), other.attachmentId()) && Objects.equals(this.fileName(), other.fileName()) && Objects.equals(this.attachmentStatusAsString(), other.attachmentStatusAsString()) && Objects.equals(this.creator(), other.creator()) && Objects.equals(this.createdDate(), other.createdDate());
    }

    public final String toString() {
        return ToString.builder((String)"CaseAttachmentAttributes").add("AttachmentId", (Object)this.attachmentId()).add("FileName", (Object)(this.fileName() == null ? null : "*** Sensitive Data Redacted ***")).add("AttachmentStatus", (Object)this.attachmentStatusAsString()).add("Creator", (Object)this.creator()).add("CreatedDate", (Object)this.createdDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "attachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "fileName": {
                return Optional.ofNullable(clazz.cast(this.fileName()));
            }
            case "attachmentStatus": {
                return Optional.ofNullable(clazz.cast(this.attachmentStatusAsString()));
            }
            case "creator": {
                return Optional.ofNullable(clazz.cast(this.creator()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attachmentId", ATTACHMENT_ID_FIELD);
        map.put("fileName", FILE_NAME_FIELD);
        map.put("attachmentStatus", ATTACHMENT_STATUS_FIELD);
        map.put("creator", CREATOR_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseAttachmentAttributes, T> g) {
        return obj -> g.apply((CaseAttachmentAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachmentId;
        private String fileName;
        private String attachmentStatus;
        private String creator;
        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseAttachmentAttributes model) {
            this.attachmentId(model.attachmentId);
            this.fileName(model.fileName);
            this.attachmentStatus(model.attachmentStatus);
            this.creator(model.creator);
            this.createdDate(model.createdDate);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getFileName() {
            return this.fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getAttachmentStatus() {
            return this.attachmentStatus;
        }

        public final void setAttachmentStatus(String attachmentStatus) {
            this.attachmentStatus = attachmentStatus;
        }

        @Override
        public final Builder attachmentStatus(String attachmentStatus) {
            this.attachmentStatus = attachmentStatus;
            return this;
        }

        @Override
        public final Builder attachmentStatus(CaseAttachmentStatus attachmentStatus) {
            this.attachmentStatus(attachmentStatus == null ? null : attachmentStatus.toString());
            return this;
        }

        public final String getCreator() {
            return this.creator;
        }

        public final void setCreator(String creator) {
            this.creator = creator;
        }

        @Override
        public final Builder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public CaseAttachmentAttributes build() {
            return new CaseAttachmentAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CaseAttachmentAttributes> {
        public Builder attachmentId(String var1);

        public Builder fileName(String var1);

        public Builder attachmentStatus(String var1);

        public Builder attachmentStatus(CaseAttachmentStatus var1);

        public Builder creator(String var1);

        public Builder createdDate(Instant var1);
    }
}

