/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.securityir.internal.SecurityIrServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.securityir.model.AccessDeniedException;
import software.amazon.awssdk.services.securityir.model.BatchGetMemberAccountDetailsRequest;
import software.amazon.awssdk.services.securityir.model.BatchGetMemberAccountDetailsResponse;
import software.amazon.awssdk.services.securityir.model.CancelMembershipRequest;
import software.amazon.awssdk.services.securityir.model.CancelMembershipResponse;
import software.amazon.awssdk.services.securityir.model.CloseCaseRequest;
import software.amazon.awssdk.services.securityir.model.CloseCaseResponse;
import software.amazon.awssdk.services.securityir.model.ConflictException;
import software.amazon.awssdk.services.securityir.model.CreateCaseCommentRequest;
import software.amazon.awssdk.services.securityir.model.CreateCaseCommentResponse;
import software.amazon.awssdk.services.securityir.model.CreateCaseRequest;
import software.amazon.awssdk.services.securityir.model.CreateCaseResponse;
import software.amazon.awssdk.services.securityir.model.CreateMembershipRequest;
import software.amazon.awssdk.services.securityir.model.CreateMembershipResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentDownloadUrlRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentDownloadUrlResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentUploadUrlRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentUploadUrlResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseResponse;
import software.amazon.awssdk.services.securityir.model.GetMembershipRequest;
import software.amazon.awssdk.services.securityir.model.GetMembershipResponse;
import software.amazon.awssdk.services.securityir.model.InternalServerException;
import software.amazon.awssdk.services.securityir.model.InvalidTokenException;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse;
import software.amazon.awssdk.services.securityir.model.ListCasesRequest;
import software.amazon.awssdk.services.securityir.model.ListCasesResponse;
import software.amazon.awssdk.services.securityir.model.ListCommentsRequest;
import software.amazon.awssdk.services.securityir.model.ListCommentsResponse;
import software.amazon.awssdk.services.securityir.model.ListMembershipsRequest;
import software.amazon.awssdk.services.securityir.model.ListMembershipsResponse;
import software.amazon.awssdk.services.securityir.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.securityir.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.securityir.model.ResourceNotFoundException;
import software.amazon.awssdk.services.securityir.model.SecurityIncidentResponseNotActiveException;
import software.amazon.awssdk.services.securityir.model.SecurityIrException;
import software.amazon.awssdk.services.securityir.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.securityir.model.TagResourceRequest;
import software.amazon.awssdk.services.securityir.model.TagResourceResponse;
import software.amazon.awssdk.services.securityir.model.ThrottlingException;
import software.amazon.awssdk.services.securityir.model.UntagResourceRequest;
import software.amazon.awssdk.services.securityir.model.UntagResourceResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseCommentRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseCommentResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseStatusRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseStatusResponse;
import software.amazon.awssdk.services.securityir.model.UpdateMembershipRequest;
import software.amazon.awssdk.services.securityir.model.UpdateMembershipResponse;
import software.amazon.awssdk.services.securityir.model.UpdateResolverTypeRequest;
import software.amazon.awssdk.services.securityir.model.UpdateResolverTypeResponse;
import software.amazon.awssdk.services.securityir.model.ValidationException;
import software.amazon.awssdk.services.securityir.transform.BatchGetMemberAccountDetailsRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.CancelMembershipRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.CloseCaseRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.CreateCaseCommentRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.CreateCaseRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.CreateMembershipRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.GetCaseAttachmentDownloadUrlRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.GetCaseAttachmentUploadUrlRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.GetCaseRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.GetMembershipRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.ListCaseEditsRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.ListCasesRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.ListCommentsRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.ListMembershipsRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UpdateCaseCommentRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UpdateCaseRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UpdateCaseStatusRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UpdateMembershipRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UpdateResolverTypeRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link SecurityIrAsyncClient}.
 *
 * @see SecurityIrAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSecurityIrAsyncClient implements SecurityIrAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecurityIrAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSecurityIrAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Grants permission to view an existing membership.
     * </p>
     *
     * @param batchGetMemberAccountDetailsRequest
     * @return A Java Future containing the result of the BatchGetMemberAccountDetails operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.BatchGetMemberAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/BatchGetMemberAccountDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<BatchGetMemberAccountDetailsResponse> batchGetMemberAccountDetails(
            BatchGetMemberAccountDetailsRequest batchGetMemberAccountDetailsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetMemberAccountDetailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetMemberAccountDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetMemberAccountDetails");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchGetMemberAccountDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchGetMemberAccountDetailsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<BatchGetMemberAccountDetailsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchGetMemberAccountDetailsRequest, BatchGetMemberAccountDetailsResponse>()
                            .withOperationName("BatchGetMemberAccountDetails").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchGetMemberAccountDetailsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(batchGetMemberAccountDetailsRequest));
            CompletableFuture<BatchGetMemberAccountDetailsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permissions to cancel an existing membership.
     * </p>
     *
     * @param cancelMembershipRequest
     * @return A Java Future containing the result of the CancelMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CancelMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CancelMembership" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelMembershipResponse> cancelMembership(CancelMembershipRequest cancelMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelMembershipRequest, CancelMembershipResponse>()
                            .withOperationName("CancelMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(cancelMembershipRequest));
            CompletableFuture<CancelMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to close an existing case.
     * </p>
     *
     * @param closeCaseRequest
     * @return A Java Future containing the result of the CloseCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CloseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CloseCase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CloseCaseResponse> closeCase(CloseCaseRequest closeCaseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(closeCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, closeCaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CloseCase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CloseCaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CloseCaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CloseCaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CloseCaseRequest, CloseCaseResponse>().withOperationName("CloseCase")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CloseCaseRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(closeCaseRequest));
            CompletableFuture<CloseCaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to create a new case.
     * </p>
     *
     * @param createCaseRequest
     * @return A Java Future containing the result of the CreateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CreateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCaseResponse> createCase(CreateCaseRequest createCaseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateCaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCaseRequest, CreateCaseResponse>().withOperationName("CreateCase")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCaseRequest));
            CompletableFuture<CreateCaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to add a comment to an existing case.
     * </p>
     *
     * @param createCaseCommentRequest
     * @return A Java Future containing the result of the CreateCaseComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CreateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateCaseCommentResponse> createCaseComment(CreateCaseCommentRequest createCaseCommentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCaseCommentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCaseCommentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCaseComment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateCaseCommentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateCaseCommentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateCaseCommentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateCaseCommentRequest, CreateCaseCommentResponse>()
                            .withOperationName("CreateCaseComment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateCaseCommentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createCaseCommentRequest));
            CompletableFuture<CreateCaseCommentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permissions to create a new membership.
     * </p>
     *
     * @param createMembershipRequest
     * @return A Java Future containing the result of the CreateMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.CreateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMembershipResponse> createMembership(CreateMembershipRequest createMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMembershipRequest, CreateMembershipResponse>()
                            .withOperationName("CreateMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(createMembershipRequest));
            CompletableFuture<CreateMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grant permission to view a designated case.
     * </p>
     *
     * @param getCaseRequest
     * @return A Java Future containing the result of the GetCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetCaseResponse> getCase(GetCaseRequest getCaseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetCaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCaseRequest, GetCaseResponse>().withOperationName("GetCase")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetCaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCaseRequest));
            CompletableFuture<GetCaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to obtain an Amazon S3 presigned URL to download an attachment.
     * </p>
     *
     * @param getCaseAttachmentDownloadUrlRequest
     * @return A Java Future containing the result of the GetCaseAttachmentDownloadUrl operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetCaseAttachmentDownloadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentDownloadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCaseAttachmentDownloadUrlResponse> getCaseAttachmentDownloadUrl(
            GetCaseAttachmentDownloadUrlRequest getCaseAttachmentDownloadUrlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCaseAttachmentDownloadUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCaseAttachmentDownloadUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCaseAttachmentDownloadUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCaseAttachmentDownloadUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCaseAttachmentDownloadUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCaseAttachmentDownloadUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCaseAttachmentDownloadUrlRequest, GetCaseAttachmentDownloadUrlResponse>()
                            .withOperationName("GetCaseAttachmentDownloadUrl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCaseAttachmentDownloadUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCaseAttachmentDownloadUrlRequest));
            CompletableFuture<GetCaseAttachmentDownloadUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to upload an attachment to a case.
     * </p>
     *
     * @param getCaseAttachmentUploadUrlRequest
     * @return A Java Future containing the result of the GetCaseAttachmentUploadUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetCaseAttachmentUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetCaseAttachmentUploadUrlResponse> getCaseAttachmentUploadUrl(
            GetCaseAttachmentUploadUrlRequest getCaseAttachmentUploadUrlRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCaseAttachmentUploadUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCaseAttachmentUploadUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCaseAttachmentUploadUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetCaseAttachmentUploadUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetCaseAttachmentUploadUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetCaseAttachmentUploadUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetCaseAttachmentUploadUrlRequest, GetCaseAttachmentUploadUrlResponse>()
                            .withOperationName("GetCaseAttachmentUploadUrl").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetCaseAttachmentUploadUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getCaseAttachmentUploadUrlRequest));
            CompletableFuture<GetCaseAttachmentUploadUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to get details of a designated service membership.
     * </p>
     *
     * @param getMembershipRequest
     * @return A Java Future containing the result of the GetMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.GetMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetMembership" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetMembershipResponse> getMembership(GetMembershipRequest getMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMembershipRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetMembershipResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetMembershipRequest, GetMembershipResponse>()
                            .withOperationName("GetMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(getMembershipRequest));
            CompletableFuture<GetMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permissions to view the aidt log for edits made to a designated case.
     * </p>
     *
     * @param listCaseEditsRequest
     * @return A Java Future containing the result of the ListCaseEdits operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListCaseEdits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCaseEdits" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCaseEditsResponse> listCaseEdits(ListCaseEditsRequest listCaseEditsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCaseEditsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCaseEditsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCaseEdits");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCaseEditsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListCaseEditsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCaseEditsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCaseEditsRequest, ListCaseEditsResponse>()
                            .withOperationName("ListCaseEdits").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCaseEditsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCaseEditsRequest));
            CompletableFuture<ListCaseEditsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to list all cases the requester has access to.
     * </p>
     *
     * @param listCasesRequest
     * @return A Java Future containing the result of the ListCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCasesResponse> listCases(ListCasesRequest listCasesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListCasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCasesRequest, ListCasesResponse>().withOperationName("ListCases")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCasesRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).withInput(listCasesRequest));
            CompletableFuture<ListCasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permissions to list and view comments for a designated case.
     * </p>
     *
     * @param listCommentsRequest
     * @return A Java Future containing the result of the ListComments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListComments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListCommentsResponse> listComments(ListCommentsRequest listCommentsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCommentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCommentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListCommentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListCommentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListCommentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListCommentsRequest, ListCommentsResponse>()
                            .withOperationName("ListComments").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListCommentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listCommentsRequest));
            CompletableFuture<ListCommentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to query the memberships a principal has access to.
     * </p>
     *
     * @param listMembershipsRequest
     * @return A Java Future containing the result of the ListMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMembershipsResponse> listMemberships(ListMembershipsRequest listMembershipsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMembershipsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMembershipsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMemberships");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMembershipsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMembershipsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListMembershipsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMembershipsRequest, ListMembershipsResponse>()
                            .withOperationName("ListMemberships").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMembershipsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listMembershipsRequest));
            CompletableFuture<ListMembershipsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to view currently configured tags on a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to add a tag(s) to a designated resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to remove a tag(s) from a designate resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ConflictException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to update an existing case.
     * </p>
     *
     * @param updateCaseRequest
     * @return A Java Future containing the result of the UpdateCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCaseResponse> updateCase(UpdateCaseRequest updateCaseRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCase");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateCaseResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCaseResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCaseRequest, UpdateCaseResponse>().withOperationName("UpdateCase")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCaseRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCaseRequest));
            CompletableFuture<UpdateCaseResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to update an existing case comment.
     * </p>
     *
     * @param updateCaseCommentRequest
     * @return A Java Future containing the result of the UpdateCaseComment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCaseCommentResponse> updateCaseComment(UpdateCaseCommentRequest updateCaseCommentRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCaseCommentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCaseCommentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCaseComment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCaseCommentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCaseCommentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCaseCommentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCaseCommentRequest, UpdateCaseCommentResponse>()
                            .withOperationName("UpdateCaseComment").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCaseCommentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCaseCommentRequest));
            CompletableFuture<UpdateCaseCommentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to update the status for a designated cases. Options include
     * <code>Submitted | Detection and Analysis | Eradication, Containment and Recovery | Post-Incident Activities | Closed</code>
     * .
     * </p>
     *
     * @param updateCaseStatusRequest
     * @return A Java Future containing the result of the UpdateCaseStatus operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateCaseStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateCaseStatusResponse> updateCaseStatus(UpdateCaseStatusRequest updateCaseStatusRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCaseStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCaseStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCaseStatus");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateCaseStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateCaseStatusResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateCaseStatusResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateCaseStatusRequest, UpdateCaseStatusResponse>()
                            .withOperationName("UpdateCaseStatus").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateCaseStatusRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateCaseStatusRequest));
            CompletableFuture<UpdateCaseStatusResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants access to UpdateMembership to change membership configuration.
     * </p>
     *
     * @param updateMembershipRequest
     * @return A Java Future containing the result of the UpdateMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateMembershipResponse> updateMembership(UpdateMembershipRequest updateMembershipRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateMembershipRequest, UpdateMembershipResponse>()
                            .withOperationName("UpdateMembership").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateMembershipRequest));
            CompletableFuture<UpdateMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Grants permission to update the resolver type for a case.
     * </p>
     * <important>
     * <p>
     * This is a one-way action and cannot be reversed.
     * </p>
     * </important>
     * <p>
     * Options include self-supported &gt; AWS-supported.
     * </p>
     *
     * @param updateResolverTypeRequest
     * @return A Java Future containing the result of the UpdateResolverType operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException</li>
     *         <li>AccessDeniedException</li>
     *         <li>ValidationException</li>
     *         <li>SecurityIncidentResponseNotActiveException</li>
     *         <li>InternalServerException</li>
     *         <li>ConflictException</li>
     *         <li>ResourceNotFoundException</li>
     *         <li>ThrottlingException</li>
     *         <li>InvalidTokenException</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>SecurityIrException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample SecurityIrAsyncClient.UpdateResolverType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateResolverType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateResolverTypeResponse> updateResolverType(UpdateResolverTypeRequest updateResolverTypeRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResolverTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResolverTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResolverType");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateResolverTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateResolverTypeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateResolverTypeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateResolverTypeRequest, UpdateResolverTypeResponse>()
                            .withOperationName("UpdateResolverType").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateResolverTypeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .withInput(updateResolverTypeRequest));
            CompletableFuture<UpdateResolverTypeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public final SecurityIrServiceClientConfiguration serviceClientConfiguration() {
        return new SecurityIrServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(SecurityIrException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTokenException")
                                .exceptionBuilderSupplier(InvalidTokenException::builder).httpStatusCode(423).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SecurityIncidentResponseNotActiveException")
                                .exceptionBuilderSupplier(SecurityIncidentResponseNotActiveException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        SecurityIrServiceClientConfigurationBuilder serviceConfigBuilder = new SecurityIrServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
