/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.securityir.internal.SecurityIrServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.securityir.model.AccessDeniedException;
import software.amazon.awssdk.services.securityir.model.BatchGetMemberAccountDetailsRequest;
import software.amazon.awssdk.services.securityir.model.BatchGetMemberAccountDetailsResponse;
import software.amazon.awssdk.services.securityir.model.CancelMembershipRequest;
import software.amazon.awssdk.services.securityir.model.CancelMembershipResponse;
import software.amazon.awssdk.services.securityir.model.CloseCaseRequest;
import software.amazon.awssdk.services.securityir.model.CloseCaseResponse;
import software.amazon.awssdk.services.securityir.model.ConflictException;
import software.amazon.awssdk.services.securityir.model.CreateCaseCommentRequest;
import software.amazon.awssdk.services.securityir.model.CreateCaseCommentResponse;
import software.amazon.awssdk.services.securityir.model.CreateCaseRequest;
import software.amazon.awssdk.services.securityir.model.CreateCaseResponse;
import software.amazon.awssdk.services.securityir.model.CreateMembershipRequest;
import software.amazon.awssdk.services.securityir.model.CreateMembershipResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentDownloadUrlRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentDownloadUrlResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentUploadUrlRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseAttachmentUploadUrlResponse;
import software.amazon.awssdk.services.securityir.model.GetCaseRequest;
import software.amazon.awssdk.services.securityir.model.GetCaseResponse;
import software.amazon.awssdk.services.securityir.model.GetMembershipRequest;
import software.amazon.awssdk.services.securityir.model.GetMembershipResponse;
import software.amazon.awssdk.services.securityir.model.InternalServerException;
import software.amazon.awssdk.services.securityir.model.InvalidTokenException;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsRequest;
import software.amazon.awssdk.services.securityir.model.ListCaseEditsResponse;
import software.amazon.awssdk.services.securityir.model.ListCasesRequest;
import software.amazon.awssdk.services.securityir.model.ListCasesResponse;
import software.amazon.awssdk.services.securityir.model.ListCommentsRequest;
import software.amazon.awssdk.services.securityir.model.ListCommentsResponse;
import software.amazon.awssdk.services.securityir.model.ListMembershipsRequest;
import software.amazon.awssdk.services.securityir.model.ListMembershipsResponse;
import software.amazon.awssdk.services.securityir.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.securityir.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.securityir.model.ResourceNotFoundException;
import software.amazon.awssdk.services.securityir.model.SecurityIncidentResponseNotActiveException;
import software.amazon.awssdk.services.securityir.model.SecurityIrException;
import software.amazon.awssdk.services.securityir.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.securityir.model.TagResourceRequest;
import software.amazon.awssdk.services.securityir.model.TagResourceResponse;
import software.amazon.awssdk.services.securityir.model.ThrottlingException;
import software.amazon.awssdk.services.securityir.model.UntagResourceRequest;
import software.amazon.awssdk.services.securityir.model.UntagResourceResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseCommentRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseCommentResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseResponse;
import software.amazon.awssdk.services.securityir.model.UpdateCaseStatusRequest;
import software.amazon.awssdk.services.securityir.model.UpdateCaseStatusResponse;
import software.amazon.awssdk.services.securityir.model.UpdateMembershipRequest;
import software.amazon.awssdk.services.securityir.model.UpdateMembershipResponse;
import software.amazon.awssdk.services.securityir.model.UpdateResolverTypeRequest;
import software.amazon.awssdk.services.securityir.model.UpdateResolverTypeResponse;
import software.amazon.awssdk.services.securityir.model.ValidationException;
import software.amazon.awssdk.services.securityir.transform.BatchGetMemberAccountDetailsRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.CancelMembershipRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.CloseCaseRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.CreateCaseCommentRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.CreateCaseRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.CreateMembershipRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.GetCaseAttachmentDownloadUrlRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.GetCaseAttachmentUploadUrlRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.GetCaseRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.GetMembershipRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.ListCaseEditsRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.ListCasesRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.ListCommentsRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.ListMembershipsRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UpdateCaseCommentRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UpdateCaseRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UpdateCaseStatusRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UpdateMembershipRequestMarshaller;
import software.amazon.awssdk.services.securityir.transform.UpdateResolverTypeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link SecurityIrClient}.
 *
 * @see SecurityIrClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultSecurityIrClient implements SecurityIrClient {
    private static final Logger log = Logger.loggerFor(DefaultSecurityIrClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultSecurityIrClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Grants permission to view an existing membership.
     * </p>
     *
     * @param batchGetMemberAccountDetailsRequest
     * @return Result of the BatchGetMemberAccountDetails operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.BatchGetMemberAccountDetails
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/BatchGetMemberAccountDetails"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public BatchGetMemberAccountDetailsResponse batchGetMemberAccountDetails(
            BatchGetMemberAccountDetailsRequest batchGetMemberAccountDetailsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchGetMemberAccountDetailsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchGetMemberAccountDetailsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchGetMemberAccountDetailsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchGetMemberAccountDetailsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchGetMemberAccountDetails");

            return clientHandler
                    .execute(new ClientExecutionParams<BatchGetMemberAccountDetailsRequest, BatchGetMemberAccountDetailsResponse>()
                            .withOperationName("BatchGetMemberAccountDetails").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(batchGetMemberAccountDetailsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new BatchGetMemberAccountDetailsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permissions to cancel an existing membership.
     * </p>
     *
     * @param cancelMembershipRequest
     * @return Result of the CancelMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CancelMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CancelMembership" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CancelMembershipResponse cancelMembership(CancelMembershipRequest cancelMembershipRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ConflictException, ResourceNotFoundException,
            ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelMembershipResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelMembershipResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelMembership");

            return clientHandler.execute(new ClientExecutionParams<CancelMembershipRequest, CancelMembershipResponse>()
                    .withOperationName("CancelMembership").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelMembershipRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to close an existing case.
     * </p>
     *
     * @param closeCaseRequest
     * @return Result of the CloseCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CloseCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CloseCase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CloseCaseResponse closeCase(CloseCaseRequest closeCaseRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CloseCaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CloseCaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(closeCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, closeCaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CloseCase");

            return clientHandler.execute(new ClientExecutionParams<CloseCaseRequest, CloseCaseResponse>()
                    .withOperationName("CloseCase").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(closeCaseRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CloseCaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to create a new case.
     * </p>
     *
     * @param createCaseRequest
     * @return Result of the CreateCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CreateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateCaseResponse createCase(CreateCaseRequest createCaseRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCase");

            return clientHandler.execute(new ClientExecutionParams<CreateCaseRequest, CreateCaseResponse>()
                    .withOperationName("CreateCase").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createCaseRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to add a comment to an existing case.
     * </p>
     *
     * @param createCaseCommentRequest
     * @return Result of the CreateCaseComment operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CreateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateCaseCommentResponse createCaseComment(CreateCaseCommentRequest createCaseCommentRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ConflictException, ResourceNotFoundException,
            ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateCaseCommentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateCaseCommentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createCaseCommentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createCaseCommentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateCaseComment");

            return clientHandler.execute(new ClientExecutionParams<CreateCaseCommentRequest, CreateCaseCommentResponse>()
                    .withOperationName("CreateCaseComment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createCaseCommentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateCaseCommentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permissions to create a new membership.
     * </p>
     *
     * @param createMembershipRequest
     * @return Result of the CreateMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.CreateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/CreateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateMembershipResponse createMembership(CreateMembershipRequest createMembershipRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ConflictException, ResourceNotFoundException,
            ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMembershipResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateMembershipResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMembership");

            return clientHandler.execute(new ClientExecutionParams<CreateMembershipRequest, CreateMembershipResponse>()
                    .withOperationName("CreateMembership").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createMembershipRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grant permission to view a designated case.
     * </p>
     *
     * @param getCaseRequest
     * @return Result of the GetCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetCaseResponse getCase(GetCaseRequest getCaseRequest) throws ServiceQuotaExceededException, AccessDeniedException,
            ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException, ConflictException,
            ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException,
            SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetCaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCase");

            return clientHandler.execute(new ClientExecutionParams<GetCaseRequest, GetCaseResponse>()
                    .withOperationName("GetCase").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getCaseRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetCaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to obtain an Amazon S3 presigned URL to download an attachment.
     * </p>
     *
     * @param getCaseAttachmentDownloadUrlRequest
     * @return Result of the GetCaseAttachmentDownloadUrl operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetCaseAttachmentDownloadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentDownloadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCaseAttachmentDownloadUrlResponse getCaseAttachmentDownloadUrl(
            GetCaseAttachmentDownloadUrlRequest getCaseAttachmentDownloadUrlRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCaseAttachmentDownloadUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCaseAttachmentDownloadUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCaseAttachmentDownloadUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCaseAttachmentDownloadUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCaseAttachmentDownloadUrl");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCaseAttachmentDownloadUrlRequest, GetCaseAttachmentDownloadUrlResponse>()
                            .withOperationName("GetCaseAttachmentDownloadUrl").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCaseAttachmentDownloadUrlRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCaseAttachmentDownloadUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to upload an attachment to a case.
     * </p>
     *
     * @param getCaseAttachmentUploadUrlRequest
     * @return Result of the GetCaseAttachmentUploadUrl operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetCaseAttachmentUploadUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetCaseAttachmentUploadUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetCaseAttachmentUploadUrlResponse getCaseAttachmentUploadUrl(
            GetCaseAttachmentUploadUrlRequest getCaseAttachmentUploadUrlRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetCaseAttachmentUploadUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetCaseAttachmentUploadUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getCaseAttachmentUploadUrlRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getCaseAttachmentUploadUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetCaseAttachmentUploadUrl");

            return clientHandler
                    .execute(new ClientExecutionParams<GetCaseAttachmentUploadUrlRequest, GetCaseAttachmentUploadUrlResponse>()
                            .withOperationName("GetCaseAttachmentUploadUrl").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getCaseAttachmentUploadUrlRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetCaseAttachmentUploadUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to get details of a designated service membership.
     * </p>
     *
     * @param getMembershipRequest
     * @return Result of the GetMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.GetMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/GetMembership" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetMembershipResponse getMembership(GetMembershipRequest getMembershipRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetMembershipResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetMembershipResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getMembershipRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetMembership");

            return clientHandler.execute(new ClientExecutionParams<GetMembershipRequest, GetMembershipResponse>()
                    .withOperationName("GetMembership").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getMembershipRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permissions to view the aidt log for edits made to a designated case.
     * </p>
     *
     * @param listCaseEditsRequest
     * @return Result of the ListCaseEdits operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListCaseEdits
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCaseEdits" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCaseEditsResponse listCaseEdits(ListCaseEditsRequest listCaseEditsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCaseEditsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCaseEditsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCaseEditsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCaseEditsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCaseEdits");

            return clientHandler.execute(new ClientExecutionParams<ListCaseEditsRequest, ListCaseEditsResponse>()
                    .withOperationName("ListCaseEdits").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCaseEditsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCaseEditsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to list all cases the requester has access to.
     * </p>
     *
     * @param listCasesRequest
     * @return Result of the ListCases operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListCases" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCasesResponse listCases(ListCasesRequest listCasesRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCasesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListCases");

            return clientHandler.execute(new ClientExecutionParams<ListCasesRequest, ListCasesResponse>()
                    .withOperationName("ListCases").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listCasesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permissions to list and view comments for a designated case.
     * </p>
     *
     * @param listCommentsRequest
     * @return Result of the ListComments operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListComments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListComments" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListCommentsResponse listComments(ListCommentsRequest listCommentsRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListCommentsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListCommentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listCommentsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listCommentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListComments");

            return clientHandler.execute(new ClientExecutionParams<ListCommentsRequest, ListCommentsResponse>()
                    .withOperationName("ListComments").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listCommentsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListCommentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to query the memberships a principal has access to.
     * </p>
     *
     * @param listMembershipsRequest
     * @return Result of the ListMemberships operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListMemberships" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListMembershipsResponse listMemberships(ListMembershipsRequest listMembershipsRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ConflictException, ResourceNotFoundException,
            ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMembershipsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListMembershipsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMembershipsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMembershipsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMemberships");

            return clientHandler.execute(new ClientExecutionParams<ListMembershipsRequest, ListMembershipsResponse>()
                    .withOperationName("ListMemberships").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listMembershipsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListMembershipsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to view currently configured tags on a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ResourceNotFoundException
     * @throws ConflictException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ResourceNotFoundException, ConflictException,
            ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to add a tag(s) to a designated resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ResourceNotFoundException
     * @throws ConflictException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to remove a tag(s) from a designate resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ResourceNotFoundException
     * @throws ConflictException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ResourceNotFoundException, ConflictException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to update an existing case.
     * </p>
     *
     * @param updateCaseRequest
     * @return Result of the UpdateCase operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCase" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateCaseResponse updateCase(UpdateCaseRequest updateCaseRequest) throws ServiceQuotaExceededException,
            AccessDeniedException, ValidationException, SecurityIncidentResponseNotActiveException, InternalServerException,
            ConflictException, ResourceNotFoundException, ThrottlingException, InvalidTokenException, AwsServiceException,
            SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCaseResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateCaseResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCaseRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCaseRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCase");

            return clientHandler.execute(new ClientExecutionParams<UpdateCaseRequest, UpdateCaseResponse>()
                    .withOperationName("UpdateCase").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateCaseRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCaseRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to update an existing case comment.
     * </p>
     *
     * @param updateCaseCommentRequest
     * @return Result of the UpdateCaseComment operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateCaseComment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseComment" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateCaseCommentResponse updateCaseComment(UpdateCaseCommentRequest updateCaseCommentRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ConflictException, ResourceNotFoundException,
            ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCaseCommentResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateCaseCommentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCaseCommentRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCaseCommentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCaseComment");

            return clientHandler.execute(new ClientExecutionParams<UpdateCaseCommentRequest, UpdateCaseCommentResponse>()
                    .withOperationName("UpdateCaseComment").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCaseCommentRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCaseCommentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to update the status for a designated cases. Options include
     * <code>Submitted | Detection and Analysis | Eradication, Containment and Recovery | Post-Incident Activities | Closed</code>
     * .
     * </p>
     *
     * @param updateCaseStatusRequest
     * @return Result of the UpdateCaseStatus operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateCaseStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateCaseStatus" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateCaseStatusResponse updateCaseStatus(UpdateCaseStatusRequest updateCaseStatusRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ConflictException, ResourceNotFoundException,
            ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateCaseStatusResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateCaseStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateCaseStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateCaseStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateCaseStatus");

            return clientHandler.execute(new ClientExecutionParams<UpdateCaseStatusRequest, UpdateCaseStatusResponse>()
                    .withOperationName("UpdateCaseStatus").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateCaseStatusRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateCaseStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants access to UpdateMembership to change membership configuration.
     * </p>
     *
     * @param updateMembershipRequest
     * @return Result of the UpdateMembership operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateMembership" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateMembershipResponse updateMembership(UpdateMembershipRequest updateMembershipRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ConflictException, ResourceNotFoundException,
            ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateMembershipResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateMembershipResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateMembershipRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateMembership");

            return clientHandler.execute(new ClientExecutionParams<UpdateMembershipRequest, UpdateMembershipResponse>()
                    .withOperationName("UpdateMembership").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateMembershipRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Grants permission to update the resolver type for a case.
     * </p>
     * <important>
     * <p>
     * This is a one-way action and cannot be reversed.
     * </p>
     * </important>
     * <p>
     * Options include self-supported &gt; AWS-supported.
     * </p>
     *
     * @param updateResolverTypeRequest
     * @return Result of the UpdateResolverType operation returned by the service.
     * @throws ServiceQuotaExceededException
     * @throws AccessDeniedException
     * @throws ValidationException
     * @throws SecurityIncidentResponseNotActiveException
     * @throws InternalServerException
     * @throws ConflictException
     * @throws ResourceNotFoundException
     * @throws ThrottlingException
     * @throws InvalidTokenException
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws SecurityIrException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample SecurityIrClient.UpdateResolverType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/security-ir-2018-05-10/UpdateResolverType"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateResolverTypeResponse updateResolverType(UpdateResolverTypeRequest updateResolverTypeRequest)
            throws ServiceQuotaExceededException, AccessDeniedException, ValidationException,
            SecurityIncidentResponseNotActiveException, InternalServerException, ConflictException, ResourceNotFoundException,
            ThrottlingException, InvalidTokenException, AwsServiceException, SdkClientException, SecurityIrException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResolverTypeResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateResolverTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResolverTypeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResolverTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Security IR");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResolverType");

            return clientHandler.execute(new ClientExecutionParams<UpdateResolverTypeRequest, UpdateResolverTypeResponse>()
                    .withOperationName("UpdateResolverType").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateResolverTypeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateResolverTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        SecurityIrServiceClientConfigurationBuilder serviceConfigBuilder = new SecurityIrServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(SecurityIrException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidTokenException")
                                .exceptionBuilderSupplier(InvalidTokenException::builder).httpStatusCode(423).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SecurityIncidentResponseNotActiveException")
                                .exceptionBuilderSupplier(SecurityIncidentResponseNotActiveException::builder)
                                .httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ValidationException")
                                .exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException")
                                .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(402).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalServerException")
                                .exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(500).build());
    }

    @Override
    public final SecurityIrServiceClientConfiguration serviceClientConfiguration() {
        return new SecurityIrServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
