/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateMembershipRequest extends SecurityIrRequest implements
        ToCopyableBuilder<CreateMembershipRequest.Builder, CreateMembershipRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateMembershipRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> MEMBERSHIP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipName").getter(getter(CreateMembershipRequest::membershipName))
            .setter(setter(Builder::membershipName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipName").build()).build();

    private static final SdkField<List<IncidentResponder>> INCIDENT_RESPONSE_TEAM_FIELD = SdkField
            .<List<IncidentResponder>> builder(MarshallingType.LIST)
            .memberName("incidentResponseTeam")
            .getter(getter(CreateMembershipRequest::incidentResponseTeam))
            .setter(setter(Builder::incidentResponseTeam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentResponseTeam").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<IncidentResponder> builder(MarshallingType.SDK_POJO)
                                            .constructor(IncidentResponder::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<OptInFeature>> OPT_IN_FEATURES_FIELD = SdkField
            .<List<OptInFeature>> builder(MarshallingType.LIST)
            .memberName("optInFeatures")
            .getter(getter(CreateMembershipRequest::optInFeatures))
            .setter(setter(Builder::optInFeatures))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optInFeatures").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OptInFeature> builder(MarshallingType.SDK_POJO)
                                            .constructor(OptInFeature::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateMembershipRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            MEMBERSHIP_NAME_FIELD, INCIDENT_RESPONSE_TEAM_FIELD, OPT_IN_FEATURES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String membershipName;

    private final List<IncidentResponder> incidentResponseTeam;

    private final List<OptInFeature> optInFeatures;

    private final Map<String, String> tags;

    private CreateMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.membershipName = builder.membershipName;
        this.incidentResponseTeam = builder.incidentResponseTeam;
        this.optInFeatures = builder.optInFeatures;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * An optional element used in combination with CreateMembership.
     * </p>
     * 
     * @return An optional element used in combination with CreateMembership.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Required element use in combination with CreateMembership to create a name for the membership.
     * </p>
     * 
     * @return Required element use in combination with CreateMembership to create a name for the membership.
     */
    public final String membershipName() {
        return membershipName;
    }

    /**
     * For responses, this returns true if the service returned a value for the IncidentResponseTeam property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasIncidentResponseTeam() {
        return incidentResponseTeam != null && !(incidentResponseTeam instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Required element use in combination with CreateMembership to add customer incident response team members and
     * trusted partners to the membership.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIncidentResponseTeam} method.
     * </p>
     * 
     * @return Required element use in combination with CreateMembership to add customer incident response team members
     *         and trusted partners to the membership.
     */
    public final List<IncidentResponder> incidentResponseTeam() {
        return incidentResponseTeam;
    }

    /**
     * For responses, this returns true if the service returned a value for the OptInFeatures property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOptInFeatures() {
        return optInFeatures != null && !(optInFeatures instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element to enable the monitoring and investigation opt-in features for the service.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOptInFeatures} method.
     * </p>
     * 
     * @return Optional element to enable the monitoring and investigation opt-in features for the service.
     */
    public final List<OptInFeature> optInFeatures() {
        return optInFeatures;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional element for customer configured tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Optional element for customer configured tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(membershipName());
        hashCode = 31 * hashCode + Objects.hashCode(hasIncidentResponseTeam() ? incidentResponseTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOptInFeatures() ? optInFeatures() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMembershipRequest)) {
            return false;
        }
        CreateMembershipRequest other = (CreateMembershipRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(membershipName(), other.membershipName())
                && hasIncidentResponseTeam() == other.hasIncidentResponseTeam()
                && Objects.equals(incidentResponseTeam(), other.incidentResponseTeam())
                && hasOptInFeatures() == other.hasOptInFeatures() && Objects.equals(optInFeatures(), other.optInFeatures())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateMembershipRequest").add("ClientToken", clientToken())
                .add("MembershipName", membershipName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("IncidentResponseTeam", hasIncidentResponseTeam() ? incidentResponseTeam() : null)
                .add("OptInFeatures", hasOptInFeatures() ? optInFeatures() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "membershipName":
            return Optional.ofNullable(clazz.cast(membershipName()));
        case "incidentResponseTeam":
            return Optional.ofNullable(clazz.cast(incidentResponseTeam()));
        case "optInFeatures":
            return Optional.ofNullable(clazz.cast(optInFeatures()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("membershipName", MEMBERSHIP_NAME_FIELD);
        map.put("incidentResponseTeam", INCIDENT_RESPONSE_TEAM_FIELD);
        map.put("optInFeatures", OPT_IN_FEATURES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMembershipRequest, T> g) {
        return obj -> g.apply((CreateMembershipRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityIrRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateMembershipRequest> {
        /**
         * <p>
         * An optional element used in combination with CreateMembership.
         * </p>
         * 
         * @param clientToken
         *        An optional element used in combination with CreateMembership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Required element use in combination with CreateMembership to create a name for the membership.
         * </p>
         * 
         * @param membershipName
         *        Required element use in combination with CreateMembership to create a name for the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder membershipName(String membershipName);

        /**
         * <p>
         * Required element use in combination with CreateMembership to add customer incident response team members and
         * trusted partners to the membership.
         * </p>
         * 
         * @param incidentResponseTeam
         *        Required element use in combination with CreateMembership to add customer incident response team
         *        members and trusted partners to the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentResponseTeam(Collection<IncidentResponder> incidentResponseTeam);

        /**
         * <p>
         * Required element use in combination with CreateMembership to add customer incident response team members and
         * trusted partners to the membership.
         * </p>
         * 
         * @param incidentResponseTeam
         *        Required element use in combination with CreateMembership to add customer incident response team
         *        members and trusted partners to the membership.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder incidentResponseTeam(IncidentResponder... incidentResponseTeam);

        /**
         * <p>
         * Required element use in combination with CreateMembership to add customer incident response team members and
         * trusted partners to the membership.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.IncidentResponder.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityir.model.IncidentResponder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.IncidentResponder.Builder#build()} is called
         * immediately and its result is passed to {@link #incidentResponseTeam(List<IncidentResponder>)}.
         * 
         * @param incidentResponseTeam
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.IncidentResponder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #incidentResponseTeam(java.util.Collection<IncidentResponder>)
         */
        Builder incidentResponseTeam(Consumer<IncidentResponder.Builder>... incidentResponseTeam);

        /**
         * <p>
         * Optional element to enable the monitoring and investigation opt-in features for the service.
         * </p>
         * 
         * @param optInFeatures
         *        Optional element to enable the monitoring and investigation opt-in features for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optInFeatures(Collection<OptInFeature> optInFeatures);

        /**
         * <p>
         * Optional element to enable the monitoring and investigation opt-in features for the service.
         * </p>
         * 
         * @param optInFeatures
         *        Optional element to enable the monitoring and investigation opt-in features for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder optInFeatures(OptInFeature... optInFeatures);

        /**
         * <p>
         * Optional element to enable the monitoring and investigation opt-in features for the service.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.OptInFeature.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityir.model.OptInFeature#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.OptInFeature.Builder#build()} is called immediately
         * and its result is passed to {@link #optInFeatures(List<OptInFeature>)}.
         * 
         * @param optInFeatures
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.OptInFeature.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #optInFeatures(java.util.Collection<OptInFeature>)
         */
        Builder optInFeatures(Consumer<OptInFeature.Builder>... optInFeatures);

        /**
         * <p>
         * Optional element for customer configured tags.
         * </p>
         * 
         * @param tags
         *        Optional element for customer configured tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityIrRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String membershipName;

        private List<IncidentResponder> incidentResponseTeam = DefaultSdkAutoConstructList.getInstance();

        private List<OptInFeature> optInFeatures = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMembershipRequest model) {
            super(model);
            clientToken(model.clientToken);
            membershipName(model.membershipName);
            incidentResponseTeam(model.incidentResponseTeam);
            optInFeatures(model.optInFeatures);
            tags(model.tags);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getMembershipName() {
            return membershipName;
        }

        public final void setMembershipName(String membershipName) {
            this.membershipName = membershipName;
        }

        @Override
        public final Builder membershipName(String membershipName) {
            this.membershipName = membershipName;
            return this;
        }

        public final List<IncidentResponder.Builder> getIncidentResponseTeam() {
            List<IncidentResponder.Builder> result = IncidentResponseTeamCopier.copyToBuilder(this.incidentResponseTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncidentResponseTeam(Collection<IncidentResponder.BuilderImpl> incidentResponseTeam) {
            this.incidentResponseTeam = IncidentResponseTeamCopier.copyFromBuilder(incidentResponseTeam);
        }

        @Override
        public final Builder incidentResponseTeam(Collection<IncidentResponder> incidentResponseTeam) {
            this.incidentResponseTeam = IncidentResponseTeamCopier.copy(incidentResponseTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentResponseTeam(IncidentResponder... incidentResponseTeam) {
            incidentResponseTeam(Arrays.asList(incidentResponseTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentResponseTeam(Consumer<IncidentResponder.Builder>... incidentResponseTeam) {
            incidentResponseTeam(Stream.of(incidentResponseTeam).map(c -> IncidentResponder.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<OptInFeature.Builder> getOptInFeatures() {
            List<OptInFeature.Builder> result = OptInFeaturesCopier.copyToBuilder(this.optInFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptInFeatures(Collection<OptInFeature.BuilderImpl> optInFeatures) {
            this.optInFeatures = OptInFeaturesCopier.copyFromBuilder(optInFeatures);
        }

        @Override
        public final Builder optInFeatures(Collection<OptInFeature> optInFeatures) {
            this.optInFeatures = OptInFeaturesCopier.copy(optInFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optInFeatures(OptInFeature... optInFeatures) {
            optInFeatures(Arrays.asList(optInFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optInFeatures(Consumer<OptInFeature.Builder>... optInFeatures) {
            optInFeatures(Stream.of(optInFeatures).map(c -> OptInFeature.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMembershipRequest build() {
            return new CreateMembershipRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
