/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCaseAttachmentUploadUrlRequest extends SecurityIrRequest implements
        ToCopyableBuilder<GetCaseAttachmentUploadUrlRequest.Builder, GetCaseAttachmentUploadUrlRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caseId")
            .getter(getter(GetCaseAttachmentUploadUrlRequest::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileName").getter(getter(GetCaseAttachmentUploadUrlRequest::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()).build();

    private static final SdkField<Long> CONTENT_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("contentLength").getter(getter(GetCaseAttachmentUploadUrlRequest::contentLength))
            .setter(setter(Builder::contentLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLength").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(GetCaseAttachmentUploadUrlRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD,
            FILE_NAME_FIELD, CONTENT_LENGTH_FIELD, CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String caseId;

    private final String fileName;

    private final Long contentLength;

    private final String clientToken;

    private GetCaseAttachmentUploadUrlRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.fileName = builder.fileName;
        this.contentLength = builder.contentLength;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * Required element for GetCaseAttachmentUploadUrl to identify the case ID for uploading an attachment to.
     * </p>
     * 
     * @return Required element for GetCaseAttachmentUploadUrl to identify the case ID for uploading an attachment to.
     */
    public final String caseId() {
        return caseId;
    }

    /**
     * <p>
     * Required element for GetCaseAttachmentUploadUrl to identify the file name of the attachment to upload.
     * </p>
     * 
     * @return Required element for GetCaseAttachmentUploadUrl to identify the file name of the attachment to upload.
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p>
     * Required element for GetCaseAttachmentUploadUrl to identify the size od the file attachment.
     * </p>
     * 
     * @return Required element for GetCaseAttachmentUploadUrl to identify the size od the file attachment.
     */
    public final Long contentLength() {
        return contentLength;
    }

    /**
     * <p>
     * Optional element for customer provided token.
     * </p>
     * 
     * @return Optional element for customer provided token.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(contentLength());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCaseAttachmentUploadUrlRequest)) {
            return false;
        }
        GetCaseAttachmentUploadUrlRequest other = (GetCaseAttachmentUploadUrlRequest) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(fileName(), other.fileName())
                && Objects.equals(contentLength(), other.contentLength()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCaseAttachmentUploadUrlRequest").add("CaseId", caseId())
                .add("FileName", fileName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ContentLength", contentLength()).add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "fileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "contentLength":
            return Optional.ofNullable(clazz.cast(contentLength()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("fileName", FILE_NAME_FIELD);
        map.put("contentLength", CONTENT_LENGTH_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCaseAttachmentUploadUrlRequest, T> g) {
        return obj -> g.apply((GetCaseAttachmentUploadUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityIrRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetCaseAttachmentUploadUrlRequest> {
        /**
         * <p>
         * Required element for GetCaseAttachmentUploadUrl to identify the case ID for uploading an attachment to.
         * </p>
         * 
         * @param caseId
         *        Required element for GetCaseAttachmentUploadUrl to identify the case ID for uploading an attachment
         *        to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * Required element for GetCaseAttachmentUploadUrl to identify the file name of the attachment to upload.
         * </p>
         * 
         * @param fileName
         *        Required element for GetCaseAttachmentUploadUrl to identify the file name of the attachment to upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p>
         * Required element for GetCaseAttachmentUploadUrl to identify the size od the file attachment.
         * </p>
         * 
         * @param contentLength
         *        Required element for GetCaseAttachmentUploadUrl to identify the size od the file attachment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLength(Long contentLength);

        /**
         * <p>
         * Optional element for customer provided token.
         * </p>
         * 
         * @param clientToken
         *        Optional element for customer provided token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityIrRequest.BuilderImpl implements Builder {
        private String caseId;

        private String fileName;

        private Long contentLength;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCaseAttachmentUploadUrlRequest model) {
            super(model);
            caseId(model.caseId);
            fileName(model.fileName);
            contentLength(model.contentLength);
            clientToken(model.clientToken);
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final Long getContentLength() {
            return contentLength;
        }

        public final void setContentLength(Long contentLength) {
            this.contentLength = contentLength;
        }

        @Override
        public final Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetCaseAttachmentUploadUrlRequest build() {
            return new GetCaseAttachmentUploadUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
