/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCaseResponse extends SecurityIrResponse implements
        ToCopyableBuilder<GetCaseResponse.Builder, GetCaseResponse> {
    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(GetCaseResponse::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> CASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseArn").getter(getter(GetCaseResponse::caseArn)).setter(setter(Builder::caseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseArn").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetCaseResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CASE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseStatus").getter(getter(GetCaseResponse::caseStatusAsString)).setter(setter(Builder::caseStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseStatus").build()).build();

    private static final SdkField<String> ENGAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engagementType").getter(getter(GetCaseResponse::engagementTypeAsString))
            .setter(setter(Builder::engagementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagementType").build()).build();

    private static final SdkField<Instant> REPORTED_INCIDENT_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("reportedIncidentStartDate")
            .getter(getter(GetCaseResponse::reportedIncidentStartDate)).setter(setter(Builder::reportedIncidentStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportedIncidentStartDate").build())
            .build();

    private static final SdkField<Instant> ACTUAL_INCIDENT_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("actualIncidentStartDate").getter(getter(GetCaseResponse::actualIncidentStartDate))
            .setter(setter(Builder::actualIncidentStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualIncidentStartDate").build())
            .build();

    private static final SdkField<List<ImpactedAwsRegion>> IMPACTED_AWS_REGIONS_FIELD = SdkField
            .<List<ImpactedAwsRegion>> builder(MarshallingType.LIST)
            .memberName("impactedAwsRegions")
            .getter(getter(GetCaseResponse::impactedAwsRegions))
            .setter(setter(Builder::impactedAwsRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAwsRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImpactedAwsRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImpactedAwsRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ThreatActorIp>> THREAT_ACTOR_IP_ADDRESSES_FIELD = SdkField
            .<List<ThreatActorIp>> builder(MarshallingType.LIST)
            .memberName("threatActorIpAddresses")
            .getter(getter(GetCaseResponse::threatActorIpAddresses))
            .setter(setter(Builder::threatActorIpAddresses))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatActorIpAddresses").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThreatActorIp> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThreatActorIp::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PENDING_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pendingAction").getter(getter(GetCaseResponse::pendingActionAsString))
            .setter(setter(Builder::pendingAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingAction").build()).build();

    private static final SdkField<List<String>> IMPACTED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("impactedAccounts")
            .getter(getter(GetCaseResponse::impactedAccounts))
            .setter(setter(Builder::impactedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Watcher>> WATCHERS_FIELD = SdkField
            .<List<Watcher>> builder(MarshallingType.LIST)
            .memberName("watchers")
            .getter(getter(GetCaseResponse::watchers))
            .setter(setter(Builder::watchers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("watchers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Watcher> builder(MarshallingType.SDK_POJO)
                                            .constructor(Watcher::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(GetCaseResponse::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate").getter(getter(GetCaseResponse::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final SdkField<String> CLOSURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("closureCode").getter(getter(GetCaseResponse::closureCodeAsString)).setter(setter(Builder::closureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closureCode").build()).build();

    private static final SdkField<String> RESOLVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolverType").getter(getter(GetCaseResponse::resolverTypeAsString))
            .setter(setter(Builder::resolverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverType").build()).build();

    private static final SdkField<List<String>> IMPACTED_SERVICES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("impactedServices")
            .getter(getter(GetCaseResponse::impactedServices))
            .setter(setter(Builder::impactedServices))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedServices").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CaseAttachmentAttributes>> CASE_ATTACHMENTS_FIELD = SdkField
            .<List<CaseAttachmentAttributes>> builder(MarshallingType.LIST)
            .memberName("caseAttachments")
            .getter(getter(GetCaseResponse::caseAttachments))
            .setter(setter(Builder::caseAttachments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseAttachments").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CaseAttachmentAttributes> builder(MarshallingType.SDK_POJO)
                                            .constructor(CaseAttachmentAttributes::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> CLOSED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("closedDate").getter(getter(GetCaseResponse::closedDate)).setter(setter(Builder::closedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, CASE_ARN_FIELD,
            DESCRIPTION_FIELD, CASE_STATUS_FIELD, ENGAGEMENT_TYPE_FIELD, REPORTED_INCIDENT_START_DATE_FIELD,
            ACTUAL_INCIDENT_START_DATE_FIELD, IMPACTED_AWS_REGIONS_FIELD, THREAT_ACTOR_IP_ADDRESSES_FIELD, PENDING_ACTION_FIELD,
            IMPACTED_ACCOUNTS_FIELD, WATCHERS_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD, CLOSURE_CODE_FIELD,
            RESOLVER_TYPE_FIELD, IMPACTED_SERVICES_FIELD, CASE_ATTACHMENTS_FIELD, CLOSED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String title;

    private final String caseArn;

    private final String description;

    private final String caseStatus;

    private final String engagementType;

    private final Instant reportedIncidentStartDate;

    private final Instant actualIncidentStartDate;

    private final List<ImpactedAwsRegion> impactedAwsRegions;

    private final List<ThreatActorIp> threatActorIpAddresses;

    private final String pendingAction;

    private final List<String> impactedAccounts;

    private final List<Watcher> watchers;

    private final Instant createdDate;

    private final Instant lastUpdatedDate;

    private final String closureCode;

    private final String resolverType;

    private final List<String> impactedServices;

    private final List<CaseAttachmentAttributes> caseAttachments;

    private final Instant closedDate;

    private GetCaseResponse(BuilderImpl builder) {
        super(builder);
        this.title = builder.title;
        this.caseArn = builder.caseArn;
        this.description = builder.description;
        this.caseStatus = builder.caseStatus;
        this.engagementType = builder.engagementType;
        this.reportedIncidentStartDate = builder.reportedIncidentStartDate;
        this.actualIncidentStartDate = builder.actualIncidentStartDate;
        this.impactedAwsRegions = builder.impactedAwsRegions;
        this.threatActorIpAddresses = builder.threatActorIpAddresses;
        this.pendingAction = builder.pendingAction;
        this.impactedAccounts = builder.impactedAccounts;
        this.watchers = builder.watchers;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.closureCode = builder.closureCode;
        this.resolverType = builder.resolverType;
        this.impactedServices = builder.impactedServices;
        this.caseAttachments = builder.caseAttachments;
        this.closedDate = builder.closedDate;
    }

    /**
     * <p>
     * Response element for GetCase that provides the case title.
     * </p>
     * 
     * @return Response element for GetCase that provides the case title.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Response element for GetCase that provides the case ARN
     * </p>
     * 
     * @return Response element for GetCase that provides the case ARN
     */
    public final String caseArn() {
        return caseArn;
    }

    /**
     * <p>
     * Response element for GetCase that provides contents of the case description.
     * </p>
     * 
     * @return Response element for GetCase that provides contents of the case description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Response element for GetCase that provides the case status. Options for statuses include
     * <code>Submitted | Detection and Analysis | Eradication, Containment and Recovery | Post-Incident Activities | Closed </code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #caseStatus} will
     * return {@link CaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #caseStatusAsString}.
     * </p>
     * 
     * @return Response element for GetCase that provides the case status. Options for statuses include
     *         <code>Submitted | Detection and Analysis | Eradication, Containment and Recovery | Post-Incident Activities | Closed </code>
     * @see CaseStatus
     */
    public final CaseStatus caseStatus() {
        return CaseStatus.fromValue(caseStatus);
    }

    /**
     * <p>
     * Response element for GetCase that provides the case status. Options for statuses include
     * <code>Submitted | Detection and Analysis | Eradication, Containment and Recovery | Post-Incident Activities | Closed </code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #caseStatus} will
     * return {@link CaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #caseStatusAsString}.
     * </p>
     * 
     * @return Response element for GetCase that provides the case status. Options for statuses include
     *         <code>Submitted | Detection and Analysis | Eradication, Containment and Recovery | Post-Incident Activities | Closed </code>
     * @see CaseStatus
     */
    public final String caseStatusAsString() {
        return caseStatus;
    }

    /**
     * <p>
     * Response element for GetCase that provides the engagement type. Options for engagement type include
     * <code>Active Security Event | Investigations</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementType}
     * will return {@link EngagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #engagementTypeAsString}.
     * </p>
     * 
     * @return Response element for GetCase that provides the engagement type. Options for engagement type include
     *         <code>Active Security Event | Investigations</code>
     * @see EngagementType
     */
    public final EngagementType engagementType() {
        return EngagementType.fromValue(engagementType);
    }

    /**
     * <p>
     * Response element for GetCase that provides the engagement type. Options for engagement type include
     * <code>Active Security Event | Investigations</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementType}
     * will return {@link EngagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #engagementTypeAsString}.
     * </p>
     * 
     * @return Response element for GetCase that provides the engagement type. Options for engagement type include
     *         <code>Active Security Event | Investigations</code>
     * @see EngagementType
     */
    public final String engagementTypeAsString() {
        return engagementType;
    }

    /**
     * <p>
     * Response element for GetCase that provides the customer provided incident start date.
     * </p>
     * 
     * @return Response element for GetCase that provides the customer provided incident start date.
     */
    public final Instant reportedIncidentStartDate() {
        return reportedIncidentStartDate;
    }

    /**
     * <p>
     * Response element for GetCase that provides the actual incident start date as identified by data analysis during
     * the investigation.
     * </p>
     * 
     * @return Response element for GetCase that provides the actual incident start date as identified by data analysis
     *         during the investigation.
     */
    public final Instant actualIncidentStartDate() {
        return actualIncidentStartDate;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedAwsRegions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImpactedAwsRegions() {
        return impactedAwsRegions != null && !(impactedAwsRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Response element for GetCase that provides the impacted regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedAwsRegions} method.
     * </p>
     * 
     * @return Response element for GetCase that provides the impacted regions.
     */
    public final List<ImpactedAwsRegion> impactedAwsRegions() {
        return impactedAwsRegions;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThreatActorIpAddresses property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasThreatActorIpAddresses() {
        return threatActorIpAddresses != null && !(threatActorIpAddresses instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Response element for GetCase that provides a list of suspicious IP addresses associated with unauthorized
     * activity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThreatActorIpAddresses} method.
     * </p>
     * 
     * @return Response element for GetCase that provides a list of suspicious IP addresses associated with unauthorized
     *         activity.
     */
    public final List<ThreatActorIp> threatActorIpAddresses() {
        return threatActorIpAddresses;
    }

    /**
     * <p>
     * Response element for GetCase that provides identifies the case is waiting on customer input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pendingAction}
     * will return {@link PendingAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pendingActionAsString}.
     * </p>
     * 
     * @return Response element for GetCase that provides identifies the case is waiting on customer input.
     * @see PendingAction
     */
    public final PendingAction pendingAction() {
        return PendingAction.fromValue(pendingAction);
    }

    /**
     * <p>
     * Response element for GetCase that provides identifies the case is waiting on customer input.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pendingAction}
     * will return {@link PendingAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pendingActionAsString}.
     * </p>
     * 
     * @return Response element for GetCase that provides identifies the case is waiting on customer input.
     * @see PendingAction
     */
    public final String pendingActionAsString() {
        return pendingAction;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedAccounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImpactedAccounts() {
        return impactedAccounts != null && !(impactedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Response element for GetCase that provides a list of impacted accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedAccounts} method.
     * </p>
     * 
     * @return Response element for GetCase that provides a list of impacted accounts.
     */
    public final List<String> impactedAccounts() {
        return impactedAccounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Watchers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWatchers() {
        return watchers != null && !(watchers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Response element for GetCase that provides a list of Watchers added to the case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWatchers} method.
     * </p>
     * 
     * @return Response element for GetCase that provides a list of Watchers added to the case.
     */
    public final List<Watcher> watchers() {
        return watchers;
    }

    /**
     * <p>
     * Response element for GetCase that provides the date the case was created.
     * </p>
     * 
     * @return Response element for GetCase that provides the date the case was created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * Response element for GetCase that provides the date a case was last modified.
     * </p>
     * 
     * @return Response element for GetCase that provides the date a case was last modified.
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p>
     * Response element for GetCase that provides the summary code for why a case was closed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #closureCode} will
     * return {@link ClosureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #closureCodeAsString}.
     * </p>
     * 
     * @return Response element for GetCase that provides the summary code for why a case was closed.
     * @see ClosureCode
     */
    public final ClosureCode closureCode() {
        return ClosureCode.fromValue(closureCode);
    }

    /**
     * <p>
     * Response element for GetCase that provides the summary code for why a case was closed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #closureCode} will
     * return {@link ClosureCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #closureCodeAsString}.
     * </p>
     * 
     * @return Response element for GetCase that provides the summary code for why a case was closed.
     * @see ClosureCode
     */
    public final String closureCodeAsString() {
        return closureCode;
    }

    /**
     * <p>
     * Response element for GetCase that provides the current resolver types. Options include
     * <code> self-supported | AWS-supported</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolverType} will
     * return {@link ResolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolverTypeAsString}.
     * </p>
     * 
     * @return Response element for GetCase that provides the current resolver types. Options include
     *         <code> self-supported | AWS-supported</code>.
     * @see ResolverType
     */
    public final ResolverType resolverType() {
        return ResolverType.fromValue(resolverType);
    }

    /**
     * <p>
     * Response element for GetCase that provides the current resolver types. Options include
     * <code> self-supported | AWS-supported</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolverType} will
     * return {@link ResolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolverTypeAsString}.
     * </p>
     * 
     * @return Response element for GetCase that provides the current resolver types. Options include
     *         <code> self-supported | AWS-supported</code>.
     * @see ResolverType
     */
    public final String resolverTypeAsString() {
        return resolverType;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedServices property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImpactedServices() {
        return impactedServices != null && !(impactedServices instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Response element for GetCase that provides a list of impacted services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedServices} method.
     * </p>
     * 
     * @return Response element for GetCase that provides a list of impacted services.
     */
    public final List<String> impactedServices() {
        return impactedServices;
    }

    /**
     * For responses, this returns true if the service returned a value for the CaseAttachments property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCaseAttachments() {
        return caseAttachments != null && !(caseAttachments instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Response element for GetCase that provides a list of current case attachments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCaseAttachments} method.
     * </p>
     * 
     * @return Response element for GetCase that provides a list of current case attachments.
     */
    public final List<CaseAttachmentAttributes> caseAttachments() {
        return caseAttachments;
    }

    /**
     * <p>
     * Response element for GetCase that provides the date a specified case was closed.
     * </p>
     * 
     * @return Response element for GetCase that provides the date a specified case was closed.
     */
    public final Instant closedDate() {
        return closedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(caseArn());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(caseStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(engagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reportedIncidentStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(actualIncidentStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedAwsRegions() ? impactedAwsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThreatActorIpAddresses() ? threatActorIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(pendingActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedAccounts() ? impactedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWatchers() ? watchers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(closureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resolverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedServices() ? impactedServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCaseAttachments() ? caseAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(closedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCaseResponse)) {
            return false;
        }
        GetCaseResponse other = (GetCaseResponse) obj;
        return Objects.equals(title(), other.title()) && Objects.equals(caseArn(), other.caseArn())
                && Objects.equals(description(), other.description())
                && Objects.equals(caseStatusAsString(), other.caseStatusAsString())
                && Objects.equals(engagementTypeAsString(), other.engagementTypeAsString())
                && Objects.equals(reportedIncidentStartDate(), other.reportedIncidentStartDate())
                && Objects.equals(actualIncidentStartDate(), other.actualIncidentStartDate())
                && hasImpactedAwsRegions() == other.hasImpactedAwsRegions()
                && Objects.equals(impactedAwsRegions(), other.impactedAwsRegions())
                && hasThreatActorIpAddresses() == other.hasThreatActorIpAddresses()
                && Objects.equals(threatActorIpAddresses(), other.threatActorIpAddresses())
                && Objects.equals(pendingActionAsString(), other.pendingActionAsString())
                && hasImpactedAccounts() == other.hasImpactedAccounts()
                && Objects.equals(impactedAccounts(), other.impactedAccounts()) && hasWatchers() == other.hasWatchers()
                && Objects.equals(watchers(), other.watchers()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(closureCodeAsString(), other.closureCodeAsString())
                && Objects.equals(resolverTypeAsString(), other.resolverTypeAsString())
                && hasImpactedServices() == other.hasImpactedServices()
                && Objects.equals(impactedServices(), other.impactedServices())
                && hasCaseAttachments() == other.hasCaseAttachments()
                && Objects.equals(caseAttachments(), other.caseAttachments()) && Objects.equals(closedDate(), other.closedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCaseResponse").add("Title", title() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CaseArn", caseArn()).add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CaseStatus", caseStatusAsString()).add("EngagementType", engagementTypeAsString())
                .add("ReportedIncidentStartDate", reportedIncidentStartDate())
                .add("ActualIncidentStartDate", actualIncidentStartDate())
                .add("ImpactedAwsRegions", hasImpactedAwsRegions() ? impactedAwsRegions() : null)
                .add("ThreatActorIpAddresses", hasThreatActorIpAddresses() ? threatActorIpAddresses() : null)
                .add("PendingAction", pendingActionAsString())
                .add("ImpactedAccounts", hasImpactedAccounts() ? impactedAccounts() : null)
                .add("Watchers", hasWatchers() ? watchers() : null).add("CreatedDate", createdDate())
                .add("LastUpdatedDate", lastUpdatedDate()).add("ClosureCode", closureCodeAsString())
                .add("ResolverType", resolverTypeAsString())
                .add("ImpactedServices", hasImpactedServices() ? impactedServices() : null)
                .add("CaseAttachments", hasCaseAttachments() ? caseAttachments() : null).add("ClosedDate", closedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "caseArn":
            return Optional.ofNullable(clazz.cast(caseArn()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "caseStatus":
            return Optional.ofNullable(clazz.cast(caseStatusAsString()));
        case "engagementType":
            return Optional.ofNullable(clazz.cast(engagementTypeAsString()));
        case "reportedIncidentStartDate":
            return Optional.ofNullable(clazz.cast(reportedIncidentStartDate()));
        case "actualIncidentStartDate":
            return Optional.ofNullable(clazz.cast(actualIncidentStartDate()));
        case "impactedAwsRegions":
            return Optional.ofNullable(clazz.cast(impactedAwsRegions()));
        case "threatActorIpAddresses":
            return Optional.ofNullable(clazz.cast(threatActorIpAddresses()));
        case "pendingAction":
            return Optional.ofNullable(clazz.cast(pendingActionAsString()));
        case "impactedAccounts":
            return Optional.ofNullable(clazz.cast(impactedAccounts()));
        case "watchers":
            return Optional.ofNullable(clazz.cast(watchers()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "closureCode":
            return Optional.ofNullable(clazz.cast(closureCodeAsString()));
        case "resolverType":
            return Optional.ofNullable(clazz.cast(resolverTypeAsString()));
        case "impactedServices":
            return Optional.ofNullable(clazz.cast(impactedServices()));
        case "caseAttachments":
            return Optional.ofNullable(clazz.cast(caseAttachments()));
        case "closedDate":
            return Optional.ofNullable(clazz.cast(closedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("title", TITLE_FIELD);
        map.put("caseArn", CASE_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("caseStatus", CASE_STATUS_FIELD);
        map.put("engagementType", ENGAGEMENT_TYPE_FIELD);
        map.put("reportedIncidentStartDate", REPORTED_INCIDENT_START_DATE_FIELD);
        map.put("actualIncidentStartDate", ACTUAL_INCIDENT_START_DATE_FIELD);
        map.put("impactedAwsRegions", IMPACTED_AWS_REGIONS_FIELD);
        map.put("threatActorIpAddresses", THREAT_ACTOR_IP_ADDRESSES_FIELD);
        map.put("pendingAction", PENDING_ACTION_FIELD);
        map.put("impactedAccounts", IMPACTED_ACCOUNTS_FIELD);
        map.put("watchers", WATCHERS_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("closureCode", CLOSURE_CODE_FIELD);
        map.put("resolverType", RESOLVER_TYPE_FIELD);
        map.put("impactedServices", IMPACTED_SERVICES_FIELD);
        map.put("caseAttachments", CASE_ATTACHMENTS_FIELD);
        map.put("closedDate", CLOSED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCaseResponse, T> g) {
        return obj -> g.apply((GetCaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityIrResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCaseResponse> {
        /**
         * <p>
         * Response element for GetCase that provides the case title.
         * </p>
         * 
         * @param title
         *        Response element for GetCase that provides the case title.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Response element for GetCase that provides the case ARN
         * </p>
         * 
         * @param caseArn
         *        Response element for GetCase that provides the case ARN
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseArn(String caseArn);

        /**
         * <p>
         * Response element for GetCase that provides contents of the case description.
         * </p>
         * 
         * @param description
         *        Response element for GetCase that provides contents of the case description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Response element for GetCase that provides the case status. Options for statuses include
         * <code>Submitted | Detection and Analysis | Eradication, Containment and Recovery | Post-Incident Activities | Closed </code>
         * </p>
         * 
         * @param caseStatus
         *        Response element for GetCase that provides the case status. Options for statuses include
         *        <code>Submitted | Detection and Analysis | Eradication, Containment and Recovery | Post-Incident Activities | Closed </code>
         * @see CaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaseStatus
         */
        Builder caseStatus(String caseStatus);

        /**
         * <p>
         * Response element for GetCase that provides the case status. Options for statuses include
         * <code>Submitted | Detection and Analysis | Eradication, Containment and Recovery | Post-Incident Activities | Closed </code>
         * </p>
         * 
         * @param caseStatus
         *        Response element for GetCase that provides the case status. Options for statuses include
         *        <code>Submitted | Detection and Analysis | Eradication, Containment and Recovery | Post-Incident Activities | Closed </code>
         * @see CaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaseStatus
         */
        Builder caseStatus(CaseStatus caseStatus);

        /**
         * <p>
         * Response element for GetCase that provides the engagement type. Options for engagement type include
         * <code>Active Security Event | Investigations</code>
         * </p>
         * 
         * @param engagementType
         *        Response element for GetCase that provides the engagement type. Options for engagement type include
         *        <code>Active Security Event | Investigations</code>
         * @see EngagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementType
         */
        Builder engagementType(String engagementType);

        /**
         * <p>
         * Response element for GetCase that provides the engagement type. Options for engagement type include
         * <code>Active Security Event | Investigations</code>
         * </p>
         * 
         * @param engagementType
         *        Response element for GetCase that provides the engagement type. Options for engagement type include
         *        <code>Active Security Event | Investigations</code>
         * @see EngagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementType
         */
        Builder engagementType(EngagementType engagementType);

        /**
         * <p>
         * Response element for GetCase that provides the customer provided incident start date.
         * </p>
         * 
         * @param reportedIncidentStartDate
         *        Response element for GetCase that provides the customer provided incident start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportedIncidentStartDate(Instant reportedIncidentStartDate);

        /**
         * <p>
         * Response element for GetCase that provides the actual incident start date as identified by data analysis
         * during the investigation.
         * </p>
         * 
         * @param actualIncidentStartDate
         *        Response element for GetCase that provides the actual incident start date as identified by data
         *        analysis during the investigation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualIncidentStartDate(Instant actualIncidentStartDate);

        /**
         * <p>
         * Response element for GetCase that provides the impacted regions.
         * </p>
         * 
         * @param impactedAwsRegions
         *        Response element for GetCase that provides the impacted regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAwsRegions(Collection<ImpactedAwsRegion> impactedAwsRegions);

        /**
         * <p>
         * Response element for GetCase that provides the impacted regions.
         * </p>
         * 
         * @param impactedAwsRegions
         *        Response element for GetCase that provides the impacted regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAwsRegions(ImpactedAwsRegion... impactedAwsRegions);

        /**
         * <p>
         * Response element for GetCase that provides the impacted regions.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder#build()} is called
         * immediately and its result is passed to {@link #impactedAwsRegions(List<ImpactedAwsRegion>)}.
         * 
         * @param impactedAwsRegions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #impactedAwsRegions(java.util.Collection<ImpactedAwsRegion>)
         */
        Builder impactedAwsRegions(Consumer<ImpactedAwsRegion.Builder>... impactedAwsRegions);

        /**
         * <p>
         * Response element for GetCase that provides a list of suspicious IP addresses associated with unauthorized
         * activity.
         * </p>
         * 
         * @param threatActorIpAddresses
         *        Response element for GetCase that provides a list of suspicious IP addresses associated with
         *        unauthorized activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatActorIpAddresses(Collection<ThreatActorIp> threatActorIpAddresses);

        /**
         * <p>
         * Response element for GetCase that provides a list of suspicious IP addresses associated with unauthorized
         * activity.
         * </p>
         * 
         * @param threatActorIpAddresses
         *        Response element for GetCase that provides a list of suspicious IP addresses associated with
         *        unauthorized activity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatActorIpAddresses(ThreatActorIp... threatActorIpAddresses);

        /**
         * <p>
         * Response element for GetCase that provides a list of suspicious IP addresses associated with unauthorized
         * activity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder#build()} is called immediately
         * and its result is passed to {@link #threatActorIpAddresses(List<ThreatActorIp>)}.
         * 
         * @param threatActorIpAddresses
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatActorIpAddresses(java.util.Collection<ThreatActorIp>)
         */
        Builder threatActorIpAddresses(Consumer<ThreatActorIp.Builder>... threatActorIpAddresses);

        /**
         * <p>
         * Response element for GetCase that provides identifies the case is waiting on customer input.
         * </p>
         * 
         * @param pendingAction
         *        Response element for GetCase that provides identifies the case is waiting on customer input.
         * @see PendingAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PendingAction
         */
        Builder pendingAction(String pendingAction);

        /**
         * <p>
         * Response element for GetCase that provides identifies the case is waiting on customer input.
         * </p>
         * 
         * @param pendingAction
         *        Response element for GetCase that provides identifies the case is waiting on customer input.
         * @see PendingAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PendingAction
         */
        Builder pendingAction(PendingAction pendingAction);

        /**
         * <p>
         * Response element for GetCase that provides a list of impacted accounts.
         * </p>
         * 
         * @param impactedAccounts
         *        Response element for GetCase that provides a list of impacted accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAccounts(Collection<String> impactedAccounts);

        /**
         * <p>
         * Response element for GetCase that provides a list of impacted accounts.
         * </p>
         * 
         * @param impactedAccounts
         *        Response element for GetCase that provides a list of impacted accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAccounts(String... impactedAccounts);

        /**
         * <p>
         * Response element for GetCase that provides a list of Watchers added to the case.
         * </p>
         * 
         * @param watchers
         *        Response element for GetCase that provides a list of Watchers added to the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchers(Collection<Watcher> watchers);

        /**
         * <p>
         * Response element for GetCase that provides a list of Watchers added to the case.
         * </p>
         * 
         * @param watchers
         *        Response element for GetCase that provides a list of Watchers added to the case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchers(Watcher... watchers);

        /**
         * <p>
         * Response element for GetCase that provides a list of Watchers added to the case.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityir.model.Watcher#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder#build()} is called immediately and
         * its result is passed to {@link #watchers(List<Watcher>)}.
         * 
         * @param watchers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #watchers(java.util.Collection<Watcher>)
         */
        Builder watchers(Consumer<Watcher.Builder>... watchers);

        /**
         * <p>
         * Response element for GetCase that provides the date the case was created.
         * </p>
         * 
         * @param createdDate
         *        Response element for GetCase that provides the date the case was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * Response element for GetCase that provides the date a case was last modified.
         * </p>
         * 
         * @param lastUpdatedDate
         *        Response element for GetCase that provides the date a case was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p>
         * Response element for GetCase that provides the summary code for why a case was closed.
         * </p>
         * 
         * @param closureCode
         *        Response element for GetCase that provides the summary code for why a case was closed.
         * @see ClosureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClosureCode
         */
        Builder closureCode(String closureCode);

        /**
         * <p>
         * Response element for GetCase that provides the summary code for why a case was closed.
         * </p>
         * 
         * @param closureCode
         *        Response element for GetCase that provides the summary code for why a case was closed.
         * @see ClosureCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClosureCode
         */
        Builder closureCode(ClosureCode closureCode);

        /**
         * <p>
         * Response element for GetCase that provides the current resolver types. Options include
         * <code> self-supported | AWS-supported</code>.
         * </p>
         * 
         * @param resolverType
         *        Response element for GetCase that provides the current resolver types. Options include
         *        <code> self-supported | AWS-supported</code>.
         * @see ResolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverType
         */
        Builder resolverType(String resolverType);

        /**
         * <p>
         * Response element for GetCase that provides the current resolver types. Options include
         * <code> self-supported | AWS-supported</code>.
         * </p>
         * 
         * @param resolverType
         *        Response element for GetCase that provides the current resolver types. Options include
         *        <code> self-supported | AWS-supported</code>.
         * @see ResolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverType
         */
        Builder resolverType(ResolverType resolverType);

        /**
         * <p>
         * Response element for GetCase that provides a list of impacted services.
         * </p>
         * 
         * @param impactedServices
         *        Response element for GetCase that provides a list of impacted services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedServices(Collection<String> impactedServices);

        /**
         * <p>
         * Response element for GetCase that provides a list of impacted services.
         * </p>
         * 
         * @param impactedServices
         *        Response element for GetCase that provides a list of impacted services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedServices(String... impactedServices);

        /**
         * <p>
         * Response element for GetCase that provides a list of current case attachments.
         * </p>
         * 
         * @param caseAttachments
         *        Response element for GetCase that provides a list of current case attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseAttachments(Collection<CaseAttachmentAttributes> caseAttachments);

        /**
         * <p>
         * Response element for GetCase that provides a list of current case attachments.
         * </p>
         * 
         * @param caseAttachments
         *        Response element for GetCase that provides a list of current case attachments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseAttachments(CaseAttachmentAttributes... caseAttachments);

        /**
         * <p>
         * Response element for GetCase that provides a list of current case attachments.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.CaseAttachmentAttributes.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.securityir.model.CaseAttachmentAttributes#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.CaseAttachmentAttributes.Builder#build()} is called
         * immediately and its result is passed to {@link #caseAttachments(List<CaseAttachmentAttributes>)}.
         * 
         * @param caseAttachments
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.CaseAttachmentAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #caseAttachments(java.util.Collection<CaseAttachmentAttributes>)
         */
        Builder caseAttachments(Consumer<CaseAttachmentAttributes.Builder>... caseAttachments);

        /**
         * <p>
         * Response element for GetCase that provides the date a specified case was closed.
         * </p>
         * 
         * @param closedDate
         *        Response element for GetCase that provides the date a specified case was closed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closedDate(Instant closedDate);
    }

    static final class BuilderImpl extends SecurityIrResponse.BuilderImpl implements Builder {
        private String title;

        private String caseArn;

        private String description;

        private String caseStatus;

        private String engagementType;

        private Instant reportedIncidentStartDate;

        private Instant actualIncidentStartDate;

        private List<ImpactedAwsRegion> impactedAwsRegions = DefaultSdkAutoConstructList.getInstance();

        private List<ThreatActorIp> threatActorIpAddresses = DefaultSdkAutoConstructList.getInstance();

        private String pendingAction;

        private List<String> impactedAccounts = DefaultSdkAutoConstructList.getInstance();

        private List<Watcher> watchers = DefaultSdkAutoConstructList.getInstance();

        private Instant createdDate;

        private Instant lastUpdatedDate;

        private String closureCode;

        private String resolverType;

        private List<String> impactedServices = DefaultSdkAutoConstructList.getInstance();

        private List<CaseAttachmentAttributes> caseAttachments = DefaultSdkAutoConstructList.getInstance();

        private Instant closedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCaseResponse model) {
            super(model);
            title(model.title);
            caseArn(model.caseArn);
            description(model.description);
            caseStatus(model.caseStatus);
            engagementType(model.engagementType);
            reportedIncidentStartDate(model.reportedIncidentStartDate);
            actualIncidentStartDate(model.actualIncidentStartDate);
            impactedAwsRegions(model.impactedAwsRegions);
            threatActorIpAddresses(model.threatActorIpAddresses);
            pendingAction(model.pendingAction);
            impactedAccounts(model.impactedAccounts);
            watchers(model.watchers);
            createdDate(model.createdDate);
            lastUpdatedDate(model.lastUpdatedDate);
            closureCode(model.closureCode);
            resolverType(model.resolverType);
            impactedServices(model.impactedServices);
            caseAttachments(model.caseAttachments);
            closedDate(model.closedDate);
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getCaseArn() {
            return caseArn;
        }

        public final void setCaseArn(String caseArn) {
            this.caseArn = caseArn;
        }

        @Override
        public final Builder caseArn(String caseArn) {
            this.caseArn = caseArn;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCaseStatus() {
            return caseStatus;
        }

        public final void setCaseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
        }

        @Override
        public final Builder caseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
            return this;
        }

        @Override
        public final Builder caseStatus(CaseStatus caseStatus) {
            this.caseStatus(caseStatus == null ? null : caseStatus.toString());
            return this;
        }

        public final String getEngagementType() {
            return engagementType;
        }

        public final void setEngagementType(String engagementType) {
            this.engagementType = engagementType;
        }

        @Override
        public final Builder engagementType(String engagementType) {
            this.engagementType = engagementType;
            return this;
        }

        @Override
        public final Builder engagementType(EngagementType engagementType) {
            this.engagementType(engagementType == null ? null : engagementType.toString());
            return this;
        }

        public final Instant getReportedIncidentStartDate() {
            return reportedIncidentStartDate;
        }

        public final void setReportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
        }

        @Override
        public final Builder reportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
            return this;
        }

        public final Instant getActualIncidentStartDate() {
            return actualIncidentStartDate;
        }

        public final void setActualIncidentStartDate(Instant actualIncidentStartDate) {
            this.actualIncidentStartDate = actualIncidentStartDate;
        }

        @Override
        public final Builder actualIncidentStartDate(Instant actualIncidentStartDate) {
            this.actualIncidentStartDate = actualIncidentStartDate;
            return this;
        }

        public final List<ImpactedAwsRegion.Builder> getImpactedAwsRegions() {
            List<ImpactedAwsRegion.Builder> result = ImpactedAwsRegionListCopier.copyToBuilder(this.impactedAwsRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpactedAwsRegions(Collection<ImpactedAwsRegion.BuilderImpl> impactedAwsRegions) {
            this.impactedAwsRegions = ImpactedAwsRegionListCopier.copyFromBuilder(impactedAwsRegions);
        }

        @Override
        public final Builder impactedAwsRegions(Collection<ImpactedAwsRegion> impactedAwsRegions) {
            this.impactedAwsRegions = ImpactedAwsRegionListCopier.copy(impactedAwsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegions(ImpactedAwsRegion... impactedAwsRegions) {
            impactedAwsRegions(Arrays.asList(impactedAwsRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegions(Consumer<ImpactedAwsRegion.Builder>... impactedAwsRegions) {
            impactedAwsRegions(Stream.of(impactedAwsRegions).map(c -> ImpactedAwsRegion.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ThreatActorIp.Builder> getThreatActorIpAddresses() {
            List<ThreatActorIp.Builder> result = ThreatActorIpListCopier.copyToBuilder(this.threatActorIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatActorIpAddresses(Collection<ThreatActorIp.BuilderImpl> threatActorIpAddresses) {
            this.threatActorIpAddresses = ThreatActorIpListCopier.copyFromBuilder(threatActorIpAddresses);
        }

        @Override
        public final Builder threatActorIpAddresses(Collection<ThreatActorIp> threatActorIpAddresses) {
            this.threatActorIpAddresses = ThreatActorIpListCopier.copy(threatActorIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddresses(ThreatActorIp... threatActorIpAddresses) {
            threatActorIpAddresses(Arrays.asList(threatActorIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddresses(Consumer<ThreatActorIp.Builder>... threatActorIpAddresses) {
            threatActorIpAddresses(Stream.of(threatActorIpAddresses).map(c -> ThreatActorIp.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getPendingAction() {
            return pendingAction;
        }

        public final void setPendingAction(String pendingAction) {
            this.pendingAction = pendingAction;
        }

        @Override
        public final Builder pendingAction(String pendingAction) {
            this.pendingAction = pendingAction;
            return this;
        }

        @Override
        public final Builder pendingAction(PendingAction pendingAction) {
            this.pendingAction(pendingAction == null ? null : pendingAction.toString());
            return this;
        }

        public final Collection<String> getImpactedAccounts() {
            if (impactedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return impactedAccounts;
        }

        public final void setImpactedAccounts(Collection<String> impactedAccounts) {
            this.impactedAccounts = ImpactedAccountsCopier.copy(impactedAccounts);
        }

        @Override
        public final Builder impactedAccounts(Collection<String> impactedAccounts) {
            this.impactedAccounts = ImpactedAccountsCopier.copy(impactedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAccounts(String... impactedAccounts) {
            impactedAccounts(Arrays.asList(impactedAccounts));
            return this;
        }

        public final List<Watcher.Builder> getWatchers() {
            List<Watcher.Builder> result = WatchersCopier.copyToBuilder(this.watchers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatchers(Collection<Watcher.BuilderImpl> watchers) {
            this.watchers = WatchersCopier.copyFromBuilder(watchers);
        }

        @Override
        public final Builder watchers(Collection<Watcher> watchers) {
            this.watchers = WatchersCopier.copy(watchers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchers(Watcher... watchers) {
            watchers(Arrays.asList(watchers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchers(Consumer<Watcher.Builder>... watchers) {
            watchers(Stream.of(watchers).map(c -> Watcher.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getClosureCode() {
            return closureCode;
        }

        public final void setClosureCode(String closureCode) {
            this.closureCode = closureCode;
        }

        @Override
        public final Builder closureCode(String closureCode) {
            this.closureCode = closureCode;
            return this;
        }

        @Override
        public final Builder closureCode(ClosureCode closureCode) {
            this.closureCode(closureCode == null ? null : closureCode.toString());
            return this;
        }

        public final String getResolverType() {
            return resolverType;
        }

        public final void setResolverType(String resolverType) {
            this.resolverType = resolverType;
        }

        @Override
        public final Builder resolverType(String resolverType) {
            this.resolverType = resolverType;
            return this;
        }

        @Override
        public final Builder resolverType(ResolverType resolverType) {
            this.resolverType(resolverType == null ? null : resolverType.toString());
            return this;
        }

        public final Collection<String> getImpactedServices() {
            if (impactedServices instanceof SdkAutoConstructList) {
                return null;
            }
            return impactedServices;
        }

        public final void setImpactedServices(Collection<String> impactedServices) {
            this.impactedServices = ImpactedServicesListCopier.copy(impactedServices);
        }

        @Override
        public final Builder impactedServices(Collection<String> impactedServices) {
            this.impactedServices = ImpactedServicesListCopier.copy(impactedServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedServices(String... impactedServices) {
            impactedServices(Arrays.asList(impactedServices));
            return this;
        }

        public final List<CaseAttachmentAttributes.Builder> getCaseAttachments() {
            List<CaseAttachmentAttributes.Builder> result = CaseAttachmentsListCopier.copyToBuilder(this.caseAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaseAttachments(Collection<CaseAttachmentAttributes.BuilderImpl> caseAttachments) {
            this.caseAttachments = CaseAttachmentsListCopier.copyFromBuilder(caseAttachments);
        }

        @Override
        public final Builder caseAttachments(Collection<CaseAttachmentAttributes> caseAttachments) {
            this.caseAttachments = CaseAttachmentsListCopier.copy(caseAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseAttachments(CaseAttachmentAttributes... caseAttachments) {
            caseAttachments(Arrays.asList(caseAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseAttachments(Consumer<CaseAttachmentAttributes.Builder>... caseAttachments) {
            caseAttachments(Stream.of(caseAttachments).map(c -> CaseAttachmentAttributes.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getClosedDate() {
            return closedDate;
        }

        public final void setClosedDate(Instant closedDate) {
            this.closedDate = closedDate;
        }

        @Override
        public final Builder closedDate(Instant closedDate) {
            this.closedDate = closedDate;
            return this;
        }

        @Override
        public GetCaseResponse build() {
            return new GetCaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
