/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCasesItem implements SdkPojo, Serializable, ToCopyableBuilder<ListCasesItem.Builder, ListCasesItem> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caseId")
            .getter(getter(ListCasesItem::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseId").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdatedDate").getter(getter(ListCasesItem::lastUpdatedDate))
            .setter(setter(Builder::lastUpdatedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(ListCasesItem::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> CASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseArn").getter(getter(ListCasesItem::caseArn)).setter(setter(Builder::caseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseArn").build()).build();

    private static final SdkField<String> ENGAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engagementType").getter(getter(ListCasesItem::engagementTypeAsString))
            .setter(setter(Builder::engagementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagementType").build()).build();

    private static final SdkField<String> CASE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseStatus").getter(getter(ListCasesItem::caseStatusAsString)).setter(setter(Builder::caseStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseStatus").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(ListCasesItem::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Instant> CLOSED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("closedDate").getter(getter(ListCasesItem::closedDate)).setter(setter(Builder::closedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closedDate").build()).build();

    private static final SdkField<String> RESOLVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolverType").getter(getter(ListCasesItem::resolverTypeAsString)).setter(setter(Builder::resolverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverType").build()).build();

    private static final SdkField<String> PENDING_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("pendingAction").getter(getter(ListCasesItem::pendingActionAsString))
            .setter(setter(Builder::pendingAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD,
            LAST_UPDATED_DATE_FIELD, TITLE_FIELD, CASE_ARN_FIELD, ENGAGEMENT_TYPE_FIELD, CASE_STATUS_FIELD, CREATED_DATE_FIELD,
            CLOSED_DATE_FIELD, RESOLVER_TYPE_FIELD, PENDING_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String caseId;

    private final Instant lastUpdatedDate;

    private final String title;

    private final String caseArn;

    private final String engagementType;

    private final String caseStatus;

    private final Instant createdDate;

    private final Instant closedDate;

    private final String resolverType;

    private final String pendingAction;

    private ListCasesItem(BuilderImpl builder) {
        this.caseId = builder.caseId;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.title = builder.title;
        this.caseArn = builder.caseArn;
        this.engagementType = builder.engagementType;
        this.caseStatus = builder.caseStatus;
        this.createdDate = builder.createdDate;
        this.closedDate = builder.closedDate;
        this.resolverType = builder.resolverType;
        this.pendingAction = builder.pendingAction;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String caseId() {
        return caseId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Instant lastUpdatedDate() {
        return lastUpdatedDate;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String title() {
        return title;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String caseArn() {
        return caseArn;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementType}
     * will return {@link EngagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #engagementTypeAsString}.
     * </p>
     * 
     * @return
     * @see EngagementType
     */
    public final EngagementType engagementType() {
        return EngagementType.fromValue(engagementType);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementType}
     * will return {@link EngagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #engagementTypeAsString}.
     * </p>
     * 
     * @return
     * @see EngagementType
     */
    public final String engagementTypeAsString() {
        return engagementType;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #caseStatus} will
     * return {@link CaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #caseStatusAsString}.
     * </p>
     * 
     * @return
     * @see CaseStatus
     */
    public final CaseStatus caseStatus() {
        return CaseStatus.fromValue(caseStatus);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #caseStatus} will
     * return {@link CaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #caseStatusAsString}.
     * </p>
     * 
     * @return
     * @see CaseStatus
     */
    public final String caseStatusAsString() {
        return caseStatus;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Instant closedDate() {
        return closedDate;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolverType} will
     * return {@link ResolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolverTypeAsString}.
     * </p>
     * 
     * @return
     * @see ResolverType
     */
    public final ResolverType resolverType() {
        return ResolverType.fromValue(resolverType);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolverType} will
     * return {@link ResolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolverTypeAsString}.
     * </p>
     * 
     * @return
     * @see ResolverType
     */
    public final String resolverTypeAsString() {
        return resolverType;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pendingAction}
     * will return {@link PendingAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pendingActionAsString}.
     * </p>
     * 
     * @return
     * @see PendingAction
     */
    public final PendingAction pendingAction() {
        return PendingAction.fromValue(pendingAction);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #pendingAction}
     * will return {@link PendingAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #pendingActionAsString}.
     * </p>
     * 
     * @return
     * @see PendingAction
     */
    public final String pendingActionAsString() {
        return pendingAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(caseArn());
        hashCode = 31 * hashCode + Objects.hashCode(engagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(caseStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(closedDate());
        hashCode = 31 * hashCode + Objects.hashCode(resolverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pendingActionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCasesItem)) {
            return false;
        }
        ListCasesItem other = (ListCasesItem) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(lastUpdatedDate(), other.lastUpdatedDate())
                && Objects.equals(title(), other.title()) && Objects.equals(caseArn(), other.caseArn())
                && Objects.equals(engagementTypeAsString(), other.engagementTypeAsString())
                && Objects.equals(caseStatusAsString(), other.caseStatusAsString())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(closedDate(), other.closedDate())
                && Objects.equals(resolverTypeAsString(), other.resolverTypeAsString())
                && Objects.equals(pendingActionAsString(), other.pendingActionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCasesItem").add("CaseId", caseId()).add("LastUpdatedDate", lastUpdatedDate())
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***").add("CaseArn", caseArn())
                .add("EngagementType", engagementTypeAsString()).add("CaseStatus", caseStatusAsString())
                .add("CreatedDate", createdDate()).add("ClosedDate", closedDate()).add("ResolverType", resolverTypeAsString())
                .add("PendingAction", pendingActionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "lastUpdatedDate":
            return Optional.ofNullable(clazz.cast(lastUpdatedDate()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "caseArn":
            return Optional.ofNullable(clazz.cast(caseArn()));
        case "engagementType":
            return Optional.ofNullable(clazz.cast(engagementTypeAsString()));
        case "caseStatus":
            return Optional.ofNullable(clazz.cast(caseStatusAsString()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "closedDate":
            return Optional.ofNullable(clazz.cast(closedDate()));
        case "resolverType":
            return Optional.ofNullable(clazz.cast(resolverTypeAsString()));
        case "pendingAction":
            return Optional.ofNullable(clazz.cast(pendingActionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("caseArn", CASE_ARN_FIELD);
        map.put("engagementType", ENGAGEMENT_TYPE_FIELD);
        map.put("caseStatus", CASE_STATUS_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("closedDate", CLOSED_DATE_FIELD);
        map.put("resolverType", RESOLVER_TYPE_FIELD);
        map.put("pendingAction", PENDING_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCasesItem, T> g) {
        return obj -> g.apply((ListCasesItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListCasesItem> {
        /**
         * <p/>
         * 
         * @param caseId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p/>
         * 
         * @param lastUpdatedDate
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedDate(Instant lastUpdatedDate);

        /**
         * <p/>
         * 
         * @param title
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p/>
         * 
         * @param caseArn
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseArn(String caseArn);

        /**
         * <p/>
         * 
         * @param engagementType
         * @see EngagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementType
         */
        Builder engagementType(String engagementType);

        /**
         * <p/>
         * 
         * @param engagementType
         * @see EngagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementType
         */
        Builder engagementType(EngagementType engagementType);

        /**
         * <p/>
         * 
         * @param caseStatus
         * @see CaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaseStatus
         */
        Builder caseStatus(String caseStatus);

        /**
         * <p/>
         * 
         * @param caseStatus
         * @see CaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaseStatus
         */
        Builder caseStatus(CaseStatus caseStatus);

        /**
         * <p/>
         * 
         * @param createdDate
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p/>
         * 
         * @param closedDate
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder closedDate(Instant closedDate);

        /**
         * <p/>
         * 
         * @param resolverType
         * @see ResolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverType
         */
        Builder resolverType(String resolverType);

        /**
         * <p/>
         * 
         * @param resolverType
         * @see ResolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverType
         */
        Builder resolverType(ResolverType resolverType);

        /**
         * <p/>
         * 
         * @param pendingAction
         * @see PendingAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PendingAction
         */
        Builder pendingAction(String pendingAction);

        /**
         * <p/>
         * 
         * @param pendingAction
         * @see PendingAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PendingAction
         */
        Builder pendingAction(PendingAction pendingAction);
    }

    static final class BuilderImpl implements Builder {
        private String caseId;

        private Instant lastUpdatedDate;

        private String title;

        private String caseArn;

        private String engagementType;

        private String caseStatus;

        private Instant createdDate;

        private Instant closedDate;

        private String resolverType;

        private String pendingAction;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCasesItem model) {
            caseId(model.caseId);
            lastUpdatedDate(model.lastUpdatedDate);
            title(model.title);
            caseArn(model.caseArn);
            engagementType(model.engagementType);
            caseStatus(model.caseStatus);
            createdDate(model.createdDate);
            closedDate(model.closedDate);
            resolverType(model.resolverType);
            pendingAction(model.pendingAction);
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getCaseArn() {
            return caseArn;
        }

        public final void setCaseArn(String caseArn) {
            this.caseArn = caseArn;
        }

        @Override
        public final Builder caseArn(String caseArn) {
            this.caseArn = caseArn;
            return this;
        }

        public final String getEngagementType() {
            return engagementType;
        }

        public final void setEngagementType(String engagementType) {
            this.engagementType = engagementType;
        }

        @Override
        public final Builder engagementType(String engagementType) {
            this.engagementType = engagementType;
            return this;
        }

        @Override
        public final Builder engagementType(EngagementType engagementType) {
            this.engagementType(engagementType == null ? null : engagementType.toString());
            return this;
        }

        public final String getCaseStatus() {
            return caseStatus;
        }

        public final void setCaseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
        }

        @Override
        public final Builder caseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
            return this;
        }

        @Override
        public final Builder caseStatus(CaseStatus caseStatus) {
            this.caseStatus(caseStatus == null ? null : caseStatus.toString());
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getClosedDate() {
            return closedDate;
        }

        public final void setClosedDate(Instant closedDate) {
            this.closedDate = closedDate;
        }

        @Override
        public final Builder closedDate(Instant closedDate) {
            this.closedDate = closedDate;
            return this;
        }

        public final String getResolverType() {
            return resolverType;
        }

        public final void setResolverType(String resolverType) {
            this.resolverType = resolverType;
        }

        @Override
        public final Builder resolverType(String resolverType) {
            this.resolverType = resolverType;
            return this;
        }

        @Override
        public final Builder resolverType(ResolverType resolverType) {
            this.resolverType(resolverType == null ? null : resolverType.toString());
            return this;
        }

        public final String getPendingAction() {
            return pendingAction;
        }

        public final void setPendingAction(String pendingAction) {
            this.pendingAction = pendingAction;
        }

        @Override
        public final Builder pendingAction(String pendingAction) {
            this.pendingAction = pendingAction;
            return this;
        }

        @Override
        public final Builder pendingAction(PendingAction pendingAction) {
            this.pendingAction(pendingAction == null ? null : pendingAction.toString());
            return this;
        }

        @Override
        public ListCasesItem build() {
            return new ListCasesItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
