/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OptInFeature implements SdkPojo, Serializable, ToCopyableBuilder<OptInFeature.Builder, OptInFeature> {
    private static final SdkField<String> FEATURE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("featureName").getter(getter(OptInFeature::featureNameAsString)).setter(setter(Builder::featureName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featureName").build()).build();

    private static final SdkField<Boolean> IS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isEnabled").getter(getter(OptInFeature::isEnabled)).setter(setter(Builder::isEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURE_NAME_FIELD,
            IS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String featureName;

    private final Boolean isEnabled;

    private OptInFeature(BuilderImpl builder) {
        this.featureName = builder.featureName;
        this.isEnabled = builder.isEnabled;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureName} will
     * return {@link OptInFeatureName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureNameAsString}.
     * </p>
     * 
     * @return
     * @see OptInFeatureName
     */
    public final OptInFeatureName featureName() {
        return OptInFeatureName.fromValue(featureName);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #featureName} will
     * return {@link OptInFeatureName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #featureNameAsString}.
     * </p>
     * 
     * @return
     * @see OptInFeatureName
     */
    public final String featureNameAsString() {
        return featureName;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Boolean isEnabled() {
        return isEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(featureNameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptInFeature)) {
            return false;
        }
        OptInFeature other = (OptInFeature) obj;
        return Objects.equals(featureNameAsString(), other.featureNameAsString())
                && Objects.equals(isEnabled(), other.isEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OptInFeature").add("FeatureName", featureNameAsString()).add("IsEnabled", isEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "featureName":
            return Optional.ofNullable(clazz.cast(featureNameAsString()));
        case "isEnabled":
            return Optional.ofNullable(clazz.cast(isEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("featureName", FEATURE_NAME_FIELD);
        map.put("isEnabled", IS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OptInFeature, T> g) {
        return obj -> g.apply((OptInFeature) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OptInFeature> {
        /**
         * <p/>
         * 
         * @param featureName
         * @see OptInFeatureName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptInFeatureName
         */
        Builder featureName(String featureName);

        /**
         * <p/>
         * 
         * @param featureName
         * @see OptInFeatureName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OptInFeatureName
         */
        Builder featureName(OptInFeatureName featureName);

        /**
         * <p/>
         * 
         * @param isEnabled
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isEnabled(Boolean isEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String featureName;

        private Boolean isEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(OptInFeature model) {
            featureName(model.featureName);
            isEnabled(model.isEnabled);
        }

        public final String getFeatureName() {
            return featureName;
        }

        public final void setFeatureName(String featureName) {
            this.featureName = featureName;
        }

        @Override
        public final Builder featureName(String featureName) {
            this.featureName = featureName;
            return this;
        }

        @Override
        public final Builder featureName(OptInFeatureName featureName) {
            this.featureName(featureName == null ? null : featureName.toString());
            return this;
        }

        public final Boolean getIsEnabled() {
            return isEnabled;
        }

        public final void setIsEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
        }

        @Override
        public final Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            return this;
        }

        @Override
        public OptInFeature build() {
            return new OptInFeature(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
