/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCaseRequest extends SecurityIrRequest implements
        ToCopyableBuilder<UpdateCaseRequest.Builder, UpdateCaseRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caseId")
            .getter(getter(UpdateCaseRequest::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("title")
            .getter(getter(UpdateCaseRequest::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateCaseRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> REPORTED_INCIDENT_START_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT).memberName("reportedIncidentStartDate")
            .getter(getter(UpdateCaseRequest::reportedIncidentStartDate)).setter(setter(Builder::reportedIncidentStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportedIncidentStartDate").build())
            .build();

    private static final SdkField<Instant> ACTUAL_INCIDENT_START_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("actualIncidentStartDate").getter(getter(UpdateCaseRequest::actualIncidentStartDate))
            .setter(setter(Builder::actualIncidentStartDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualIncidentStartDate").build())
            .build();

    private static final SdkField<String> ENGAGEMENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engagementType").getter(getter(UpdateCaseRequest::engagementTypeAsString))
            .setter(setter(Builder::engagementType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagementType").build()).build();

    private static final SdkField<List<Watcher>> WATCHERS_TO_ADD_FIELD = SdkField
            .<List<Watcher>> builder(MarshallingType.LIST)
            .memberName("watchersToAdd")
            .getter(getter(UpdateCaseRequest::watchersToAdd))
            .setter(setter(Builder::watchersToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("watchersToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Watcher> builder(MarshallingType.SDK_POJO)
                                            .constructor(Watcher::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Watcher>> WATCHERS_TO_DELETE_FIELD = SdkField
            .<List<Watcher>> builder(MarshallingType.LIST)
            .memberName("watchersToDelete")
            .getter(getter(UpdateCaseRequest::watchersToDelete))
            .setter(setter(Builder::watchersToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("watchersToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Watcher> builder(MarshallingType.SDK_POJO)
                                            .constructor(Watcher::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ThreatActorIp>> THREAT_ACTOR_IP_ADDRESSES_TO_ADD_FIELD = SdkField
            .<List<ThreatActorIp>> builder(MarshallingType.LIST)
            .memberName("threatActorIpAddressesToAdd")
            .getter(getter(UpdateCaseRequest::threatActorIpAddressesToAdd))
            .setter(setter(Builder::threatActorIpAddressesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatActorIpAddressesToAdd")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThreatActorIp> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThreatActorIp::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ThreatActorIp>> THREAT_ACTOR_IP_ADDRESSES_TO_DELETE_FIELD = SdkField
            .<List<ThreatActorIp>> builder(MarshallingType.LIST)
            .memberName("threatActorIpAddressesToDelete")
            .getter(getter(UpdateCaseRequest::threatActorIpAddressesToDelete))
            .setter(setter(Builder::threatActorIpAddressesToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatActorIpAddressesToDelete")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThreatActorIp> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThreatActorIp::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IMPACTED_SERVICES_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("impactedServicesToAdd")
            .getter(getter(UpdateCaseRequest::impactedServicesToAdd))
            .setter(setter(Builder::impactedServicesToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedServicesToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IMPACTED_SERVICES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("impactedServicesToDelete")
            .getter(getter(UpdateCaseRequest::impactedServicesToDelete))
            .setter(setter(Builder::impactedServicesToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedServicesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ImpactedAwsRegion>> IMPACTED_AWS_REGIONS_TO_ADD_FIELD = SdkField
            .<List<ImpactedAwsRegion>> builder(MarshallingType.LIST)
            .memberName("impactedAwsRegionsToAdd")
            .getter(getter(UpdateCaseRequest::impactedAwsRegionsToAdd))
            .setter(setter(Builder::impactedAwsRegionsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAwsRegionsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImpactedAwsRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImpactedAwsRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ImpactedAwsRegion>> IMPACTED_AWS_REGIONS_TO_DELETE_FIELD = SdkField
            .<List<ImpactedAwsRegion>> builder(MarshallingType.LIST)
            .memberName("impactedAwsRegionsToDelete")
            .getter(getter(UpdateCaseRequest::impactedAwsRegionsToDelete))
            .setter(setter(Builder::impactedAwsRegionsToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAwsRegionsToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImpactedAwsRegion> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImpactedAwsRegion::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IMPACTED_ACCOUNTS_TO_ADD_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("impactedAccountsToAdd")
            .getter(getter(UpdateCaseRequest::impactedAccountsToAdd))
            .setter(setter(Builder::impactedAccountsToAdd))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAccountsToAdd").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IMPACTED_ACCOUNTS_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("impactedAccountsToDelete")
            .getter(getter(UpdateCaseRequest::impactedAccountsToDelete))
            .setter(setter(Builder::impactedAccountsToDelete))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAccountsToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD, TITLE_FIELD,
            DESCRIPTION_FIELD, REPORTED_INCIDENT_START_DATE_FIELD, ACTUAL_INCIDENT_START_DATE_FIELD, ENGAGEMENT_TYPE_FIELD,
            WATCHERS_TO_ADD_FIELD, WATCHERS_TO_DELETE_FIELD, THREAT_ACTOR_IP_ADDRESSES_TO_ADD_FIELD,
            THREAT_ACTOR_IP_ADDRESSES_TO_DELETE_FIELD, IMPACTED_SERVICES_TO_ADD_FIELD, IMPACTED_SERVICES_TO_DELETE_FIELD,
            IMPACTED_AWS_REGIONS_TO_ADD_FIELD, IMPACTED_AWS_REGIONS_TO_DELETE_FIELD, IMPACTED_ACCOUNTS_TO_ADD_FIELD,
            IMPACTED_ACCOUNTS_TO_DELETE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String caseId;

    private final String title;

    private final String description;

    private final Instant reportedIncidentStartDate;

    private final Instant actualIncidentStartDate;

    private final String engagementType;

    private final List<Watcher> watchersToAdd;

    private final List<Watcher> watchersToDelete;

    private final List<ThreatActorIp> threatActorIpAddressesToAdd;

    private final List<ThreatActorIp> threatActorIpAddressesToDelete;

    private final List<String> impactedServicesToAdd;

    private final List<String> impactedServicesToDelete;

    private final List<ImpactedAwsRegion> impactedAwsRegionsToAdd;

    private final List<ImpactedAwsRegion> impactedAwsRegionsToDelete;

    private final List<String> impactedAccountsToAdd;

    private final List<String> impactedAccountsToDelete;

    private UpdateCaseRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.title = builder.title;
        this.description = builder.description;
        this.reportedIncidentStartDate = builder.reportedIncidentStartDate;
        this.actualIncidentStartDate = builder.actualIncidentStartDate;
        this.engagementType = builder.engagementType;
        this.watchersToAdd = builder.watchersToAdd;
        this.watchersToDelete = builder.watchersToDelete;
        this.threatActorIpAddressesToAdd = builder.threatActorIpAddressesToAdd;
        this.threatActorIpAddressesToDelete = builder.threatActorIpAddressesToDelete;
        this.impactedServicesToAdd = builder.impactedServicesToAdd;
        this.impactedServicesToDelete = builder.impactedServicesToDelete;
        this.impactedAwsRegionsToAdd = builder.impactedAwsRegionsToAdd;
        this.impactedAwsRegionsToDelete = builder.impactedAwsRegionsToDelete;
        this.impactedAccountsToAdd = builder.impactedAccountsToAdd;
        this.impactedAccountsToDelete = builder.impactedAccountsToDelete;
    }

    /**
     * <p>
     * Required element for UpdateCase to identify the case ID for updates.
     * </p>
     * 
     * @return Required element for UpdateCase to identify the case ID for updates.
     */
    public final String caseId() {
        return caseId;
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content for the title field.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content for the title field.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content for the description field.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content for the description field.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content for the customer reported incident start date field.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content for the customer reported incident start date field.
     */
    public final Instant reportedIncidentStartDate() {
        return reportedIncidentStartDate;
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content for the incident start date field.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content for the incident start date field.
     */
    public final Instant actualIncidentStartDate() {
        return actualIncidentStartDate;
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content for the engagement type field.
     * <code>Available engagement types include Security Incident | Investigation</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementType}
     * will return {@link EngagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #engagementTypeAsString}.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content for the engagement type field.
     *         <code>Available engagement types include Security Incident | Investigation</code>.
     * @see EngagementType
     */
    public final EngagementType engagementType() {
        return EngagementType.fromValue(engagementType);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content for the engagement type field.
     * <code>Available engagement types include Security Incident | Investigation</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engagementType}
     * will return {@link EngagementType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #engagementTypeAsString}.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content for the engagement type field.
     *         <code>Available engagement types include Security Incident | Investigation</code>.
     * @see EngagementType
     */
    public final String engagementTypeAsString() {
        return engagementType;
    }

    /**
     * For responses, this returns true if the service returned a value for the WatchersToAdd property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWatchersToAdd() {
        return watchersToAdd != null && !(watchersToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content to add additional watchers to a case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWatchersToAdd} method.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content to add additional watchers to a case.
     */
    public final List<Watcher> watchersToAdd() {
        return watchersToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the WatchersToDelete property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasWatchersToDelete() {
        return watchersToDelete != null && !(watchersToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content to remove existing watchers from a case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWatchersToDelete} method.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content to remove existing watchers from a case.
     */
    public final List<Watcher> watchersToDelete() {
        return watchersToDelete;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThreatActorIpAddressesToAdd property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasThreatActorIpAddressesToAdd() {
        return threatActorIpAddressesToAdd != null && !(threatActorIpAddressesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content to add additional suspicious IP addresses related to a case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThreatActorIpAddressesToAdd} method.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content to add additional suspicious IP addresses related to a
     *         case.
     */
    public final List<ThreatActorIp> threatActorIpAddressesToAdd() {
        return threatActorIpAddressesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the ThreatActorIpAddressesToDelete property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasThreatActorIpAddressesToDelete() {
        return threatActorIpAddressesToDelete != null && !(threatActorIpAddressesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content to remove suspicious IP addresses from a case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasThreatActorIpAddressesToDelete} method.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content to remove suspicious IP addresses from a case.
     */
    public final List<ThreatActorIp> threatActorIpAddressesToDelete() {
        return threatActorIpAddressesToDelete;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedServicesToAdd property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImpactedServicesToAdd() {
        return impactedServicesToAdd != null && !(impactedServicesToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content to add services impacted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedServicesToAdd} method.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content to add services impacted.
     */
    public final List<String> impactedServicesToAdd() {
        return impactedServicesToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedServicesToDelete property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImpactedServicesToDelete() {
        return impactedServicesToDelete != null && !(impactedServicesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content to remove services impacted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedServicesToDelete} method.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content to remove services impacted.
     */
    public final List<String> impactedServicesToDelete() {
        return impactedServicesToDelete;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedAwsRegionsToAdd property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImpactedAwsRegionsToAdd() {
        return impactedAwsRegionsToAdd != null && !(impactedAwsRegionsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content to add regions impacted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedAwsRegionsToAdd} method.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content to add regions impacted.
     */
    public final List<ImpactedAwsRegion> impactedAwsRegionsToAdd() {
        return impactedAwsRegionsToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedAwsRegionsToDelete property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImpactedAwsRegionsToDelete() {
        return impactedAwsRegionsToDelete != null && !(impactedAwsRegionsToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content to remove regions impacted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedAwsRegionsToDelete} method.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content to remove regions impacted.
     */
    public final List<ImpactedAwsRegion> impactedAwsRegionsToDelete() {
        return impactedAwsRegionsToDelete;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedAccountsToAdd property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImpactedAccountsToAdd() {
        return impactedAccountsToAdd != null && !(impactedAccountsToAdd instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content to add accounts impacted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedAccountsToAdd} method.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content to add accounts impacted.
     */
    public final List<String> impactedAccountsToAdd() {
        return impactedAccountsToAdd;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImpactedAccountsToDelete property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasImpactedAccountsToDelete() {
        return impactedAccountsToDelete != null && !(impactedAccountsToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Optional element for UpdateCase to provide content to add accounts impacted.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImpactedAccountsToDelete} method.
     * </p>
     * 
     * @return Optional element for UpdateCase to provide content to add accounts impacted.
     */
    public final List<String> impactedAccountsToDelete() {
        return impactedAccountsToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(reportedIncidentStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(actualIncidentStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(engagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasWatchersToAdd() ? watchersToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasWatchersToDelete() ? watchersToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasThreatActorIpAddressesToAdd() ? threatActorIpAddressesToAdd() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasThreatActorIpAddressesToDelete() ? threatActorIpAddressesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedServicesToAdd() ? impactedServicesToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedServicesToDelete() ? impactedServicesToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedAwsRegionsToAdd() ? impactedAwsRegionsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedAwsRegionsToDelete() ? impactedAwsRegionsToDelete() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedAccountsToAdd() ? impactedAccountsToAdd() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImpactedAccountsToDelete() ? impactedAccountsToDelete() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCaseRequest)) {
            return false;
        }
        UpdateCaseRequest other = (UpdateCaseRequest) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description())
                && Objects.equals(reportedIncidentStartDate(), other.reportedIncidentStartDate())
                && Objects.equals(actualIncidentStartDate(), other.actualIncidentStartDate())
                && Objects.equals(engagementTypeAsString(), other.engagementTypeAsString())
                && hasWatchersToAdd() == other.hasWatchersToAdd() && Objects.equals(watchersToAdd(), other.watchersToAdd())
                && hasWatchersToDelete() == other.hasWatchersToDelete()
                && Objects.equals(watchersToDelete(), other.watchersToDelete())
                && hasThreatActorIpAddressesToAdd() == other.hasThreatActorIpAddressesToAdd()
                && Objects.equals(threatActorIpAddressesToAdd(), other.threatActorIpAddressesToAdd())
                && hasThreatActorIpAddressesToDelete() == other.hasThreatActorIpAddressesToDelete()
                && Objects.equals(threatActorIpAddressesToDelete(), other.threatActorIpAddressesToDelete())
                && hasImpactedServicesToAdd() == other.hasImpactedServicesToAdd()
                && Objects.equals(impactedServicesToAdd(), other.impactedServicesToAdd())
                && hasImpactedServicesToDelete() == other.hasImpactedServicesToDelete()
                && Objects.equals(impactedServicesToDelete(), other.impactedServicesToDelete())
                && hasImpactedAwsRegionsToAdd() == other.hasImpactedAwsRegionsToAdd()
                && Objects.equals(impactedAwsRegionsToAdd(), other.impactedAwsRegionsToAdd())
                && hasImpactedAwsRegionsToDelete() == other.hasImpactedAwsRegionsToDelete()
                && Objects.equals(impactedAwsRegionsToDelete(), other.impactedAwsRegionsToDelete())
                && hasImpactedAccountsToAdd() == other.hasImpactedAccountsToAdd()
                && Objects.equals(impactedAccountsToAdd(), other.impactedAccountsToAdd())
                && hasImpactedAccountsToDelete() == other.hasImpactedAccountsToDelete()
                && Objects.equals(impactedAccountsToDelete(), other.impactedAccountsToDelete());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("UpdateCaseRequest")
                .add("CaseId", caseId())
                .add("Title", title() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ReportedIncidentStartDate", reportedIncidentStartDate())
                .add("ActualIncidentStartDate", actualIncidentStartDate())
                .add("EngagementType", engagementTypeAsString())
                .add("WatchersToAdd", hasWatchersToAdd() ? watchersToAdd() : null)
                .add("WatchersToDelete", hasWatchersToDelete() ? watchersToDelete() : null)
                .add("ThreatActorIpAddressesToAdd", hasThreatActorIpAddressesToAdd() ? threatActorIpAddressesToAdd() : null)
                .add("ThreatActorIpAddressesToDelete",
                        hasThreatActorIpAddressesToDelete() ? threatActorIpAddressesToDelete() : null)
                .add("ImpactedServicesToAdd", hasImpactedServicesToAdd() ? impactedServicesToAdd() : null)
                .add("ImpactedServicesToDelete", hasImpactedServicesToDelete() ? impactedServicesToDelete() : null)
                .add("ImpactedAwsRegionsToAdd", hasImpactedAwsRegionsToAdd() ? impactedAwsRegionsToAdd() : null)
                .add("ImpactedAwsRegionsToDelete", hasImpactedAwsRegionsToDelete() ? impactedAwsRegionsToDelete() : null)
                .add("ImpactedAccountsToAdd", hasImpactedAccountsToAdd() ? impactedAccountsToAdd() : null)
                .add("ImpactedAccountsToDelete", hasImpactedAccountsToDelete() ? impactedAccountsToDelete() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "title":
            return Optional.ofNullable(clazz.cast(title()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "reportedIncidentStartDate":
            return Optional.ofNullable(clazz.cast(reportedIncidentStartDate()));
        case "actualIncidentStartDate":
            return Optional.ofNullable(clazz.cast(actualIncidentStartDate()));
        case "engagementType":
            return Optional.ofNullable(clazz.cast(engagementTypeAsString()));
        case "watchersToAdd":
            return Optional.ofNullable(clazz.cast(watchersToAdd()));
        case "watchersToDelete":
            return Optional.ofNullable(clazz.cast(watchersToDelete()));
        case "threatActorIpAddressesToAdd":
            return Optional.ofNullable(clazz.cast(threatActorIpAddressesToAdd()));
        case "threatActorIpAddressesToDelete":
            return Optional.ofNullable(clazz.cast(threatActorIpAddressesToDelete()));
        case "impactedServicesToAdd":
            return Optional.ofNullable(clazz.cast(impactedServicesToAdd()));
        case "impactedServicesToDelete":
            return Optional.ofNullable(clazz.cast(impactedServicesToDelete()));
        case "impactedAwsRegionsToAdd":
            return Optional.ofNullable(clazz.cast(impactedAwsRegionsToAdd()));
        case "impactedAwsRegionsToDelete":
            return Optional.ofNullable(clazz.cast(impactedAwsRegionsToDelete()));
        case "impactedAccountsToAdd":
            return Optional.ofNullable(clazz.cast(impactedAccountsToAdd()));
        case "impactedAccountsToDelete":
            return Optional.ofNullable(clazz.cast(impactedAccountsToDelete()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("title", TITLE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("reportedIncidentStartDate", REPORTED_INCIDENT_START_DATE_FIELD);
        map.put("actualIncidentStartDate", ACTUAL_INCIDENT_START_DATE_FIELD);
        map.put("engagementType", ENGAGEMENT_TYPE_FIELD);
        map.put("watchersToAdd", WATCHERS_TO_ADD_FIELD);
        map.put("watchersToDelete", WATCHERS_TO_DELETE_FIELD);
        map.put("threatActorIpAddressesToAdd", THREAT_ACTOR_IP_ADDRESSES_TO_ADD_FIELD);
        map.put("threatActorIpAddressesToDelete", THREAT_ACTOR_IP_ADDRESSES_TO_DELETE_FIELD);
        map.put("impactedServicesToAdd", IMPACTED_SERVICES_TO_ADD_FIELD);
        map.put("impactedServicesToDelete", IMPACTED_SERVICES_TO_DELETE_FIELD);
        map.put("impactedAwsRegionsToAdd", IMPACTED_AWS_REGIONS_TO_ADD_FIELD);
        map.put("impactedAwsRegionsToDelete", IMPACTED_AWS_REGIONS_TO_DELETE_FIELD);
        map.put("impactedAccountsToAdd", IMPACTED_ACCOUNTS_TO_ADD_FIELD);
        map.put("impactedAccountsToDelete", IMPACTED_ACCOUNTS_TO_DELETE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCaseRequest, T> g) {
        return obj -> g.apply((UpdateCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityIrRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCaseRequest> {
        /**
         * <p>
         * Required element for UpdateCase to identify the case ID for updates.
         * </p>
         * 
         * @param caseId
         *        Required element for UpdateCase to identify the case ID for updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * Optional element for UpdateCase to provide content for the title field.
         * </p>
         * 
         * @param title
         *        Optional element for UpdateCase to provide content for the title field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * Optional element for UpdateCase to provide content for the description field.
         * </p>
         * 
         * @param description
         *        Optional element for UpdateCase to provide content for the description field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Optional element for UpdateCase to provide content for the customer reported incident start date field.
         * </p>
         * 
         * @param reportedIncidentStartDate
         *        Optional element for UpdateCase to provide content for the customer reported incident start date
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportedIncidentStartDate(Instant reportedIncidentStartDate);

        /**
         * <p>
         * Optional element for UpdateCase to provide content for the incident start date field.
         * </p>
         * 
         * @param actualIncidentStartDate
         *        Optional element for UpdateCase to provide content for the incident start date field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualIncidentStartDate(Instant actualIncidentStartDate);

        /**
         * <p>
         * Optional element for UpdateCase to provide content for the engagement type field.
         * <code>Available engagement types include Security Incident | Investigation</code>.
         * </p>
         * 
         * @param engagementType
         *        Optional element for UpdateCase to provide content for the engagement type field.
         *        <code>Available engagement types include Security Incident | Investigation</code>.
         * @see EngagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementType
         */
        Builder engagementType(String engagementType);

        /**
         * <p>
         * Optional element for UpdateCase to provide content for the engagement type field.
         * <code>Available engagement types include Security Incident | Investigation</code>.
         * </p>
         * 
         * @param engagementType
         *        Optional element for UpdateCase to provide content for the engagement type field.
         *        <code>Available engagement types include Security Incident | Investigation</code>.
         * @see EngagementType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngagementType
         */
        Builder engagementType(EngagementType engagementType);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add additional watchers to a case.
         * </p>
         * 
         * @param watchersToAdd
         *        Optional element for UpdateCase to provide content to add additional watchers to a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchersToAdd(Collection<Watcher> watchersToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add additional watchers to a case.
         * </p>
         * 
         * @param watchersToAdd
         *        Optional element for UpdateCase to provide content to add additional watchers to a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchersToAdd(Watcher... watchersToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add additional watchers to a case.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityir.model.Watcher#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder#build()} is called immediately and
         * its result is passed to {@link #watchersToAdd(List<Watcher>)}.
         * 
         * @param watchersToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #watchersToAdd(java.util.Collection<Watcher>)
         */
        Builder watchersToAdd(Consumer<Watcher.Builder>... watchersToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove existing watchers from a case.
         * </p>
         * 
         * @param watchersToDelete
         *        Optional element for UpdateCase to provide content to remove existing watchers from a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchersToDelete(Collection<Watcher> watchersToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove existing watchers from a case.
         * </p>
         * 
         * @param watchersToDelete
         *        Optional element for UpdateCase to provide content to remove existing watchers from a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder watchersToDelete(Watcher... watchersToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove existing watchers from a case.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.securityir.model.Watcher#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder#build()} is called immediately and
         * its result is passed to {@link #watchersToDelete(List<Watcher>)}.
         * 
         * @param watchersToDelete
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.Watcher.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #watchersToDelete(java.util.Collection<Watcher>)
         */
        Builder watchersToDelete(Consumer<Watcher.Builder>... watchersToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add additional suspicious IP addresses related to a
         * case.
         * </p>
         * 
         * @param threatActorIpAddressesToAdd
         *        Optional element for UpdateCase to provide content to add additional suspicious IP addresses related
         *        to a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatActorIpAddressesToAdd(Collection<ThreatActorIp> threatActorIpAddressesToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add additional suspicious IP addresses related to a
         * case.
         * </p>
         * 
         * @param threatActorIpAddressesToAdd
         *        Optional element for UpdateCase to provide content to add additional suspicious IP addresses related
         *        to a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatActorIpAddressesToAdd(ThreatActorIp... threatActorIpAddressesToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add additional suspicious IP addresses related to a
         * case.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder#build()} is called immediately
         * and its result is passed to {@link #threatActorIpAddressesToAdd(List<ThreatActorIp>)}.
         * 
         * @param threatActorIpAddressesToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatActorIpAddressesToAdd(java.util.Collection<ThreatActorIp>)
         */
        Builder threatActorIpAddressesToAdd(Consumer<ThreatActorIp.Builder>... threatActorIpAddressesToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove suspicious IP addresses from a case.
         * </p>
         * 
         * @param threatActorIpAddressesToDelete
         *        Optional element for UpdateCase to provide content to remove suspicious IP addresses from a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatActorIpAddressesToDelete(Collection<ThreatActorIp> threatActorIpAddressesToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove suspicious IP addresses from a case.
         * </p>
         * 
         * @param threatActorIpAddressesToDelete
         *        Optional element for UpdateCase to provide content to remove suspicious IP addresses from a case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder threatActorIpAddressesToDelete(ThreatActorIp... threatActorIpAddressesToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove suspicious IP addresses from a case.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder#build()} is called immediately
         * and its result is passed to {@link #threatActorIpAddressesToDelete(List<ThreatActorIp>)}.
         * 
         * @param threatActorIpAddressesToDelete
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.ThreatActorIp.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #threatActorIpAddressesToDelete(java.util.Collection<ThreatActorIp>)
         */
        Builder threatActorIpAddressesToDelete(Consumer<ThreatActorIp.Builder>... threatActorIpAddressesToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add services impacted.
         * </p>
         * 
         * @param impactedServicesToAdd
         *        Optional element for UpdateCase to provide content to add services impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedServicesToAdd(Collection<String> impactedServicesToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add services impacted.
         * </p>
         * 
         * @param impactedServicesToAdd
         *        Optional element for UpdateCase to provide content to add services impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedServicesToAdd(String... impactedServicesToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove services impacted.
         * </p>
         * 
         * @param impactedServicesToDelete
         *        Optional element for UpdateCase to provide content to remove services impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedServicesToDelete(Collection<String> impactedServicesToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove services impacted.
         * </p>
         * 
         * @param impactedServicesToDelete
         *        Optional element for UpdateCase to provide content to remove services impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedServicesToDelete(String... impactedServicesToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add regions impacted.
         * </p>
         * 
         * @param impactedAwsRegionsToAdd
         *        Optional element for UpdateCase to provide content to add regions impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAwsRegionsToAdd(Collection<ImpactedAwsRegion> impactedAwsRegionsToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add regions impacted.
         * </p>
         * 
         * @param impactedAwsRegionsToAdd
         *        Optional element for UpdateCase to provide content to add regions impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAwsRegionsToAdd(ImpactedAwsRegion... impactedAwsRegionsToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add regions impacted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder#build()} is called
         * immediately and its result is passed to {@link #impactedAwsRegionsToAdd(List<ImpactedAwsRegion>)}.
         * 
         * @param impactedAwsRegionsToAdd
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #impactedAwsRegionsToAdd(java.util.Collection<ImpactedAwsRegion>)
         */
        Builder impactedAwsRegionsToAdd(Consumer<ImpactedAwsRegion.Builder>... impactedAwsRegionsToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove regions impacted.
         * </p>
         * 
         * @param impactedAwsRegionsToDelete
         *        Optional element for UpdateCase to provide content to remove regions impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAwsRegionsToDelete(Collection<ImpactedAwsRegion> impactedAwsRegionsToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove regions impacted.
         * </p>
         * 
         * @param impactedAwsRegionsToDelete
         *        Optional element for UpdateCase to provide content to remove regions impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAwsRegionsToDelete(ImpactedAwsRegion... impactedAwsRegionsToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to remove regions impacted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder#build()} is called
         * immediately and its result is passed to {@link #impactedAwsRegionsToDelete(List<ImpactedAwsRegion>)}.
         * 
         * @param impactedAwsRegionsToDelete
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #impactedAwsRegionsToDelete(java.util.Collection<ImpactedAwsRegion>)
         */
        Builder impactedAwsRegionsToDelete(Consumer<ImpactedAwsRegion.Builder>... impactedAwsRegionsToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add accounts impacted.
         * </p>
         * 
         * @param impactedAccountsToAdd
         *        Optional element for UpdateCase to provide content to add accounts impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAccountsToAdd(Collection<String> impactedAccountsToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add accounts impacted.
         * </p>
         * 
         * @param impactedAccountsToAdd
         *        Optional element for UpdateCase to provide content to add accounts impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAccountsToAdd(String... impactedAccountsToAdd);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add accounts impacted.
         * </p>
         * 
         * @param impactedAccountsToDelete
         *        Optional element for UpdateCase to provide content to add accounts impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAccountsToDelete(Collection<String> impactedAccountsToDelete);

        /**
         * <p>
         * Optional element for UpdateCase to provide content to add accounts impacted.
         * </p>
         * 
         * @param impactedAccountsToDelete
         *        Optional element for UpdateCase to provide content to add accounts impacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder impactedAccountsToDelete(String... impactedAccountsToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityIrRequest.BuilderImpl implements Builder {
        private String caseId;

        private String title;

        private String description;

        private Instant reportedIncidentStartDate;

        private Instant actualIncidentStartDate;

        private String engagementType;

        private List<Watcher> watchersToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<Watcher> watchersToDelete = DefaultSdkAutoConstructList.getInstance();

        private List<ThreatActorIp> threatActorIpAddressesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<ThreatActorIp> threatActorIpAddressesToDelete = DefaultSdkAutoConstructList.getInstance();

        private List<String> impactedServicesToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> impactedServicesToDelete = DefaultSdkAutoConstructList.getInstance();

        private List<ImpactedAwsRegion> impactedAwsRegionsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<ImpactedAwsRegion> impactedAwsRegionsToDelete = DefaultSdkAutoConstructList.getInstance();

        private List<String> impactedAccountsToAdd = DefaultSdkAutoConstructList.getInstance();

        private List<String> impactedAccountsToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCaseRequest model) {
            super(model);
            caseId(model.caseId);
            title(model.title);
            description(model.description);
            reportedIncidentStartDate(model.reportedIncidentStartDate);
            actualIncidentStartDate(model.actualIncidentStartDate);
            engagementType(model.engagementType);
            watchersToAdd(model.watchersToAdd);
            watchersToDelete(model.watchersToDelete);
            threatActorIpAddressesToAdd(model.threatActorIpAddressesToAdd);
            threatActorIpAddressesToDelete(model.threatActorIpAddressesToDelete);
            impactedServicesToAdd(model.impactedServicesToAdd);
            impactedServicesToDelete(model.impactedServicesToDelete);
            impactedAwsRegionsToAdd(model.impactedAwsRegionsToAdd);
            impactedAwsRegionsToDelete(model.impactedAwsRegionsToDelete);
            impactedAccountsToAdd(model.impactedAccountsToAdd);
            impactedAccountsToDelete(model.impactedAccountsToDelete);
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getReportedIncidentStartDate() {
            return reportedIncidentStartDate;
        }

        public final void setReportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
        }

        @Override
        public final Builder reportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
            return this;
        }

        public final Instant getActualIncidentStartDate() {
            return actualIncidentStartDate;
        }

        public final void setActualIncidentStartDate(Instant actualIncidentStartDate) {
            this.actualIncidentStartDate = actualIncidentStartDate;
        }

        @Override
        public final Builder actualIncidentStartDate(Instant actualIncidentStartDate) {
            this.actualIncidentStartDate = actualIncidentStartDate;
            return this;
        }

        public final String getEngagementType() {
            return engagementType;
        }

        public final void setEngagementType(String engagementType) {
            this.engagementType = engagementType;
        }

        @Override
        public final Builder engagementType(String engagementType) {
            this.engagementType = engagementType;
            return this;
        }

        @Override
        public final Builder engagementType(EngagementType engagementType) {
            this.engagementType(engagementType == null ? null : engagementType.toString());
            return this;
        }

        public final List<Watcher.Builder> getWatchersToAdd() {
            List<Watcher.Builder> result = WatchersCopier.copyToBuilder(this.watchersToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatchersToAdd(Collection<Watcher.BuilderImpl> watchersToAdd) {
            this.watchersToAdd = WatchersCopier.copyFromBuilder(watchersToAdd);
        }

        @Override
        public final Builder watchersToAdd(Collection<Watcher> watchersToAdd) {
            this.watchersToAdd = WatchersCopier.copy(watchersToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchersToAdd(Watcher... watchersToAdd) {
            watchersToAdd(Arrays.asList(watchersToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchersToAdd(Consumer<Watcher.Builder>... watchersToAdd) {
            watchersToAdd(Stream.of(watchersToAdd).map(c -> Watcher.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Watcher.Builder> getWatchersToDelete() {
            List<Watcher.Builder> result = WatchersCopier.copyToBuilder(this.watchersToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatchersToDelete(Collection<Watcher.BuilderImpl> watchersToDelete) {
            this.watchersToDelete = WatchersCopier.copyFromBuilder(watchersToDelete);
        }

        @Override
        public final Builder watchersToDelete(Collection<Watcher> watchersToDelete) {
            this.watchersToDelete = WatchersCopier.copy(watchersToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchersToDelete(Watcher... watchersToDelete) {
            watchersToDelete(Arrays.asList(watchersToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchersToDelete(Consumer<Watcher.Builder>... watchersToDelete) {
            watchersToDelete(Stream.of(watchersToDelete).map(c -> Watcher.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ThreatActorIp.Builder> getThreatActorIpAddressesToAdd() {
            List<ThreatActorIp.Builder> result = ThreatActorIpListCopier.copyToBuilder(this.threatActorIpAddressesToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatActorIpAddressesToAdd(Collection<ThreatActorIp.BuilderImpl> threatActorIpAddressesToAdd) {
            this.threatActorIpAddressesToAdd = ThreatActorIpListCopier.copyFromBuilder(threatActorIpAddressesToAdd);
        }

        @Override
        public final Builder threatActorIpAddressesToAdd(Collection<ThreatActorIp> threatActorIpAddressesToAdd) {
            this.threatActorIpAddressesToAdd = ThreatActorIpListCopier.copy(threatActorIpAddressesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddressesToAdd(ThreatActorIp... threatActorIpAddressesToAdd) {
            threatActorIpAddressesToAdd(Arrays.asList(threatActorIpAddressesToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddressesToAdd(Consumer<ThreatActorIp.Builder>... threatActorIpAddressesToAdd) {
            threatActorIpAddressesToAdd(Stream.of(threatActorIpAddressesToAdd)
                    .map(c -> ThreatActorIp.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ThreatActorIp.Builder> getThreatActorIpAddressesToDelete() {
            List<ThreatActorIp.Builder> result = ThreatActorIpListCopier.copyToBuilder(this.threatActorIpAddressesToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatActorIpAddressesToDelete(Collection<ThreatActorIp.BuilderImpl> threatActorIpAddressesToDelete) {
            this.threatActorIpAddressesToDelete = ThreatActorIpListCopier.copyFromBuilder(threatActorIpAddressesToDelete);
        }

        @Override
        public final Builder threatActorIpAddressesToDelete(Collection<ThreatActorIp> threatActorIpAddressesToDelete) {
            this.threatActorIpAddressesToDelete = ThreatActorIpListCopier.copy(threatActorIpAddressesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddressesToDelete(ThreatActorIp... threatActorIpAddressesToDelete) {
            threatActorIpAddressesToDelete(Arrays.asList(threatActorIpAddressesToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddressesToDelete(Consumer<ThreatActorIp.Builder>... threatActorIpAddressesToDelete) {
            threatActorIpAddressesToDelete(Stream.of(threatActorIpAddressesToDelete)
                    .map(c -> ThreatActorIp.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getImpactedServicesToAdd() {
            if (impactedServicesToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return impactedServicesToAdd;
        }

        public final void setImpactedServicesToAdd(Collection<String> impactedServicesToAdd) {
            this.impactedServicesToAdd = ImpactedServicesListCopier.copy(impactedServicesToAdd);
        }

        @Override
        public final Builder impactedServicesToAdd(Collection<String> impactedServicesToAdd) {
            this.impactedServicesToAdd = ImpactedServicesListCopier.copy(impactedServicesToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedServicesToAdd(String... impactedServicesToAdd) {
            impactedServicesToAdd(Arrays.asList(impactedServicesToAdd));
            return this;
        }

        public final Collection<String> getImpactedServicesToDelete() {
            if (impactedServicesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return impactedServicesToDelete;
        }

        public final void setImpactedServicesToDelete(Collection<String> impactedServicesToDelete) {
            this.impactedServicesToDelete = ImpactedServicesListCopier.copy(impactedServicesToDelete);
        }

        @Override
        public final Builder impactedServicesToDelete(Collection<String> impactedServicesToDelete) {
            this.impactedServicesToDelete = ImpactedServicesListCopier.copy(impactedServicesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedServicesToDelete(String... impactedServicesToDelete) {
            impactedServicesToDelete(Arrays.asList(impactedServicesToDelete));
            return this;
        }

        public final List<ImpactedAwsRegion.Builder> getImpactedAwsRegionsToAdd() {
            List<ImpactedAwsRegion.Builder> result = ImpactedAwsRegionListCopier.copyToBuilder(this.impactedAwsRegionsToAdd);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpactedAwsRegionsToAdd(Collection<ImpactedAwsRegion.BuilderImpl> impactedAwsRegionsToAdd) {
            this.impactedAwsRegionsToAdd = ImpactedAwsRegionListCopier.copyFromBuilder(impactedAwsRegionsToAdd);
        }

        @Override
        public final Builder impactedAwsRegionsToAdd(Collection<ImpactedAwsRegion> impactedAwsRegionsToAdd) {
            this.impactedAwsRegionsToAdd = ImpactedAwsRegionListCopier.copy(impactedAwsRegionsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegionsToAdd(ImpactedAwsRegion... impactedAwsRegionsToAdd) {
            impactedAwsRegionsToAdd(Arrays.asList(impactedAwsRegionsToAdd));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegionsToAdd(Consumer<ImpactedAwsRegion.Builder>... impactedAwsRegionsToAdd) {
            impactedAwsRegionsToAdd(Stream.of(impactedAwsRegionsToAdd)
                    .map(c -> ImpactedAwsRegion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ImpactedAwsRegion.Builder> getImpactedAwsRegionsToDelete() {
            List<ImpactedAwsRegion.Builder> result = ImpactedAwsRegionListCopier.copyToBuilder(this.impactedAwsRegionsToDelete);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpactedAwsRegionsToDelete(Collection<ImpactedAwsRegion.BuilderImpl> impactedAwsRegionsToDelete) {
            this.impactedAwsRegionsToDelete = ImpactedAwsRegionListCopier.copyFromBuilder(impactedAwsRegionsToDelete);
        }

        @Override
        public final Builder impactedAwsRegionsToDelete(Collection<ImpactedAwsRegion> impactedAwsRegionsToDelete) {
            this.impactedAwsRegionsToDelete = ImpactedAwsRegionListCopier.copy(impactedAwsRegionsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegionsToDelete(ImpactedAwsRegion... impactedAwsRegionsToDelete) {
            impactedAwsRegionsToDelete(Arrays.asList(impactedAwsRegionsToDelete));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegionsToDelete(Consumer<ImpactedAwsRegion.Builder>... impactedAwsRegionsToDelete) {
            impactedAwsRegionsToDelete(Stream.of(impactedAwsRegionsToDelete)
                    .map(c -> ImpactedAwsRegion.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getImpactedAccountsToAdd() {
            if (impactedAccountsToAdd instanceof SdkAutoConstructList) {
                return null;
            }
            return impactedAccountsToAdd;
        }

        public final void setImpactedAccountsToAdd(Collection<String> impactedAccountsToAdd) {
            this.impactedAccountsToAdd = ImpactedAccountsCopier.copy(impactedAccountsToAdd);
        }

        @Override
        public final Builder impactedAccountsToAdd(Collection<String> impactedAccountsToAdd) {
            this.impactedAccountsToAdd = ImpactedAccountsCopier.copy(impactedAccountsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAccountsToAdd(String... impactedAccountsToAdd) {
            impactedAccountsToAdd(Arrays.asList(impactedAccountsToAdd));
            return this;
        }

        public final Collection<String> getImpactedAccountsToDelete() {
            if (impactedAccountsToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return impactedAccountsToDelete;
        }

        public final void setImpactedAccountsToDelete(Collection<String> impactedAccountsToDelete) {
            this.impactedAccountsToDelete = ImpactedAccountsCopier.copy(impactedAccountsToDelete);
        }

        @Override
        public final Builder impactedAccountsToDelete(Collection<String> impactedAccountsToDelete) {
            this.impactedAccountsToDelete = ImpactedAccountsCopier.copy(impactedAccountsToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAccountsToDelete(String... impactedAccountsToDelete) {
            impactedAccountsToDelete(Arrays.asList(impactedAccountsToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateCaseRequest build() {
            return new UpdateCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
