/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResolverTypeRequest extends SecurityIrRequest implements
        ToCopyableBuilder<UpdateResolverTypeRequest.Builder, UpdateResolverTypeRequest> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caseId")
            .getter(getter(UpdateResolverTypeRequest::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("caseId").build()).build();

    private static final SdkField<String> RESOLVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolverType").getter(getter(UpdateResolverTypeRequest::resolverTypeAsString))
            .setter(setter(Builder::resolverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD,
            RESOLVER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String caseId;

    private final String resolverType;

    private UpdateResolverTypeRequest(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.resolverType = builder.resolverType;
    }

    /**
     * <p>
     * Required element for UpdateResolverType to identify the case to update.
     * </p>
     * 
     * @return Required element for UpdateResolverType to identify the case to update.
     */
    public final String caseId() {
        return caseId;
    }

    /**
     * <p>
     * Required element for UpdateResolverType to identify the new resolver.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolverType} will
     * return {@link ResolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolverTypeAsString}.
     * </p>
     * 
     * @return Required element for UpdateResolverType to identify the new resolver.
     * @see ResolverType
     */
    public final ResolverType resolverType() {
        return ResolverType.fromValue(resolverType);
    }

    /**
     * <p>
     * Required element for UpdateResolverType to identify the new resolver.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolverType} will
     * return {@link ResolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolverTypeAsString}.
     * </p>
     * 
     * @return Required element for UpdateResolverType to identify the new resolver.
     * @see ResolverType
     */
    public final String resolverTypeAsString() {
        return resolverType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(resolverTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverTypeRequest)) {
            return false;
        }
        UpdateResolverTypeRequest other = (UpdateResolverTypeRequest) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(resolverTypeAsString(), other.resolverTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResolverTypeRequest").add("CaseId", caseId()).add("ResolverType", resolverTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "resolverType":
            return Optional.ofNullable(clazz.cast(resolverTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("resolverType", RESOLVER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverTypeRequest, T> g) {
        return obj -> g.apply((UpdateResolverTypeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityIrRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResolverTypeRequest> {
        /**
         * <p>
         * Required element for UpdateResolverType to identify the case to update.
         * </p>
         * 
         * @param caseId
         *        Required element for UpdateResolverType to identify the case to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * Required element for UpdateResolverType to identify the new resolver.
         * </p>
         * 
         * @param resolverType
         *        Required element for UpdateResolverType to identify the new resolver.
         * @see ResolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverType
         */
        Builder resolverType(String resolverType);

        /**
         * <p>
         * Required element for UpdateResolverType to identify the new resolver.
         * </p>
         * 
         * @param resolverType
         *        Required element for UpdateResolverType to identify the new resolver.
         * @see ResolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverType
         */
        Builder resolverType(ResolverType resolverType);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SecurityIrRequest.BuilderImpl implements Builder {
        private String caseId;

        private String resolverType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverTypeRequest model) {
            super(model);
            caseId(model.caseId);
            resolverType(model.resolverType);
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getResolverType() {
            return resolverType;
        }

        public final void setResolverType(String resolverType) {
            this.resolverType = resolverType;
        }

        @Override
        public final Builder resolverType(String resolverType) {
            this.resolverType = resolverType;
            return this;
        }

        @Override
        public final Builder resolverType(ResolverType resolverType) {
            this.resolverType(resolverType == null ? null : resolverType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateResolverTypeRequest build() {
            return new UpdateResolverTypeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
