/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResolverTypeResponse extends SecurityIrResponse implements
        ToCopyableBuilder<UpdateResolverTypeResponse.Builder, UpdateResolverTypeResponse> {
    private static final SdkField<String> CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("caseId")
            .getter(getter(UpdateResolverTypeResponse::caseId)).setter(setter(Builder::caseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseId").build()).build();

    private static final SdkField<String> CASE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseStatus").getter(getter(UpdateResolverTypeResponse::caseStatusAsString))
            .setter(setter(Builder::caseStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseStatus").build()).build();

    private static final SdkField<String> RESOLVER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolverType").getter(getter(UpdateResolverTypeResponse::resolverTypeAsString))
            .setter(setter(Builder::resolverType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_ID_FIELD,
            CASE_STATUS_FIELD, RESOLVER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String caseId;

    private final String caseStatus;

    private final String resolverType;

    private UpdateResolverTypeResponse(BuilderImpl builder) {
        super(builder);
        this.caseId = builder.caseId;
        this.caseStatus = builder.caseStatus;
        this.resolverType = builder.resolverType;
    }

    /**
     * <p>
     * Response element for UpdateResolver identifying the case ID being updated.
     * </p>
     * 
     * @return Response element for UpdateResolver identifying the case ID being updated.
     */
    public final String caseId() {
        return caseId;
    }

    /**
     * <p>
     * Response element for UpdateResolver identifying the current status of the case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #caseStatus} will
     * return {@link CaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #caseStatusAsString}.
     * </p>
     * 
     * @return Response element for UpdateResolver identifying the current status of the case.
     * @see CaseStatus
     */
    public final CaseStatus caseStatus() {
        return CaseStatus.fromValue(caseStatus);
    }

    /**
     * <p>
     * Response element for UpdateResolver identifying the current status of the case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #caseStatus} will
     * return {@link CaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #caseStatusAsString}.
     * </p>
     * 
     * @return Response element for UpdateResolver identifying the current status of the case.
     * @see CaseStatus
     */
    public final String caseStatusAsString() {
        return caseStatus;
    }

    /**
     * <p>
     * Response element for UpdateResolver identifying the current resolver of the case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolverType} will
     * return {@link ResolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolverTypeAsString}.
     * </p>
     * 
     * @return Response element for UpdateResolver identifying the current resolver of the case.
     * @see ResolverType
     */
    public final ResolverType resolverType() {
        return ResolverType.fromValue(resolverType);
    }

    /**
     * <p>
     * Response element for UpdateResolver identifying the current resolver of the case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resolverType} will
     * return {@link ResolverType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resolverTypeAsString}.
     * </p>
     * 
     * @return Response element for UpdateResolver identifying the current resolver of the case.
     * @see ResolverType
     */
    public final String resolverTypeAsString() {
        return resolverType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caseId());
        hashCode = 31 * hashCode + Objects.hashCode(caseStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resolverTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverTypeResponse)) {
            return false;
        }
        UpdateResolverTypeResponse other = (UpdateResolverTypeResponse) obj;
        return Objects.equals(caseId(), other.caseId()) && Objects.equals(caseStatusAsString(), other.caseStatusAsString())
                && Objects.equals(resolverTypeAsString(), other.resolverTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResolverTypeResponse").add("CaseId", caseId()).add("CaseStatus", caseStatusAsString())
                .add("ResolverType", resolverTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseId":
            return Optional.ofNullable(clazz.cast(caseId()));
        case "caseStatus":
            return Optional.ofNullable(clazz.cast(caseStatusAsString()));
        case "resolverType":
            return Optional.ofNullable(clazz.cast(resolverTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseId", CASE_ID_FIELD);
        map.put("caseStatus", CASE_STATUS_FIELD);
        map.put("resolverType", RESOLVER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverTypeResponse, T> g) {
        return obj -> g.apply((UpdateResolverTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SecurityIrResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResolverTypeResponse> {
        /**
         * <p>
         * Response element for UpdateResolver identifying the case ID being updated.
         * </p>
         * 
         * @param caseId
         *        Response element for UpdateResolver identifying the case ID being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caseId(String caseId);

        /**
         * <p>
         * Response element for UpdateResolver identifying the current status of the case.
         * </p>
         * 
         * @param caseStatus
         *        Response element for UpdateResolver identifying the current status of the case.
         * @see CaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaseStatus
         */
        Builder caseStatus(String caseStatus);

        /**
         * <p>
         * Response element for UpdateResolver identifying the current status of the case.
         * </p>
         * 
         * @param caseStatus
         *        Response element for UpdateResolver identifying the current status of the case.
         * @see CaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaseStatus
         */
        Builder caseStatus(CaseStatus caseStatus);

        /**
         * <p>
         * Response element for UpdateResolver identifying the current resolver of the case.
         * </p>
         * 
         * @param resolverType
         *        Response element for UpdateResolver identifying the current resolver of the case.
         * @see ResolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverType
         */
        Builder resolverType(String resolverType);

        /**
         * <p>
         * Response element for UpdateResolver identifying the current resolver of the case.
         * </p>
         * 
         * @param resolverType
         *        Response element for UpdateResolver identifying the current resolver of the case.
         * @see ResolverType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverType
         */
        Builder resolverType(ResolverType resolverType);
    }

    static final class BuilderImpl extends SecurityIrResponse.BuilderImpl implements Builder {
        private String caseId;

        private String caseStatus;

        private String resolverType;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverTypeResponse model) {
            super(model);
            caseId(model.caseId);
            caseStatus(model.caseStatus);
            resolverType(model.resolverType);
        }

        public final String getCaseId() {
            return caseId;
        }

        public final void setCaseId(String caseId) {
            this.caseId = caseId;
        }

        @Override
        public final Builder caseId(String caseId) {
            this.caseId = caseId;
            return this;
        }

        public final String getCaseStatus() {
            return caseStatus;
        }

        public final void setCaseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
        }

        @Override
        public final Builder caseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
            return this;
        }

        @Override
        public final Builder caseStatus(CaseStatus caseStatus) {
            this.caseStatus(caseStatus == null ? null : caseStatus.toString());
            return this;
        }

        public final String getResolverType() {
            return resolverType;
        }

        public final void setResolverType(String resolverType) {
            this.resolverType = resolverType;
        }

        @Override
        public final Builder resolverType(String resolverType) {
            this.resolverType = resolverType;
            return this;
        }

        @Override
        public final Builder resolverType(ResolverType resolverType) {
            this.resolverType(resolverType == null ? null : resolverType.toString());
            return this;
        }

        @Override
        public UpdateResolverTypeResponse build() {
            return new UpdateResolverTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
