/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityir.SecurityIrClient;
import software.amazon.awssdk.services.securityir.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityir.model.ListCommentsItem;
import software.amazon.awssdk.services.securityir.model.ListCommentsRequest;
import software.amazon.awssdk.services.securityir.model.ListCommentsResponse;

public class ListCommentsIterable
implements SdkIterable<ListCommentsResponse> {
    private final SecurityIrClient client;
    private final ListCommentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCommentsIterable(SecurityIrClient client, ListCommentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCommentsResponseFetcher();
    }

    public Iterator<ListCommentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListCommentsItem> items() {
        Function<ListCommentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCommentsResponseFetcher
    implements SyncPageFetcher<ListCommentsResponse> {
        private ListCommentsResponseFetcher() {
        }

        public boolean hasNextPage(ListCommentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCommentsResponse nextPage(ListCommentsResponse previousPage) {
            if (previousPage == null) {
                return ListCommentsIterable.this.client.listComments(ListCommentsIterable.this.firstRequest);
            }
            return ListCommentsIterable.this.client.listComments((ListCommentsRequest)((Object)ListCommentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

