/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.CaseAttachmentAttributes;
import software.amazon.awssdk.services.securityir.model.CaseAttachmentsListCopier;
import software.amazon.awssdk.services.securityir.model.CaseStatus;
import software.amazon.awssdk.services.securityir.model.ClosureCode;
import software.amazon.awssdk.services.securityir.model.EngagementType;
import software.amazon.awssdk.services.securityir.model.ImpactedAccountsCopier;
import software.amazon.awssdk.services.securityir.model.ImpactedAwsRegion;
import software.amazon.awssdk.services.securityir.model.ImpactedAwsRegionListCopier;
import software.amazon.awssdk.services.securityir.model.ImpactedServicesListCopier;
import software.amazon.awssdk.services.securityir.model.PendingAction;
import software.amazon.awssdk.services.securityir.model.ResolverType;
import software.amazon.awssdk.services.securityir.model.SecurityIrResponse;
import software.amazon.awssdk.services.securityir.model.ThreatActorIp;
import software.amazon.awssdk.services.securityir.model.ThreatActorIpListCopier;
import software.amazon.awssdk.services.securityir.model.Watcher;
import software.amazon.awssdk.services.securityir.model.WatchersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetCaseResponse
extends SecurityIrResponse
implements ToCopyableBuilder<Builder, GetCaseResponse> {
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("title").getter(GetCaseResponse.getter(GetCaseResponse::title)).setter(GetCaseResponse.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("title").build()}).build();
    private static final SdkField<String> CASE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseArn").getter(GetCaseResponse.getter(GetCaseResponse::caseArn)).setter(GetCaseResponse.setter(Builder::caseArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseArn").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetCaseResponse.getter(GetCaseResponse::description)).setter(GetCaseResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> CASE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("caseStatus").getter(GetCaseResponse.getter(GetCaseResponse::caseStatusAsString)).setter(GetCaseResponse.setter(Builder::caseStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseStatus").build()}).build();
    private static final SdkField<String> ENGAGEMENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engagementType").getter(GetCaseResponse.getter(GetCaseResponse::engagementTypeAsString)).setter(GetCaseResponse.setter(Builder::engagementType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engagementType").build()}).build();
    private static final SdkField<Instant> REPORTED_INCIDENT_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("reportedIncidentStartDate").getter(GetCaseResponse.getter(GetCaseResponse::reportedIncidentStartDate)).setter(GetCaseResponse.setter(Builder::reportedIncidentStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reportedIncidentStartDate").build()}).build();
    private static final SdkField<Instant> ACTUAL_INCIDENT_START_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("actualIncidentStartDate").getter(GetCaseResponse.getter(GetCaseResponse::actualIncidentStartDate)).setter(GetCaseResponse.setter(Builder::actualIncidentStartDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualIncidentStartDate").build()}).build();
    private static final SdkField<List<ImpactedAwsRegion>> IMPACTED_AWS_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedAwsRegions").getter(GetCaseResponse.getter(GetCaseResponse::impactedAwsRegions)).setter(GetCaseResponse.setter(Builder::impactedAwsRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAwsRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImpactedAwsRegion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ThreatActorIp>> THREAT_ACTOR_IP_ADDRESSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("threatActorIpAddresses").getter(GetCaseResponse.getter(GetCaseResponse::threatActorIpAddresses)).setter(GetCaseResponse.setter(Builder::threatActorIpAddresses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("threatActorIpAddresses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ThreatActorIp::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PENDING_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pendingAction").getter(GetCaseResponse.getter(GetCaseResponse::pendingActionAsString)).setter(GetCaseResponse.setter(Builder::pendingAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pendingAction").build()}).build();
    private static final SdkField<List<String>> IMPACTED_ACCOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedAccounts").getter(GetCaseResponse.getter(GetCaseResponse::impactedAccounts)).setter(GetCaseResponse.setter(Builder::impactedAccounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedAccounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Watcher>> WATCHERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("watchers").getter(GetCaseResponse.getter(GetCaseResponse::watchers)).setter(GetCaseResponse.setter(Builder::watchers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("watchers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Watcher::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdDate").getter(GetCaseResponse.getter(GetCaseResponse::createdDate)).setter(GetCaseResponse.setter(Builder::createdDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedDate").getter(GetCaseResponse.getter(GetCaseResponse::lastUpdatedDate)).setter(GetCaseResponse.setter(Builder::lastUpdatedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedDate").build()}).build();
    private static final SdkField<String> CLOSURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("closureCode").getter(GetCaseResponse.getter(GetCaseResponse::closureCodeAsString)).setter(GetCaseResponse.setter(Builder::closureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closureCode").build()}).build();
    private static final SdkField<String> RESOLVER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resolverType").getter(GetCaseResponse.getter(GetCaseResponse::resolverTypeAsString)).setter(GetCaseResponse.setter(Builder::resolverType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverType").build()}).build();
    private static final SdkField<List<String>> IMPACTED_SERVICES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("impactedServices").getter(GetCaseResponse.getter(GetCaseResponse::impactedServices)).setter(GetCaseResponse.setter(Builder::impactedServices)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("impactedServices").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<CaseAttachmentAttributes>> CASE_ATTACHMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("caseAttachments").getter(GetCaseResponse.getter(GetCaseResponse::caseAttachments)).setter(GetCaseResponse.setter(Builder::caseAttachments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseAttachments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CaseAttachmentAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CLOSED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("closedDate").getter(GetCaseResponse.getter(GetCaseResponse::closedDate)).setter(GetCaseResponse.setter(Builder::closedDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("closedDate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_FIELD, CASE_ARN_FIELD, DESCRIPTION_FIELD, CASE_STATUS_FIELD, ENGAGEMENT_TYPE_FIELD, REPORTED_INCIDENT_START_DATE_FIELD, ACTUAL_INCIDENT_START_DATE_FIELD, IMPACTED_AWS_REGIONS_FIELD, THREAT_ACTOR_IP_ADDRESSES_FIELD, PENDING_ACTION_FIELD, IMPACTED_ACCOUNTS_FIELD, WATCHERS_FIELD, CREATED_DATE_FIELD, LAST_UPDATED_DATE_FIELD, CLOSURE_CODE_FIELD, RESOLVER_TYPE_FIELD, IMPACTED_SERVICES_FIELD, CASE_ATTACHMENTS_FIELD, CLOSED_DATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetCaseResponse.memberNameToFieldInitializer();
    private final String title;
    private final String caseArn;
    private final String description;
    private final String caseStatus;
    private final String engagementType;
    private final Instant reportedIncidentStartDate;
    private final Instant actualIncidentStartDate;
    private final List<ImpactedAwsRegion> impactedAwsRegions;
    private final List<ThreatActorIp> threatActorIpAddresses;
    private final String pendingAction;
    private final List<String> impactedAccounts;
    private final List<Watcher> watchers;
    private final Instant createdDate;
    private final Instant lastUpdatedDate;
    private final String closureCode;
    private final String resolverType;
    private final List<String> impactedServices;
    private final List<CaseAttachmentAttributes> caseAttachments;
    private final Instant closedDate;

    private GetCaseResponse(BuilderImpl builder) {
        super(builder);
        this.title = builder.title;
        this.caseArn = builder.caseArn;
        this.description = builder.description;
        this.caseStatus = builder.caseStatus;
        this.engagementType = builder.engagementType;
        this.reportedIncidentStartDate = builder.reportedIncidentStartDate;
        this.actualIncidentStartDate = builder.actualIncidentStartDate;
        this.impactedAwsRegions = builder.impactedAwsRegions;
        this.threatActorIpAddresses = builder.threatActorIpAddresses;
        this.pendingAction = builder.pendingAction;
        this.impactedAccounts = builder.impactedAccounts;
        this.watchers = builder.watchers;
        this.createdDate = builder.createdDate;
        this.lastUpdatedDate = builder.lastUpdatedDate;
        this.closureCode = builder.closureCode;
        this.resolverType = builder.resolverType;
        this.impactedServices = builder.impactedServices;
        this.caseAttachments = builder.caseAttachments;
        this.closedDate = builder.closedDate;
    }

    public final String title() {
        return this.title;
    }

    public final String caseArn() {
        return this.caseArn;
    }

    public final String description() {
        return this.description;
    }

    public final CaseStatus caseStatus() {
        return CaseStatus.fromValue(this.caseStatus);
    }

    public final String caseStatusAsString() {
        return this.caseStatus;
    }

    public final EngagementType engagementType() {
        return EngagementType.fromValue(this.engagementType);
    }

    public final String engagementTypeAsString() {
        return this.engagementType;
    }

    public final Instant reportedIncidentStartDate() {
        return this.reportedIncidentStartDate;
    }

    public final Instant actualIncidentStartDate() {
        return this.actualIncidentStartDate;
    }

    public final boolean hasImpactedAwsRegions() {
        return this.impactedAwsRegions != null && !(this.impactedAwsRegions instanceof SdkAutoConstructList);
    }

    public final List<ImpactedAwsRegion> impactedAwsRegions() {
        return this.impactedAwsRegions;
    }

    public final boolean hasThreatActorIpAddresses() {
        return this.threatActorIpAddresses != null && !(this.threatActorIpAddresses instanceof SdkAutoConstructList);
    }

    public final List<ThreatActorIp> threatActorIpAddresses() {
        return this.threatActorIpAddresses;
    }

    public final PendingAction pendingAction() {
        return PendingAction.fromValue(this.pendingAction);
    }

    public final String pendingActionAsString() {
        return this.pendingAction;
    }

    public final boolean hasImpactedAccounts() {
        return this.impactedAccounts != null && !(this.impactedAccounts instanceof SdkAutoConstructList);
    }

    public final List<String> impactedAccounts() {
        return this.impactedAccounts;
    }

    public final boolean hasWatchers() {
        return this.watchers != null && !(this.watchers instanceof SdkAutoConstructList);
    }

    public final List<Watcher> watchers() {
        return this.watchers;
    }

    public final Instant createdDate() {
        return this.createdDate;
    }

    public final Instant lastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public final ClosureCode closureCode() {
        return ClosureCode.fromValue(this.closureCode);
    }

    public final String closureCodeAsString() {
        return this.closureCode;
    }

    public final ResolverType resolverType() {
        return ResolverType.fromValue(this.resolverType);
    }

    public final String resolverTypeAsString() {
        return this.resolverType;
    }

    public final boolean hasImpactedServices() {
        return this.impactedServices != null && !(this.impactedServices instanceof SdkAutoConstructList);
    }

    public final List<String> impactedServices() {
        return this.impactedServices;
    }

    public final boolean hasCaseAttachments() {
        return this.caseAttachments != null && !(this.caseAttachments instanceof SdkAutoConstructList);
    }

    public final List<CaseAttachmentAttributes> caseAttachments() {
        return this.caseAttachments;
    }

    public final Instant closedDate() {
        return this.closedDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.caseStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.engagementTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.reportedIncidentStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.actualIncidentStartDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedAwsRegions() ? this.impactedAwsRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasThreatActorIpAddresses() ? this.threatActorIpAddresses() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedAccounts() ? this.impactedAccounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasWatchers() ? this.watchers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.closureCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolverTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImpactedServices() ? this.impactedServices() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCaseAttachments() ? this.caseAttachments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.closedDate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCaseResponse)) {
            return false;
        }
        GetCaseResponse other = (GetCaseResponse)((Object)obj);
        return Objects.equals(this.title(), other.title()) && Objects.equals(this.caseArn(), other.caseArn()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.caseStatusAsString(), other.caseStatusAsString()) && Objects.equals(this.engagementTypeAsString(), other.engagementTypeAsString()) && Objects.equals(this.reportedIncidentStartDate(), other.reportedIncidentStartDate()) && Objects.equals(this.actualIncidentStartDate(), other.actualIncidentStartDate()) && this.hasImpactedAwsRegions() == other.hasImpactedAwsRegions() && Objects.equals(this.impactedAwsRegions(), other.impactedAwsRegions()) && this.hasThreatActorIpAddresses() == other.hasThreatActorIpAddresses() && Objects.equals(this.threatActorIpAddresses(), other.threatActorIpAddresses()) && Objects.equals(this.pendingActionAsString(), other.pendingActionAsString()) && this.hasImpactedAccounts() == other.hasImpactedAccounts() && Objects.equals(this.impactedAccounts(), other.impactedAccounts()) && this.hasWatchers() == other.hasWatchers() && Objects.equals(this.watchers(), other.watchers()) && Objects.equals(this.createdDate(), other.createdDate()) && Objects.equals(this.lastUpdatedDate(), other.lastUpdatedDate()) && Objects.equals(this.closureCodeAsString(), other.closureCodeAsString()) && Objects.equals(this.resolverTypeAsString(), other.resolverTypeAsString()) && this.hasImpactedServices() == other.hasImpactedServices() && Objects.equals(this.impactedServices(), other.impactedServices()) && this.hasCaseAttachments() == other.hasCaseAttachments() && Objects.equals(this.caseAttachments(), other.caseAttachments()) && Objects.equals(this.closedDate(), other.closedDate());
    }

    public final String toString() {
        return ToString.builder((String)"GetCaseResponse").add("Title", (Object)(this.title() == null ? null : "*** Sensitive Data Redacted ***")).add("CaseArn", (Object)this.caseArn()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("CaseStatus", (Object)this.caseStatusAsString()).add("EngagementType", (Object)this.engagementTypeAsString()).add("ReportedIncidentStartDate", (Object)this.reportedIncidentStartDate()).add("ActualIncidentStartDate", (Object)this.actualIncidentStartDate()).add("ImpactedAwsRegions", this.hasImpactedAwsRegions() ? this.impactedAwsRegions() : null).add("ThreatActorIpAddresses", this.hasThreatActorIpAddresses() ? this.threatActorIpAddresses() : null).add("PendingAction", (Object)this.pendingActionAsString()).add("ImpactedAccounts", this.hasImpactedAccounts() ? this.impactedAccounts() : null).add("Watchers", this.hasWatchers() ? this.watchers() : null).add("CreatedDate", (Object)this.createdDate()).add("LastUpdatedDate", (Object)this.lastUpdatedDate()).add("ClosureCode", (Object)this.closureCodeAsString()).add("ResolverType", (Object)this.resolverTypeAsString()).add("ImpactedServices", this.hasImpactedServices() ? this.impactedServices() : null).add("CaseAttachments", this.hasCaseAttachments() ? this.caseAttachments() : null).add("ClosedDate", (Object)this.closedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "caseArn": {
                return Optional.ofNullable(clazz.cast(this.caseArn()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "caseStatus": {
                return Optional.ofNullable(clazz.cast(this.caseStatusAsString()));
            }
            case "engagementType": {
                return Optional.ofNullable(clazz.cast(this.engagementTypeAsString()));
            }
            case "reportedIncidentStartDate": {
                return Optional.ofNullable(clazz.cast(this.reportedIncidentStartDate()));
            }
            case "actualIncidentStartDate": {
                return Optional.ofNullable(clazz.cast(this.actualIncidentStartDate()));
            }
            case "impactedAwsRegions": {
                return Optional.ofNullable(clazz.cast(this.impactedAwsRegions()));
            }
            case "threatActorIpAddresses": {
                return Optional.ofNullable(clazz.cast(this.threatActorIpAddresses()));
            }
            case "pendingAction": {
                return Optional.ofNullable(clazz.cast(this.pendingActionAsString()));
            }
            case "impactedAccounts": {
                return Optional.ofNullable(clazz.cast(this.impactedAccounts()));
            }
            case "watchers": {
                return Optional.ofNullable(clazz.cast(this.watchers()));
            }
            case "createdDate": {
                return Optional.ofNullable(clazz.cast(this.createdDate()));
            }
            case "lastUpdatedDate": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedDate()));
            }
            case "closureCode": {
                return Optional.ofNullable(clazz.cast(this.closureCodeAsString()));
            }
            case "resolverType": {
                return Optional.ofNullable(clazz.cast(this.resolverTypeAsString()));
            }
            case "impactedServices": {
                return Optional.ofNullable(clazz.cast(this.impactedServices()));
            }
            case "caseAttachments": {
                return Optional.ofNullable(clazz.cast(this.caseAttachments()));
            }
            case "closedDate": {
                return Optional.ofNullable(clazz.cast(this.closedDate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", TITLE_FIELD);
        map.put("caseArn", CASE_ARN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("caseStatus", CASE_STATUS_FIELD);
        map.put("engagementType", ENGAGEMENT_TYPE_FIELD);
        map.put("reportedIncidentStartDate", REPORTED_INCIDENT_START_DATE_FIELD);
        map.put("actualIncidentStartDate", ACTUAL_INCIDENT_START_DATE_FIELD);
        map.put("impactedAwsRegions", IMPACTED_AWS_REGIONS_FIELD);
        map.put("threatActorIpAddresses", THREAT_ACTOR_IP_ADDRESSES_FIELD);
        map.put("pendingAction", PENDING_ACTION_FIELD);
        map.put("impactedAccounts", IMPACTED_ACCOUNTS_FIELD);
        map.put("watchers", WATCHERS_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastUpdatedDate", LAST_UPDATED_DATE_FIELD);
        map.put("closureCode", CLOSURE_CODE_FIELD);
        map.put("resolverType", RESOLVER_TYPE_FIELD);
        map.put("impactedServices", IMPACTED_SERVICES_FIELD);
        map.put("caseAttachments", CASE_ATTACHMENTS_FIELD);
        map.put("closedDate", CLOSED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCaseResponse, T> g) {
        return obj -> g.apply((GetCaseResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrResponse.BuilderImpl
    implements Builder {
        private String title;
        private String caseArn;
        private String description;
        private String caseStatus;
        private String engagementType;
        private Instant reportedIncidentStartDate;
        private Instant actualIncidentStartDate;
        private List<ImpactedAwsRegion> impactedAwsRegions = DefaultSdkAutoConstructList.getInstance();
        private List<ThreatActorIp> threatActorIpAddresses = DefaultSdkAutoConstructList.getInstance();
        private String pendingAction;
        private List<String> impactedAccounts = DefaultSdkAutoConstructList.getInstance();
        private List<Watcher> watchers = DefaultSdkAutoConstructList.getInstance();
        private Instant createdDate;
        private Instant lastUpdatedDate;
        private String closureCode;
        private String resolverType;
        private List<String> impactedServices = DefaultSdkAutoConstructList.getInstance();
        private List<CaseAttachmentAttributes> caseAttachments = DefaultSdkAutoConstructList.getInstance();
        private Instant closedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCaseResponse model) {
            super(model);
            this.title(model.title);
            this.caseArn(model.caseArn);
            this.description(model.description);
            this.caseStatus(model.caseStatus);
            this.engagementType(model.engagementType);
            this.reportedIncidentStartDate(model.reportedIncidentStartDate);
            this.actualIncidentStartDate(model.actualIncidentStartDate);
            this.impactedAwsRegions(model.impactedAwsRegions);
            this.threatActorIpAddresses(model.threatActorIpAddresses);
            this.pendingAction(model.pendingAction);
            this.impactedAccounts(model.impactedAccounts);
            this.watchers(model.watchers);
            this.createdDate(model.createdDate);
            this.lastUpdatedDate(model.lastUpdatedDate);
            this.closureCode(model.closureCode);
            this.resolverType(model.resolverType);
            this.impactedServices(model.impactedServices);
            this.caseAttachments(model.caseAttachments);
            this.closedDate(model.closedDate);
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getCaseArn() {
            return this.caseArn;
        }

        public final void setCaseArn(String caseArn) {
            this.caseArn = caseArn;
        }

        @Override
        public final Builder caseArn(String caseArn) {
            this.caseArn = caseArn;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCaseStatus() {
            return this.caseStatus;
        }

        public final void setCaseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
        }

        @Override
        public final Builder caseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
            return this;
        }

        @Override
        public final Builder caseStatus(CaseStatus caseStatus) {
            this.caseStatus(caseStatus == null ? null : caseStatus.toString());
            return this;
        }

        public final String getEngagementType() {
            return this.engagementType;
        }

        public final void setEngagementType(String engagementType) {
            this.engagementType = engagementType;
        }

        @Override
        public final Builder engagementType(String engagementType) {
            this.engagementType = engagementType;
            return this;
        }

        @Override
        public final Builder engagementType(EngagementType engagementType) {
            this.engagementType(engagementType == null ? null : engagementType.toString());
            return this;
        }

        public final Instant getReportedIncidentStartDate() {
            return this.reportedIncidentStartDate;
        }

        public final void setReportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
        }

        @Override
        public final Builder reportedIncidentStartDate(Instant reportedIncidentStartDate) {
            this.reportedIncidentStartDate = reportedIncidentStartDate;
            return this;
        }

        public final Instant getActualIncidentStartDate() {
            return this.actualIncidentStartDate;
        }

        public final void setActualIncidentStartDate(Instant actualIncidentStartDate) {
            this.actualIncidentStartDate = actualIncidentStartDate;
        }

        @Override
        public final Builder actualIncidentStartDate(Instant actualIncidentStartDate) {
            this.actualIncidentStartDate = actualIncidentStartDate;
            return this;
        }

        public final List<ImpactedAwsRegion.Builder> getImpactedAwsRegions() {
            List<ImpactedAwsRegion.Builder> result = ImpactedAwsRegionListCopier.copyToBuilder(this.impactedAwsRegions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImpactedAwsRegions(Collection<ImpactedAwsRegion.BuilderImpl> impactedAwsRegions) {
            this.impactedAwsRegions = ImpactedAwsRegionListCopier.copyFromBuilder(impactedAwsRegions);
        }

        @Override
        public final Builder impactedAwsRegions(Collection<ImpactedAwsRegion> impactedAwsRegions) {
            this.impactedAwsRegions = ImpactedAwsRegionListCopier.copy(impactedAwsRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegions(ImpactedAwsRegion ... impactedAwsRegions) {
            this.impactedAwsRegions(Arrays.asList(impactedAwsRegions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAwsRegions(Consumer<ImpactedAwsRegion.Builder> ... impactedAwsRegions) {
            this.impactedAwsRegions(Stream.of(impactedAwsRegions).map(c -> (ImpactedAwsRegion)((ImpactedAwsRegion.Builder)ImpactedAwsRegion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ThreatActorIp.Builder> getThreatActorIpAddresses() {
            List<ThreatActorIp.Builder> result = ThreatActorIpListCopier.copyToBuilder(this.threatActorIpAddresses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setThreatActorIpAddresses(Collection<ThreatActorIp.BuilderImpl> threatActorIpAddresses) {
            this.threatActorIpAddresses = ThreatActorIpListCopier.copyFromBuilder(threatActorIpAddresses);
        }

        @Override
        public final Builder threatActorIpAddresses(Collection<ThreatActorIp> threatActorIpAddresses) {
            this.threatActorIpAddresses = ThreatActorIpListCopier.copy(threatActorIpAddresses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddresses(ThreatActorIp ... threatActorIpAddresses) {
            this.threatActorIpAddresses(Arrays.asList(threatActorIpAddresses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder threatActorIpAddresses(Consumer<ThreatActorIp.Builder> ... threatActorIpAddresses) {
            this.threatActorIpAddresses(Stream.of(threatActorIpAddresses).map(c -> (ThreatActorIp)((ThreatActorIp.Builder)ThreatActorIp.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPendingAction() {
            return this.pendingAction;
        }

        public final void setPendingAction(String pendingAction) {
            this.pendingAction = pendingAction;
        }

        @Override
        public final Builder pendingAction(String pendingAction) {
            this.pendingAction = pendingAction;
            return this;
        }

        @Override
        public final Builder pendingAction(PendingAction pendingAction) {
            this.pendingAction(pendingAction == null ? null : pendingAction.toString());
            return this;
        }

        public final Collection<String> getImpactedAccounts() {
            if (this.impactedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return this.impactedAccounts;
        }

        public final void setImpactedAccounts(Collection<String> impactedAccounts) {
            this.impactedAccounts = ImpactedAccountsCopier.copy(impactedAccounts);
        }

        @Override
        public final Builder impactedAccounts(Collection<String> impactedAccounts) {
            this.impactedAccounts = ImpactedAccountsCopier.copy(impactedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedAccounts(String ... impactedAccounts) {
            this.impactedAccounts(Arrays.asList(impactedAccounts));
            return this;
        }

        public final List<Watcher.Builder> getWatchers() {
            List<Watcher.Builder> result = WatchersCopier.copyToBuilder(this.watchers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWatchers(Collection<Watcher.BuilderImpl> watchers) {
            this.watchers = WatchersCopier.copyFromBuilder(watchers);
        }

        @Override
        public final Builder watchers(Collection<Watcher> watchers) {
            this.watchers = WatchersCopier.copy(watchers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchers(Watcher ... watchers) {
            this.watchers(Arrays.asList(watchers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder watchers(Consumer<Watcher.Builder> ... watchers) {
            this.watchers(Stream.of(watchers).map(c -> (Watcher)((Watcher.Builder)Watcher.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedDate() {
            return this.createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Instant getLastUpdatedDate() {
            return this.lastUpdatedDate;
        }

        public final void setLastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
        }

        @Override
        public final Builder lastUpdatedDate(Instant lastUpdatedDate) {
            this.lastUpdatedDate = lastUpdatedDate;
            return this;
        }

        public final String getClosureCode() {
            return this.closureCode;
        }

        public final void setClosureCode(String closureCode) {
            this.closureCode = closureCode;
        }

        @Override
        public final Builder closureCode(String closureCode) {
            this.closureCode = closureCode;
            return this;
        }

        @Override
        public final Builder closureCode(ClosureCode closureCode) {
            this.closureCode(closureCode == null ? null : closureCode.toString());
            return this;
        }

        public final String getResolverType() {
            return this.resolverType;
        }

        public final void setResolverType(String resolverType) {
            this.resolverType = resolverType;
        }

        @Override
        public final Builder resolverType(String resolverType) {
            this.resolverType = resolverType;
            return this;
        }

        @Override
        public final Builder resolverType(ResolverType resolverType) {
            this.resolverType(resolverType == null ? null : resolverType.toString());
            return this;
        }

        public final Collection<String> getImpactedServices() {
            if (this.impactedServices instanceof SdkAutoConstructList) {
                return null;
            }
            return this.impactedServices;
        }

        public final void setImpactedServices(Collection<String> impactedServices) {
            this.impactedServices = ImpactedServicesListCopier.copy(impactedServices);
        }

        @Override
        public final Builder impactedServices(Collection<String> impactedServices) {
            this.impactedServices = ImpactedServicesListCopier.copy(impactedServices);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder impactedServices(String ... impactedServices) {
            this.impactedServices(Arrays.asList(impactedServices));
            return this;
        }

        public final List<CaseAttachmentAttributes.Builder> getCaseAttachments() {
            List<CaseAttachmentAttributes.Builder> result = CaseAttachmentsListCopier.copyToBuilder(this.caseAttachments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCaseAttachments(Collection<CaseAttachmentAttributes.BuilderImpl> caseAttachments) {
            this.caseAttachments = CaseAttachmentsListCopier.copyFromBuilder(caseAttachments);
        }

        @Override
        public final Builder caseAttachments(Collection<CaseAttachmentAttributes> caseAttachments) {
            this.caseAttachments = CaseAttachmentsListCopier.copy(caseAttachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseAttachments(CaseAttachmentAttributes ... caseAttachments) {
            this.caseAttachments(Arrays.asList(caseAttachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder caseAttachments(Consumer<CaseAttachmentAttributes.Builder> ... caseAttachments) {
            this.caseAttachments(Stream.of(caseAttachments).map(c -> (CaseAttachmentAttributes)((CaseAttachmentAttributes.Builder)CaseAttachmentAttributes.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getClosedDate() {
            return this.closedDate;
        }

        public final void setClosedDate(Instant closedDate) {
            this.closedDate = closedDate;
        }

        @Override
        public final Builder closedDate(Instant closedDate) {
            this.closedDate = closedDate;
            return this;
        }

        @Override
        public GetCaseResponse build() {
            return new GetCaseResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SecurityIrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetCaseResponse> {
        public Builder title(String var1);

        public Builder caseArn(String var1);

        public Builder description(String var1);

        public Builder caseStatus(String var1);

        public Builder caseStatus(CaseStatus var1);

        public Builder engagementType(String var1);

        public Builder engagementType(EngagementType var1);

        public Builder reportedIncidentStartDate(Instant var1);

        public Builder actualIncidentStartDate(Instant var1);

        public Builder impactedAwsRegions(Collection<ImpactedAwsRegion> var1);

        public Builder impactedAwsRegions(ImpactedAwsRegion ... var1);

        public Builder impactedAwsRegions(Consumer<ImpactedAwsRegion.Builder> ... var1);

        public Builder threatActorIpAddresses(Collection<ThreatActorIp> var1);

        public Builder threatActorIpAddresses(ThreatActorIp ... var1);

        public Builder threatActorIpAddresses(Consumer<ThreatActorIp.Builder> ... var1);

        public Builder pendingAction(String var1);

        public Builder pendingAction(PendingAction var1);

        public Builder impactedAccounts(Collection<String> var1);

        public Builder impactedAccounts(String ... var1);

        public Builder watchers(Collection<Watcher> var1);

        public Builder watchers(Watcher ... var1);

        public Builder watchers(Consumer<Watcher.Builder> ... var1);

        public Builder createdDate(Instant var1);

        public Builder lastUpdatedDate(Instant var1);

        public Builder closureCode(String var1);

        public Builder closureCode(ClosureCode var1);

        public Builder resolverType(String var1);

        public Builder resolverType(ResolverType var1);

        public Builder impactedServices(Collection<String> var1);

        public Builder impactedServices(String ... var1);

        public Builder caseAttachments(Collection<CaseAttachmentAttributes> var1);

        public Builder caseAttachments(CaseAttachmentAttributes ... var1);

        public Builder caseAttachments(Consumer<CaseAttachmentAttributes.Builder> ... var1);

        public Builder closedDate(Instant var1);
    }
}

