/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.securityir.SecurityIrClient;
import software.amazon.awssdk.services.securityir.internal.UserAgentUtils;
import software.amazon.awssdk.services.securityir.model.ListCasesItem;
import software.amazon.awssdk.services.securityir.model.ListCasesRequest;
import software.amazon.awssdk.services.securityir.model.ListCasesResponse;

public class ListCasesIterable
implements SdkIterable<ListCasesResponse> {
    private final SecurityIrClient client;
    private final ListCasesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCasesIterable(SecurityIrClient client, ListCasesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCasesResponseFetcher();
    }

    public Iterator<ListCasesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ListCasesItem> items() {
        Function<ListCasesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCasesResponseFetcher
    implements SyncPageFetcher<ListCasesResponse> {
        private ListCasesResponseFetcher() {
        }

        public boolean hasNextPage(ListCasesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCasesResponse nextPage(ListCasesResponse previousPage) {
            if (previousPage == null) {
                return ListCasesIterable.this.client.listCases(ListCasesIterable.this.firstRequest);
            }
            return ListCasesIterable.this.client.listCases((ListCasesRequest)((Object)ListCasesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

