/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum CustomerType {
    STANDALONE("Standalone"),
    ORGANIZATION("Organization"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, CustomerType> VALUE_MAP;
    private final String value;

    private CustomerType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CustomerType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CustomerType> knownValues() {
        EnumSet<CustomerType> knownValues = EnumSet.allOf(CustomerType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(CustomerType.class, CustomerType::toString);
    }
}

