/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.securityir.model.IncidentResponder;
import software.amazon.awssdk.services.securityir.model.IncidentResponseTeamCopier;
import software.amazon.awssdk.services.securityir.model.OptInFeature;
import software.amazon.awssdk.services.securityir.model.OptInFeaturesCopier;
import software.amazon.awssdk.services.securityir.model.SecurityIrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateMembershipRequest
extends SecurityIrRequest
implements ToCopyableBuilder<Builder, UpdateMembershipRequest> {
    private static final SdkField<String> MEMBERSHIP_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipId").getter(UpdateMembershipRequest.getter(UpdateMembershipRequest::membershipId)).setter(UpdateMembershipRequest.setter(Builder::membershipId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("membershipId").build()}).build();
    private static final SdkField<String> MEMBERSHIP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("membershipName").getter(UpdateMembershipRequest.getter(UpdateMembershipRequest::membershipName)).setter(UpdateMembershipRequest.setter(Builder::membershipName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipName").build()}).build();
    private static final SdkField<List<IncidentResponder>> INCIDENT_RESPONSE_TEAM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("incidentResponseTeam").getter(UpdateMembershipRequest.getter(UpdateMembershipRequest::incidentResponseTeam)).setter(UpdateMembershipRequest.setter(Builder::incidentResponseTeam)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("incidentResponseTeam").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(IncidentResponder::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<OptInFeature>> OPT_IN_FEATURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("optInFeatures").getter(UpdateMembershipRequest.getter(UpdateMembershipRequest::optInFeatures)).setter(UpdateMembershipRequest.setter(Builder::optInFeatures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("optInFeatures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OptInFeature::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERSHIP_ID_FIELD, MEMBERSHIP_NAME_FIELD, INCIDENT_RESPONSE_TEAM_FIELD, OPT_IN_FEATURES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateMembershipRequest.memberNameToFieldInitializer();
    private final String membershipId;
    private final String membershipName;
    private final List<IncidentResponder> incidentResponseTeam;
    private final List<OptInFeature> optInFeatures;

    private UpdateMembershipRequest(BuilderImpl builder) {
        super(builder);
        this.membershipId = builder.membershipId;
        this.membershipName = builder.membershipName;
        this.incidentResponseTeam = builder.incidentResponseTeam;
        this.optInFeatures = builder.optInFeatures;
    }

    public final String membershipId() {
        return this.membershipId;
    }

    public final String membershipName() {
        return this.membershipName;
    }

    public final boolean hasIncidentResponseTeam() {
        return this.incidentResponseTeam != null && !(this.incidentResponseTeam instanceof SdkAutoConstructList);
    }

    public final List<IncidentResponder> incidentResponseTeam() {
        return this.incidentResponseTeam;
    }

    public final boolean hasOptInFeatures() {
        return this.optInFeatures != null && !(this.optInFeatures instanceof SdkAutoConstructList);
    }

    public final List<OptInFeature> optInFeatures() {
        return this.optInFeatures;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipId());
        hashCode = 31 * hashCode + Objects.hashCode(this.membershipName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIncidentResponseTeam() ? this.incidentResponseTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOptInFeatures() ? this.optInFeatures() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMembershipRequest)) {
            return false;
        }
        UpdateMembershipRequest other = (UpdateMembershipRequest)((Object)obj);
        return Objects.equals(this.membershipId(), other.membershipId()) && Objects.equals(this.membershipName(), other.membershipName()) && this.hasIncidentResponseTeam() == other.hasIncidentResponseTeam() && Objects.equals(this.incidentResponseTeam(), other.incidentResponseTeam()) && this.hasOptInFeatures() == other.hasOptInFeatures() && Objects.equals(this.optInFeatures(), other.optInFeatures());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateMembershipRequest").add("MembershipId", (Object)this.membershipId()).add("MembershipName", (Object)(this.membershipName() == null ? null : "*** Sensitive Data Redacted ***")).add("IncidentResponseTeam", this.hasIncidentResponseTeam() ? this.incidentResponseTeam() : null).add("OptInFeatures", this.hasOptInFeatures() ? this.optInFeatures() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "membershipId": {
                return Optional.ofNullable(clazz.cast(this.membershipId()));
            }
            case "membershipName": {
                return Optional.ofNullable(clazz.cast(this.membershipName()));
            }
            case "incidentResponseTeam": {
                return Optional.ofNullable(clazz.cast(this.incidentResponseTeam()));
            }
            case "optInFeatures": {
                return Optional.ofNullable(clazz.cast(this.optInFeatures()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("membershipId", MEMBERSHIP_ID_FIELD);
        map.put("membershipName", MEMBERSHIP_NAME_FIELD);
        map.put("incidentResponseTeam", INCIDENT_RESPONSE_TEAM_FIELD);
        map.put("optInFeatures", OPT_IN_FEATURES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateMembershipRequest, T> g) {
        return obj -> g.apply((UpdateMembershipRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SecurityIrRequest.BuilderImpl
    implements Builder {
        private String membershipId;
        private String membershipName;
        private List<IncidentResponder> incidentResponseTeam = DefaultSdkAutoConstructList.getInstance();
        private List<OptInFeature> optInFeatures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMembershipRequest model) {
            super(model);
            this.membershipId(model.membershipId);
            this.membershipName(model.membershipName);
            this.incidentResponseTeam(model.incidentResponseTeam);
            this.optInFeatures(model.optInFeatures);
        }

        public final String getMembershipId() {
            return this.membershipId;
        }

        public final void setMembershipId(String membershipId) {
            this.membershipId = membershipId;
        }

        @Override
        public final Builder membershipId(String membershipId) {
            this.membershipId = membershipId;
            return this;
        }

        public final String getMembershipName() {
            return this.membershipName;
        }

        public final void setMembershipName(String membershipName) {
            this.membershipName = membershipName;
        }

        @Override
        public final Builder membershipName(String membershipName) {
            this.membershipName = membershipName;
            return this;
        }

        public final List<IncidentResponder.Builder> getIncidentResponseTeam() {
            List<IncidentResponder.Builder> result = IncidentResponseTeamCopier.copyToBuilder(this.incidentResponseTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIncidentResponseTeam(Collection<IncidentResponder.BuilderImpl> incidentResponseTeam) {
            this.incidentResponseTeam = IncidentResponseTeamCopier.copyFromBuilder(incidentResponseTeam);
        }

        @Override
        public final Builder incidentResponseTeam(Collection<IncidentResponder> incidentResponseTeam) {
            this.incidentResponseTeam = IncidentResponseTeamCopier.copy(incidentResponseTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentResponseTeam(IncidentResponder ... incidentResponseTeam) {
            this.incidentResponseTeam(Arrays.asList(incidentResponseTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder incidentResponseTeam(Consumer<IncidentResponder.Builder> ... incidentResponseTeam) {
            this.incidentResponseTeam(Stream.of(incidentResponseTeam).map(c -> (IncidentResponder)((IncidentResponder.Builder)IncidentResponder.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<OptInFeature.Builder> getOptInFeatures() {
            List<OptInFeature.Builder> result = OptInFeaturesCopier.copyToBuilder(this.optInFeatures);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOptInFeatures(Collection<OptInFeature.BuilderImpl> optInFeatures) {
            this.optInFeatures = OptInFeaturesCopier.copyFromBuilder(optInFeatures);
        }

        @Override
        public final Builder optInFeatures(Collection<OptInFeature> optInFeatures) {
            this.optInFeatures = OptInFeaturesCopier.copy(optInFeatures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optInFeatures(OptInFeature ... optInFeatures) {
            this.optInFeatures(Arrays.asList(optInFeatures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder optInFeatures(Consumer<OptInFeature.Builder> ... optInFeatures) {
            this.optInFeatures(Stream.of(optInFeatures).map(c -> (OptInFeature)((OptInFeature.Builder)OptInFeature.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateMembershipRequest build() {
            return new UpdateMembershipRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SecurityIrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateMembershipRequest> {
        public Builder membershipId(String var1);

        public Builder membershipName(String var1);

        public Builder incidentResponseTeam(Collection<IncidentResponder> var1);

        public Builder incidentResponseTeam(IncidentResponder ... var1);

        public Builder incidentResponseTeam(Consumer<IncidentResponder.Builder> ... var1);

        public Builder optInFeatures(Collection<OptInFeature> var1);

        public Builder optInFeatures(OptInFeature ... var1);

        public Builder optInFeatures(Consumer<OptInFeature.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

