/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCaseStatusResponse extends SecurityIrResponse implements
        ToCopyableBuilder<UpdateCaseStatusResponse.Builder, UpdateCaseStatusResponse> {
    private static final SdkField<String> CASE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("caseStatus").getter(getter(UpdateCaseStatusResponse::caseStatusAsString))
            .setter(setter(Builder::caseStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("caseStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CASE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String caseStatus;

    private UpdateCaseStatusResponse(BuilderImpl builder) {
        super(builder);
        this.caseStatus = builder.caseStatus;
    }

    /**
     * <p>
     * Response element for UpdateCaseStatus showing the newly configured status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #caseStatus} will
     * return {@link SelfManagedCaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #caseStatusAsString}.
     * </p>
     * 
     * @return Response element for UpdateCaseStatus showing the newly configured status.
     * @see SelfManagedCaseStatus
     */
    public final SelfManagedCaseStatus caseStatus() {
        return SelfManagedCaseStatus.fromValue(caseStatus);
    }

    /**
     * <p>
     * Response element for UpdateCaseStatus showing the newly configured status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #caseStatus} will
     * return {@link SelfManagedCaseStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #caseStatusAsString}.
     * </p>
     * 
     * @return Response element for UpdateCaseStatus showing the newly configured status.
     * @see SelfManagedCaseStatus
     */
    public final String caseStatusAsString() {
        return caseStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(caseStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCaseStatusResponse)) {
            return false;
        }
        UpdateCaseStatusResponse other = (UpdateCaseStatusResponse) obj;
        return Objects.equals(caseStatusAsString(), other.caseStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCaseStatusResponse").add("CaseStatus", caseStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "caseStatus":
            return Optional.ofNullable(clazz.cast(caseStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("caseStatus", CASE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCaseStatusResponse, T> g) {
        return obj -> g.apply((UpdateCaseStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityIrResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateCaseStatusResponse> {
        /**
         * <p>
         * Response element for UpdateCaseStatus showing the newly configured status.
         * </p>
         * 
         * @param caseStatus
         *        Response element for UpdateCaseStatus showing the newly configured status.
         * @see SelfManagedCaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelfManagedCaseStatus
         */
        Builder caseStatus(String caseStatus);

        /**
         * <p>
         * Response element for UpdateCaseStatus showing the newly configured status.
         * </p>
         * 
         * @param caseStatus
         *        Response element for UpdateCaseStatus showing the newly configured status.
         * @see SelfManagedCaseStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelfManagedCaseStatus
         */
        Builder caseStatus(SelfManagedCaseStatus caseStatus);
    }

    static final class BuilderImpl extends SecurityIrResponse.BuilderImpl implements Builder {
        private String caseStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCaseStatusResponse model) {
            super(model);
            caseStatus(model.caseStatus);
        }

        public final String getCaseStatus() {
            return caseStatus;
        }

        public final void setCaseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
        }

        @Override
        public final Builder caseStatus(String caseStatus) {
            this.caseStatus = caseStatus;
            return this;
        }

        @Override
        public final Builder caseStatus(SelfManagedCaseStatus caseStatus) {
            this.caseStatus(caseStatus == null ? null : caseStatus.toString());
            return this;
        }

        @Override
        public UpdateCaseStatusResponse build() {
            return new UpdateCaseStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
