/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.securityir.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SelfManagedCaseStatus {
    SUBMITTED("Submitted"),
    DETECTION_AND_ANALYSIS("Detection and Analysis"),
    CONTAINMENT_ERADICATION_AND_RECOVERY("Containment, Eradication and Recovery"),
    POST_INCIDENT_ACTIVITIES("Post-incident Activities"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SelfManagedCaseStatus> VALUE_MAP;
    private final String value;

    private SelfManagedCaseStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SelfManagedCaseStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SelfManagedCaseStatus> knownValues() {
        EnumSet<SelfManagedCaseStatus> knownValues = EnumSet.allOf(SelfManagedCaseStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SelfManagedCaseStatus.class, SelfManagedCaseStatus::toString);
    }
}

