/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CaseAttachmentAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<CaseAttachmentAttributes.Builder, CaseAttachmentAttributes> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentId").getter(getter(CaseAttachmentAttributes::attachmentId))
            .setter(setter(Builder::attachmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentId").build()).build();

    private static final SdkField<String> FILE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileName").getter(getter(CaseAttachmentAttributes::fileName)).setter(setter(Builder::fileName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileName").build()).build();

    private static final SdkField<String> ATTACHMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("attachmentStatus").getter(getter(CaseAttachmentAttributes::attachmentStatusAsString))
            .setter(setter(Builder::attachmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachmentStatus").build()).build();

    private static final SdkField<String> CREATOR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("creator")
            .getter(getter(CaseAttachmentAttributes::creator)).setter(setter(Builder::creator))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creator").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdDate").getter(getter(CaseAttachmentAttributes::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD,
            FILE_NAME_FIELD, ATTACHMENT_STATUS_FIELD, CREATOR_FIELD, CREATED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attachmentId;

    private final String fileName;

    private final String attachmentStatus;

    private final String creator;

    private final Instant createdDate;

    private CaseAttachmentAttributes(BuilderImpl builder) {
        this.attachmentId = builder.attachmentId;
        this.fileName = builder.fileName;
        this.attachmentStatus = builder.attachmentStatus;
        this.creator = builder.creator;
        this.createdDate = builder.createdDate;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String attachmentId() {
        return attachmentId;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String fileName() {
        return fileName;
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attachmentStatus}
     * will return {@link CaseAttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attachmentStatusAsString}.
     * </p>
     * 
     * @return
     * @see CaseAttachmentStatus
     */
    public final CaseAttachmentStatus attachmentStatus() {
        return CaseAttachmentStatus.fromValue(attachmentStatus);
    }

    /**
     * <p/>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attachmentStatus}
     * will return {@link CaseAttachmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attachmentStatusAsString}.
     * </p>
     * 
     * @return
     * @see CaseAttachmentStatus
     */
    public final String attachmentStatusAsString() {
        return attachmentStatus;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final String creator() {
        return creator;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final Instant createdDate() {
        return createdDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(fileName());
        hashCode = 31 * hashCode + Objects.hashCode(attachmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creator());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CaseAttachmentAttributes)) {
            return false;
        }
        CaseAttachmentAttributes other = (CaseAttachmentAttributes) obj;
        return Objects.equals(attachmentId(), other.attachmentId()) && Objects.equals(fileName(), other.fileName())
                && Objects.equals(attachmentStatusAsString(), other.attachmentStatusAsString())
                && Objects.equals(creator(), other.creator()) && Objects.equals(createdDate(), other.createdDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CaseAttachmentAttributes").add("AttachmentId", attachmentId())
                .add("FileName", fileName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AttachmentStatus", attachmentStatusAsString()).add("Creator", creator()).add("CreatedDate", createdDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attachmentId":
            return Optional.ofNullable(clazz.cast(attachmentId()));
        case "fileName":
            return Optional.ofNullable(clazz.cast(fileName()));
        case "attachmentStatus":
            return Optional.ofNullable(clazz.cast(attachmentStatusAsString()));
        case "creator":
            return Optional.ofNullable(clazz.cast(creator()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attachmentId", ATTACHMENT_ID_FIELD);
        map.put("fileName", FILE_NAME_FIELD);
        map.put("attachmentStatus", ATTACHMENT_STATUS_FIELD);
        map.put("creator", CREATOR_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CaseAttachmentAttributes, T> g) {
        return obj -> g.apply((CaseAttachmentAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CaseAttachmentAttributes> {
        /**
         * <p/>
         * 
         * @param attachmentId
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attachmentId(String attachmentId);

        /**
         * <p/>
         * 
         * @param fileName
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileName(String fileName);

        /**
         * <p/>
         * 
         * @param attachmentStatus
         * @see CaseAttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaseAttachmentStatus
         */
        Builder attachmentStatus(String attachmentStatus);

        /**
         * <p/>
         * 
         * @param attachmentStatus
         * @see CaseAttachmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaseAttachmentStatus
         */
        Builder attachmentStatus(CaseAttachmentStatus attachmentStatus);

        /**
         * <p/>
         * 
         * @param creator
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creator(String creator);

        /**
         * <p/>
         * 
         * @param createdDate
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);
    }

    static final class BuilderImpl implements Builder {
        private String attachmentId;

        private String fileName;

        private String attachmentStatus;

        private String creator;

        private Instant createdDate;

        private BuilderImpl() {
        }

        private BuilderImpl(CaseAttachmentAttributes model) {
            attachmentId(model.attachmentId);
            fileName(model.fileName);
            attachmentStatus(model.attachmentStatus);
            creator(model.creator);
            createdDate(model.createdDate);
        }

        public final String getAttachmentId() {
            return attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final String getFileName() {
            return fileName;
        }

        public final void setFileName(String fileName) {
            this.fileName = fileName;
        }

        @Override
        public final Builder fileName(String fileName) {
            this.fileName = fileName;
            return this;
        }

        public final String getAttachmentStatus() {
            return attachmentStatus;
        }

        public final void setAttachmentStatus(String attachmentStatus) {
            this.attachmentStatus = attachmentStatus;
        }

        @Override
        public final Builder attachmentStatus(String attachmentStatus) {
            this.attachmentStatus = attachmentStatus;
            return this;
        }

        @Override
        public final Builder attachmentStatus(CaseAttachmentStatus attachmentStatus) {
            this.attachmentStatus(attachmentStatus == null ? null : attachmentStatus.toString());
            return this;
        }

        public final String getCreator() {
            return creator;
        }

        public final void setCreator(String creator) {
            this.creator = creator;
        }

        @Override
        public final Builder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        @Override
        public CaseAttachmentAttributes build() {
            return new CaseAttachmentAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
