/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.securityir.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCasesResponse extends SecurityIrResponse implements
        ToCopyableBuilder<ListCasesResponse.Builder, ListCasesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListCasesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<ListCasesItem>> ITEMS_FIELD = SdkField
            .<List<ListCasesItem>> builder(MarshallingType.LIST)
            .memberName("items")
            .getter(getter(ListCasesResponse::items))
            .setter(setter(Builder::items))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListCasesItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListCasesItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> TOTAL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("total")
            .getter(getter(ListCasesResponse::total)).setter(setter(Builder::total))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("total").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ITEMS_FIELD,
            TOTAL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ListCasesItem> items;

    private final Long total;

    private ListCasesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.items = builder.items;
        this.total = builder.total;
    }

    /**
     * <p>
     * An optional string that, if supplied on subsequent calls to ListCases, allows the API to fetch the next page of
     * results.
     * </p>
     * 
     * @return An optional string that, if supplied on subsequent calls to ListCases, allows the API to fetch the next
     *         page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Items property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasItems() {
        return items != null && !(items instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Response element for ListCases that includes caseARN, caseID, caseStatus, closedDate, createdDate,
     * engagementType, lastUpdatedDate, pendingAction, resolverType, and title for each response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasItems} method.
     * </p>
     * 
     * @return Response element for ListCases that includes caseARN, caseID, caseStatus, closedDate, createdDate,
     *         engagementType, lastUpdatedDate, pendingAction, resolverType, and title for each response.
     */
    public final List<ListCasesItem> items() {
        return items;
    }

    /**
     * <p>
     * Response element for ListCases providing the total number of responses.
     * </p>
     * 
     * @return Response element for ListCases providing the total number of responses.
     */
    public final Long total() {
        return total;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasItems() ? items() : null);
        hashCode = 31 * hashCode + Objects.hashCode(total());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCasesResponse)) {
            return false;
        }
        ListCasesResponse other = (ListCasesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasItems() == other.hasItems()
                && Objects.equals(items(), other.items()) && Objects.equals(total(), other.total());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListCasesResponse").add("NextToken", nextToken()).add("Items", hasItems() ? items() : null)
                .add("Total", total()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "items":
            return Optional.ofNullable(clazz.cast(items()));
        case "total":
            return Optional.ofNullable(clazz.cast(total()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("items", ITEMS_FIELD);
        map.put("total", TOTAL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListCasesResponse, T> g) {
        return obj -> g.apply((ListCasesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SecurityIrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListCasesResponse> {
        /**
         * <p>
         * An optional string that, if supplied on subsequent calls to ListCases, allows the API to fetch the next page
         * of results.
         * </p>
         * 
         * @param nextToken
         *        An optional string that, if supplied on subsequent calls to ListCases, allows the API to fetch the
         *        next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Response element for ListCases that includes caseARN, caseID, caseStatus, closedDate, createdDate,
         * engagementType, lastUpdatedDate, pendingAction, resolverType, and title for each response.
         * </p>
         * 
         * @param items
         *        Response element for ListCases that includes caseARN, caseID, caseStatus, closedDate, createdDate,
         *        engagementType, lastUpdatedDate, pendingAction, resolverType, and title for each response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(Collection<ListCasesItem> items);

        /**
         * <p>
         * Response element for ListCases that includes caseARN, caseID, caseStatus, closedDate, createdDate,
         * engagementType, lastUpdatedDate, pendingAction, resolverType, and title for each response.
         * </p>
         * 
         * @param items
         *        Response element for ListCases that includes caseARN, caseID, caseStatus, closedDate, createdDate,
         *        engagementType, lastUpdatedDate, pendingAction, resolverType, and title for each response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder items(ListCasesItem... items);

        /**
         * <p>
         * Response element for ListCases that includes caseARN, caseID, caseStatus, closedDate, createdDate,
         * engagementType, lastUpdatedDate, pendingAction, resolverType, and title for each response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.securityir.model.ListCasesItem.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.securityir.model.ListCasesItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.securityir.model.ListCasesItem.Builder#build()} is called immediately
         * and its result is passed to {@link #items(List<ListCasesItem>)}.
         * 
         * @param items
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.securityir.model.ListCasesItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #items(java.util.Collection<ListCasesItem>)
         */
        Builder items(Consumer<ListCasesItem.Builder>... items);

        /**
         * <p>
         * Response element for ListCases providing the total number of responses.
         * </p>
         * 
         * @param total
         *        Response element for ListCases providing the total number of responses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder total(Long total);
    }

    static final class BuilderImpl extends SecurityIrResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListCasesItem> items = DefaultSdkAutoConstructList.getInstance();

        private Long total;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCasesResponse model) {
            super(model);
            nextToken(model.nextToken);
            items(model.items);
            total(model.total);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListCasesItem.Builder> getItems() {
            List<ListCasesItem.Builder> result = ListCasesItemsCopier.copyToBuilder(this.items);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setItems(Collection<ListCasesItem.BuilderImpl> items) {
            this.items = ListCasesItemsCopier.copyFromBuilder(items);
        }

        @Override
        public final Builder items(Collection<ListCasesItem> items) {
            this.items = ListCasesItemsCopier.copy(items);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(ListCasesItem... items) {
            items(Arrays.asList(items));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder items(Consumer<ListCasesItem.Builder>... items) {
            items(Stream.of(items).map(c -> ListCasesItem.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getTotal() {
            return total;
        }

        public final void setTotal(Long total) {
            this.total = total;
        }

        @Override
        public final Builder total(Long total) {
            this.total = total;
            return this;
        }

        @Override
        public ListCasesResponse build() {
            return new ListCasesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
